c
c
      subroutine w_xlines (icolor, ixl, iyl, nchar, numbld, numlin, 
     +                     numtxt,
     +                     lines, text_in,
     +                     fixed, stack)
c
c action : put out a patch of text with attributes onto a window
c          then return with character strings which must contain numerics
c author : w.g.bardsley, university of manchester, u.k.
c          25/10/2010 developed from w_nlines
c          12/08/2011 added closure cross and other minor editing
c          05/08/2017 added call to add_stop_option and removed allocations 

c          nchar does not set the edit box width but sets the 
c          data type as follows:
c          nchar =< 12: read integers in a field of width 12
c          nchar >= 13: read double precision values in a field of width 25  
c          numlin = number of lines each containing a number
c          numtxt = number of lines of numtxt (optional) lines to display before the edit boxes
c          stack = .true. then show vertical edit boxes
c          stack = .false. then show horizontal edit boxes 
c
c          icolor    background   text     highlight-text
c          ======    ==========   ====     ==============
c          9 or 15   white        black    red
c          o/w       grey         black    blue
c
c          numbld(i)  font (Courier is used if fixed = .true.)
c          =========  ====
c          0, 1       Times
c          2, 3       Times Italic
c          4, 5       Times Bold
c          6, 7       Times Bold Italic
c
c          text size is set by the size parameters
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: icolor, ixl, iyl, nchar,
     +                                       numlin, numtxt
      integer,             intent (in)    :: numbld(*) 
      character (len = *), intent (in)    :: text_in(*)
      character (len = *), intent (inout) :: lines(numlin)
      logical,             intent (in)    :: fixed, stack 
c
c locals
c      
      integer    i, itemp, j, k, l  
      integer    x_len200
      integer    ixyuse, mwtype  
      integer    ixy_use, mw_type, nmax
      parameter (ixy_use = 2, mw_type = 2, nmax = 25)
      integer    iscale, n1, n2
      parameter (n1 = 1, n2 = 2)
      double precision size1, size_courier, size_roman, xtemp
      double precision size_courier_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00) 
      character (len = 129) text(nmax), line1, w_dbleup
      character (len = 100) mssage
      character (len = 25 ) copy_25(nmax)
      character (len = 12 ) copy_12(nmax)
      character (len = 3  ) space
      character (len = 1  ) blank
      parameter (blank = ' ', space = '   ')
      logical    abort, use_12
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200
      external   w_syspar, w_dbleup, x_putfat, x_txt2i1, x_txt2r1
      external   add_stop_option
      intrinsic  dble, index, ichar 
c
c check numtxt then copy text_in into text
c     
      if (numlin.lt.1) return
      if (numlin.gt.nmax .or. numtxt.gt.nmax) then
         write (mssage,100) numlin, nmax
         call x_putfat (mssage)
         return
      else
         if (nchar.le.12) then
            use_12 = .true.
            do i = 1, numlin
               copy_12(i) = lines(i)
            enddo
         else
            use_12 = .false.
            do i = 1, numlin
               copy_25(i) = lines(i)
            enddo
         endif     
      endif  
      if (numtxt.gt.0) then        
         do i = 1, numtxt
            text(i) = w_dbleup(text_in(i))
         enddo       
      endif
   20 continue   
c
c window type: recommend, ixyuse = 2 (ignore ixl and iyl and toolwindow)
c                         mwtype = 2 (dialogue window with no closure cross)
c            
      if (ixl.le.0 .or. iyl.le.0) then
         ixyuse = 2
      else   
         ixyuse = ixy_use
      endif   
      mwtype = mw_type  
c
c set the font type
c                  
      roman = roman_1
c
c Scale the font sizes
c                  
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent  
      size_courier = correction*size_courier_1 
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
     
     
c
c swap the next code to use ixl, iyl and parameter iscale to position the window
c ==============================================================================
c 
      if (ixyuse.eq.1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif
c
c swap the next code to use a normal window rather than a dialogue window
c =======================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[thin_border]&')
      endif
      i = winio@('%ca[Simfit: data required]&')
      if (numtxt.gt.1 .or. numlin.gt.1) call add_stop_option (n1)
c
c now set the background colour depending on icolor
c
      if (icolor.eq.9 .or. icolor.eq.15) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg[grey]&')
      endif

      if (numtxt.gt.0) then
         do i = n1, numtxt
c
c now set the text font depending on numbld(i) and fixed
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                  k = winio@('%fn[Courier New]%bf%it&')
               endif 
c
c and set the text color depending on numbld(i) and icolor
c
               if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  if (icolor.eq.9 .or. icolor.eq.15) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif            
               line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl%sf&'
               k = winio@(line1, size_courier)
            else 
               if (roman) then
                  if (numbld(i).le.1) then
                     k = winio@('%fn[Times New Roman]&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%fn[Times New Roman]%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%fn[Times New Roman]%bf&')
                  else
                     k = winio@('%fn[Times New Roman]%bf%it&')
                  endif
               else       
                  if (i.eq.1 .and.numbld(1).ne.0) then 
                     k = winio@('%`sf%bf&')
                  elseif (numbld(i).le.1) then
                     k = winio@('%`sf&')
                  elseif (numbld(i).le.3) then
                     k = winio@('%`sf%it&')
                  elseif (numbld(i).le.5) then
                     k = winio@('%`sf%bf&')
                  else
                     k = winio@('%`sf%bf%it&')
                  endif
               endif 
c
c and set the text color depending on numbld(i) and icolor
c                  
               if (.not.roman .and. i.eq.1 .and. numbld(1).ne.0) then 
                   k = winio@('%tc[black]&')
               elseif (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +             numbld(i).eq.4 .or. numbld(i).eq.6) then
                  k = winio@('%tc[black]&')
               else
                  if (icolor.eq.9 .or. icolor.eq.15) then
                     k = winio@('%tc[red]&')
                  else
                     k = winio@('%tc[blue]&')
                  endif
               endif                 
               j = index(text(i), '`')
               if (j.lt.n1) then
                  line1 ='%ts'//text(i)(n1:x_len200(text(i)))//'%nl%sf&'  
                  k = winio@(line1, size_roman)
               else
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line1 = blank
                  line1 = text(i)(n1:j - n1)//'&'
                  k = winio@(line1(n1:j))
                  line1 = blank
                  line1 = '%ta'//text(i)(j + n1:l)//'%nl&'
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  k = winio@(line1(n1:l - j + 7))
                  k = winio@('%sf&')
               endif
            endif
         enddo
c
c add an extra blank line if the last line is not a blank line
c         
         if (numtxt.le.0) then
            k = winio@('%ff   %nl&')
         elseif (text(numtxt).ne.blank) then
            k = winio@('%ff   %nl&')
         endif   
      endif
c
c first set the scale if nchar is large to reduce font size then the edit boxes
c
      size1 = size_courier
      k = winio@('%`sf%tc[black]%ts&', size1)
      if (stack .or. nchar*numlin.gt.80) then
         do i = n1, numlin
            if (i.gt.1) k = winio@('%ff&')
            k = winio@('%`bg[white]&')
            if (use_12) then
               k = winio@('%10rs&', copy_12(i))
            else
               k = winio@('%20rs&', copy_25(i))
            endif
         enddo
         k = winio@('%ff%nl   &')
         if (numlin.eq.1) then
            k = winio@('%`tt[OK]') 
         else   
            k = winio@('%tt[OK]') 
         endif   
      else
         do i = n1, numlin
            k = winio@('%`bg[white]&')
            if (use_12) then
               k = winio@('%10rs&', copy_12(i))
            else   
               k = winio@('%20rs&', copy_25(i))
            endif
            if (i.eq.numlin) then
               k = winio@('%ff%nl   &')
               if (numlin.eq.1) then
                  k = winio@(space//'%`tt[OK]') 
               else   
                  k = winio@(space//'%tt[OK]') 
               endif   
            else
               k = winio@(space//'&') 
            endif     
         enddo
      endif     
c
c finally check then overwrite lines 
c     
      if (use_12) then 
c
c check for a valid integer
c        
         do i = 1, numlin
            call x_txt2i1 (itemp,
     +                     copy_12(i),
     +                     abort)            
            if (abort) then     
               if (numlin.eq.1) then
                  write (mssage,400) 
               else   
                  write (mssage,500) i
               endif   
               call x_putfat (mssage)
               copy_12(i) = lines(i)
               goto 20
            endif   
         enddo   
      else
         do i = 1, numlin
            call x_txt2r1 (xtemp,
     +                     copy_25(i),
     +                     abort)            
c
c error message if .not.ok
c                
            if (abort) then
               if (numlin.eq.1) then
                  write (mssage,200) 
                else  
                  write (mssage,300) i
               endif   
               call x_putfat (mssage)
               copy_25(i) = lines(i)
               goto 20
            endif   
         enddo   
      endif   
      do i = 1, numlin
         if (use_12) then
            lines(i) = copy_12(i)
         else
            lines(i) = copy_25(i)
         endif      
      enddo   
c
c format statements
c      
  100 format (I4,1x,'lines or text in call to w_xlines: maximum =',i3)  
  200 format ('The edit box does not contain a valid number')     
  300 format ('Edit box',i3,1x,'does not contain a valid number')     
  400 format ('The edit box does not contain a valid integer') 
  500 format ('Edit box',i3,1x,'does not contain a valid integer')      
      end
c
c
 