
c
c
      subroutine w_yesno1 (icolor, ixl, iyl, lshade, numcol, numrow,
     +                     numtxt,
     +                     line_in, text_in, 
     +                     fixed, flash, high, yes)
c
c action : put out a yes/no question onto a window
c author : w.g.bardsley, university of manchester, u.k., 21/12/96
c          10/02/1997 added tabbing
c          04/04/1997 added call to w_syspar to control font size
c                      fixed gives Courier o/w roman
c                      high highlights the final question
c          09/09/1998 removed topmost and made into a normal dialogue window
c          14/11/1998 re-introduced Roman/Courier for buttons
c          14/04/1999 went back to ms sans serif at size courier and used
c                     %ww[no_sysmenu] to make selection unambiguous
c                     and force selection by button press
c          03/12/1999 restored topmost
c          22/01/2001 suppressed topmost
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     o/w normal dialogue window
c          13/02/2002 XP version
c          18/12/2002 added %sy[toolwindow] 
c          20/11/2006 removed toolwindow and added ixyuse and intents 
c          06/02/2007 edited for w_clearwin.dll
c          01/06/2007 added roman and w_dbleup 
c          03/04/2009 added space to free-up the icon 
c          01/08/2017 added stop menu and nmax  
c
c  icolor: (input/unchanged) colour scheme (not used in this version)
c     ixl: (input/unchanged) x coordinate of top left hand corner (depends on ixyuse)
c     iyl: (input/unchanged) y coordinate of top left hand corner (depends on ixyuse)
c  lshade: (input/unchanged) shading (not used in this version)
c  numcol: (input/unchanged) extra columns (suggest, set = 0 for windows version)
c  numrow: (input/unchanged) extra rows (suggest, set = 0 for windows version)
c  numtxt: (input/unchanged) number of lines of text
c line_in: (input/unchanged) 1-line question
c text_in: (input/unchanged) text array to precede question
c   fixed: (input/unchanged) mono spaced font (Courier New)
c   flash: (input/unchanged) not used in this version
c    high: (input/unchanged) final question highlighted if .true.
c     yes: (input/output) sets default on input then returns with decision
c
c          this version uses: len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c          numcol, numrow and flash are not used in this version
c
c          this version deals with 1 liners as special cases
c
c          icolor background   text     highlight-text (in question line)
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          text size is set by the size parameters
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numcol, numrow, numtxt
      character (len = *), intent (in)    :: line_in, text_in(numtxt)
      logical,             intent (in)    :: fixed, flash, high 
      logical,             intent (inout) :: yes
c
c locals
c      
      integer    i, j, k, l, ntext 
      integer    isend, nmax
      parameter (isend = 1, nmax = 20)
      integer    x_len200
      integer    ixyuse, mwtype
      integer    ixy_use, mw_type
      parameter (ixy_use = 2, mw_type = 2)
      integer    iscale, n0, n1, n2, n4, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n7 = 7)
      integer    i_simfit_decide_no, i_simfit_decide_yes
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_roman_1 = 1.15d+00, size_courier_1 = 1.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  line*129, line1*129, text(50)*129, w_dbleup*129
      character  blank*1, space*3
      parameter (blank = ' ', space = '   ')
      logical    dummy, yes_or_no 
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200
      external   w_syspar, w_dbleup
      external   i_simfit_decide_no, i_simfit_decide_yes
      external   add_stop_option
      intrinsic  dble, index
      common / simfit_yesno1 / yes_or_no 
c
c define the font
c               
      roman = roman_1
c
c Scale the font sizes
c                          
      ntext = numtxt  
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else   
         ixyuse = ixy_use
      endif   
      mwtype = mw_type
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1  
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
c
c use up dummy, numcol, numrow, flash to stop ftn90 complaining
c
      dummy = flash
      if (dummy) then
         i = lshade
         i = numcol
         i = numrow
      endif
c
c use ixl, iyl and parameter iscale to position the window
c                     
      if (ixyuse.eq.n1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c initialise yes_or_no
c
      yes_or_no = yes      
c
c initialise line and text
c                         
      line = w_dbleup(line_in)
      if (ntext.gt.n0) then 
         do i = n1, ntext 
            text(i) = w_dbleup(text_in(i))
         enddo
      endif
c
c caption
c                   
      i = winio@('%ca[Simfit: decision]&')
c
c swap the next line for a normal window instead of a dialogue window
c ===================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
      elseif (mwtype.eq.n2) then
         i = winio@('%sy[no_sysmenu]&')
      endif
c
c stop menu
c
      if (numtxt.gt.n0 .and. numtxt.le.nmax) then
         call add_stop_option (isend)
      endif          
c
c now set the font and background and text colours depending on icolor
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
      else  
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
         else
            i = winio@('%`sf&')
         endif      
      endif
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
         k = winio@('%tc[grey]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
         k = winio@('%tc[grey]&')
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
         k = winio@('%tc[grey]&')
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
         k = winio@('%tc[black]&')
      else
         k = winio@('%bg[grey]&')
         k = winio@('%tc[black]&')
      endif
c
c else the general case ... leave the caption out
c
      if (ntext.gt.n0) then
         do i = n1, ntext
            if (fixed) then
               if (i.eq.ntext) then
                  line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'&'
               else
                  line1 = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               endif
               k = winio@(line1, size_courier)
            else
c
c Is there a tabbing character (grave accent `) ?
c
               j = index(text(i), '`')
               k = winio@('%ts&', size_roman) 
               l = x_len200(text(i))
               line1 = blank
               if (j.ge.n1) then
                  line1 = text(i)(n1:j - n1)//'&'
                  k = winio@(line1(n1:j))
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  line1 = blank
                  if (i.eq.ntext) then
                     line1 = '%ta'//text(i)(j + n1:l)//'&'
                     k = winio@(line1(n1:l - j + n4))
                  else
                     line1 = '%ta'//text(i)(j + n1:l)//'%nl&'
                     k = winio@(line1(n1:l - j + n7))
                  endif
               else
                  if (i.eq.ntext) then
                     line1 = text(i)(n1:l)//'&'
                     k = winio@(line1(n1:l + n1))
                  else
                     line1 = text(i)(n1:l)//'%nl&'
                     k = winio@(line1(n1:l - j + n4))
                  endif
               endif
            endif
         enddo
         k = winio@('%ff&')
         k = winio@('%nl   &')
      endif
c
c now the final question highlighted if high = .true.
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
         i = winio@('%ts&', size_courier)
      else 
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
         else
            i = winio@('%`ts&')
         endif       
         i = winio@('%ts&', size_roman)
      endif
      if (high) then
         if (icolor.eq.0) then
            k = winio@('%tc[yellow]&')
         elseif (icolor.eq.1) then
            k = winio@('%tc[yellow]&')
         elseif (icolor.eq.4) then
            k = winio@('%tc[yellow]&')
        elseif (icolor.eq.9) then
            k = winio@('%tc[red]&')
         else
            k = winio@('%tc[blue]&')
         endif
      endif
      
      k = winio@('%nl  &')
      
      line1 = '%si?'//line(n1:x_len200(line))//space//'&'
      k = winio@(line1)
      k = winio@('%`sf&')
      k = winio@('%ts&', size_courier)
      
      if (numtxt.le.nmax) then
         k = winio@('%ff&')
         k = winio@('%nl  &')
         k = winio@('%nl  &')
         k = winio@('%cn&')
         if (yes) then
           line1 = '%8`^bt[&Yes]'//space//'%8^bt[&No]&'
         else
           line1 = '%8^bt[&Yes]'//space//'%8`^bt[&No]&'
         endif
      else
         if (yes) then
           line1 = '%6`^bt[&Yes]'//space//'%6^bt[&No]&'
         else
           line1 = '%6^bt[&Yes]'//space//'%6`^bt[&No]&'
         endif
      endif   
      k = winio@(line1, i_simfit_decide_yes, i_simfit_decide_no)
      
      k = winio@('%ff&') 
      k = winio@('%nl   ')
      
      yes = yes_or_no
      end
c
c
      recursive integer function i_simfit_decide_no()
      implicit none
      logical  yes_or_no
      common / simfit_yesno1 / yes_or_no
      yes_or_no = .false.
      i_simfit_decide_no = 0
      end
c
c
      recursive integer function i_simfit_decide_yes()
      implicit none
      logical  yes_or_no
      common / simfit_yesno1 / yes_or_no
      yes_or_no = .true.
      i_simfit_decide_yes = 0
      end
c
c
