c
c
      subroutine x64_config
c
c action: configure 64-bit Simfit and 64-bit Simdem
c author: w.g.bardsley, university of manchester, u.k., 29/12/2011
c
      implicit   none
      integer    ios, n, nout
      integer    icolor, ix, iy, mode
      parameter (icolor = 7, ix = 0, iy = 0, mode = 0) 
      integer    numdec, numopt, numsta, numtxt 
      parameter (numopt = 5, numsta = 15, numtxt = numsta + numopt - 1)
      integer    ktext
      parameter (ktext = 21) 
      integer    kumbld(30), numbld(30) 
      integer    nval(12)
      character (len = 100 ) line, text(30), info(30), x_trim100 
      character (len = 100 ) path1, path2, path3
      character (len = 100 ) type1, type2, type3
      character (len = 1024) full_path, full_path1, full_path2,
     +           full_path3, temp, x64_cfgfile, x64_simfit, x86_driven 
      character (len = 1024) cval(12)
      character (len = 1   ) bslash
      parameter (bslash = '\')
      logical    repeet, there, yesno
      external   x_trim100, x_lstbox, w_v7path, x_getnou, x_patch2,
     +           x_yesno2, x_getstr, x_putadv, x_putfat, x_getcfg  
      data       numbld / 30*0 /
      data       kumbld / 30*0 /
c
c initialise
c      
      kumbld(1) = 1
      kumbld(7) = 1
      kumbld(13) = 1
      numbld(1) = 4
      numbld(4) = 1
      numbld(8) = 1
      numbld(12) = 1
      
      call w_v7path (n,
     +               'cfg', full_path) 
      if (full_path(n:n).eq.bslash) then
         x64_cfgfile = full_path(1:n)//'x64_simfit.cfg'
         full_path1 = full_path(1:n - 1)
      else
         x64_cfgfile = full_path(1:n)//bslash//'x64_simfit.cfg'
         full_path1 = full_path
      endif
      
      full_path2 = 'No path specified in x64_simfit.cfg'
      full_path3 = 'No path specified in x64_simfit.cfg'
      type1 = 'x64_simfit.cfg not located'
      type2 = 'x86_simfit_driven.exe not located'
      type3 = '64-bit Simfit files not located'
c
c check for existing x64_simfit.cfg      
c
      inquire (file = x64_cfgfile, exist = there, iostat = ios) 

      if (.not.there) then
c
c make a default version if one does not exist
c        
         call x_getcfg (mode, nval,
     +                  cval)
         call x_getnou (nout)
         open (unit = nout, file = x64_cfgfile, iostat = ios)
         if (ios.eq.0) write (nout,'(a)', iostat=ios) cval(3)
         if (ios.eq.0) write (nout,'(a)', iostat=ios) full_path3
         if (ios.eq.0) write (nout,100,iostat=ios)  
         if (ios.eq.0) write (nout,200,iostat=ios)  
         close (unit = nout)
         if (ios.eq.0) there = .true.
      endif                 
      
      if (ios.eq.0 .and. there) then
c
c open the configuration file
c        
         type1 = 'x64_simfit.cfg located'
         call x_getnou (nout)
         open (unit = nout, file = x64_cfgfile, iostat = ios) 
         if (ios.eq.0) read (nout,'(a)',iostat=ios) temp
         if (ios.eq.0) then
            full_path2 = temp
            n = len_trim(temp)
            if (temp(n:n).ne.bslash) then
               n = n + 1
               temp(n:n) = bslash
            endif    
            x86_driven = temp(1:n)//'x86_simfit_driven.exe'
            inquire (file = x86_driven, exist = there, iostat = ios)
            if (ios.eq.0.and.there) then
               type2 = 'x86_simfit_driven.exe located'
            else   
               type2 = 'x86_simfit_driven.exe not located'
            endif   
         endif 
         
         if (ios.eq.0) read (nout,'(a)',iostat=ios) temp
         if (ios.eq.0) then
            full_path3 = temp
            n = len_trim(temp)
            if (temp(n:n).ne.bslash) then
               n = n + 1
               temp(n:n) = bslash
            endif    
            x64_simfit = temp(1:n)//'x64_simfit_driver.dll'
            inquire (file = x64_simfit, exist = there, iostat = ios)
            if (ios.eq.0.and.there) then
               type3 = 'x64_simfit_driver.dll located'
            else   
               type3 = '64-bit Simfit files not located'
            endif   
         endif    
            
         close (unit = nout) 
           
      endif     
      
      path1 = x_trim100(full_path1)
      path2 = x_trim100(full_path2)
      path3 = x_trim100(full_path3)
c
c main loop
c
      numdec = 3
      repeet = .true. 
      do while (repeet)      
         
         write (text,300) path1, type1, path2, type2, path3, type3
         call x_lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                  text)  
     
         if (numdec.eq.1) then
c
c numdec = 1: get full_path2
c           
            full_path = full_path2 
            call x_getstr ('Path to x86_simfit_driven.exe', full_path)
            n = len_trim (full_path)
            if (full_path(n:n).ne.bslash) then
               n = n + 1
               full_path(n:n) = bslash
            endif
            temp = full_path(1:n)//'x86_simfit_driven.exe'
            inquire (file = temp, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               x86_driven = temp
               full_path2 = full_path(1:n - 1)
               type2 = 'x86_simfit_driven.exe located' 
               call x_putadv ('Path accepted')
               path2 = x_trim100(full_path2)
            else
               call x_putfat ('Path rejected')
            endif 
            numdec = 3     
         elseif (numdec.eq.2) then  
c
c numdec = 2: get full_path3
c           
            full_path = full_path3  
            call x_getstr ('Path to 64-bit Simfit programs', full_path)
            n = len_trim (full_path)
            if (full_path(n:n).ne.bslash) then
               n = n + 1
               full_path(n:n) = bslash
            endif   
            temp = full_path(1:n)//'x64_simfit_driver.dll'
            inquire (file = temp, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               x64_simfit = temp
               full_path3 = full_path(1:n - 1)
               type3 = 'x64_simfit_driver.dll located' 
               call x_putadv ('Path accepted')
               path3 = x_trim100(full_path3)
            else
               call x_putfat ('Path rejected')
            endif 
            numdec = 3               
         elseif (numdec.eq.3) then
c
c numdec = 3: help
c           
            write (info,200)
            call x_patch2 (kumbld, ktext,
     +                     info)
            numdec = 5               
         elseif (numdec.eq.numopt - 1) then
c
c numdec 4: write x64_simfit.cfg  
c         
            yesno = .false.
            write (line,400)
            call x_yesno2 (icolor, ix, iy,
     +                     line, 
     +                     yesno)
            if (yesno) then
               call x_getnou (nout)
               open (unit = nout, file = x64_cfgfile, iostat = ios)
               if (ios.eq.0) write (nout,'(a)',iostat=ios) full_path2
               if (ios.eq.0) write (nout,'(a)',iostat=ios) full_path3
               if (ios.eq.0) then
                  write (nout,100,iostat=ios)  
                  if (ios.eq.0) write (nout,200,iostat=ios)
               endif
               close (unit = nout)
               if (ios.eq.0) type1 = 'x64_simfit.cfg located'
            endif 
            numdec = 5
         elseif (numdec.eq.numopt) then
c
c numdec = 5: return
c         
            repeet = .false.
         endif     

      enddo 
c
c format statements
c 
  100 format (
     +/
     +/   
     +/'%-------------------------------------------------------------'   
     +/)   
  200 format (
     + 'The configuration file x64_simfit.cfg'
     +/    
     +/'x64_simfit.cfg contains details required to run the 64-bit'    
     +/'versions of Simdem and Simfit. The first two lines have the'   
     +/'following meanings.'    
     +/    
     +/'Line 1: The path to x86_simfit_driven.exe'    
     +/'In Simfit installations this would be the path to the 32-bit'
     +/'Simfit binaries, e.g. C:\Program Files (x86)\Simfit\bin'     
     +/'In Simdem installations this would be the path to the 32-bit'
     +/'Simdem binaries, e.g. C:\Program Files (x86)\Simdem\bin'     
     +/    
     +/'Line 2: The path to the 64-bit Simfit binaries'    
     +/'This is not required with Simdem installations, but with Simfit'    
     +/'installations it would be, e.g. C:\Program Files\Simfit\bin' 
     +/    
     +/'For more more details read x64_simfit.txt, or x64_simdem.txt'
     +/    
     +/'Note that x64_simfit.cfg is not used in Simdem installations'
     +/'where x64_simfit_driver.dll and x86_simfit_driven.exe are on'
     +/'the path, as with the 64-bit NAG Fortran Builder.')
  300 format (
     + 'Configuring 64-bit Simfit and 64-bit Simdem'
     +/                
     +/'Current path to x64_simfit.cfg'                
     +/a
     +/a
     +/                
     +/'Current path to x86_simfit_driver.exe'                
     +/a
     +/a
     +/                
     +/'Current path to 64-bit Simfit programs'
     +/a
     +/a
     +/
     +/'Edit path to x86_simfit_driver.exe'
     +/'Edit path to 64-bit Simfit programs'
     +/'Help'
     +/'Save'
     +/'Exit 64-bit configuration options') 
  400 format ('Write current configuration details to x64_simfit.cfg') 
      end
c
c                     
           