C
C
      SUBROUTINE X_ADDSTR (FNAME, STRNG)
C
C ACTION: Add a string to the end of a text file if possible
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         28/01/2007 derived from ADDSTR 
C
      IMPLICIT   NONE  
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (IN) :: FNAME, STRNG      
C
C Locals
C      
      INTEGER    N0
      PARAMETER (N0 = 0)
      INTEGER    IOS, NOUT
      CHARACTER  TEXT*1024
      LOGICAL    THERE, READ_ONLY, REPEET
      EXTERNAL   X_GETNOU, X_ATTRIB
C
C Does the file exist ?
C                                  
      CALL X_ATTRIB (FNAME,
     +               THERE, READ_ONLY)   
      IF (.NOT.THERE .OR. READ_ONLY) RETURN
C
C Find a unit
C
      CALL X_GETNOU (NOUT)
      IF (NOUT.LT.N0) RETURN
C
C Open the file
C
      OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF  
C
C Add the string to the end of the file
C      
      REPEET = .TRUE.
      DO WHILE (REPEET)
         READ (NOUT,'(A)',IOSTAT=IOS) TEXT
         IF (IOS.LT.N0) THEN
            BACKSPACE (NOUT, IOSTAT = IOS)
            WRITE (NOUT,'(A)',IOSTAT=IOS) STRNG
            REPEET = .FALSE.
         ENDIF
      ENDDO
      CLOSE (UNIT = NOUT)              
      END
C
C
