c
c
      subroutine x_adjlab (n,
     +                     labels)
c
c action: adjust label position and rotation angle
c author: w.g.bardsley, university of manchester, u.k., 24/12/2007
c         14/09/2011 developed from adjlab$
c
      implicit none
c
c arguments
c
      integer,             intent (in) :: n
      character (len = *), intent (in) :: labels(n) 
c
c allocatable
c            
      double precision,     allocatable :: theta(:), 
     +                                     x(:), x_shift(:), 
     +                                     y(:), y_shift(:)
      character (len = 50), allocatable :: text(:)      
c
c locals
c      
      integer    i, icount, ierr, ios, numdec, numlab, numopt, nout,
     +           nstart, ntext2
      integer    ncol, nrow
      integer    k5, nwmax, numtxt
      parameter (k5 = 5, nwmax = 2000, numtxt = 21)
      integer    numbld(numtxt)
      integer    n_degrees, n_max, n_min
      parameter (n_max = 360, n_min = -n_max)
      character  blank3*3, flabel*12, fname*1024, line*100,
     +           x_sim256*1024, star3*3, text2(numtxt)*100,
     +           title*80, word24*24
      parameter (blank3 = '   ',
     +           flabel = 'f$rotate.tmp',
     +           word24 = '%simfitrotatelabelsfile%',
     +           star3 = '***') 
      logical    again, exist, repeet, read_only
      intrinsic  nint, dble
      external   x_listbx, x_sim256, x_getnou, x_patch2, x_lstbox,
     +           x_getd01, x_getjm1, x_attrib, x_putfat      
      data       numbld / numtxt*0 /
c
c check then allocate
c      
      if (n.lt.1) then
         call x_putfat ('Insufficient labels to move/rotate')
         return
      elseif (n.gt.nwmax) then
         call x_putfat ('Too many labels to move/rotate ... max = 2000')
         return 
      endif  
      
      fname = x_sim256(flabel)
      call x_attrib (fname,
     +               exist, read_only)
      if (.not.exist) then
         call x_putfat (flabel//' could not be located')
         return
      endif
      
      if (read_only) then
         call x_putfat (flabel//' must not be read_only')
         return
      endif 
        
      ierr = 0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x_shift)) deallocate(x_shift, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y_shift)) deallocate(y_shift, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(theta)) deallocate(theta, stat = ierr)
      if (ierr.ne.0) return  
     
      allocate(text(n + 2), stat = ierr)
      if (ierr.ne.0) return 
      allocate(x(n), stat = ierr)
      if (ierr.ne.0) return
      allocate(x_shift(n), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(n), stat = ierr)
      if (ierr.ne.0) return
      allocate(y_shift(n), stat = ierr)
      if (ierr.ne.0) return
      allocate(theta(n), stat = ierr)
      if (ierr.ne.0) return
c
c read the label coordinates
c
      call x_getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      read (nout,'(a)', iostat = ios) title
      read (nout,*,iostat=ios) nrow, ncol
      if (ios.eq.0) then
         if (nrow.lt.n .or. ncol.ne.k5) then
            call x_putfat ('f$rotate.tmp has incorrect dimensions')
            ios = -1
         endif   
      endif
      icount = 0   
      if (ios.eq.0 .and. title.eq.word24) then
         do i = 1, n
            icount = icount + 1
            if (ios.eq.0) read (nout,*,iostat=ios) x(i), x_shift(i),
     +                                             y(i), y_shift(i),
     +                                             theta(i)
            if (ios.ne.0) exit
         enddo
         close (unit = nout)   
      else  
         call x_putfat ('f$rotate.tmp has incorrect title') 
         close (unit = nout)
         deallocate(text, stat = ierr)
         deallocate(x, stat = ierr)
         deallocate(x_shift, stat = ierr)
         deallocate(y, stat = ierr)
         deallocate(y_shift, stat = ierr)
         deallocate(theta, stat = ierr)
         return
      endif
      if (ios.ne.0 .or. icount.ne.n) then
         call x_putfat (
     +  'Could not read all coordinates off f$rotate.tmp')
         deallocate(text, stat = ierr)
         deallocate(x, stat = ierr)
         deallocate(x_shift, stat = ierr)
         deallocate(y, stat = ierr)
         deallocate(y_shift, stat = ierr)
         deallocate(theta, stat = ierr)
         return
      endif   
c
c define text
c           
      text(1) = 'Cancel'
      text(2) = 'Help'
      do i = 1, n
         text(i + 2) = blank3//labels(i)
      enddo
c
c main loop
c      
      numdec = 2  
      repeet = .true.
      do while (repeet)  
         numopt = n + 2
         call x_listbx (numdec, numopt,
     +                  text)      
         if (numdec.eq.1) then
c
c numdec = 1: Cancel (or Apply if changes have been done)
c           
            repeet = .false.
         elseif (numdec.eq.2) then
c
c numdec = 2: help
c         
            write (text2,100)
            numbld(1) = 1   
            call x_patch2 (numbld, numtxt,
     +                     text2)
            numbld(1) = 0 
         else
c
c numdec > 2: edit coordinates
c            
            numlab = numdec - 2
            n_degrees = nint(theta(numlab))
            numopt = 4
            nstart = 9
            ntext2 = nstart + numopt - 1
            numdec = numopt
            again = .true.
            do while (again)
               write (text2,200) numlab, labels(numlab),
     +                           x(numlab), y(numlab),
     +                           x_shift(numlab), y_shift(numlab),
     +                           n_degrees  
               numbld(1) = 4
               numbld(4) = 1     
               call x_lstbox (numbld, numdec, numopt, nstart, ntext2,
     +                        text2)
               numbld(1) = 0
               numbld(4) = 0 
               if (numdec.eq.1) then
c
c change x_shift
c                 
                  write (line,300) x(numlab)
                  call x_getd01 (x_shift(numlab),
     +                           line)
                  text(1) = 'Apply'
                  text(numlab + 2)(1:3) = star3
               elseif (numdec.eq.2) then
c
c change y_shift
c               
                  write (line,400) y(numlab)
                  call x_getd01 (y_shift(numlab),
     +                           line)
                   text(1) = 'Apply'
                   text(numlab + 2)(1:3) = star3
               elseif (numdec.eq.3) then    
c
c change theta
c               
                  write (line,500)
                  call x_getjm1 (n_min, n_degrees, n_max,
     +                           line)         
                  theta(numlab) = dble(n_degrees)
                  text(1) = 'Apply'
                  text(numlab + 2)(1:3) = star3
               else
                  again = .false.
               endif 
            enddo  
            numdec = numlab + 2    
         endif     
      enddo 
c
c write out a new file
c      
      open (unit = nout, file = fname, iostat = ios)
      write (nout,'(a)',iostat=ios) word24
      write (nout,'(2i6)',iostat=ios) n, k5
      do i = 1, n
         write (nout,'(1p,5e13.5)',iostat=ios) x(i), x_shift(i), 
     +                                         y(i), y_shift(i),
     +                                         theta(i)
      enddo
      close (unit = nout)
c
c deallocate
c      
      deallocate(text, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(x_shift, stat = ierr)
      deallocate(y, stat = ierr)
      deallocate(y_shift, stat = ierr)
      deallocate(theta, stat = ierr)
c
c format statement
c      
  100 format (
     + 'Using x_shift, y_shift, and theta to move and rotate labels'
     +/
     +/'Labels displayed on this plot do not have arbitrary positions,'
     +/'as they are related to symbols with meaningful coordinates.'
     +/'For this reason, they cannot be dragged and dropped to the'
     +/'current hotspot denoted by the red arrow, like arrows and other'
     +/'graphical objects. There are two ways to adjust the positions,'
     +/'and orientation of these labels to improve readability.'  
     +/
     +/'1)`Add a new label as a graphical object and, when this is in'
     +/'  `the required position, edit the old label to replace it by'
     +/'  `a blank string. The disadvatage of this method is that you'
     +/'  `can mix up labels or drag then into misleading positions.' 
     +/'2)`Select a label now, then make small changes in x,y values,'
     +/'  `even rotating if it helps. The advantage of this technique'
     +/'  `is that you can keep check of the direction of movement from'
     +/'  `the default position, and you can easily restore the default'
     +/'  `position and angle of rotation by simply setting:'
     +/'  `x_shift = 0'
     +/'  `y_shift = 0'
     +/'  `theta = 0')
  200 format (
     + 'Moving and rotating label',i4
     +/
     +/'Current label:'
     +/a
     +/
     +/'Default x coordinate =',1p,e11.3     
     +/'Default y coordinate =',   e11.3
     +/
     +/'Change x_coordinate: x_shift =',e11.3
     +/'Change y_coordinate: y_shift =',e11.3
     +/'Change rotation angle: theta =',i6,1x,'degrees'
     +/'Apply')
  300 format ('x_shift: Note that the default x coordinate =',1p,e11.3)   
  400 format ('y_shift: Note that the default y coordinate =',1p,e11.3)
  500 format ('theta (in degrees): default theta = 0')   
      end 
c
c      