c
c
      subroutine x_allcfg
c
c action: check that all Simfit auxiliary files (e.g. *.cfg, etc.) have write permission 
c author: w.g.bardsley, university of manchester, uk, 19/06/2010
c         20/11/2019 increased n_res to 21 and made the text correct for the ProgramData folder
c      
      implicit none
      integer    i, icolor, icount
      integer    n_cfg, n_clp, n_cur, n_mat, n_orb, n_res, n_tmp, n_txt,
     +           n_vec 
      parameter (n_cfg = 25, n_clp = 20, n_cur = 20, n_mat = 20,
     +           n_orb = 12, n_res = 21, n_tmp = 2, n_txt = 5,
     +           n_vec = 20)
      integer    n_max
      parameter (n_max = n_cfg + n_clp + n_cur + n_mat + n_orb + n_res +
     +           n_tmp + n_txt + n_vec) 
      character (len = 16) cfg(n_cfg), clp(n_clp), cur(n_cur), 
     +                     mat(n_mat), orb(n_orb), res(n_res), 
     +                     tmp(n_tmp), txt(n_txt), vec(n_vec)
      character (len = 1024) fnames(n_max), x_sim256
      character (len = 100) text1(3), text2(23) 
      character (len = 80) word80, x_trim80
      character (len = 1024) word256, w_fpath2
      character (len = 1) blank
      parameter (blank = ' ')
      logical    exist, ok(n_max), read_only   
      external   x_sim256 
      external   x_attrib, w_table1, x_trim80, w_fpath2
      data       cfg / 'l_simfit.cfg',
     +                 'pspecial.cfg',       
     +                 'w_clpbrd.cfg',       
     +                 'w_curfit.cfg',       
     +                 'w_filter.cfg',       
     +                 'w_graphs.cfg',       
     +                 'w_input.cfg ',       
     +                 'w_labels.cfg',       
     +                 'w_matrix.cfg',       
     +                 'w_module.cfg',       
     +                 'w_output.cfg',       
     +                 'w_params.cfg',       
     +                 'w_ps.cfg    ',       
     +                 'w_result.cfg',       
     +                 'w_simfit.cfg',       
     +                 'w_symbol.cfg',       
     +                 'w_vector.cfg',       
     +                 'w_ftests.cfg',       
     +                 'a_recent.cfg',       
     +                 'c_recent.cfg',       
     +                 'f_recent.cfg',       
     +                 'g_recent.cfg',       
     +                 'm_recent.cfg',       
     +                 'p_recent.cfg',       
     +                 'v_recent.cfg' /   
      data       res / 'f$result.txt',   
     +                 'f$result.001',   
     +                 'f$result.002',   
     +                 'f$result.003',   
     +                 'f$result.004',   
     +                 'f$result.005',   
     +                 'f$result.006',   
     +                 'f$result.007',   
     +                 'f$result.008',   
     +                 'f$result.009',   
     +                 'f$result.010',    
     +                 'f$result.011',   
     +                 'f$result.012',    
     +                 'f$result.013',    
     +                 'f$result.014',    
     +                 'f$result.015',    
     +                 'f$result.016',    
     +                 'f$result.017',    
     +                 'f$result.018',    
     +                 'f$result.019',    
     +                 'f$result.020' /    
      data       txt / 'iterate.txt ',   
     +                 'nagifail.txt',   
     +                 'w_qnfit.txt ',   
     +                 'w_deqsol.txt',   
     +                 'w_makdat.txt' / 
      data       orb / 'f$orbits.001',
     +                 'f$orbits.002',    
     +                 'f$orbits.003',    
     +                 'f$orbits.004',    
     +                 'f$orbits.005',    
     +                 'f$orbits.006',    
     +                 'f$orbits.007',    
     +                 'f$orbits.008',    
     +                 'f$orbits.009',    
     +                 'f$orbits.010',    
     +                 'f$orbits.011',    
     +                 'f$orbits.012' / 
      data       tmp / 'tempfile.eps',
     +                 'tempfile.txt' / 
      data       clp / 'clipboard_1.tmp',  
     +                 'clipboard_2.tmp', 
     +                 'clipboard_3.tmp', 
     +                 'clipboard_4.tmp', 
     +                 'clipboard_5.tmp', 
     +                 'clipboard_6.tmp', 
     +                 'clipboard_7.tmp', 
     +                 'clipboard_8.tmp', 
     +                 'clipboard_9.tmp', 
     +                 'clipboard_10.tmp', 
     +                 'clipboard_11.tmp', 
     +                 'clipboard_12.tmp', 
     +                 'clipboard_13.tmp', 
     +                 'clipboard_14.tmp', 
     +                 'clipboard_15.tmp', 
     +                 'clipboard_16.tmp', 
     +                 'clipboard_17.tmp', 
     +                 'clipboard_18.tmp', 
     +                 'clipboard_19.tmp', 
     +                 'clipboard_20.tmp' / 
      data       mat / 'matrix_1.tmp',
     +                 'matrix_2.tmp', 
     +                 'matrix_3.tmp', 
     +                 'matrix_4.tmp', 
     +                 'matrix_5.tmp', 
     +                 'matrix_6.tmp', 
     +                 'matrix_7.tmp', 
     +                 'matrix_8.tmp', 
     +                 'matrix_9.tmp', 
     +                 'matrix_10.tmp', 
     +                 'matrix_11.tmp', 
     +                 'matrix_12.tmp', 
     +                 'matrix_13.tmp', 
     +                 'matrix_14.tmp', 
     +                 'matrix_15.tmp', 
     +                 'matrix_16.tmp', 
     +                 'matrix_17.tmp', 
     +                 'matrix_18.tmp', 
     +                 'matrix_19.tmp', 
     +                 'matrix_20.tmp' /
      data       vec / 'vector_1.tmp',
     +                 'vector_2.tmp', 
     +                 'vector_3.tmp', 
     +                 'vector_4.tmp', 
     +                 'vector_5.tmp', 
     +                 'vector_6.tmp', 
     +                 'vector_7.tmp', 
     +                 'vector_8.tmp', 
     +                 'vector_9.tmp', 
     +                 'vector_10.tmp', 
     +                 'vector_11.tmp', 
     +                 'vector_12.tmp', 
     +                 'vector_13.tmp', 
     +                 'vector_14.tmp', 
     +                 'vector_15.tmp', 
     +                 'vector_16.tmp', 
     +                 'vector_17.tmp', 
     +                 'vector_18.tmp', 
     +                 'vector_19.tmp', 
     +                 'vector_20.tmp' / 
      data       cur / 'curfit_1.tmp',
     +                 'curfit_2.tmp', 
     +                 'curfit_3.tmp', 
     +                 'curfit_4.tmp', 
     +                 'curfit_5.tmp', 
     +                 'curfit_6.tmp', 
     +                 'curfit_7.tmp', 
     +                 'curfit_8.tmp', 
     +                 'curfit_9.tmp', 
     +                 'curfit_10.tmp', 
     +                 'curfit_11.tmp', 
     +                 'curfit_12.tmp', 
     +                 'curfit_13.tmp', 
     +                 'curfit_14.tmp', 
     +                 'curfit_15.tmp', 
     +                 'curfit_16.tmp', 
     +                 'curfit_17.tmp', 
     +                 'curfit_18.tmp', 
     +                 'curfit_19.tmp', 
     +                 'curfit_20.tmp' /                
c
c initialise fnames
c     
      icount = 0
      do i = 1, n_cfg
         icount = icount + 1
         fnames(icount) = x_sim256(cfg(i))
      enddo 
      
      do i = 1, n_res
         icount = icount + 1
         fnames(icount) = x_sim256(res(i))
      enddo
      
      do i = 1, n_tmp
         icount = icount + 1
         fnames(icount) = x_sim256(tmp(i))
      enddo
      
      do i = 1, n_txt
         icount = icount + 1
         fnames(icount) = x_sim256(txt(i))
      enddo
      
      do i = 1, n_orb
         icount = icount + 1
         fnames(icount) = x_sim256(orb(i))
      enddo

      do i = 1, n_clp
         icount = icount + 1
         fnames(icount) = x_sim256(clp(i))
      enddo 

      do i = 1, n_mat
         icount = icount + 1
         fnames(icount) = x_sim256(mat(i))
      enddo 

      do i = 1, n_vec
         icount = icount + 1
         fnames(icount) = x_sim256(vec(i))
      enddo  

      do i = 1, n_cur
         icount = icount + 1
         fnames(icount) = x_sim256(cur(i))
      enddo        
c
c check for read only permissions
c       
      icount = 0
      do i = 1, n_max
         ok(i) = .true.
         call x_attrib (fnames(i),
     +                  exist, read_only) 
         if (exist .and. read_only) then
            icount = icount + 1
            ok(i) = .false.
         endif   
      enddo 
      if (icount.gt.0) then
c
c display a warning message
c        
         if (icount.eq.1) then
            write (text1,100) 'file has'
         else
            write (text1,100) 'files have'
         endif      
         icolor = 15
         call w_table1 (icolor, 'OPEN')
         icolor = 4
         do i = 1, 3
            call w_table1 (icolor, text1(i))
            icolor = 0
         enddo 
         call w_table1 (icolor, blank)
         icolor = 1
         do i = 1, n_max
            if (.not.ok(i)) then
               word256 = w_fpath2(fnames(i))
               word80 = x_trim80(word256)
               call w_table1 (icolor, word80)
            endif   
         enddo 
         icolor = 0
         write (text2,200)
         call w_table1 (icolor, blank)
         do i = 1, 20
            if (i.eq.1 .or. i.ge.16) then
               icolor = 4
            else
               icolor = 0
            endif      
            call w_table1 (icolor, text2(i))
         enddo
         call w_table1 (icolor, 'CLOSE')        
      endif        
  100 format ('ERROR: ',
     + 'Simfit auxiliary files must have read and write permissions'
     +/
     +/'The following',1x,a,1x,'the read-only attribute:')
  200 format (
     + 'This version of Simfit creates several folders on installation.'
     +/
     +/'The main folder is'
     +/'C:\PrograData\Simfit\user'
     +/'Note that this folder is hidden unless you choose to view it.' 
     +/ 
     +/'Then three subfolders are created namely:'
     +/'C:\ProgramData\Simfit\user\cfg (configuration files)'  
     +/'C:\Programdata\Simfit\user\res (results files)'
     +/'C:\ProgramData\Simfit\user\usr (For your use as required)'
     +/
     +/'Note that You may have an alternative main drive (e.g. D:) or'
     +/'be using a network but \user will be your name on the computer'
     +/'so every user has their own configuration files and archived'
     +/'results. If this message appears take the following action.'   
     +/
     +/'As administrator you must give read-write permission to the' 
     +/'file or files indicated then delete them.'
     +/'When Simfit or Simdem executables are then run as a standard'
     +/'user, defaults will be created in appropriate locations.')      
      end