c
c
      character (len = *) function x_aux256 (pname)
c
c action: returns fullpath to simdem file pname or return as a simple copy
c author: w.g.bardsley, university of manchester, u.k.
c         04/06/2009 new version derived from x_sim256  
c         11/01/2011 added temp for temporary files
c         14/01/2010 added call to w_v7path and checked for dem and doc folders
c         06/04/2011 corrected checks for tempfile.eps and extended to use the
c                    new installation scheme and only alter pname if the file exists 
c         10/05/2011 added calls to w_v7path and altered to agree with x_sim256 technique
c         15/11/2011 added matrix.txt and matrix.tmp
c
c Note: pname must be a simple file name and the
c       following simdem installation tree is assumed
c
c       ... simdem\bin
c       ... simdem\doc
c       ... simdem\dem
c       ... simdem\f95
c       ... simdem\for
c       ... ProgramData\Simfit\user\res
c       ... ProgramData\Simfit\user\usr
c       ... ProgramData\Simfit\user\cfg
c
      implicit none 
c
c argument
c         
      character (len = *), intent (in) :: pname
c
c locals
c       
      integer    x_len200
      integer    l1, l2, l3, l4, nmax
      parameter (l1 = 1, nmax = 50)
      character  pcopy*(nmax), x_aux256*1024
      character  fname*1024, simdem*1024, word2*2, word3*3, word4*4,
     +           word5*5, word7*7, word9*9, word10*10, temp*1024
      character  blank*1, bslash*1, colon*1
      parameter (blank = ' ', bslash = '\', colon = ':') 
      logical    there
      external   x_auxdir, x_len200, x_lcase1, x_triml1
      external   w_v7path
      intrinsic  index
c
c Part 1: initialise then return if pname = blank or is not a simple file name
c =======
c      

      x_aux256 = pname
      if (index(pname,bslash).ne.0 .or.
     +    index(pname,colon) .ne.0 .or.
     +    pname.eq.blank) return  
      l3 = x_len200(pname)  
      if (l3.le.5 .or. l3.gt.nmax) return

c
c define word4 = the file extension 
c        

      pcopy = pname
      call x_triml1 (pcopy)
      l3 = x_len200 (pcopy)
      call x_lcase1 (pcopy)
      word3 = pcopy(l3 - 2:l3)
      word4 = pcopy(l3 - 3:l3)
      word5 = pcopy(l3 - 4:13)

c
c Part 2: try the temp, cfg, and res folders
c =======
c

      call w_v7path (l4,
     +               'tmp', temp) 
      l4 = l4 + 1
      temp(l4:l4) = bslash
      
      if (l3.eq.12) then
         word2 = pcopy(1:2)
         if (word2.eq.'f$' .and. word4.eq.'.tmp') then 
c
c try f$123456.tmp in the temp folder
c           
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_aux256 = fname
            return
         endif
         if (pcopy.eq.'tempfile.txt') then
c
c try tempfile.txt in the temp folder
c     
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_aux256 = fname
            return
         endif      
      endif
       
      if (pcopy.eq.'w_in.tmp'   .or.
     +    pcopy.eq.'w_out.tmp'  .or.
     +    pcopy.eq.'matrix.tmp' .or.
     +    pcopy.eq.'matrix.txt' .or.
     +    pcopy.eq.'temp_file') then
c
c try w_in.tmp and w_out.tmp, etc. in the temp folder
c
         fname = temp(l1:l4)//pcopy(l1:l3)
         x_aux256 = fname
         return
      endif   
c
c try .cfg in the cfg folder 
c
      if (word4.eq.'.cfg') then
         call w_v7path (l4,
     +                  'cfg', temp)
         l4 = l4 + 1
         temp(l4:l4) = bslash
         fname = temp(l1:l4)//pcopy(l1:l3)
         x_aux256 = fname
         return
      endif 
c
c try results  
c     
      call w_v7path (l4,
     +              'res', temp)
      l4 = l4 + 1
      temp(l4:l4) = bslash
      if (l3.ge.11 .and. l3.le.12) then
         word9 = pcopy(1:9)
         if (word9.eq.'f$result.'    .or.
     +       word9.eq.'f$orbits.'    .or.              
     +       pcopy.eq.'w_deqsol.txt' .or.
     +       pcopy.eq.'w_qnfit.txt'  .or.
     +       pcopy.eq.'w_makdat.txt' .or.
     +       pcopy.eq.'iterate.txt'  ) then
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_aux256 = fname
            return
         endif       
      endif
      if (word4.eq.'.tmp') then 
         word7 = pcopy(1:7)
         if (word7.eq.'matrix_' .or.
     +       word7.eq.'vector_' .or.
     +       word7.eq.'curfit_') then  
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_aux256 = fname
            return
         endif 
         word10 = pcopy(1:10)
         if (word10.eq.'clipboard_') then 
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_aux256 = fname
            return
         endif   
      endif 
c
c try user
c  
      if (pcopy.eq.'tempfile.eps') then
         call w_v7path (l4,
     +                  'usr', temp) 
         l4 = l4 + 1
         temp(l4:l4) = bslash  
         fname = temp(l1:l4)//pcopy(l1:l3)
         x_aux256 = fname
         return
      endif   

c
c check number 1: try to get .exe in the the simdem folder 
c ==============
c
        
      call x_auxdir (l2,
     +               simdem)
      if (l2.le.2) return
      
      if (word4.eq.'.exe') then 
         fname = simdem(l1:l2)//pcopy(l1:l3)
         inquire (file = fname, exist = there)
         if (there) then
            x_aux256 = fname
            return
         endif   
      endif

c
c check number 2: check for doc or dem folder 
c ===============
c     
                     
      if (word3.eq.'.ps'  .or.
     +    word4.eq.'.eps' .or.
     +    word4.eq.'.pdf' .or.
     +    pcopy.eq.'editps.tfl' .or.
     +    pcopy.eq.'images.tfl') then
         fname = simdem(l1:l2 - 4)//'dem\'//pcopy(l1:l3)
         inquire (file = fname, exist = there)
         if (there) then
            x_aux256 = fname
            return
         endif  
         fname = simdem(l1:l2 - 4)//'doc\'//pcopy(l1:l3)
         inquire (file = fname, exist = there)
         if (there) then
            x_aux256 = fname
            return
         endif    
      endif
       
c
c check number 3: check for html and txt
c ===============
c
      
      if (word5.eq.'.html' .or. word4.eq.'.txt') then
         fname = simdem(l1:l2 - 4)//'doc\'//pcopy(l1:l3)
         inquire (file = fname, exist = there)
         if (there) then
            x_aux256 = fname
            return
         endif  
      endif    

c
c check number 4: try the for and f95 fortran code folders
c ===============
c
      
       if (word4.eq.'.for') then
          fname = simdem(l1:l2 - 4)//'for\'//pcopy(l1:l3)
          inquire (file = fname, exist = there)
          if (there) then
             x_aux256 = fname
             return
          endif     
       endif   

       if (word4.eq.'.f95') then
          fname = simdem(l1:l2 - 4)//'f95\'//pcopy(l1:l3)
          inquire (file = fname, exist = there)
          if (there) then
             x_aux256 = fname
             return
          endif     
       endif   

c
c check number 5: all options have failed so try the dem folder
c =============== This should pick up .TFL, .tf1, .tf2, .mod, etc.
c

      fname = simdem(l1:l2 - 4)//'dem\'//pcopy(l1:l3)
      inquire (file = fname, exist = there)
      if (there) then
         x_aux256 = fname
         return
      endif     
      end
c
c  