c
c
      subroutine x_auxdir (l,
     +                     simdem)
c
c action: universal version of x_auxdir (32-bit and/or 64-bit)  
c author: w.g.bardsley, university of manchester, u.k, 25/02/2017
c         24/04/2021 added first and get_program_name       
     
            implicit none              
c
c arguments
c          
      integer,             intent (out) :: l 
      character (len = *), intent (out) :: simdem  
c
c locals
c       
      integer    ios, icount, k, l_sav, nout
      character (len = 1024) fname, simdem_sav, path, temp
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    ex, first, isit64, os64, ready, there
      external   isit64, x64_auxdir, x32_auxdir 
      external   get_program_name, x_lcase1, w_v7path, w_getnou
      intrinsic  len_trim
      save       l_sav  
      save       simdem_sav
      save       first, ready
      data       icount, l_sav / 0, 0 /
      data       simdem_sav, temp / blank, blank /
      data       first, ready / .true., .false. /
c
c initialise then try get_program_name first time round
c      
      l = l_sav
      simdem = simdem_sav
      if (first) then
         first = .false.
         call get_program_name (fname)
         temp = fname
         call x_lcase1 (temp)
         k = len_trim (temp)
         if (index(temp,'\bin\simdem.exe').gt.0) then
            l_sav = k - 10
            simdem_sav(1:l_sav) = fname(1:l_sav)
            l = l_sav
            simdem = simdem_sav
            ready = .true.
         elseif (index(temp,'\bin\x64_simdem.exe').gt.0) then
            l_sav = k - 14
            simdem_sav(1:l_sav) = fname(1:l_sav)
            l = l_sav
            simdem = simdem_sav
            ready = .true.
         endif
         if (ready) then
            call w_v7path (k,
     +                     'cfg', path)
            if (path(k:k).ne.'\') then
               k = k + 1
               path(k:k) = '\'
               fname = path(1:k)//'w_simdem_path.cfg'  
               call w_getnou (nout)
               open (unit = nout, file = fname, iostat = ios) 
               write (nout,'(a)',iostat = ios) simdem_sav
               close (unit = nout) 
            endif
         endif        
      endif       
      if (ready) then
c
c values for l and simdem are already stored 
c
         l = l_sav
         simdem = simdem_sav
         return
      else    
c
c o/w see if the path has been saved previously
c       
         call w_v7path (k,
     +                  'cfg', path)
         if (path(k:k).ne.'\') then
            k = k + 1
            path(k:k) = '\'
            fname = path(1:k)//'w_simdem_path.cfg'  
            inquire (file = fname, exist = ex, iostat = ios)
            if (ex) then
               call w_getnou (nout)
               open (unit = nout, file = fname, iostat = ios) 
               if (ios.eq.0) read (nout,'(a)',iostat = ios) simdem_sav
               close (unit = nout) 
               if (ios.eq.0) then
                  ready = .true.
                  l_sav = len_trim(simdem_sav)
                  l = l_sav 
                  simdem = simdem_sav
                  return
               endif
            endif      
         endif  
      endif 
      if (icount.gt.5) then
c
c more than 5 attempts have been made so give in
c        
         l = 0 
         l_sav = 0
         simdem = blank
         simdem_sav = blank
         ready = .false.
         return
      endif   
      if (l_sav.gt.0 .and. simdem_sav.ne.blank) then
c
c check that the saved values are ok
c        
         temp = simdem_sav(1:l_sav)//'simdem.exe'
         inquire (file = temp, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            l_sav = l
            simdem_sav = simdem
            ready = .true.
            return
         endif   
         temp = simdem_sav(1:l_sav)//'x64_simdem.exe'
         inquire (file = temp, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            l_sav = l
            simdem_sav = simdem
            ready = .true.
            return
         endif
      endif        
      os64 = isit64()
      if (os64) then
c
c check for the 64-bit version
c        
         call x64_auxdir (l, 
     +                    simdem) 
         if (l.gt.0 .and. simdem.ne.blank) then
            temp = simdem(1:l)//'x64_simdem.exe'
            inquire (file = temp, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               l_sav = l
               simdem_sav = simdem
               ready = .true.
               return
            endif   
            temp = simdem(1:l)//'simdem.exe'
            inquire (file = temp, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               l_sav = l
               simdem_sav = simdem
               ready = .true.
               return
            endif           
         endif        
      endif
c
c failure so far so try for the 32-bit version
c      
      call x32_auxdir (l, 
     +                 simdem) 
      if (l.gt.0 .and. simdem.ne.blank) then
         temp = simdem(1:l)//'simdem.exe'
         inquire (file = temp, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            l_sav = l
            simdem_sav = simdem
            ready = .true.
            return
         endif   
         temp = simdem(1:l)//'x64_simdem.exe'
         inquire (file = temp, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            l_sav = l
            simdem_sav = simdem
            ready = .true.
            return
         endif           
      endif 
c
c increment icount to prevent excessive attempts
c      
      icount = icount + 1       
      end
c
c------------------------------------------------------------------
c
      subroutine x64_auxdir (l,
     +                       simdem)
     
c
c**************************************************************
c Warning: this version looks for simdem.exe and x64_simdem.exe
c**************************************************************
c
     
c
c action: get the simdem directory and its length
c author: w.g.bardsley, university of manchester, u.k.
c         18/04/2009 derived from x_simdir
c         24/06/2010 replaced call to w_config by call to x_getcfg
c         29/09/2010 added check for undefined
c         04/04/2011 extended to check using calls to w_v7path
c         01/06/2011 added l_sav and simdem_sav and check for Silverfrost folder
c         15/12/2012 added checks for x64_simdem
c         20/12/2012 restored to only checking for simdem.exe 
c         05/11/2015 now also checks for x64_simdem.exe
c
c      l: (output) length of directory string as follows:
c         l = len200(simdem) if simdem(1:l)//'simdem.exe' = ...\simdem\bin\simdem.exe exists
c         l = 0 otherwise
c simdem: (output) the directory string as follows:
c         simdem = simdem folder if simdem(1:l)//'simdem.exe' = ...\simdem\bin\simdem.exe exists
c         simdem = blank otherwise  
c    
c  Note: If successful simdem is returned with a final \ 
c        This version does not at present use the value of ierr and only performs extra work when ierr.ne.0     
c
      implicit none              
c
c arguments
c          
      integer,             intent (out) :: l 
      character (len = *), intent (out) :: simdem  
c
c locals
c      
      integer    mode, nmax
      parameter (mode = 0, nmax = 1)
      integer    ierr, ios, k, lsim, n, x_len200, nval(12)
      integer    l_sav
      character (len = 1024) cval(12), files(nmax), ftemp, simdem_sav,
     +           temp 
      character (len = 12) undef, word12
      parameter (undef = '***Undefined')
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\') 
      logical    first1, first2, there
      external   x_getcfg, x_len200, x_triml1, x_lcase1, x_putadv,
     +           x_putwar, x_putfat, w_v7path, w_flfind 
      intrinsic  len  
      save       first1, first2, l_sav, simdem_sav
      data       first1, first2 / .true., .true. /
      data       l_sav / 0 /
      data       simdem_sav / blank / 
c
c initialise the arguments
c                         
      l = 0
      simdem = blank
c
c check len(simdem)
c   
      lsim = len(simdem)
      if (lsim.lt.12) then
          call x_putfat (
     +'len(simdem) < 12, MUST be >= 12 in call to X_AUXDIR')
         return
      elseif (first1 .and. lsim.lt.256) then
         first1 = .false.
         call x_putwar (
     +'len(simdem) < 256, should be >= 1024 in call to X_AUXDIR')
      elseif (first2 .and. lsim.lt.1024) then
         first2 = .false.
         call x_putadv (
     +'len(simdem) < 1024, should be >= 1024 in call to X_AUXDIR')
      endif
c
c read the stored values if any
c              
      if (l_sav.gt.0 .and. simdem_sav.ne.blank) then
         ftemp = simdem_sav(1:l_sav)//'simdem_exe'
         inquire (file = ftemp, exist = there, iostat = ios)
         if (there .and. ios.eq.0) then
            l = l_sav
            simdem = simdem_sav
            return
         endif
         ftemp = simdem_sav(1:l_sav)//'x64_simdem_exe'
         inquire (file = ftemp, exist = there, iostat = ios)
         if (there .and. ios.eq.0) then
            l = l_sav
            simdem = simdem_sav
            return
         else   
            l_sav = 0
            simdem_sav = blank
         endif
      endif         
c      
c initialise ierr  
c
      ierr = 0
c
c check for blank or undefined
c                      
      call x_getcfg (mode, nval,
     +               cval)    
      if (cval(3).eq.blank .or. cval(3).eq.undef) then 
c
c w_simfit.cfg is ambigous so set ierr = 1
c        
         ierr = 1
      else  
c
c trim and check for final \
c      
         temp = cval(3)
         call x_triml1 (temp)
         k = x_len200(temp)
         if (temp(k:k).ne.bslash) then
            k = k + 1
            temp(k:k) = bslash
         endif 
         if (k.gt.lsim) then
c
c string supplied in subroutine call is not long enough so set ierr = 2
c           
            ierr = 2
         else             
c
c check for ...\simdem\bin and if not there set ierr = 3
c        
           word12 = temp(k - 11:k)
           call x_lcase1 (word12)
           if (word12.ne.'\simdem\bin\') then
              ierr = 3
           else   
c
c check for presence of the simdem driver and if not there set ierr = 4
c               
              ftemp = temp(1:k)//'simdem.exe'
              inquire (file = ftemp, exist = there, iostat = ios)
              if (ios.eq.0 .and. there) then
                 l = k
                 simdem = temp(1:k)
              else   
                 ierr = 4    
              endif   
              ftemp = temp(1:k)//'x64_simdem.exe'
              inquire (file = ftemp, exist = there, iostat = ios)
              if (ios.eq.0 .and. there) then
                 l = k
                 simdem = temp(1:k)
              else   
                 ierr = 4    
              endif             
            endif   
         endif   
      endif 
c
c if all is well then store l_sav and simdem_sav and return
c      
      if (ierr.eq.0) then
         l_sav = l
         simdem_sav = simdem
         return 
      endif   
c
c try the simdem 32-bit folder
c         
      call w_v7path (k,
     +               'p32', temp)
      ftemp = temp(1:k)//'\simdem\bin\simdem.exe'
      inquire (file = ftemp, exist = there, iostat = ios)
      if (ios.eq.0 .and. there .and. lsim.gt.k + 11) then
         l = k + 12
         simdem = ftemp (1:l)
         l_sav = l
         simdem_sav = simdem
         return
      endif   
c
c try a search of 32-bit NAG program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k)//'\NAG', 'simdem.exe', files)
      if (n.gt.0) then
        inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif
c
c try a search of 32-bit Silverfrost program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k)//'\Silverfrost', 'simdem.exe', files)
      if (n.gt.0) then
        inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif      
c
c try a search of all 32-bit program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k), 'simdem.exe', files)
      if (n.gt.0) then
         inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif      
c
c try the simdem 64-bit folder
c         
      call w_v7path (k,
     +               'p64', temp)
      ftemp = temp(1:k)//'\simdem\bin\x64_simdem.exe'
      inquire (file = ftemp, exist = there, iostat = ios)
      if (ios.eq.0 .and. there .and. lsim.gt.k + 11) then
         l = k + 12
         simdem = ftemp (1:l)
         l_sav = l
         simdem_sav = simdem
         return
      endif   
c
c try a search of 64-bit NAG program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k)//'\NAG', 'x64_simdem.exe', files)
      if (n.gt.0) then
        inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif
c
c try a search of all 64-bit program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k), 'x64_simdem.exe', files)
      if (n.gt.0) then
         inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif      
      end      
c
c-------------------------------------------------------------------             
c
      subroutine x32_auxdir (l,
     +                       simdem)
     
c
c*******************************************************************
c Warning: this version only looks for simdem.exe not x64_simdem.exe
c*******************************************************************
c
     
c
c action: get the simdem directory and its length
c author: w.g.bardsley, university of manchester, u.k.
c         18/04/2009 derived from x_simdir
c         24/06/2010 replaced call to w_config by call to x_getcfg
c         29/09/2010 added check for undefined
c         04/04/2011 extended to check using calls to w_v7path
c         01/06/2011 added l_sav and simdem_sav and check for Silverfrost folder
c         15/12/2012 added checks for x64_simdem
c         20/12/2012 restored to only checking for simdem.exe 
c
c      l: (output) length of directory string as follows:
c         l = len200(simdem) if simdem(1:l)//'simdem.exe' = ...\simdem\bin\simdem.exe exists
c         l = 0 otherwise
c simdem: (output) the directory string as follows:
c         simdem = simdem folder if simdem(1:l)//'simdem.exe' = ...\simdem\bin\simdem.exe exists
c         simdem = blank otherwise  
c    
c  Note: If successful simdem is returned with a final \ 
c        This version does not at present use the value of ierr and only performs extra work when ierr.ne.0     
c
      implicit none              
c
c arguments
c          
      integer,             intent (out) :: l 
      character (len = *), intent (out) :: simdem  
c
c locals
c      
      integer    mode, nmax
      parameter (mode = 0, nmax = 1)
      integer    ierr, ios, k, lsim, n, x_len200, nval(12)
      integer    l_sav
      character (len = 1024) cval(12), files(nmax), ftemp, simdem_sav,
     +           temp 
      character (len = 12) undef, word12
      parameter (undef = '***Undefined')
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\') 
      logical    first1, first2, there
      external   x_getcfg, x_len200, x_triml1, x_lcase1, x_putadv,
     +           x_putwar, x_putfat, w_v7path, w_flfind 
      intrinsic  len  
      save       first1, first2, l_sav, simdem_sav
      data       first1, first2 / .true., .true. /
      data       l_sav / 0 /
      data       simdem_sav / blank / 
c
c initialise the arguments
c                         
      l = 0
      simdem = blank
c
c check len(simdem)
c   
      lsim = len(simdem)
      if (lsim.lt.12) then
          call x_putfat (
     +'len(simdem) < 12, MUST be >= 12 in call to X_AUXDIR')
         return
      elseif (first1 .and. lsim.lt.256) then
         first1 = .false.
         call x_putwar (
     +'len(simdem) < 256, should be >= 1024 in call to X_AUXDIR')
      elseif (first2 .and. lsim.lt.1024) then
         first2 = .false.
         call x_putadv (
     +'len(simdem) < 1024, should be >= 1024 in call to X_AUXDIR')
      endif
c
c read the stored values if any
c              
      if (l_sav.gt.0 .and. simdem_sav.ne.blank) then
         ftemp = simdem_sav(1:l_sav)//'simdem_exe'
         inquire (file = ftemp, exist = there, iostat = ios)
         if (there .and. ios.eq.0) then
            l = l_sav
            simdem = simdem_sav
            return
         else   
            l_sav = 0
            simdem_sav = blank
         endif
      endif         
c      
c initialise ierr  
c
      ierr = 0
c
c check for blank or undefined
c                      
      call x_getcfg (mode, nval,
     +               cval)    
      if (cval(3).eq.blank .or. cval(3).eq.undef) then 
c
c w_simfit.cfg is ambigous so set ierr = 1
c        
         ierr = 1
      else  
c
c trim and check for final \
c      
         temp = cval(3)
         call x_triml1 (temp)
         k = x_len200(temp)
         if (temp(k:k).ne.bslash) then
            k = k + 1
            temp(k:k) = bslash
         endif 
         if (k.gt.lsim) then
c
c string supplied in subroutine call is not long enough so set ierr = 2
c           
            ierr = 2
         else             
c
c check for ...\simdem\bin and if not there set ierr = 3
c        
           word12 = temp(k - 11:k)
           call x_lcase1 (word12)
           if (word12.ne.'\simdem\bin\') then
              ierr = 3
           else   
c
c check for presence of the simdem driver and if not there set ierr = 4
c               
              ftemp = temp(1:k)//'simdem.exe'
              inquire (file = ftemp, exist = there, iostat = ios)
              if (ios.eq.0 .and. there) then
                 l = k
                 simdem = temp(1:k)
              else   
                 ierr = 4    
              endif        
            endif   
         endif   
      endif 
c
c if all is well then store l_sav and simdem_sav and return
c      
      if (ierr.eq.0) then
         l_sav = l
         simdem_sav = simdem
         return 
      endif   
c
c try the simdem 32-bit folder
c         
      call w_v7path (k,
     +               'p32', temp)
      ftemp = temp(1:k)//'\simdem\bin\simdem.exe'
      inquire (file = ftemp, exist = there, iostat = ios)
      if (ios.eq.0 .and. there .and. lsim.gt.k + 11) then
         l = k + 12
         simdem = ftemp (1:l)
         l_sav = l
         simdem_sav = simdem
         return
      endif   
c
c try a search of 32-bit NAG program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k)//'\NAG', 'simdem.exe', files)
      if (n.gt.0) then
        inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif
c
c try a search of 32-bit Silverfrost program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k)//'\Silverfrost', 'simdem.exe', files)
      if (n.gt.0) then
        inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif      

c
c try a search of all 32-bit program files
c
      n = 0
      call w_flfind (n, nmax,
     +               temp(1:k), 'simdem.exe', files)
      if (n.gt.0) then
         inquire (file = files(1), exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            k = x_len200(files(1)) - 10
            if (k.le.lsim) then
               l = k 
               simdem = files(1)(1:l)
               l_sav = l
               simdem_sav = simdem
               return
            endif   
         endif   
      endif      
      end
c
c             


