C
C
      SUBROUTINE X_BCCOPY (IBAR, IFILL, IHUE,
     +                     FACTOR,
     +                     FNAME,
     +                     ABORT)
C
C ACTION : Copy bar chart editing to the bar chart file
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 12/10/98
C          19/05/2007 added INTENTS
C          19/09/2001 derived from BCCOPY$ 
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: IBAR, IFILL(IBAR), IHUE(IBAR)
      DOUBLE PRECISION,    INTENT (IN)  :: FACTOR(IBAR) 
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME 
      LOGICAL,             INTENT (OUT) :: ABORT 
C
C Locals
C       
      INTEGER    I, IERR, IFI, IHU, IOS, NIN, NOUT, NPTS
      DOUBLE PRECISION A, B, C, D, E, F, G, H, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  FILEX*1024, TITLE*100
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   X_GETNOU, W_GETTMP, W_DELEET
      EXTERNAL   X_PUTFAT
C
C Open the file supplied and check if, it is correctly formatted
C
      ABORT = .TRUE.
      CALL X_GETNOU (NIN)
C...1
      IERR = 1
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) GOTO 20
C...2
      IERR = 2
      CALL W_GETTMP (IOS,
     +             FILEX)
      IF (IOS.NE.0) GOTO 20
C...3
      IERR = 3
      CALL X_GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.0) GOTO 20
C...4
      IERR = 4
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
C...5
      IERR = 5
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NPTS, I
      IF (IOS.NE.0 .OR. NPTS.NE.IBAR .OR. I.NE.9) GOTO 20
C
C Read the values and copy to a temporary file
C
      DO I = 1, NPTS
C...
         IERR = IERR + 1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D, E, F, G, H,
     +                                         Z
         IF (IOS.NE.0) GOTO 20
         IFI = IFILL(I)
         IF (IFI.LT.0 .OR. IFI.GT.10) IFI = 1
         IHU = IHUE(I)
         IF (IHU.LT.0 .OR. IHU.GT.71) IHU = 15
         H = FACTOR(I)
         IF (H.LT.ZERO .OR. H.GT.ONE) H = ONE
C...
         IERR = IERR + 1
         WRITE (NOUT,100,ERR=20,IOSTAT=IOS) A, B, C, D, E, F, IFI, H,
     +                                      IHU
         IF (IOS.NE.0) GOTO 20
      ENDDO
      IOS = 0
      DO WHILE (IOS.EQ.0)
         READ (NIN,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.EQ.0) WRITE (NOUT,'(A)',IOSTAT=IOS) TITLE
      ENDDO
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
C
C Copy the edited values back into the original file
C
      CALL X_GETNOU (NOUT)
C...
      IERR = IERR + 1
      OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) GOTO 20
      CALL X_GETNOU (NIN)
C...
      IERR = IERR + 1
      OPEN (UNIT = NIN, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.0) GOTO 20
C...
      IERR = IERR + 1
      READ (NOUT,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
C...
      IERR = IERR + 1
      READ (NOUT,*,END=20,ERR=20,IOSTAT=IOS) NPTS, I
      IF (IOS.NE.0 .OR. NPTS.NE.IBAR .OR. I.NE.9) GOTO 20
      DO I = 1, NPTS
C...
         IERR = IERR + 1
         READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) A, B, C, D, E, F, IFI,
     +                                           H, IHU
         IF (IOS.NE.0) GOTO 20
C...
         IERR = IERR + 1
         WRITE (NOUT,100,ERR=20,IOSTAT=IOS) A, B, C, D, E, F, IFI, H,
     +                                      IHU
         IF (IOS.NE.0) GOTO 20
      ENDDO
      IOS = 0
      DO WHILE (IOS.EQ.0)
         READ (NIN,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.EQ.0) WRITE (NOUT,'(A)',IOSTAT=IOS) TITLE
      ENDDO
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
C
C Delete temporary file then return
C
      CALL W_DELEET (FILEX,
     +               ASKIF, THERE)
      ABORT = .FALSE.
      RETURN
C
C Crash
C
   20 CONTINUE
      ABORT = .TRUE.
      WRITE (TITLE,200) IERR, IOS
      CALL X_PUTFAT (TITLE)
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
C
C Format statements
C      
  100 FORMAT (1P,6E11.3,I3,0P,F6.3,I4)
  200 FORMAT ('File copy error',I6,' in X_BCCOPY: IOSTAT =',I6)
      END
C 
C