C
C
      SUBROUTINE X_BCPANL (NGROUP,
     +                     PLINE, PSYMB)
C
C ACTION : Edit bar chart panel
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/05/2011
C          17/09/2011 derived from BCPANL$ 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NGROUP
      CHARACTER (LEN = *), INTENT (INOUT) :: PLINE(NGROUP),
     +                                       PSYMB(NGROUP)
C
C Locals
C
      INTEGER    ISEND, NUMHLP, N0, N1	
      PARAMETER (ISEND = 0, NUMHLP = 20, N0 = 0, N1 = 1)
      CHARACTER (LEN = 100) HELP(NUMHLP) 
      INTEGER    NSWAP
      EXTERNAL   X_NEWSTR
      EXTERNAL   X_SELSTR
C
C Check
C      
      IF (NGROUP.LT.N1) RETURN
C
C Initialise
C
      WRITE (HELP,100)
C
C Main loop
C
      NSWAP = N1
      DO WHILE (NSWAP.GT.N0)
         CALL X_SELSTR (NSWAP, NUMHLP, NGROUP,
     +                  HELP, PLINE)
         IF (NSWAP.GT.N0) THEN
C
C Edit a label
C
            CALL X_NEWSTR (ISEND,
     +                     PLINE(NSWAP), PSYMB(NSWAP))
         ENDIF
      ENDDO   
C
C Format statements
C      
  100 FORMAT (
     + 'Editing barcharts and information panels'
     +/
     +/'Bar grouping details are set using the configuration options'
     +/'for data supplied as a matrix, i.e. automatic grouping. So,'
     +/'use [Configure] to set your own fill-style/colour defaults,'
     +/'but note that advanced bar chart files override defaults.'
     +/'You should realise that bars plotted on the graph and bars'
     +/'plotted on information panels are, to a degree, independent.'
     +/'This allows maximum versatility, e.g. when a bar chart'
     +/'does not consist of groups with fixed numbers of elements.'
     +/'So, if you want to design an information panel to reflect'
     +/'ungrouped data, just set fill styles and labels as required,'
     +/'and suppress the rest, i.e. over-ride the defaults.'
     +/
     +/'Bars on the plot or in the information panel are identified'
     +/'in the menus by number, fill style and colour. So decide'
     +/'which items you require, then set these individually and'
     +/'suppress the unwanted ones from the menu. Note that, if you'
     +/'suppress an information panel text label by typing in a blank,'
     +/'then the associated bar key will also be suppressed.')
      END
C
C
