c
c
      subroutine x_cfgfil (ios, kdummy, ldummy, modsav, nitems, nout,
     +                     nval,
     +                     cval, line, ntype, path,
     +                     cancel, ok, read_only, there)
c
c action: creat a new cfg file
c author: w.g.bardsley, university of manchester, u.k., 10/05/2011
c         31/01/2013 deleted adding configure.txt if present as a local file
c         30/08/2015 added call to x_getcfg to refresh the current saved copies 
c         18/07/2017 added call to use_gsdll to check cval(8)
c         06/11/2022 added pdfrdr
c         08/11/2022 added epsrdr
c
      implicit none
c
c arguments
c
      integer,             intent (in)    :: modsav, nitems, nout             
      integer,             intent (inout) :: ios, kdummy(nitems),
     +                                       ldummy(nitems),
     +                                       nval(nitems)
      character (len = *), intent (in)    :: ntype, path
      character (len = *), intent (inout) :: cval(nitems),
     +                                       line(2*nitems) 
      logical,             intent (in)    :: cancel, ok
      logical,             intent (in)    :: read_only
      logical,             intent (inout) :: there
c
c locals
c      
      integer    i 
      integer    jsend, mode
      parameter (jsend = 6, mode = 1)
      integer    ipcent_low, ipcent_mid, ipcent_high
      parameter (ipcent_low = 50, ipcent_mid = 80, ipcent_high = 95)
      integer    jpcent_low, jpcent_mid, jpcent_high
      parameter (jpcent_low = 75, jpcent_mid = 100, jpcent_high = 150)
      integer    kpcent_low, kpcent_mid, kpcent_high
      parameter (kpcent_low = 20, kpcent_mid = 30, kpcent_high = 60)
      character (len = 20) undef, use_dll
      parameter (  undef = '***Undefined',
     +           use_dll = '***DLL used ') 
      character (len = 50) pstop
      parameter (pstop = '%End of configuration parameters')
      character (len = 80) mssage
      logical    askif, usedll, use_gsdll 
      parameter (askif = .false.)
      external   check_cval, pdfrdr, epsrdr
      external   x_infofl, x_putadv, x_getcfg, use_gsdll
      external   w_deleet             

c                                                 
c*************************************************
c start of code to create a new configuration file
c*************************************************
c
      
c
c attempt to create w_simfit.cfg on exit with new settings
c     
      if (.not.there .or. .not.cancel) then
         if (.not.ok .or. (modsav.eq.1 .and. ios.ne.0)) then
            if (there) then
               if (read_only) then
                  call x_infofl (jsend,
     +                           path)                   
                  return
               else
                  call w_deleet (path,
     +                         askif, there)
                  if (there) then
                     call x_infofl (jsend,
     +                              path)                            
                     return
                  endif
               endif
            endif
            open (unit = nout, file = path, iostat = ios)
            if (ios.eq.0) then
               do i = 1, nitems
                  if (i.eq.1) then
                     write (line(1),'(i5,1x,a)') nval(1), ntype
                  else
                     if (i.eq.nitems -2) then
                        if (nval(i).lt.ipcent_low .or.
     +                      nval(i).gt.ipcent_high) nval(i) = ipcent_mid
                     elseif (i.eq.nitems -1) then
                        if (nval(i).lt.jpcent_low .or.
     +                      nval(i).gt.jpcent_high) nval(i) = jpcent_mid
                     elseif (i.eq.nitems) then
                        if (nval(i).lt.kpcent_low .or.
     +                      nval(i).gt.kpcent_high) nval(i) = kpcent_mid
                     endif
                     write (line(i),'(i5)') nval(i)
                  endif 
c
c start of code to define any missing executables as undef
c                  
                  if (i.eq.1  .or. i.eq.2  .or.  
     +                i.eq.7  .or. i.eq.12) then 
                     inquire (file = cval(i), exist = there,
     +                        iostat = ios)
                     if (.not.there .or. ios.ne.0) cval(i) = undef
                  elseif (i.eq.3) then
                     call check_cval (i,
     +                                cval)
                  elseif (i.eq.8) then 
                     usedll = use_gsdll()
                     if (usedll) then
                        cval(8) = use_dll
                     else   
                        inquire (file = cval(8), exist = there,
     +                           iostat = ios)
                        if (.not.there .or. ios.ne.0) cval(8) = undef   
                     endif 
                  elseif (i.eq.8) then
                     call epsrdr (cval(10))   
                  elseif (i.eq.11) then   
                     call pdfrdr (cval(11))
                  endif  
c
c end of code to define any missing executables as undef
c                           
                  line(nitems + i) = cval(i)
               enddo
               do i = 1, 2*nitems
                  write (nout,'(a)') line(i)
               enddo
               do i = 1, nitems
                  write (nout,'(i5)') kdummy(i)
               enddo
               do i = 1, nitems
                  write (nout,'(i5)') ldummy(i)
               enddo
               write (nout,'(a)') pstop
               close (unit = nout) 
               call x_getcfg (mode, nval,
     +                        cval) 
            else
               write (mssage,100)
               call x_putadv (mssage)
               close (unit = nout)
               call w_deleet (path,
     +                      askif, there)
            endif
         endif   
      endif 
c
c format string 
c      
  100 format ('Simfit failed to create w_simfit.cfg')      
      
c                                               
c***********************************************
c end of code to create a new configuration file
c***********************************************
c
      end
c
c      