c
c
      subroutine x_cfgini (kdummy, ldummy, ndummy, nitems,
     +                     cdummy)
c
c action: initialise the default configuration items
c author: w.g.bardsley, university of manchester, u.k. 10/05/2011
c
c Note: 1) When called and there is no configuation file this routine will attempt to setup 
c          a meaningful configuration
c       2) When called and a configuration file exists it only attempts to repair the
c          existing configuration for the main items
c   
c         09/09/2012 added calls to x_repair
c         20/12/2012 removed checks for x64_simfit.exe and x64_simdem.exe
c         02/11/2015 replaced checks for x64_simfit.exe and x64_simdem.exe
c         26/02/2017 universal version using isit64
c         14/05/2017 added gsview and sumatraPDF and made cdummy starting estimates
c                    language independent
c         29/05/2017 removed sumatraPDF as a substitute for gsview
c         27/09/2017 increased kpcent_mid from 30 to 40  
c         06/11/2022 added pdfrdr  
c         08/11/2022 added epsrdr
c         23/11/2022 suppressed ndummy(9) and edited pdfrdr and epsrdr 
c         
      implicit none
c
c arguments
c                 
      integer,             intent (in)    :: nitems
      integer,             intent (out)   :: kdummy(nitems),
     +                                       ldummy(nitems),
     +                                       ndummy(nitems)
      character (len = *), intent (out)   :: cdummy(nitems)
c
c local
c      
      integer    i, ios, j, jsend, l
      integer    isend
      parameter (isend = 1)
      integer    ipcent_mid
      parameter (ipcent_mid = 80)
      integer    jpcent_mid
      parameter (jpcent_mid = 100)
      integer    kpcent_mid
      parameter (kpcent_mid = 40)
      character (len = 1024) path, stub, temp
      character (len = 12) cfg_path
      parameter (cfg_path = 'w_simfit.cfg')
      character (len = 12) word12 
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\')
      character (len = 20) undef
      parameter (undef = '***Undefined') 
      character (len = 20) not_used
      parameter (not_used = '***Not used')  
      logical    abort, repair, there
      logical    isit64, os64
      external   adjust_config_cval
      external   x_lcase1, x_linux4, x_putadv, x_cfgdir, x_repair
      external   w_system, w_v7path
      external   isit64, pdfrdr, epsrdr
c
c check nitems
c      
      if (nitems.lt.12) then
         call x_putadv ('NITEMS less than 12 in call to X_CFGINI')
         return
      endif 
       
c  
c*********************************************************************                                                                   
c*********************************************************************
c start of code to initialise the dummy variables if first time called
c*********************************************************************
c********************************************************************* 
c
       
      call x_cfgdir (i,
     +               path)
      path(i + 1:i + 12) = cfg_path
c
c initialise the integers
c
      do i = 1, nitems - 2
         ndummy(i) = 1
      enddo
      ndummy(3) = 0!switch off defining individual results files
      ndummy(5) = 0!switch off checking for simfit programs
      ndummy(9) = 0!switch off check for pdf reader
      ndummy(nitems - 2) = ipcent_mid!% display used for plot 
      ndummy(nitems - 1) = jpcent_mid!% font size 
      ndummy(nitems) = kpcent_mid!number of rows in table
c
c initialise the character variables then overwrite those set by w_v7path
c         
      write (cdummy,100)
c
c start of refining cdummy starting estimates to be language independent
c      
      call w_v7path (l,
     +               'win', path)
      if (path(l:l).eq.bslash) then
         cdummy(1) = path(1:l)//'Notepad.exe'
         cdummy(2) = path(1:l)//'Explorer.exe'
      else
         cdummy(1) = path(1:l)//bslash//'Notepad.exe'  
         cdummy(2) = path(1:l)//bslash//'Explorer.exe'
      endif
      
      call w_v7path (l,
     +               'p64', path)
      if (path(l:l).eq.bslash) then
         cdummy(3) = path(1:l)//'simfit\bin'
         cdummy(8) = path(1:l)//'gs\gs9.21\bin\gswin64c.exe'
         call epsrdr (cdummy(10))
         call pdfrdr (cdummy(11))
      else
         cdummy(3) = path(1:l)//bslash//'simfit\bin'
         cdummy(8) = path(1:l)//bslash//'gs\gs9.21\bin\gswin64c.exe'
         call epsrdr (cdummy(10))
         call pdfrdr (cdummy(11))
      endif
      
      call w_v7path (l,
     +               's32', path)
      if (path(l:l).eq.bslash) then
         cdummy(12) = path(1:l)//'Calc.exe'
      else 
         cdummy(12) = path(1:l)//bslash//'Calc.exe'        
      endif   
c
c end of refining cdummy starting estimates to be language independent
c                   
      call adjust_config_cval (cdummy)      
c
c initialise the advanced counters
c         
      do i = 1, nitems
         kdummy(i) = 1
         ldummy(i) = 0
      enddo
      ldummy(6) = 100
      ldummy(7) = 100
      ldummy(8) = 100
      ldummy(9) = 100  
      ldummy(10) = 15
      ldummy(11) = 6
      ldummy(12) = 0  
c
c first try to initialise the linux paths
c         
      call x_linux4 (isend, 
     +               cdummy,
     +               abort)         
c
c if this fails then re-initialise the characters and check for system files
c           
      os64 = isit64() 
      if (abort) then  
c
c must be a windows installation so initialise windows defaults
c         
         inquire (file = path, exist = there, iostat = ios)
         if (ios.eq.0 .and. .not.there) then
c
c ---------------------------------------------------------------
c there is no current configuration file so try to assign cval(3)
c ---------------------------------------------------------------
c            
            call get_program_name@(temp)
            j = index(temp, bslash, back = .true.)
            stub = temp(1:j) 
            cdummy(3) = undef
            cdummy(7) = not_used
            word12 = blank
            if (j.gt.12) then
               word12 = temp(j - 11:j)
               call x_lcase1 (word12)
            endif
            
            if (word12.eq.'\simfit\bin\') then
               if (os64) then   
                  temp = stub(1:j)//'x64_simfit.exe'   
               else
                  temp = stub(1:j)//'w_simfit.exe'
               endif      
               inquire (file = temp, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
c
c cval(3) points to x64_simfit.exe or w_simfit.exe
c                 
                  cdummy(3) = stub(1:j - 1)
                  cdummy(7) = not_used 
               endif  
            else
               ios = 0
               there = .false.   
            endif
            
            if (ios.eq.0 .and. .not.there .and.
     +          word12.eq.'\simdem\bin\') then
               if (os64) then
                  temp = stub(1:j)//'x64_simdem.exe'
               else    
                  temp = stub(1:j)//'simdem.exe'
               endif   
               inquire (file = temp, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then  
c                 
c cval(3) points to simdem.exe or x64_simdem.exe
c                       
                  cdummy(3) = stub(1:j - 1)
                  cdummy(7) = not_used
               endif
            endif

            if (ios.eq.0 .and. .not.there) then
c
c cdummy(3) seems to be incorrect so use x_repair
c              
               jsend = 0
               call x_repair (jsend,
     +                        cdummy(3),
     +                        abort)
               if (abort) then
                  repair = .true.
                  jsend = 2
                  call x_repair (jsend,
     +                           cdummy(3),
     +                           abort)
               else
                  repair = .false.
               endif
               if (repair .and. abort) then
                  jsend = 3
                  call x_repair (jsend,
     +                           cdummy(3),
     +                           abort)
               endif  
            endif  
            
c
c try to find the Windows and user-installed auxiliaries
c            
            call w_system (cdummy(1), 'notepad.exe', there)
            
            call w_system (cdummy(2), 'explorer.exe', there)
            
            
            call epsrdr (cdummy(8))      
            call epsrdr (cdummy(10))
            call pdfrdr (cdummy(11))
     
            call w_system (cdummy(12), 'calc.exe', there) 
         else
c
c ----------------------------------------------------------
c Check using x_repair even if there is a configuration file 
c ----------------------------------------------------------
c         
            call get_program_name@(temp)
            j = index(temp, bslash, back = .true.)
            stub = temp(1:j) 
            word12 = blank
            if (j.gt.12) then
               word12 = temp(j - 11:j)
               call x_lcase1 (word12)
            endif
            
            if (word12.eq.'\simfit\bin\') then   
               if (os64) then
                  temp = stub(1:j)//'x64_simfit.exe'   
               else   
                  temp = stub(1:j)//'w_simfit.exe'   
               endif   
               inquire (file = temp, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
c
c cval(3) points to x64_simfit.exe or w_simfit.exe
c                 
                  cdummy(3) = stub(1:j - 1)
                  cdummy(7) = not_used 
                  jsend = 4
                  call x_repair (jsend,
     +                           cdummy(3),
     +                           abort)
               endif  
            else
               ios = 0
               there = .false.   
            endif
            
            if (ios.eq.0 .and. .not.there .and.
     +          word12.eq.'\simdem\bin\') then
               if (os64) then
                  temp = stub(1:j)//'x64_simdem.exe'
               else   
                  temp = stub(1:j)//'simdem.exe'
               endif   
               inquire (file = temp, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then  
c                 
c cval(3) points to simdem.exe or x64_simdem.exe
c                       
                  cdummy(3) = stub(1:j - 1)
                  cdummy(7) = not_used 
                  jsend = 4
                  call x_repair (jsend,
     +                           cdummy(3),
     +                           abort)
               endif
            endif
            
            jsend = 0
            call x_repair (jsend,
     +                     cdummy(3),
     +                     abort)
            if (abort) then
               repair = .true.
               jsend = 1
               call x_repair (jsend,
     +                        cdummy(3),
     +                        abort)
            else
               repair = .false.   
            endif   
            if (repair .and. abort) then
               jsend = 2
               call x_repair (jsend,
     +                        cdummy(3),
     +                        abort)
            endif
            if (repair .and. abort) then
               jsend = 3
               call x_repair (jsend,
     +                        cdummy(3),
     +                        abort)
            endif                                                                 
            if (repair .and. .not.abort) then
               jsend = 4
               call x_repair (jsend,
     +                        cdummy(3),
     +                        abort)
            endif   
         endif
      else    
c
c must be a linux installation so re-initialise nval(1), kval(8)
c         
         ndummy(1) = 0   
         kdummy(8) = 0
      endif   
c
c format statement
c      
  100 format (
     + 'C:\Windows\Notepad.exe'
     +/'C:\Windows\Explorer.exe'
     +/'C:\Program Files\Simfit\bin'
     +/'Results'
     +/'User'
     +/'Config'
     +/'***Not used'
     +/'***Use DLL'
     +/'Temp'
     +/'***Use DLL'
     +/'Windows default'
     +/'C:\Windows\System32\Calc.exe')      
c                                    
c*******************************************************************
c*******************************************************************
c End of code to initialise the dummy variables if first time called
c*******************************************************************
c*******************************************************************
c
      end
c
c              
      subroutine pdfrdr (fname)
c
c action: return 'Windows default' to use shellx to select the Windows Default
c author: w.g.bardsley university of manchester u.k., 10/11/2022
c      
      implicit none
c
c argument
c      
      character (len = *), intent (inout) :: fname
      fname = 'Windows default'
      end


      
      subroutine epsrdr (fname)
      
c
c action: check for Ghostscript DLL or return message 
c author: w.g.bardsley university of manchester u.k., 14/11/2022
c      
      implicit none
      logical usedll, use_gsdll, os64, isit64
      external use_gsdll, isit64
c
c argument
c      
      character (len = *), intent (inout) :: fname
c
c locals
c      
      usedll = use_gsdll()
      os64 = isit64()
      if (usedll) then
         if (os64) then 
            fname = 'gsDLL64.dll will be used'
         else   
            fname = 'gsDLL32.dll will be used'
         endif   
      else  
        if (os64) then 
           fname = 'Needs ...\bin\gsDLL64.dll'
        else
           fname = 'Needs ...\bin\gsDLL32.dll' 
        endif 
      endif  
      end 
c
c      