c
c
      subroutine x_chkext (fname,
     +                     noisy, ok)
c
c action: check a file extension to see if it is a common binary type
c author: w.g.bardsley, university of manchester, uk, 08/09/2010
c         22/12/2018 replaced .pdf by .bat
c
c noisy = .true. then call x_infofl o/w silent exit
c
      implicit none
c
c arguments
c          
      character (len = *) , intent (in)  :: fname
      logical             , intent (in)  :: noisy
      logical             , intent (out) :: ok
c
c locals
c      
      integer    k, x_len200
      integer    n5
      parameter (n5 = 5)
      character (len = 1) blank
      parameter (blank = ' ')
      external   x_infofl, x_lcase1, x_len200
      character (len = 4) word4
c
c initialise ok
c      
      ok = .true.
c
c check for blank file name
c      
      if (fname.eq.blank) then
         ok = .false.
         if (noisy) call x_infofl (n5,
     +                             'blank file name')
         return
      endif               
c
c define word4
c      
      k = x_len200(fname)
      if (k.lt.5) return
      word4 = fname(k - 3:k) 
      call x_lcase1 (word4)
c
c check for a common binary type file extension
c      
      if (word4.eq.'.exe' .or. word4.eq.'.dll' .or.
     +    word4.eq.'.xls' .or. word4.eq.'.doc' .or.
     +    word4.eq.'.bmp' .or. word4.eq.'.jpg' .or.
     +    word4.eq.'.emf' .or. word4.eq.'.tif' .or.
     +    word4.eq.'.wmf' .or. word4.eq.'.bat' .or.
     +    word4.eq.'.pcx' .or. word4.eq.'.png' .or.
     +    word4.eq.'.com' .or. word4.eq.'.chm' .or.
     +    word4.eq.'.gif' .or. word4.eq.'.dvi' .or.
     +    word4.eq.'.cht' .or. word4.eq.'.hlp' .or.
     +    word4.eq.'.wav' .or. word4.eq.'.pip' .or.
     +    word4.eq.'.ico' .or. word4.eq.'.eit' .or.
     +    word4.eq.'.xsl' .or. word4.eq.'.sys' .or.
     +    word4.eq.'.obj' .or. word4.eq.'.zip') then
         ok = .false.
         if (noisy) call x_infofl (n5,
     +                             fname)               
         ok = .false.
      endif
      end
c
c      
