C
C
      SUBROUTINE X_CHKMEN (NSTART, NTEXT, NUMDEC, NUMOPT, NUMPOS,
     +                     SRNAME, TEXT, 
     +                     ABORT)
C
C ACTION: Check menu arguments for consistency
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 5/2/97
C         28/01/2007 derived from CHKMEN
C         06/11/2023 now only checks numpos(i) for hot-keys if CHK_NUMPOS = .TRUE.  
C
C This subroutine checks all arguments passed to the Simfit menu routines
C to make sure the arguments are consistent. It should only be activated
C during program development and, if it reacts during normal use, then there
C is an error in the calling program which must be identified and put right.
C 
C NSTART: (input/unchanged) starting line for menu items in TEXT
C  NTEXT: (input/unchanged) total number of text lines
C NUMDEC: (input/unchanged) starting decision number
C NUMOPT: (input/unchanged) total number of menu items, i.e. options
C NUMPOS: (input/unchanged) position of hot key in menu item
C SRNAME: (input/unchanged) the calling subroutine
C   TEXT: (input/unchanged) text array i.e.header/options/trailer
C  ABORT: (output) error indicator  
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NSTART, NTEXT, NUMDEC,
     +                                     NUMOPT, NUMPOS(NUMOPT) 
      CHARACTER (LEN = *), INTENT (IN)  :: SRNAME, TEXT(NTEXT)  
      LOGICAL,             INTENT (OUT) :: ABORT 
C
C Locals
C      
      INTEGER    NHOT
      PARAMETER (NHOT = 50)
      INTEGER    IHOT(NHOT)
      INTEGER    I, J, K, L
      INTEGER    ICHAR, X_LEN200
      INTEGER    N0, N1, N2, N32, N48, N57, N65, N90, N97, N122
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N32 = 32, N48 = 48, N57 = 57,
     +           N65 = 65, N90 = 90, N97 = 97, N122 = 122)
      CHARACTER  LINE*100
      LOGICAL    CHK_NUMPOS, NUMPOS_CHK
      PARAMETER (NUMPOS_CHK = .FALSE.)
      EXTERNAL   X_PUTWAR, X_PUTFAT, X_LEN200
      INTRINSIC  ICHAR
C
C First set ABORT = .TRUE. and check for serious errors
C
      ABORT = .TRUE.
      CHK_NUMPOS = NUMPOS_CHK
C
C Check NSTART, NTEXT and NUMOPT
C
      IF (NSTART.LT.N1 .OR. NTEXT.LT.N1 .OR.
     +    NUMOPT.LT.N1 .OR. NSTART.GT.NTEXT .OR.
     +    NSTART + NUMOPT - N1.GT.NTEXT) THEN
         WRITE (LINE,100) SRNAME
         CALL X_PUTFAT (LINE)
         RETURN
      ENDIF
C
C Check NUMOPT
C
      IF (NUMOPT.LT.N2 .OR. NUMOPT.GT.NTEXT) THEN
         WRITE (LINE,200) SRNAME
         CALL X_PUTFAT (LINE)
         RETURN
      ENDIF
C
C Now set ABORT = .FALSE. and check for minor errors
C                   
      ABORT = .FALSE.
C
C Check NUMDEC
C
      IF (NUMDEC.LT.N1 .OR. NUMDEC.GT.NUMOPT) THEN
         WRITE (LINE,300) SRNAME
         CALL X_PUTWAR (LINE)
      ENDIF
C
C Check NUMPOS IF CHK_NUMPOS = .TRUE.
C
      IF (CHK_NUMPOS) THEN
         J = N0
         DO I = NSTART, NSTART + NUMOPT - N1
            J = J + N1
            K = X_LEN200(TEXT(I))
            L = NUMPOS(J)
            IF (L.LT.N1 .OR. L.GT.K) THEN
               WRITE (LINE,400) J, SRNAME
               CALL X_PUTWAR (LINE)
            ENDIF
            IHOT(J) = ICHAR(TEXT(I)(L:L))
         ENDDO
C
C Check NUMPOS hot keys
C
         DO I = N1, NUMOPT
            J = IHOT(I)
            IF (J.LT.N48 .OR.
     +          (J.GT.N57 .AND. J.LT.N65) .OR.
     +          (J.GT.N90 .AND. J.LT.N97) .OR.
     +          J.GT.N122) THEN
                WRITE (LINE,500) I, SRNAME
                CALL X_PUTWAR (LINE)
            ENDIF
            IF (J.GE.97 .AND. J.LE.122) IHOT(I) = IHOT(I) - N32
         ENDDO
C
C Check for repeats
C
         DO I = N1, NUMOPT - N1
            DO J = I + N1, NUMOPT
               IF (IHOT(I).EQ.IHOT(J)) THEN
                  WRITE (LINE,600) I, J, SRNAME
                  CALL X_PUTWAR (LINE)
               ENDIF
            ENDDO
         ENDDO
      ENDIF
  100 FORMAT ('NSTART/NUMOPT/NTEXT inconsistent in call to',1X,A)
  200 FORMAT ('NUMOPT unacceptable in call to',1X,A)
  300 FORMAT ('NUMDEC out of range in call to',1X,A)
  400 FORMAT ('NUMPOS(',I2,') unacceptable in call to',1X,A)
  500 FORMAT ('HOTKEY(',I2,') unacceptable in call to',1X,A)
  600 FORMAT ('HOTKEY(',I2,') = HOTKEY(',I2,') in call to',1X,A)
      END
C
C
