c
c
      subroutine x_chktic (nxtic,
     +                     xmax, xmin,
     +                     xtype)
c
c action: check that tick marks are at integers
c author: w.g.bardsley, university of manchester, u.k.m 18/10/2006
c         14/09/2011 developed from chktic$
c     
      implicit none
c
c arguments
c          
      integer,             intent (in) :: nxtic
      double precision,    intent (in) :: xmax, xmin
      character (len = 1), intent (in) :: xtype
c
c locals
c       
      integer    i, iy, n, numtxt
      parameter (numtxt = 12)
      integer    numbld(numtxt) 
      double precision delta, epsi, x1, x2, y1, y2 
      double precision factor
      parameter (factor = 1000.0d+00)
      character  text(numtxt)*100, yesno(3)*5
      logical    allok
      external   x_patch2  
      intrinsic  max, min, dble, nint
c
c define n, x1 and x2
c      
      n = nxtic + 1
      x1 = min(xmax,xmin)
      x2 = max(xmax,xmin)
      if (n.gt.1 .and. x2.gt.x1) then 
c
c initialise
c      
         allok = .true.
         do i = 1, 3 
            yesno(i) = 'Yes'
         enddo   
         numbld(1) = 1
         do i = 2, numtxt
            numbld(i) = 0
         enddo   
         delta = (x2 - x1)/dble(n - 1)
         epsi = (x2 - x1)/factor
         y1 = x1
         iy = nint(y1)
         y2 = dble(iy)
         if (abs(y2 - y1).gt.epsi) then
            allok = .false. 
            yesno(1) = 'No'
            numbld(7) = 1
         endif 
         y1 = x1 + delta
         iy = nint(y1) 
         y2 = dble(iy)
         if (abs(y2 - y1).gt.epsi) then
            allok = .false.
            yesno(2) = 'No'
            numbld(8) = 1
         endif 
         y1 = x2
         iy = nint(y1)
         y2 = dble(iy)
         if (abs(y2 - y1).gt.epsi) then
            allok = .false. 
            yesno(3) = 'No'
            numbld(9) = 1
         endif 
         if (.not.allok) then
c
c warn user that not all are ok
c         
            write (text,100) xtype, x1, yesno(1), x1 + delta, yesno(2),
     +                       x2, yesno(3)             
            call x_patch2 (numbld, numtxt,
     +                     text)            
         endif
      endif 
c
c format statement
c        
  100 format (
     + 'Warning about inconsistent',1x,a,1x,'axis tick marks'
     +/  
     +/'You have selected to display integer values at'
     +/'the tick marks, but not all values at the tick'
     +/'marks are integers as follows:'
     +/
     +/'First value`',1p,e12.4,1x,a
     +/'Next value `',   e12.4,1x,a
     +/'Last value `',   e12.4,1x,a
     +/
     +/'Adjust first value, last value, and number of tick'
     +/'marks, or plot floating point values instead.')      
      end                                                         
      
c
c