c
c
      subroutine x_dquote (isend, l, 
     +                     fname)
c
c action: add or remove double quotes to file names
c author: w.g.bardsley, university of manchester, u.k. 20/05/2017
c     
      implicit none
c
c arguments
c      
      integer,             intent(in)    :: isend 
      integer,             intent(out)   :: l 
      character (len = *), intent(inout) :: fname 
c
c local
c      
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      character (len = 1024) fcopy
      character (len = 1   ) blank, dquote
      parameter (blank = ' ', dquote = '"')
      external   x_putfat
      intrinsic  index, adjustl
c
c initialise then check
c
      fname = adjustl(fname)
      l = len_trim(fname)
      if (l.le.n0) return  
      if (isend.eq.n0) then
         call x_putfat ('ISEND = 0 in call to X_dquote')
         return
      endif
      if (isend.lt.n0) then
c
c isend < 0, remove quotes
c        
         if (index(fname,dquote).le.n0) return
         if (fname(l:l).eq.dquote) fname(l:l) = blank
         if (fname(n1:n1).eq.dquote) fname(n1:n1) = blank  
      else
c
c isend > 0, add quotes
c         
         if (fname(n1:n1).eq.dquote .and. fname(l:l).eq.dquote) return  
         if (fname(l:l).ne.dquote) then
           l = l + n1
           fname(l:l) = dquote
         endif
         if (fname(n1:n1).ne.dquote) then
            fcopy = dquote//fname(n1:l)
            l = l + n1
            fname = fcopy(n1:l)
         endif      
      endif
      fname = adjustl(fname)
      l = len_trim(fname)
      end
c
c      