C 
C
      SUBROUTINE X_EDICFG (ISEND)
C
C ACTION: edit w_ps.cfg
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 12/12/2000
C         23/04/2007 added INTENTS
C         20/10/2013 introduced IBOT, ITOP and GETJM1  
C
C         ISEND = 1: Edit fonts
C         ISEND = 2: Edit line thickness
C
      IMPLICIT   NONE 
C
C Argument
C      
      INTEGER, INTENT (IN) :: ISEND
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N13, N72
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N13 = 13, N72 = 72)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4)
      INTEGER    I, IBOT, ITOP, NUMPOS(N13)
      INTEGER    IDEV, IVAL, NCOLOR, NFONT
      INTEGER    IDEV_D, IVAL_D, NCOLOR_D, NFONT_D
      DOUBLE PRECISION RED(N72), BLUE(N72), GREEN(N72),
     +                 RED_D(N72), BLUE_D(N72), GREEN_D(N72)
      DOUBLE PRECISION SIZE_1, SIZE_D, THICK, THICK_D,
     +                 XINCH(N0:N1), YINCH(N0:N1), ZSCALE(N0:N1),
     +                 XINCH_D(N0:N1), YINCH_D(N0:N1), ZSCALE_D(N0:N1)
      DOUBLE PRECISION XBOT, XTOP, X_WGBCFG
      CHARACTER   TEXT(20)*80, LINE*100
      EXTERNAL    X_WPSCFG, X_GETDM1, X_PUTADV, X_WGBCFG, X_GETJM1
      EXTERNAL    X_LBOX02
C
C Read the current values off w_ps.cfg
C
      CALL X_WPSCFG (N0, N72,
     +               IDEV, IVAL, THICK, SIZE_1,
     +               XINCH, YINCH, ZSCALE,
     +               NFONT, NCOLOR,
     +               RED, GREEN, BLUE)
C
C Initialise the default values
C
      CALL X_WPSCFG (N3, N72,
     +               IDEV_D, IVAL_D, THICK_D, SIZE_D,
     +               XINCH_D, YINCH_D, ZSCALE_D,
     +               NFONT_D, NCOLOR_D,
     +               RED_D, GREEN_D, BLUE_D)
      IF (ISEND.EQ.N1) THEN
C
C Fonts
C
            WRITE (TEXT,100)
            NUMDEC = NFONT
            NUMOPT = N13
            DO I = N1, N13
               NUMPOS(I) = N1
            ENDDO
            CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                     TEXT)
            NFONT = NUMDEC
C
C Scale fonts
C
            WRITE (LINE,200) SIZE_1, SIZE_D
            XBOT = 0.25D+00
            XTOP = 2.5D+00
            CALL X_GETDM1 (XBOT, SIZE_1, XTOP, 
     +                     LINE)
      ELSEIF (ISEND.EQ.N2) THEN
C
C Line thickness
C
            CALL X_PUTADV (
     +'Sets overall (not relative) Windows line width in pixels')
            IBOT = 1
            ITOP = 10
            IF (IDEV.LT.IBOT) THEN
               IDEV = IBOT
            ELSEIF (IDEV.GT.ITOP) THEN
               IDEV = ITOP
            ENDIF      
            WRITE (LINE,300) IDEV, IDEV_D
            CALL X_GETJM1 (IBOT, IDEV, ITOP,
     +                     LINE)
      ENDIF
C
C Write the edited values to w_ps.cfg
C
      CALL X_WPSCFG (N1, N72,
     +               IDEV, IVAL, THICK, SIZE_1,
     +               XINCH, YINCH, ZSCALE,
     +               NFONT, NCOLOR,
     +               RED, GREEN, BLUE)
C
C Refresh WGBCFG$
C
      THICK = X_WGBCFG(N0) 
C
C Format statements
C      
  100 FORMAT (
     + 'Times-Roman'
     +/'Times-Bold'
     +/'Times-Italic'
     +/'Times-BoldItalic'
     +/'Helvetica'
     +/'Helvetica-Bold'
     +/'Helvetica-Oblique'
     +/'Helvetica-BoldOblique'
     +/'Courier'
     +/'Courier-Bold'
     +/'Courier-Oblique'
     +/'Courier-BoldOblique'
     +/'Symbol')
  200 FORMAT (
     +'Overall font size factor required ( Current =',F5.2,
     +                                 ',  Default =',F5.2,' )')
  300 FORMAT (
     +'Windows line width factor required ( Current =',I3,
     +                                  ',  Default =',I3,' )')
      END
C 
C