C
C
      SUBROUTINE X_EDITAX (KANGLE, KTIC, MDROP, MTIC, NWORDS,
     +                     ZCOORD, ZDROP, ZMAX, ZMIN, ZZBOT, ZZTOP,
     +                     LOGO, WORDS, VECTOR,
     +                     DEND_G, NUMBER, PCENTX, PHIGHX, PLOTX,
     +                     ROTATE, SHOW_XAXIS, TOINT)
C
C ACTION : Edit the X-axis
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 8/11/92
C          Derived from GKSAXS by adding ROTATE etc.
C          12/09/1996 added ZCOORD, ZZBOT, ZZTOP to slide axis along
C          18/09/1996 added PLOTX
C          23/09/1996 added VECTOR
C          14/07/1997 win32 version
C          18/02/2000 added PCENTX
C          23/02/2000 added PHIGHX
C          23/10/2000 added SELSTR
C          19/12/2000 added display/suppress all labels facility
C          20/07/2001 added SHOW_XAXIS and LVIEW2
C          15/08/2001 added MDROP and ZDROP
C          13/10/2004 added ITYPE, XSIZE, STORE, WORD6, FSIZES$
C          11/07/2005 added DEND_G, call to EDITLB$ and extensive editing
C          18/10/2006 added calls to CHKTIC$ 
C          20/05/2007 added INTENTS
C          21/12/2007 added call to SAVGKS$
C          19/07/2009 added call to GRFSIG$ 
C          26/08/2009 new version of GRFSIG$ and PHIGHX now disabled but retained
C          02/12/2010 replaced SAVGKS$ by SAVLGL$
C          19/09/2011 derived from EDITAX$
C          08/02/2013 improved definition of INFO(6) 
C
C          All arguments are input/output except NWORDS and LOGO (which should = 'X')
C
      IMPLICIT   NONE
C
C Arguments
C                        
      INTEGER,             INTENT (IN)    :: NWORDS
      INTEGER,             INTENT (INOUT) :: KANGLE, KTIC, MDROP, MTIC
      DOUBLE PRECISION,    INTENT (INOUT) :: ZCOORD, ZDROP, ZMAX, ZMIN,
     +                                       ZZBOT, ZZTOP
      CHARACTER (LEN = *), INTENT (INOUT) :: WORDS(NWORDS),
     +                                       VECTOR(NWORDS)
      CHARACTER (LEN = *), INTENT (IN)    :: LOGO
      LOGICAL,             INTENT (INOUT) :: DEND_G, NUMBER, PCENTX,
     +                                       PHIGHX, PLOTX(NWORDS),
     +                                       ROTATE, SHOW_XAXIS, TOINT
C
C Locals
C
      INTEGER    ISEND, ITYPE
      PARAMETER (ISEND = 2, ITYPE = 5)
      INTEGER    I, IADD1, NDEC, NPTS
      INTEGER    ISIG, MTRANS, NFIG, NSIG
      INTEGER    IBOT, IMID, ITOP
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 4, IXL = 4, IYL = 4)
      INTEGER    NUMOPT, NUMPOS(10)
      DOUBLE PRECISION XSIZE
      DOUBLE PRECISION XBIG, YBIG, ZBIG
      CHARACTER  WORD1*1, WORD4*4, WORD5*5, WORD11(3)*11
      CHARACTER  INFO(17)*30, LINE*100, TEXT(30)*100
      LOGICAL    AGAIN, STORE, XLABEL
      LOGICAL    STEMP, TITLES
      PARAMETER (STEMP = .FALSE., TITLES = .TRUE.)
      EXTERNAL   SAVLGL$, SAVETR$ 
      EXTERNAL   X_GETDG2, X_GETJM1, X_GETDM1, X_PUTADV, X_FSIZES,
     +           X_EDITLB, X_CHKTIC, X_GRFSIG 
      EXTERNAL   X_LBOX02, X_TRIML1, X_LVIEW2
      INTRINSIC  MIN
      DATA       NUMPOS / 10*1 /
C
C Check for XLABEL
C      
      CALL SAVLGL$(ISEND, 
     +             XLABEL, STEMP)
      IF (.NOT.XLABEL) THEN
         CALL X_PUTADV ('Labels are not being plotted')       
         RETURN
      ENDIF    
C
C Check then initialise XSIZE
C
      WORD1 = LOGO(1:1)
      IF (WORD1.NE.'X' .AND. WORD1.NE.'x') THEN
         LINE = 'LOGO not X or x in call to EDITAX$'
         CALL X_PUTADV (LINE)
         WORD1 = 'X'
      ENDIF
      STORE = .FALSE.
      CALL X_FSIZES (ITYPE,
     +               XSIZE,
     +               STORE)
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Check if tick marks are at integers
C       
         IF (NUMBER .AND. TOINT) THEN
            CALL X_CHKTIC (MTIC,
     +                     ZMAX, ZMIN,
     +                     LOGO)
         ENDIF 
C
C Integers or floating point numbers
C
         IF (TOINT) THEN
            INFO(1) = 'Integers'
         ELSE
            INFO(1) = 'Floating point'
         ENDIF
C
C Add a % character
C
         IF (PCENTX) THEN
            INFO(2) = 'add a % character'
         ELSE
            INFO(2) = 'no % character'
         ENDIF
C
C Significant figures
C 
         STORE = .FALSE.
         CALL SAVETR$ (MTRANS,
     +                 STORE)          
         ISIG = 3
         CALL X_GRFSIG (ISIG, MTRANS, NFIG, NSIG,
     +                 'X')        
         IF (NSIG.EQ.1) THEN
            INFO(3) = 'Low precision'
         ELSEIF (NSIG.EQ.2) THEN   
            INFO(3) = 'Automatic precision'
         ELSE
            INFO(3) = 'High precision'
         ENDIF
C
C Numbers or text strings
C
         IF (NUMBER) THEN
            INFO(4) = 'Numbers'
         ELSE
            INFO(4) = 'Text strings'
            INFO(1) = INFO(4)
            INFO(2) = INFO(4)
            INFO(3) = INFO(4)
         ENDIF
C
C Rotate labels
C
         IF (ROTATE) THEN
            IF (KANGLE.EQ.2) THEN
               INFO(5) = '- 45 degrees'
            ELSEIF (KANGLE.EQ.3) THEN
               INFO(5) = '- 60 degrees'
            ELSEIF (KANGLE.EQ.4) THEN
               INFO(5) = '- 75 degrees'
            ELSEIF (KANGLE.EQ.5) THEN
               INFO(5) = '- 90 degrees'
            ELSEIF (KANGLE.EQ.6) THEN
               INFO(5) = '+ 90 degrees'
            ELSEIF (KANGLE.EQ.7) THEN
               INFO(5) = '+ 75 degrees'
            ELSEIF (KANGLE.EQ.8) THEN
               INFO(5) = '+ 60 degrees'
            ELSEIF (KANGLE.EQ.9) THEN
               INFO(5) = '+ 45 degrees'
            ELSE
               INFO(5) = '**Error**'
            ENDIF
         ELSE
            INFO(5) = 'Horizontal'
         ENDIF

         ITOP = MIN(MTIC + 1, NWORDS)
         IADD1 = 0
         DO I = 1, ITOP
            IF (PLOTX(I)) IADD1 = IADD1 + 1
         ENDDO
         WRITE (INFO(6),'(A,I3)') 'Number suppressed =', ITOP - IADD1
         
C
C Label size
C
         WRITE (WORD5,'(F5.2)') XSIZE
         CALL X_TRIML1 (WORD5)
         INFO(7) = WORD5
C
C Number of tick marks
C
         WRITE (WORD5,'(I5)') MTIC + 1
         CALL X_TRIML1 (WORD5)
         INFO(8) = WORD5
C
C Type of tick marks
C
         IF (MTIC.LT.1) THEN
            INFO(9) = 'None'
         ELSEIF (KTIC.EQ. 1) THEN
            INFO(9) = 'Out'
         ELSEIF (KTIC.EQ.2) THEN
            INFO(9) = 'None'
         ELSE
            INFO(9) = 'In'
         ENDIF
C
C Range of data to be plotted
C
         WRITE (WORD11(1),'(1P,E11.4)') ZMIN
         WRITE (WORD11(2),'(1P,E11.4)') ZMAX
C
C Translation
C
         WRITE (WORD11(3),'(1P,E11.4)') ZCOORD
         INFO(10) = WORD11(1)//','//WORD11(2)
         INFO(11) = WORD11(3)
C
C Suppress X axis
C
         IF (SHOW_XAXIS) THEN
            INFO(12) = 'Display' 
         ELSE
            INFO(12) = 'Suppress'
         ENDIF
         WRITE (WORD4,'(I4)') MDROP
         CALL X_TRIML1 (WORD4)
         INFO(13) = WORD4
         WRITE (WORD4,'(F4.2)') ZDROP
         INFO(14) = WORD4
         INFO(15) = '...'
C
C Display main menu
C
         WRITE (TEXT,100) WORD1, (INFO(I), I = 1, 15)
         NUMOPT = 15
         NDEC = NUMOPT
         CALL X_LVIEW2 (IXL, IYL, NDEC, NUMOPT,
     +                  TEXT, TITLES)
         IF (NDEC.EQ.1) THEN
C
C Integers/Decimals
C
            TOINT = .NOT.TOINT
         ELSEIF (NDEC.EQ.2) THEN
C
C Add/suppress %
C
            PCENTX = .NOT.PCENTX
         ELSEIF (NDEC.EQ.3) THEN
C
C High/Low precision
C
            ISIG = 2
            CALL X_GRFSIG (ISIG, MTRANS, NFIG, NSIG,
     +                     'X')
            IF (NSIG.EQ.1) THEN
               PHIGHX = .FALSE.
            ELSE               
               PHIGHX = .TRUE.
            ENDIF   
         ELSEIF (NDEC.EQ.4) THEN
C
C Numbers/Labels
C
            NUMBER = .NOT.NUMBER
         ELSEIF (NDEC.EQ.5) THEN
C
C Rotation
C
            WRITE (TEXT,200)
            NUMOPT = 9
            CALL X_LBOX02 (ICOLOR, IXL, IYL, KANGLE, NUMOPT, NUMPOS,
     +                     TEXT)
            IF (KANGLE.EQ.1) THEN
               ROTATE = .FALSE.
            ELSE
               ROTATE = .TRUE.
            ENDIF
         ELSEIF (NDEC.EQ.6 .AND. MTIC.GE.0) THEN
C
C Labels: edit/display/suppress
C
            NPTS = MIN(MTIC + 1, NWORDS)
            CALL X_EDITLB (NPTS, NPTS,
     +                     WORDS, VECTOR,
     +                     DEND_G, PLOTX)
         ELSEIF (NDEC.EQ.7) THEN
C
C Font size
C
            STORE = .TRUE.
            CALL X_FSIZES (ITYPE,
     +                     XSIZE, 
     +                     STORE)
         ELSEIF (NDEC.EQ.8) THEN
C
C Tick marks: number
C
            IBOT = 0
            IMID = MTIC + 1
            ITOP = NWORDS
            CALL X_GETJM1 (IBOT, IMID, ITOP,
     +'Number of tick-marks/labels required')
            MTIC = IMID - 1
         ELSEIF (NDEC.EQ.9) THEN
C
C Tick marks: direction
C
            WRITE (TEXT,300)
            NUMOPT = 3
            IMID = NUMOPT
            CALL X_LBOX02 (ICOLOR, IXL, IYL, IMID, NUMOPT, NUMPOS,
     +                     TEXT)
            KTIC = IMID
         ELSEIF (NDEC.EQ.10) THEN
C
C Axes: range
C
            WRITE (LINE,400) ZMIN, ZMAX
            XBIG = ZMIN
            YBIG = ZMAX
            CALL X_GETDG2 (XBIG, YBIG,
     +                     LINE)
            ZMIN = XBIG
            ZMAX = YBIG
         ELSEIF (NDEC.EQ.11) THEN
C
C Axes: translate
C
            XBIG = ZZBOT
            ZBIG = ZZTOP
            WRITE (LINE,500) WORD1, ZCOORD
            YBIG = ZCOORD
            CALL X_GETDM1 (XBIG, YBIG, ZBIG,
     +                     LINE)
            ZCOORD = YBIG
            CALL X_PUTADV (
     +'Translations are suppressed by boxes round data or plot offsets')
         ELSEIF (NDEC.EQ.12) THEN
C
C Axes: display/suppress
C
            SHOW_XAXIS = .NOT.SHOW_XAXIS
         ELSEIF (NDEC.EQ.13) THEN
C
C Double labels: threshold
C
            IBOT = 10
            ITOP = 200
            WRITE (LINE,600) MDROP
            CALL X_GETJM1 (IBOT, MDROP, ITOP,
     +                     LINE)
         ELSEIF (NDEC.EQ.14) THEN
C
C Double threshold: distance
C
            XBIG = 0.02D+00
            ZBIG = 0.20D+00
            WRITE (LINE,700) ZDROP
            CALL X_GETDM1 (XBIG, ZDROP, ZBIG,
     +                     LINE)
         ELSE
C
C Apply
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO  
C
C Format statements
C      
  100 FORMAT (
     + 'Display features of the',1X,A1,'-axis`Current settings'
     +/'Labels: integers or decimals `',A
     +/'Labels: add % characters     `',A
     +/'Labels: significant figures  `',A
     +/'Labels: plot text or numbers `',A
     +/'Labels: horizontal or rotated`',A
     +/'Labels: edit/display/suppress`',A
     +/'Labels: font scaling factor  `',A
     +/'Tick marks: change number    `',A
     +/'Tick marks: change direction `',A
     +/'Axis: change range plotted   `',A
     +/'Axis: move to new position   `',A
     +/'Axis: display or suppress    `',A
     +/'Double label: threshold      `',A
     +/'Double label: translation    `',A
     +/'Apply                        `',A)
  200 FORMAT (
     + 'Horizontal'
     +/'45 degrees clockwise'
     +/'60 degrees clockwise'
     +/'75 degrees clockwise'
     +/'90 degrees clockwise'
     +/'90 degrees anticlockwise'
     +/'75 degrees anticlockwise'
     +/'60 degrees anticlockwise'
     +/'45 degrees anticlockwise')
  300 FORMAT (
     + 'Ticks pointing out'
     +/'Suppress ticks/labels'
     +/'Ticks pointing in')
  400 FORMAT (
     +'Start-value, Stop-value for axes (current =',
     +1P,E11.3,',',E11.3,')')
  500 FORMAT (
     +'Coordinate required for',1X,A,1X,'axis (current =',1P,E11.3,')')
  600 FORMAT (
     +'No. of labels before swapping to double rows (current =',I3,')')
  700 FORMAT (
     +'Translation required for double labels (current =',1P,E11.3,')')
      END
C
C
