C
C
      SUBROUTINE X_EDITBC (IFILL, IHUE, NGROUP, NPTS,
     +                     FACTOR, WIDE, WIDE1,
     +                     LABEL1, VECTOR,
     +                     BARCAP, BARKEY)
C
C ACTION : Edit bar chart
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 23/6/95
C          20/02/1997 Added BARCAP_1
C          14/07/1997 win32 version
C          25/10/2000 reorganised to use SELSTR
C          30/11/2000 introduced call to PALETT$
C          08/01/2003 increased no. keys to 15 when BARKEY = .TRUE. and
C                     introduced WIDE, WIDE1
C          26/10/2004 added NGROUP to argument list and APPLY_1
C          13/11/2004 added call to LABELS and SYMLAB$
C          19/05/2007 added INTENTS and removed calls to LABELS and SYMLAB$
C          18/12/2010 added PLINE and PSYMB in call to BCKEYS$
C          14/05/2011 added NGSAV and NTEMP and extensively edited 
C                     Note: bar chart panels are now edited by BCPANL$ so this routine 
C                           should not called with BARKEY = .TRUE. any more. 
C                           The code is left in left in for possible future use
C          19/09/2011 removed pline and psymb and added call to savbck$
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NGROUP, NPTS
      INTEGER,             INTENT (INOUT) :: IFILL(NPTS), IHUE(NPTS)
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NPTS), WIDE, WIDE1
      CHARACTER (LEN = *), INTENT (INOUT) :: LABEL1(NPTS), VECTOR(NPTS)
      LOGICAL,             INTENT (INOUT) :: BARCAP, BARKEY
C
C Locals
C
      INTEGER    I, ISEND, NAPPLY, NMAX, NUMHLP, NUMTXT
      PARAMETER (ISEND = 0, NMAX = 500, NUMHLP = 20)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, N0, N1, N20
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, N0 = 0, N1 = 1,
     +           N20 = 20)
      INTEGER    MODE
      PARAMETER (MODE = 0)
      INTEGER    NUMBLD(30), NUMPOS(20), NGSAV, NTEMP, NUMSTR
      INTEGER    NSWAP
      DOUBLE PRECISION XBOT, XMID, XTOP
      PARAMETER (XBOT = 0.0D+00, XTOP = 1.0D+00)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (BOT = 0.001D+00, TOP = 10.0D+00)
      CHARACTER  BLANK*1, LETTER*1
      PARAMETER (BLANK = ' ', LETTER = 's')
      CHARACTER  CIPHER*20, DOIT*20, TEXT(30)*100, WORD1*1
      CHARACTER  HELP(NUMHLP)*100, STRNG(NMAX)*50
      LOGICAL    AGAIN, APPLY_1, BARCAP_1
      LOGICAL    BORDER, STORE
      PARAMETER (BORDER = .FALSE., STORE = .TRUE.)
      SAVE       APPLY_1, BARCAP_1
      EXTERNAL   SAVBCK$
      EXTERNAL   X_GETJM1, X_NEWSTR, W_PALETT, X_GETDM1 
      EXTERNAL   X_YESNO2, X_LBOX02, X_SELSTR, W_PATCH1
      INTRINSIC  MOD, MIN
      SAVE       NGSAV 
      DATA       NGSAV / 20 /
      DATA       NUMPOS / 20*1 /
      DATA       APPLY_1, BARCAP_1 / .TRUE., .TRUE. /
      DATA       NUMBLD / 30*0 /
C
C Initialise
C
      IF (BARKEY) THEN
         NAPPLY = 0
         NUMDEC = 5
         NUMSTR = N20
         NTEMP = NGSAV
      ELSE
         NUMDEC = 6
         NUMSTR = NPTS
         NGSAV = MIN(NGROUP,N20)
         NTEMP = NPTS/NGROUP
      ENDIF
      IF (NUMSTR.LE.NMAX) THEN
         WRITE (HELP,500)
         DO I = N1, NUMSTR
            WRITE (CIPHER,600) IHUE(I)
            IF (IFILL(I).EQ.1) THEN
               STRNG(I) = 'Outline '//CIPHER
            ELSEIF (IFILL(I).EQ.2) THEN
               STRNG(I) = 'Solid '//CIPHER
            ELSEIF (IFILL(I).EQ.3) THEN
               STRNG(I) = 'Diagonal up '//CIPHER
            ELSEIF (IFILL(I).EQ.4) THEN
               STRNG(I) = 'Diagonal down '//CIPHER
            ELSEIF (IFILL(I).EQ.5) THEN
               STRNG(I) = 'Criss-cross '//CIPHER
            ELSEIF (IFILL(I).EQ.6) THEN
               STRNG(I) = 'Horizontal '//CIPHER
            ELSEIF (IFILL(I).EQ.7) THEN
              STRNG(I) = 'Vertical '//CIPHER
            ELSEIF (IFILL(I).EQ.8) THEN
               STRNG(I) = 'Dashed lines '//CIPHER
            ELSEIF (IFILL(I).EQ.9) THEN
               STRNG(I) = 'Dotted lines '//CIPHER
            ELSEIF (IFILL(I).EQ.10) THEN
               STRNG(I) = 'Dashed-Dotted '//CIPHER
            ELSE
               WRITE (STRNG(I),100) I
            ENDIF
            IF (BARKEY .AND. LABEL1(I).EQ.BLANK) WRITE (STRNG(I),100) I
         ENDDO
      ENDIF
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (BARKEY) THEN
            WRITE (TEXT,200)
            NUMOPT = 3
         ELSE
            IF (APPLY_1) THEN
               NAPPLY = NPTS/NGROUP
               WORD1 = LETTER
               DOIT = '[Yes]'
            ELSE
               NAPPLY = 1
               WORD1 = BLANK
               DOIT = '[No]'
            ENDIF
            WRITE (TEXT,300) NAPPLY, WORD1, NAPPLY, WORD1, NAPPLY,
     +                       WORD1, DOIT
            NUMOPT = 10
         ENDIF
         NUMDEC = NUMOPT - N1
         CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                  TEXT)
         NSWAP = N0
         IF (NUMDEC.EQ.NUMOPT) THEN
C
C Apply changes
C
            AGAIN = .FALSE.
            NUMDEC = N0

         ELSEIF (NUMDEC.LE.4) THEN
C
C Choose item to edit
C
            IF (NUMDEC.EQ.1) THEN
               IF (NUMSTR.GT.NMAX) THEN
                  NSWAP = N0
                  CALL X_GETJM1 (N0, NSWAP, NPTS,
     +           'Number of the item to be edited (0 for no change)')
               ELSE
                  CALL X_SELSTR (NSWAP, NUMHLP, NTEMP,
     +                           HELP, LABEL1)
               ENDIF
            ELSEIF (NUMDEC.LE.4 .AND. .NOT.BARKEY) THEN
               IF (NUMSTR.GT.NMAX) THEN
                  NSWAP = N0
                  CALL X_GETJM1 (N0, NSWAP, NPTS,
     +           'Number of the item to be edited (0 for no change)')
               ELSE
                  CALL X_SELSTR (NSWAP, NUMHLP, NUMSTR,
     +                           HELP, STRNG)
               ENDIF
            ENDIF
         ENDIF
         IF (NSWAP.GT.N0 .AND. NUMDEC.EQ.1) THEN
C
C Edit a label
C
            CALL X_NEWSTR (ISEND,
     +                     LABEL1(NSWAP), VECTOR(NSWAP))
         ELSEIF (NSWAP.GT.N0 .AND. NUMDEC.EQ.2 .AND. .NOT.BARKEY) THEN
C
C Edit a fill style
C
            NUMOPT = 12
            WRITE (TEXT,400) NSWAP
            IF (IFILL(NSWAP).GT.-1 .AND. IFILL(NSWAP).LT.9) THEN
               NUMDEC = IFILL(NSWAP) + N1
            ELSE
               NUMDEC = NUMOPT
            ENDIF
            CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                     TEXT)
            IF (NUMDEC.LT.NUMOPT) THEN
               IFILL(NSWAP) = NUMDEC - N1
               IF (NSWAP.LE.NMAX) THEN
                  I = NSWAP
                  WRITE (CIPHER,600) IHUE(I)
                  IF (IFILL(I).EQ.1) THEN
                     STRNG(I) = 'Outline '//CIPHER
                  ELSEIF (IFILL(I).EQ.2) THEN
                     STRNG(I) = 'Solid '//CIPHER
                  ELSEIF (IFILL(I).EQ.3) THEN
                     STRNG(I) = 'Diagonal up '//CIPHER
                  ELSEIF (IFILL(I).EQ.4) THEN
                     STRNG(I) = 'Diagonal down '//CIPHER
                  ELSEIF (IFILL(I).EQ.5) THEN
                     STRNG(I) = 'Criss-cross '//CIPHER
                  ELSEIF (IFILL(I).EQ.6) THEN
                     STRNG(I) = 'Horizontal '//CIPHER
                  ELSEIF (IFILL(I).EQ.7) THEN
                    STRNG(I) = 'Vertical '//CIPHER
                  ELSEIF (IFILL(I).EQ.8) THEN
                     STRNG(I) = 'Dashed lines '//CIPHER
                  ELSEIF (IFILL(I).EQ.9) THEN
                     STRNG(I) = 'Dotted lines '//CIPHER
                  ELSEIF (IFILL(I).EQ.10) THEN
                     STRNG(I) = 'Dashed-Dotted '//CIPHER
                  ELSE
                     WRITE (STRNG(I),100) I
                  ENDIF
                  IF (BARKEY .AND. LABEL1(I).EQ.BLANK)
     +                WRITE (STRNG(I),100) I
               ENDIF
            ENDIF
            NUMDEC = 2
         ELSEIF (NSWAP.GT.N0 .AND. NUMDEC.EQ.3 .AND. .NOT.BARKEY) THEN
C
C Edit a bar width
C
            XMID = FACTOR(NSWAP)
            CALL X_GETDM1 (XBOT, XMID, XTOP,
     +      'Fractional width required (i.e. between 0 and 1)')
            FACTOR(NSWAP) = XMID
            NUMDEC = 3
         ELSEIF (NSWAP.GT.N0 .AND. NUMDEC.EQ.4 .AND. .NOT.BARKEY) THEN
C
C Edit a colour
C
            NUMDEC = IHUE(NSWAP)
            CALL W_PALETT (NUMDEC, MODE)
            IHUE(NSWAP) = NUMDEC
            IF (NSWAP.LE.NMAX) THEN
               I = NSWAP
               WRITE (CIPHER,600) IHUE(I)
               IF (IFILL(I).EQ.1) THEN
                  STRNG(I) = 'Outline '//CIPHER
               ELSEIF (IFILL(I).EQ.2) THEN
                  STRNG(I) = 'Solid '//CIPHER
               ELSEIF (IFILL(I).EQ.3) THEN
                  STRNG(I) = 'Diagonal up '//CIPHER
               ELSEIF (IFILL(I).EQ.4) THEN
                  STRNG(I) = 'Diagonal down '//CIPHER
               ELSEIF (IFILL(I).EQ.5) THEN
                  STRNG(I) = 'Criss-cross '//CIPHER
               ELSEIF (IFILL(I).EQ.6) THEN
                  STRNG(I) = 'Horizontal '//CIPHER
               ELSEIF (IFILL(I).EQ.7) THEN
                 STRNG(I) = 'Vertical '//CIPHER
               ELSEIF (IFILL(I).EQ.8) THEN
                  STRNG(I) = 'Dashed lines '//CIPHER
              ELSEIF (IFILL(I).EQ.9) THEN
                  STRNG(I) = 'Dotted lines '//CIPHER
               ELSEIF (IFILL(I).EQ.10) THEN
                  STRNG(I) = 'Dashed-Dotted '//CIPHER
               ELSE
               WRITE (STRNG(I),100) I
               ENDIF
               IF (BARKEY .AND. LABEL1(I).EQ.BLANK)
     +                WRITE (STRNG(I),100) I
            ENDIF
            NUMDEC = 4
         ELSEIF (AGAIN .AND. NUMDEC.EQ.5 .AND. .NOT.BARKEY) THEN
C
C Toggle APPLY_1
C
            APPLY_1 = .NOT.APPLY_1
         ELSEIF (AGAIN .AND. NUMDEC.EQ.6 .AND. .NOT.BARKEY) THEN
C
C Line thickness for main bars
C
            CALL X_GETDM1 (BOT, WIDE, TOP,
     +     'Line thickness required for main bars (default = 1)')
            NUMDEC = NUMOPT
         ELSEIF (AGAIN .AND. NUMDEC.EQ.7 .AND. .NOT.BARKEY) THEN
C
C Line thickness for error bars
C
            CALL X_GETDM1 (BOT, WIDE1, TOP,
     +     'Line thickness required for error bars (default = 1)')
            NUMDEC = NUMOPT
         ELSEIF (AGAIN .AND. NUMDEC.EQ.8 .AND. .NOT.BARKEY) THEN
C
C Edit bar cap type
C
            BARCAP_1 = BARCAP
            CALL X_YESNO2 (ICOLOR, IX, IY,
     +'Plot bar caps on the error-bars (if applicable) ?', BARCAP_1)
            BARCAP = BARCAP_1
            NUMDEC = NUMOPT
         ENDIF
         IF (AGAIN .AND. NSWAP.GT.N0 .AND. APPLY_1 .AND.
     +       NAPPLY.GT.1 .AND. NUMDEC.GE.2 .AND. NUMDEC.LE.4 .AND.
     +       .NOT.BARKEY) THEN
C
C Apply across groups
C
            I = MOD(NSWAP + NGROUP, NGROUP)
            IF (I.EQ.N0) I = NGROUP
            DO WHILE (I.GT.N0 .AND. I.LE.NPTS)
               IF (I.NE.NSWAP) THEN
                  IF (NUMDEC.EQ.2) THEN
                     IFILL(I) = IFILL(NSWAP)
                  ELSEIF (NUMDEC.EQ.3) THEN
                     FACTOR(I) = FACTOR(NSWAP)
                  ELSE
                     IHUE(I) = IHUE(NSWAP)
                  ENDIF
               ENDIF
               I = I + NGROUP
            ENDDO
         ENDIF
         IF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,700)
            NUMTXT = 21
            NUMBLD(1) = 1
            NUMBLD(13) = 1
            NUMBLD(18) = 1
            CALL W_PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                     TEXT,
     +                     BORDER)
         ENDIF
      ENDDO
C
C Refresh panel
C
       IF (.NOT.BARKEY) CALL SAVBCK$(IFILL, IHUE, NTEMP,
     +                               STORE)        
C
C Format statements
C      
  100 FORMAT ('No display at bar number',I3)
  200 FORMAT (
     + 'Edit panel key-labels'
     +/'Help'
     +/'Apply')
  300 FORMAT (
     + 'Edit group labels'
     +/'Select a bar: edit',I3,1X,'fill-style',A
     +/'Select a bar: edit',I3,1X,'bar width',A
     +/'Select a bar: edit',I3,1X,'colour',A
     +/'Apply edits across all groups',2X,A
     +/'Change line thickness: main bars'
     +/'Change line thickness: error bars'
     +/'Change error bar end-caps type'
     +/'Help'
     +/'Apply')
  400 FORMAT (
     + 'No display at bar number',I3
     +/'Outline'
     +/'Solid'
     +/'Diagonal up'
     +/'Diagonal down'
     +/'Criss-cross'
     +/'Horizontal'
     +/'Vertical'
     +/'Dashed lines'
     +/'Dotted lines'
     +/'Dashed-Dotted'
     +/'Use current fill-style')
  500 FORMAT (
     + 'Editing barcharts and information panels'
     +/
     +/'Bar grouping details are set using the configuration options'
     +/'for data supplied as a matrix, i.e. automatic grouping. So,'
     +/'use [Configure] to set your own fill-style/colour defaults,'
     +/'but note that advanced bar chart files override defaults.'
     +/'You should realise that bars plotted on the graph and bars'
     +/'plotted on information panels are, to a degree, independent.'
     +/'This allows maximum versatility, e.g. when a bar chart'
     +/'does not consist of groups with fixed numbers of elements.'
     +/'So, if you want to design an information panel to reflect'
     +/'ungrouped data, just set fill styles and labels as required,'
     +/'and suppress the rest, i.e. over-ride the defaults.'
     +/
     +/'Bars on the plot or in the information panel are identified'
     +/'in the menus by number, fill style and colour. So decide'
     +/'which items you require, then set these individually and'
     +/'suppress the unwanted ones from the menu. Note that, if you'
     +/'suppress an information panel text label by typing in a blank,'
     +/'then the associated bar key will also be suppressed.')
  600 FORMAT ('(colour =',I4,')')
  700 FORMAT (
     + 'Bar chart fill styles, labels, and colours.'
     +/
     +/'Typically a bar chart will have bars collected into groups, and'
     +/'within each group the pattern of fill styles, colours, and bar'
     +/'widths will be the same. However it is possible to create a bar'
     +/'chart with arbitrary bars. When a bar chart is first created it'
     +/'will have either default parameters (if it is created from an'
     +/'arbitrary matrix) or parameters set from an advanced bar chart'
     +/'file. Default parameters are set using the option to configure'
     +/'fill-styles, colours, and labels, but note that advanced bar'
     +/'chart files over-rule the defaults.'
     +/
     +/'Editing the bars plotted'
     +/'You must choose either to apply each edit to corresponding bars'
     +/'across groups (the usual choice), or to edit each separate bar'
     +/'displayed on an individual basis (only for advanced work).'
     +/
     +/'Editing information panel key labels'
     +/'There will be a panel key for every distinct fill-style/colour'
     +/'combination up to the maximum allowed (20). Changing fill-style'
     +/'or colour in the main plot automatically changes panel items.')
      END
C
C
