C
C
      SUBROUTINE X_EDITLB (NPTS, NWORDS,
     +                     WORDS, VECTOR,
     +                     DEND_G, PLOTX)
C
C ACTION : Edit labels
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          12/07/2005 derived from EDITAX$
C          20/05/2007 added INTENTS
C          27/05/2011 added calls to SELSTR and FORM12
C          14/09/2011 developed from EDITLB$
C
C          NPTS: (input/unchanged) suggested number of labels to be edited
C        NWORDS: (input/unchanged) dimension
C         WORDS: (input/output) text labels, i.e. text strings
C        VECTOR: (input/output) text vectors, i.e. templates
C        DEND_G: (input/unchanged) dendrogram indicator
C         PLOTX: (input/output) display/suppress status
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NPTS, NWORDS
      CHARACTER (LEN = *), INTENT (INOUT) :: WORDS(NWORDS),
     +                                       VECTOR(NWORDS)
      LOGICAL,             INTENT (IN)    :: DEND_G
      LOGICAL,             INTENT (INOUT) :: PLOTX(NWORDS)
C
C Locals
C
      INTEGER    ISEND, NUMOPT, NUMSTA
      PARAMETER (ISEND = 0, NUMOPT = 8, NUMSTA = 15)
      INTEGER    I, IADD1, IBOT, IMID, ITOP, NDEC, NPT1, NUMEDI, NUMTXT
      INTEGER    NUMBLD(30)
      CHARACTER (LEN = 12) X_FORM12, WORD12_NPTS, WORD12_NPLOT 
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  CIPHER(6)*60
      LOGICAL    AGAIN, FFILES
      EXTERNAL   X_GETJM1, X_NEWSTR, X_PUTADV
      EXTERNAL   X_LSTBOX, X_GETLBL, W_CHKBOX, X_PATCH2, X_SELSTR,
     +           X_FORM12
      DATA       CIPHER / 'labels to be selected for plotting',
     +                    'labels to be selected for suppressing',
     +                    'labels to plot/suppress individually',
     +                    'labels to select from (simple editing)',
     +                    'templates to select from (simple editing)',
     +                    'labels to select from (advanced editing)'/
      DATA      NUMBLD / 30*0 /
C
C Check
C
      IF (NPTS.LT.1 .OR. NWORDS.LT.1) RETURN
C
C Initialise
C
      IF (DEND_G) THEN
         FFILES = .FALSE.
      ELSE
         FFILES = .TRUE.
      ENDIF
      IF (NPTS.GE.0 .AND. NPTS.LE.NWORDS) THEN
         NPT1 = NPTS
      ELSE
         NPT1 = 0
      ENDIF
      NUMEDI = 1
      IMID = NPT1
      
C
C Main loop
C
      NDEC = NUMOPT - 1
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Display main menu
C
        
         WORD12_NPTS = X_FORM12(NPTS)
         IADD1 = 0
         DO I = 1, IMID
            IF (PLOTX(I)) IADD1 = IADD1 + 1
         ENDDO
         WORD12_NPLOT = X_FORM12(IADD1)     
         WRITE (TEXT,100) WORD12_NPTS, WORD12_NPLOT
         NUMTXT = NUMSTA + NUMOPT - 1
         NUMBLD(1) = 4
         NUMBLD(12) = 1
         NUMBLD(13) = 1
         CALL X_LSTBOX (NUMBLD, NDEC, NUMOPT, NUMSTA, NUMTXT,
     +                  TEXT)
         NUMBLD(1) = 0
         NUMBLD(12) = 0
         NUMBLD(13) = 0
         IF (NDEC.LE.6) THEN
C
C select IMID
C
            IF (NPTS.EQ.NWORDS) THEN
               IMID = NPTS
            ELSE    
               IBOT = 0
               IMID = NPT1
               ITOP = NWORDS
               WRITE (LINE,200) CIPHER(NDEC)
               CALL X_GETJM1 (IBOT, IMID, ITOP,
     +                        LINE)
               IF (IMID.LE.0) NDEC = 0
            ENDIF    
         ENDIF
         IF (NDEC.EQ.0) THEN
C
C No items requested
C
            NDEC = NUMOPT - 1
         ELSEIF (NDEC.EQ.1) THEN
C
C Labels: display all
C
            DO I = 1, IMID
               PLOTX(I) = .TRUE.
            ENDDO
            I = 1
            WRITE (LINE,300) I, IMID
            CALL X_PUTADV (LINE)
         ELSEIF (NDEC.EQ.2) THEN
C
C Labels: suppress all
C
            DO I = 1, IMID
               PLOTX(I) = .FALSE.
            ENDDO
            I = 1
            WRITE (LINE,400) I, IMID
            CALL X_PUTADV (LINE)
         ELSEIF (NDEC.EQ.3) THEN
C
C Labels: display/suppress
C
            WRITE (LINE,500)
            CALL W_CHKBOX (IMID,
     +                     WORDS, LINE,
     +                     PLOTX)
         ELSEIF (NDEC.EQ.4) THEN
C
C Labels: edit all
C
            I = 1
            CALL X_GETLBL (I, IMID,
     +                     WORDS,
     +                     FFILES)
         ELSEIF (NDEC.EQ.5) THEN
C
C Templates: edit all
C
            I = 2
            CALL X_GETLBL (I, IMID,
     +                     VECTOR,
     +                     FFILES)
         ELSEIF (NDEC.EQ.6) THEN
C
C Labels: edit one
C
            WRITE (TEXT,600)
            NUMTXT = 22
            NUMEDI = 1
            DO WHILE (NUMEDI.GT.0)
               CALL X_SELSTR (NUMEDI, NUMTXT, IMID,
     +                        TEXT, WORDS)
               IF (NUMEDI.GT.0) CALL X_NEWSTR (ISEND,
     +                          WORDS(NUMEDI), VECTOR(NUMEDI))
            ENDDO   
         ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            WRITE (TEXT,600)
            NUMTXT = 22
            NUMBLD(1) = 1
            NUMBLD(15) = 1
            CALL X_PATCH2 (NUMBLD, NUMTXT,
     +                     TEXT)
            NUMBLD(1) = 0
            NUMBLD(15) = 0
         ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C Apply
C
            AGAIN = .FALSE.
         ENDIF
      ENDDO 
C
C Format statements
C      
  100 FORMAT (
     + 'Techniques for editing labels'
     +/
     +/'Labels can be plotted instead of numbers on the X-axis as'
     +/'with Bar Charts and Dendrograms, or in special cases where'
     +/'user-chosen text is preferred to integers or floating point' 
     +/'numbers. With prinicipal components, K-means clusters, or'
     +/'biplots, there may be many labels and it could be best to'
     +/'edit all labels simultaneously, or to input labels from'
     +/'files. However, with small numbers of labels, selected'
     +/'editing of individual labels would be more appropriate.'
     +/ 
     +/'Number of labels available for plotting =',1X,A 
     +/'Number of labels selected for plotting =',1X,A 
     +/
     +/'Labels: plot all'
     +/'Labels: suppress all'
     +/'Labels: plot/suppress individually'
     +/'Edit: all labels simultaneously'
     +/'Edit: all templates simultaneously'
     +/'Edit: selected labels individually'
     +/'Help'
     +/'Apply')
  200 FORMAT ('Total number of',1x,a)
  300 FORMAT ('Labels',i2,1x,'to',i5,1x,'will now be plotted')
  400 FORMAT ('Labels',i2,1x,'to',i5,1x,'will now be be suppressed')
  500 FORMAT ('Tick the labels to be displayed')
  600 FORMAT (
     + 'Edit/plot/suppress labels and templates'
     +/
     +/'Each text string displayed on a Simfit plot consists of a label'
     +/'and template pair. The label is just a sequence of characters,'
     +/'and the template is a sequence of numbers or characters which'
     +/'are the instructions as to how the label characters are to be'
     +/'plotted, e.g., subscript, superscript, maths, accents, etc.'
     +/
     +/'From this control you can select the labels to be plotted, and'
     +/'the labels to be suppressed. You can also edit whole sets of'
     +/'labels and templates by a variety of techniques; in particular,'
     +/'you can read in files containing sets of labels or templates to'
     +/'overwrite the defaults.'
     +/
     +/'Adding labels to statistical graphs'
     +/
     +/'When scores or loadings from principal components analysis, or'
     +/'dendrograms are plotted in advanced mode, the labels related'
     +/'to the symbols can be appended to the data (e.g. cluster.tf1),'
     +/'but the default integer labels can be easily overwritten by a'
     +/'simple text file containing just labels, such as you can choose'
     +/'to Save As ...from your spread-sheet program.')
      END
C
C
