C
C
      SUBROUTINE X_EDITPC (IFILL, IHUE, NPTS,
     +                     FACTOR, WIDE,
     +                     FSAV1, LABEL1, VECTOR,
     +                     PIEKEY)
C
C ACTION : Edit PIE chart
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 23/6/95
C
C          PIEFIL$ reads in then normalises X = X/sum-of-all-X and the file
C          is not consulted again. So this file mechanism will not change
C          X as it is now. The solution is to always make the piechart
C          file read for X at each drawing by calling PIEFIL$ from LOOP09$
C
C          24/09/1996 added NEWSTR$ and VECTOR
C          14/07/1997 win32 version
C          11/09/1998 added FSAV and FSAV1 but this is the problem
C          25/10/2000 added SELSTR
C          30/11/2000 introduced PALETT$
C          09/01/2003 added WIDE
C          14/10/2004 added ITYPE, JTYPE, XSIZE, YSIZE, STORE, FSIZES$
C          13/11/2004 added calls to LABELS and SYMLAB$ 
C          19/05/2007 added INTENTS and removed calls to LABELS and SYMLAB$
C          14/05/2011 rearranged menus 
C          17/09/2011 derived from EDITPC$
C          24/09/2011 added code to bypass menu created by FORMAT 100 but
C                     left the structure in for possible future use
C          31/12/2015 added call to X_SAVCFG
C          
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NPTS
      INTEGER,             INTENT (INOUT) :: IFILL(NPTS), IHUE(NPTS)
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NPTS), WIDE
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV1 
      CHARACTER (LEN = *), INTENT (INOUT) :: LABEL1(NPTS), VECTOR(NPTS)
      LOGICAL,             INTENT (IN)    :: PIEKEY
C
C Locals
C
      INTEGER    I, ISEND, NOUT1, NOUT2, NP1
      INTEGER    ICOLOR, IX, IY, NHELP, NUMDEC, NUMOPT, NSWAP
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      INTEGER    NUMPOS(16)
      INTEGER    ITYPE, JTYPE, MODE, NMAX
      PARAMETER (ITYPE = 9, JTYPE = 10, MODE = 0, NMAX = 100)
      DOUBLE PRECISION A, B, C, D, DEFOLT, XMID, XSIZE, YSIZE
      DOUBLE PRECISION HALF, XBOT, XTOP
      PARAMETER (HALF = 0.5D+00, XBOT = 0.0D+00, XTOP = 1.0D+00)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (BOT = 1.0D-02, TOP = 1.0D+02)
      CHARACTER  ITEMS(NMAX)*60, TEXT(30)*100
      CHARACTER  FNAME*1024, TITLE*100
      LOGICAL    AGAIN, REPEET, STORE, OK
      LOGICAL    MUST_EXIST
      PARAMETER (MUST_EXIST = .FALSE.)
      EXTERNAL   X_GETDM1, X_NEWSTR, W_PALETT, X_FSIZES, X_PUTADV
      EXTERNAL   X_LBOX02, X_GETNOU, X_SELSTR, X_GETSTR, X_GETFFS
      EXTERNAL   X_SAVCFG
      DATA       NUMPOS / 16*1 /
C
C Initialise
C
      STORE = .FALSE.
      CALL X_FSIZES (ITYPE,
     +               XSIZE,
     +               STORE)
      CALL X_FSIZES (JTYPE,
     +               YSIZE, 
     +               STORE)
      NUMDEC = 1
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (PIEKEY) THEN
            NUMOPT = 6
            WRITE (TEXT,100) YSIZE
            DEFOLT = XTOP
         ELSE
            NUMOPT = 8
            WRITE (TEXT,200) XSIZE, WIDE
            DEFOLT = HALF
         ENDIF
C         
C------------------------------------------------------------------------------------         
C

         IF (PIEKEY) THEN
C
C 24/09/2011 This version only allows label editing as the panel-key-editing sections
C            were getting confused with the main segment editing parameters, probably
C            due to the new clearwin module ambiguity and I don't have time to
C            sort it out.
C           
            NUMOPT = 1
         ELSE   
            NUMDEC = NUMOPT
            CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, 
     +                     TEXT)
         ENDIF

C
C------------------------------------------------------------------------------------         
C
         
         NSWAP = 1
         IF (NUMDEC.LE.4) THEN
C
C Choose the item
C
            NHELP = 18
            WRITE (TEXT,400)
            IF (NUMDEC.EQ.1) THEN
               REPEET = .TRUE.
               DO WHILE (REPEET)
                  CALL X_SELSTR (NSWAP, NHELP, NPTS,
     +                           TEXT, LABEL1)
                  IF (NSWAP.GT.0) THEN
                     ISEND = 0
                     CALL X_NEWSTR (ISEND, 
     +                              LABEL1(NSWAP), VECTOR(NSWAP))
                  ELSE
                     REPEET = .FALSE.
                  ENDIF        
               ENDDO
               AGAIN = .FALSE.
               NSWAP = 0  
            ELSEIF (NUMDEC.EQ.3) THEN
               DO I = 1, NPTS
                  ITEMS(I) = LABEL1(I)
               ENDDO
               NP1 = NPTS + 1
               ITEMS(NP1) = 'Set all to a default value'
               CALL X_SELSTR (NSWAP, NHELP, NP1,
     +                        TEXT, ITEMS)
            ELSE
               CALL X_SELSTR (NSWAP, NHELP, NPTS,
     +                        TEXT, LABEL1)
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            NSWAP = 0
            AGAIN = .FALSE.
         ENDIF
         IF (AGAIN .AND. NSWAP.GT.0) THEN
            IF (NUMDEC.EQ.2) THEN
C
C Edit a fill style
C
               NUMOPT = 12
               WRITE (TEXT,300) NSWAP
               IF (IFILL(NSWAP).GT.-1 .AND. IFILL(NSWAP).LT.9) THEN
                  NUMDEC = IFILL(NSWAP) + 1
               ELSE
                  NUMDEC = NUMOPT
               ENDIF
               CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                        TEXT)
               IF (NUMDEC.LT.NUMOPT) IFILL(NSWAP) = NUMDEC - 1
            ELSEIF (NUMDEC.EQ.3) THEN
C
C Edit a displacement
C
               IF (NSWAP.EQ.NP1) THEN
                  XMID = DEFOLT
                  CALL X_GETDM1 (XBOT, XMID, XTOP,
     +         'Fractional distance required (i.e. between 0 and 1)')
                   DO I = 1, NPTS
                      FACTOR(I) = XMID
                   ENDDO
               ELSE
                  XMID = FACTOR(NSWAP)
                  CALL X_GETDM1 (XBOT, XMID, XTOP,
     +         'Fractional distance required (i.e. between 0 and 1)')
                  FACTOR(NSWAP) = XMID
               ENDIF
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Edit a colour
C
               NUMDEC = IHUE(NSWAP)
               CALL W_PALETT (NUMDEC, MODE)
               IHUE(NSWAP) = NUMDEC
            ELSEIF (NUMDEC.EQ.5) THEN
C
C Change font size
C            
               STORE = .TRUE.
               IF (PIEKEY) THEN
                  CALL X_FSIZES (JTYPE,
     +                           YSIZE,
     +                           STORE)
               ELSE
                  CALL X_FSIZES (ITYPE,
     +                           XSIZE,
     +                           STORE)
               ENDIF
            ELSEIF (NUMDEC.EQ.6) THEN
C
C Line width
C            
               CALL X_GETDM1 (BOT, WIDE, TOP,
     +                       'Line width required')   
            ELSEIF (NUMDEC.EQ.7) THEN
C
C Save to a file
C
               CALL X_GETFFS (FNAME,
     +                        MUST_EXIST, OK)
               IF (OK) THEN              
                  CALL X_GETNOU (NOUT1)
                  OPEN (UNIT = NOUT1, FILE = FSAV1)
                  CALL X_GETNOU (NOUT2)
                  OPEN (UNIT = NOUT2, FILE = FNAME)
                  READ (NOUT1,'(A)') TITLE
                  CALL X_GETSTR ('Title for this data', TITLE)
                  WRITE (NOUT2,'(A)') TITLE
                  READ (NOUT1,'(A)') TITLE
                  WRITE (NOUT2,'(2I6)') NPTS, 4
                  DO I = 1, NPTS
                     READ (NOUT1,*) A, B, C, D
                     WRITE (NOUT2,'(F8.4,I6,F8.4,I6)') A, IFILL(I),
     +                                                 FACTOR(I),
     +                                                 IHUE(I)
                  ENDDO
                  WRITE (NOUT2,'(I6)') NPTS + 2
                  WRITE (NOUT2,'(A)') 'begin{labels}'
                  DO I = 1, NPTS
                     WRITE (NOUT2,'(A)') LABEL1(I)
                  ENDDO
                  WRITE (NOUT2,'(A)') 'end{labels}'
                  CLOSE (UNIT = NOUT1)
                  CLOSE (UNIT = NOUT2)
                  CALL X_PUTADV (
     +           'An advanced pie chart file has been created')
                  ISEND = 1
                  CALL X_SAVCFG (ISEND,
     +                           FNAME)                  
               ENDIF
            ENDIF
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Edit panel labels'
     +/'Select panel key: new fill-style'
     +/'Select panel key: alter key width'
     +/'Select panel key: change colour'
     +/'Change font size (current =',F6.2,')'
     +/'Apply')
  200 FORMAT (
     + 'Edit segment labels'
     +/'Select segment: new fill-style'
     +/'Select segment: offset radially'
     +/'Select segment: change colour'
     +/'Change font size (current =',F6.2,')'
     +/'Change line width (current =',F6.2,')'
     +/'Save As ...'
     +/'Apply')
  300 FORMAT (
     + 'Suppress segment',I3
     +/'Empty'
     +/'Solid'
     +/'Diagonal-up'
     +/'Diagonal-down'
     +/'Criss-cross'
     +/'Horizontal'
     +/'Vertically-up'
     +/'Dashed lines'
     +/'Dotted lines'
     +/'Dashes & dots'
     +/'Apply')
  400 FORMAT (
     + 'Editing pie chart fill styles, labels and dimensions'
     +/
     +/'The pie chart segments and associated information panel'
     +/'keys are linked in that, if you change the colour or fill'
     +/'style of either it will automatically adjust the display'
     +/'details for the other, in order to remain consistent.'
     +/
     +/'However the labels are not identical, and also the dimensions'
     +/'differ in that, with segments you can alter the centrifugal'
     +/'displacement, while with panel keys you can alter the width'
     +/'of the individual fill style indicator.'
     +/
     +/'If you wish to save a pie chart after you have chosen all the'
     +/'labels, offsets, colours and fill styles, you can write the'
     +/'advanced pie chart data to an advanced pie chart file.'
     +/'Alternatively, you can just as easily save such details to a'
     +/'configuration file, which is more versatile because this will'
     +/'also store any arrows, text strings, or graphical objects.')
      END
C
C
