C
C
C SUBROUTINES: 
C X_EPSPDF
C X_PS2INI
C X_PS2CHK
C X_GSTYPE
C
      SUBROUTINE X_EPSPDF (FNAME_IN)
C
C ACTION : PS to PDF using GHOSTSCRIPT then display
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          21/09/2013 derived from PS2PDF but left logical variable OK in for possible future use
C          09/05/2017 added logical argument in call to X_OKCVAL
C          12/05/2017 new version derived from new version of ps2pdf 
C          28/05/2017 corrected so either ghostscript or the dll can be used
C          19/06/2017 made the dll priority 
C          07/05/2020 now accepts *.ps as well as *.eps and added NOUT1 and NOUT2 to write pdf to the temp not the local folder
C          11/05/2020 introduced the option to call svg_copy by setting SVG = .TRUE.
C                     also introduced a cycle of 0 to n temporary file names ... current value is n = 9
C          18/05/2020 initialised character variables and introduced SWITCH 
C                     this must agree with w_eps2gs 
C 
C Information 
C ===========
C  ...\tmp\simfit_gs.tmp    is the error file output from the ghostscript DLL
C  ...\tmp\f$simfit_gs.eps  is fname, a copy of the input file called fname_in     
C "...\tmp\f$simfit_gs.eps" is file1, a quoted copy of fname
C "...\tmp\f$simfit_gs.pdf" is file2, a quoted copy of the pdf target supplied to ghostscript
C
c        Note added at 22/05/2020
c        ------------------------
c        It is now clear that the reason provoking these changes was due to an error in
c        the ghostscript dll pdfwrite and at this date the distributed dlls were replaced
c        by the previous versions of gsdll32.dll and gsdll64.dll. Until such time as I revise
c        this code the following procedure must be followed.
c        Make sure SWITCH = .FALSE. in both W_EPS2GS and X_EPSPDF and reserve SWITCH = .TRUE.
c        for future de-bugging 
C
      IMPLICIT   NONE  
C
C Arguments
C          
      CHARACTER (LEN = *), INTENT (IN) :: FNAME_IN
C
C Locals
C      
      INTEGER    JSEND, KSEND
      PARAMETER (JSEND = 8, KSEND = 6)
      INTEGER    N1, N12, N18
      PARAMETER (N1 = 1, N12 = 12, N18 = 18)
      INTEGER    ICOUNT 
      INTEGER    IOS, ITYPE, LSTART, LSTOP, L, L1, L2, NOUT1, NOUT2
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER (LEN = 1024) FILE1, FILE2, GS, LINE, STRNG 
      CHARACTER (LEN = 1024) FNAME 
      CHARACTER (LEN = 28  ) DFOLT
      CHARACTER (LEN = 1   ) NUMBER 
      PARAMETER (DFOLT = '-q -dBATCH -dSAFER -dNOPAUSE')
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ALWAYS_SUPPLY, SUPPLY, ALWAYS_SVG, SVG,
     +           ALWAYS_MAKE_COPY, MAKE_COPY
      PARAMETER (ALWAYS_SUPPLY = .TRUE., ALWAYS_SVG = .TRUE., 
     +           ALWAYS_MAKE_COPY = .TRUE.)
      LOGICAL    ABORT, OK, THERE
      LOGICAL    SWITCH, SWITCH1
      PARAMETER (SWITCH = .FALSE.)
      EXTERNAL   X_PS2INI, X_GSTYPE, X_PUTADV
      EXTERNAL   W_EPS2GS, W_STARTP
      EXTERNAL   RUN_ACROBAT, W_V7PATH, W_GETNOU, SVG_COPY   
      INTRINSIC  ADJUSTL, LEN_TRIM, TRIM
      DATA       ICOUNT / -1 /
C
C choose the path ... this must agree with W_EPS2GS
C        
      SWITCH1 = SWITCH 
C
C Part 0: Make sure the file supplied exists and that SUPPLY = .TRUE., MAKE_COPY = .TRUE.,  and SVG = .TRUE.
C ------
C     
      FNAME = BLANK
      FILE1 = BLANK
      FILE2 = BLANK
      GS = BLANK
      STRNG = BLANK
      LINE = BLANK  
      SUPPLY = ALWAYS_SUPPLY
      SVG = ALWAYS_SVG
      MAKE_COPY = ALWAYS_MAKE_COPY
     
      INQUIRE (FILE = FNAME_IN, EXIST = THERE, IOSTAT = IOS)
      IF (IOS.EQ.0 .AND. .NOT.THERE) THEN
         CALL X_PUTADV ('X_EPSPDF cannot find the named file supplied')
         RETURN
      ENDIF   
C
C Part 1: See if we can find ghostscript and/or the DLL then increment ICOUNT 
C -------  
C    
      CALL X_GSTYPE (ITYPE,
     +               GS)!returns ITYPE: 0 = neither, 6 = DLL, 8 = GS, 14 = both  
      IF (ITYPE.LT.KSEND) THEN
         CALL X_PUTADV (
     +'Cannot find Ghostscript or the Ghostscript DLL')
         RETURN
      ENDIF   
      IF (ICOUNT.LT.9) THEN
         ICOUNT = ICOUNT + 1
      ELSE
         ICOUNT = 1
      ENDIF      
      WRITE (NUMBER,'(I1)') ICOUNT
     
      IF (SUPPLY) THEN
         IF (SWITCH1) THEN
            FNAME = 'C:\TEMP\EPS2GS\'
            L = 15
         ELSE   
            CALL W_V7PATH (L,
     +                    'tmp', FNAME)
            IF (FNAME(L:L).NE.'\') THEN
               L = L + 1
               FNAME(L:L) = '\'
            ENDIF
         ENDIF    
         FNAME(l + 1:L + 17) = 'f$simfit_gs_'//NUMBER//'.eps'  
          
C
C Copy FNAME_IN to FNAME then call PS2INI 
C          
         IF (MAKE_COPY) THEN
            IF (SVG) THEN   
               CALL SVG_COPY (FNAME_IN, FNAME,
     +                        ABORT)
               IF (ABORT) THEN
                  CALL X_PUTADV (
     +'X_EPSPDF cannot copy file_in to ...\tmp\f$simfit_gs_N.eps')
                  RETURN
               ENDIF   
            ELSE  
               CALL W_GETNOU (NOUT1)
               OPEN (UNIT = NOUT1, FILE = FNAME_IN, IOSTAT = IOS)
               IF (IOS.EQ.0) READ (NOUT1,'(A)', IOSTAT=IOS) LINE  
               IF (IOS.EQ.0) CALL W_GETNOU (NOUT2)  
               IF (IOS.EQ.0) OPEN (UNIT = NOUT2, FILE = FNAME, 
     +                             IOSTAT = IOS)
               IF (IOS.EQ.0) WRITE (NOUT2,'(A)',IOSTAT=IOS) TRIM(LINE)  
               CLOSE (UNIT = NOUT1)
               CLOSE (UNIT = NOUT2)
               IF (IOS.NE.0) RETURN
               IOS = 0
               DO WHILE (IOS.EQ.0)
                  READ (NOUT1,'(A)',IOSTAT=IOS) LINE
                  IF (IOS.EQ.0) WRITE (NOUT2,'(A)',IOSTAT=IOS) 
     +                                TRIM(LINE)
               ENDDO
               CLOSE (UNIT = NOUT1)
               CLOSE (UNIT = NOUT2) 
               IF (IOS.NE.0) RETURN    
            ENDIF
         ENDIF
         CALL X_PS2INI (X1, X2, Y1, Y2, 
     +                  'pdf', FILE1, FILE2, FNAME,
     +                  OK)!returns FILE1 and FILE2 double quoted
         IF (.NOT.OK) THEN
            CALL X_PUTADV ('X_EPSPDF failure calling X_PS2INI')
            RETURN
         ENDIF   
      ENDIF
     
C
C Part 2: Make the command then call ghostscript
C -------
C                                         
      
C
C Step 1: initialise STRNG
C
      STRNG = DFOLT
C
C Step 2: Build up the command line
C
      LINE = BLANK     
C
C Step 3: Build up the command line...add the string
C
      LSTART = N1
      LSTOP = N1
      L1 = N1
      L2 = LEN_TRIM(STRNG)
      LSTART = LSTOP + N1
      LSTOP = LSTART + L2 - N1
      LINE(LSTART:LSTOP) = STRNG(L1:L2)
C
C Step 4: Build up the command line...add the device
C
      LSTART = LSTOP + N1
      LSTOP = LSTART + N18
      LINE(LSTART:LSTOP) = ' -sDEVICE=pdfwrite'
C            
C Step 5: Build up the command line...name the output file
C
      LSTART = LSTOP + N1
      LSTOP = LSTART + N12
      LINE(LSTART:LSTOP) = '-sOutputFile='
      L1 = N1
      L2 = LEN_TRIM(FILE2)
      LSTART = LSTOP + N1
      LSTOP = LSTART + L2 - N1
      LINE(LSTART:LSTOP) = FILE2(L1:L2)
      LSTART = LSTOP + N1
      LSTOP = LSTART
      LINE(LSTART:LSTOP) = BLANK
C
C Step 6: Build up the command line...add the input filename
C
      L1 = N1
      L2 = LEN_TRIM(FILE1)
      LSTART = LSTOP + N1
      LSTOP = LSTART + L2 - N1
      LINE(LSTART:LSTOP) = FILE1(L1:L2)
C
C Step 7: Use W_EPS2GS to fire up Ghostscript
C
      LINE = ADJUSTL(LINE)
      
      IF (ITYPE.EQ.JSEND) THEN
         CALL W_STARTP (GS,
     +                  LINE)! = 8 so only GhostScript available 
         ABORT = .FALSE.                 
      ELSE  
         CALL W_EPS2GS (LINE,
     +                  ABORT)! use the DLL 
         IF (ABORT) THEN
            CALL X_PUTADV (
     +'X_EPSPDF failed calling the DLL from W_EPS2GS')
            RETURN
         ENDIF    
      ENDIF
      IF (.NOT.ABORT) THEN
C
C Step 8: Strip off double quotes which will be added when acrobat is called
C                 
         L1 = N1
         L2 = LEN_TRIM(FILE2)
         FILE2(L1:L1) = BLANK
         FILE2(L2:L2) = BLANK
         FILE2 = ADJUSTL(FILE2)
         CALL RUN_ACROBAT (FILE2) 
      ENDIF
      END
C
C
c
c
      subroutine x_ps2ini (x1, x2, y1, y2, 
     +                     ext, file1, file2, fname, 
     +                     ok)
c
c action: check then initialise before calling the ghostscript routines
c author: w.g.bardsley, university of manchester, u.k., 12/05/2017
c
c x1, x2, y1, y2: BoundingBox parameters
c            ext: extension required, e.g. 'pdf' or '.pdf'  
c          file1: fname with double quotes
c          file2: fname with new extension and double quotes
c          fname: input file with or without double quotes
c             ok: .true. if successful
c       
      implicit none
c
c arguments
c      
      double precision,    intent (out) :: x1, x2, y1, y2
      character (len = *), intent (in)  :: ext, fname
      character (len = *), intent (out) :: file1, file2
      logical,             intent (out) :: ok  
c
c locals
c      
      integer    ios, l1, l2, l3, ldot, nin 
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 1024) tfile
      character (len = 100 ) ext_copy
      character (len = 4   ) suffix
      character (len = 1   ) blank, dot, dquote
      parameter (blank = ' ', dot = '.', dquote = '"')
      logical    abort, askif, back, there
      parameter (askif = .false., back = .true.)
      intrinsic  index, len_trim, adjustl
      external   x_ucase1, x_getnou, w_deleet, x_ps2chk
c
c initialise then check fname
c      
      x1 = zero
      x2 = zero
      y1 = zero
      y2 = zero
      file1 = blank
      file2 = blank
      ok = .false.
      l2 = len_trim (fname)
      if (fname(1:1).eq.dquote .and. fname(l2:l2).eq.dquote) then
         file1 = fname(2:l2 - 1)
         l2 = l2 - 2
      else
         file1 = fname
      endif        
      if (l2.lt.4) return
c
c examine the input file extension and new extension
c      
      ldot = index(file1, dot, back)
      l1 = l2 - ldot
      if (l1.lt.2 .or. l1.gt.4) return
      suffix = file1(ldot + 1:l2) 
      call x_ucase1 (suffix)
      if (suffix.ne.'PS' .and. suffix.ne.'EPS' .and. 
     +    suffix.ne.'EPSF' .and. suffix.ne.'EPSI'
     +    .and.suffix.ne.'TMP' ) return
      l3 = len_trim(ext)
      if (l3.lt.2) return
c
c check that the input file is an EPS type file
c      
      call x_getnou (nin)
      open (unit = nin, file = file1, iostat = ios)  
      if (ios.ne.0) then
         close (unit = nin)
         return
      endif       
      CALL X_PS2CHK (NIN,
     +               X1, X2, Y1, Y2, 
     +               TFILE,
     +               ABORT)
      CLOSE (UNIT = NIN)
      CALL w_deleet (TFILE, 
     +               ASKIF, THERE)
      IF (ABORT) RETURN 
c
c calculate file1 and file2 then return ok = .true.  
c      
      ext_copy = ext
      ext_copy = adjustl(ext_copy) 
      l3 = len_trim(ext_copy)
      if (ext_copy(1:1).eq.dot) then
         file2 = file1(1:ldot)//ext_copy(2:l3)
      else
         file2 = file1(1:ldot)//ext_copy(1:l3)
      endif  
      l1 = len_trim(file1)
      l2 = len_trim(file2)
      file1 = dquote//file1(1:l1)//dquote    
      file2 = dquote//file2(1:l2)//dquote 
      ok = .true. 
      end
c
C
      SUBROUTINE X_PS2CHK (NIN,
     +                     X1, X2, Y1, Y2, 
     +                     TFILE,
     +                     ABORT)
C
C ACTION : Is it a ps file ?
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          Copy of ISITPS from editps but creates a shifted eps file
C          14/08/2006 revised and increased line length from 256 to 1024
C          22/04/2007 added INTENTS
C
C            NIN: (input/unchanged) unit with supposed PS file already connected
C X1, X2, Y1, Y2: (output) new BoundingBox after translation
C          TFILE: (output) temporary file with new eps file after translating
C          ABORT: (output) error indicator
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NIN 
      DOUBLE PRECISION,    INTENT (OUT) :: X1, X2, Y1, Y2 
      CHARACTER (LEN = *), INTENT (OUT) :: TFILE 
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    IADD1, IFAIL, IOS
      INTEGER    NOUT
      INTEGER    N0
      PARAMETER (N0 = 0)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE*1024
      CHARACTER  WORD2*2, WORD14*14
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    DONE1, DONE2
      EXTERNAL   X_PUTFAT, X_TRIML1, X_GETNOU, W_GETTMP
      INTRINSIC  NINT
C
C Initialise
C
      IADD1 = 1
      IOS = N0
      X1 = ZERO
      X2 = ZERO
      Y1 = ZERO
      Y2 = ZERO   
      TFILE = BLANK
      ABORT = .TRUE.
      DONE1 = .FALSE.
      DONE2 = .FALSE.
C
C Check for %! on first line
C
      READ (NIN,'(A)',IOSTAT=IOS) LINE
      IF (IOS.EQ.N0) THEN
         CALL X_TRIML1 (LINE)
         WORD2 = LINE(1:2)
      ELSE
         WORD2 = BLANK
      ENDIF      
      IF (WORD2.NE.'%!') THEN  
         WRITE (LINE,100)
         CALL X_PUTFAT (LINE)
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
C
C Open temporary file and write the first line
C
      CALL X_GETNOU (NOUT)
      CALL W_GETTMP (IFAIL,
     +               TFILE)
      OPEN (UNIT = NOUT, FILE = TFILE, IOSTAT = IOS)
      WRITE (NOUT,'(A)') LINE
C
C Check for BoundingBox
C
      WORD2 = '%%'
      DO WHILE (WORD2.EQ.'%%')
         IADD1 = IADD1 + 1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
         IF (IOS.NE.N0) GOTO 20
         CALL X_TRIML1 (LINE)
         WORD2 = LINE(1:2)
         WORD14 = LINE(1:14)
         IF (WORD14.EQ.'%%BoundingBox:') THEN
            READ (LINE(15:120),*,END=20,ERR=20,IOSTAT=IOS) X1,Y1,X2,Y2
            IF (IOS.NE.0) GOTO 20
            WRITE (NOUT,200) N0, N0, NINT(X2 - X1), NINT(Y2 - Y1)
            DONE1 = .TRUE.
         ELSEIF (WORD14.EQ.'%%EndComments ') THEN
            IF (.NOT.DONE1) GOTO 20
            WRITE (NOUT,'(A)') LINE
            WRITE (NOUT,300) - NINT(X1), - NINT(Y1)
            X2 = X2 - X1
            Y2 = Y2 - Y1
            DONE2 = .TRUE.
         ELSE
            WRITE (NOUT,'(A)') LINE
         ENDIF
      ENDDO
C
C Check to make sure BoundingBox read and translation done
C
      IF (.NOT.DONE1 .OR. .NOT.DONE2) GOTO 20
C
C Carry on reading and writing
C
      IOS = N0
      DO WHILE (IOS.EQ.N0)
         READ (NIN,'(A)',IOSTAT=IOS) LINE
         IF (IOS.NE.N0) THEN
            ABORT = .FALSE.
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF   
         WRITE (NOUT,'(A)') LINE
      ENDDO
C
C LABEL 20: Failure to find BoundingBox
C      
   20 CONTINUE
      ABORT = .TRUE.
      WRITE (LINE,400) IADD1
      CALL X_PUTFAT (LINE)
      CLOSE (UNIT = NOUT)  
C
C Except for 100 these format statements must NOT be translated
C      
  100 FORMAT ('EPSF files must begin with %! ... File rejected')
  200 FORMAT ('%%BoundingBox:',4I6)
  300 FORMAT (2I6,' translate')
  400 FORMAT (
     +'No EPS %%BoundingBox:x1,y1,x2,y2 in DSC comments 2 to',I3)
      END
C
c
      subroutine x_gstype (itype,
     +                     gs)
c     
c action: see if ghostscript or the dll are available
c author: w.g.bardsley, university of manchester,u.k. 16/05/2015
c         24/05/2017 checked to see if cval(8) = '*.exe'
c
c      values returned as follows:
c      itype =  0: neither is available
c      itype =  6: only the dll is available
c      itype =  8: only ghostscript is available
c      itype = 14: both are available
c      itype >= 8: gs is the path to ghostscript  
c       
      implicit none
c
c arguments
c      
      integer,             intent (out) :: itype 
      character (len = *), intent (out) :: gs 
c
c locals
c      
      integer    mode, n0, n6, n8
      parameter (mode = 0, n0 = 0, n6 = 6, n8 = 8) 
      integer    l, nval(12) 
      character (len = 1024) cval(12)
      character (len = 4   ) dot_exe, word4 
      parameter (dot_exe = '.EXE')
      character (len = 1   ) blank
      logical    ok_6, ok_8
      parameter (blank = ' ')
      external   x_okcval, w_config, x_ucase1
      intrinsic  len_trim
      itype = n0
      gs = blank
      call x_okcval (n6,
     +               ok_6) 
      if (ok_6) itype = itype + n6
      call x_okcval (n8,
     +               ok_8)
      if (ok_8) then
         call w_config (mode, nval,
     +                  cval)
         l = len_trim(cval(8))
         if (l.gt.4) then
            word4 = cval(8)(l - 3:l)
            call x_ucase1 (word4)
            if (word4.eq.dot_exe) then
               gs = cval(8)
               itype = itype + n8
            endif
         endif      
      endif 
      end          
c
c
      
      
