C
C
      SUBROUTINE X_ERRBAR (FNAME)
C
C ACTION: replace FNAME data by error bar data
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 28/11/99
C         22/06/2006 introduced allocatable arrays 
C         23/03/2007 added INTENT
C         20/09/2011 derived from ERRBAR$
C
      IMPLICIT   NONE 
C
C Argument
C             
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
C
C Local allocatable workspaces
C                            
      DOUBLE PRECISION, ALLOCATABLE :: E(:), X(:), Y(:)
C
C Locals
C      
      INTEGER    ISEND
      PARAMETER (ISEND = 3)
      INTEGER    I, IERR, IOS, N, NCOL, NMAX, NOUT, NROW
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  TITLE*80
      EXTERNAL   X_NYYBAR, X_GETNOU
      EXTERNAL   X_PUTFAT, X_PUTADV, X_PUTIOS
C
C Open a unit and read the title
C
      CALL X_GETNOU (NOUT)
      CLOSE (UNIT = NOUT)
      OPEN (UNIT = NOUT, FILE = FNAME)
      READ (NOUT,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.0) THEN
         CALL X_PUTFAT ('Error reading title in call to X_ERRBAR')
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
C
C Read NROW, NCOL
C
      READ (NOUT,*,IOSTAT=IOS) NROW, NCOL
      IF (IOS.NE.0) THEN                  
         CALL X_PUTIOS (IOS, 'X_ERRBAR')
         CALL X_PUTFAT ('Error reading NROW, NCOL in call to X_ERRBAR')
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      IF (NCOL.EQ.4) THEN
         CALL X_PUTADV ('This is already an error bar file')
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      IF (NCOL.LT.2 .OR. NCOL.GT.4) THEN
         CALL X_PUTADV ('This is not an (x,y) or (x,y,s) file')
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      IF (NROW.LT.2) THEN
         CALL X_PUTADV ('Not enough x-values to calculate means')
         CLOSE (UNIT = NOUT)
         RETURN
      ELSE
         N = NROW
         NMAX = N
      ENDIF      
      IERR = 0
      IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
      IF (IERR.EQ.0 .AND. ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.EQ.0 .AND. ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.EQ.0) ALLOCATE(E(NMAX), STAT = IERR)
      IF (IERR.EQ.0) ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.EQ.0) ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.0) THEN 
         DEALLOCATE(E, STAT = IERR)  
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(Y, STAT = IERR)
         CALL X_PUTFAT ('Cannot allocate E, X, or Y in X_ERRBAR')
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF   
C
C Read in and check the data if NCOL = 2
C
      IF (NCOL.EQ.2) THEN
         DO I = 1, N
            READ (NOUT,*,IOSTAT=IOS) X(I), Y(I)
            E(I) = ZERO
            IF (IOS.NE.0) THEN
               CALL X_PUTFAT ('Error reading data in call to X_ERBBAR')
               DEALLOCATE(E, STAT = IERR)  
               DEALLOCATE(X, STAT = IERR)
               DEALLOCATE(Y, STAT = IERR)
               CLOSE (UNIT = NOUT)
               RETURN
            ENDIF
            IF (I.GT.1) THEN
               IF (X(I).LT.X(I - 1)) THEN
                  CALL X_PUTFAT (
     +'x-values not in nondecreasing order in call to X_ERRBAR')
                  DEALLOCATE(E, STAT = IERR)  
                  DEALLOCATE(X, STAT = IERR)
                  DEALLOCATE(Y, STAT = IERR)
                  CLOSE (UNIT = NOUT)
                  RETURN
                ENDIF
            ENDIF
         ENDDO
       ELSE
C
C Read in and check data if NCOL = 3
C
         DO I = 1, N
            READ (NOUT,*,IOSTAT=IOS) X(I), Y(I), E(I)
            IF (IOS.NE.0) THEN
               CALL X_PUTFAT ('Error reading data in call to X_ERBBAR')
               DEALLOCATE(E, STAT = IERR)  
               DEALLOCATE(X, STAT = IERR)
               DEALLOCATE(Y, STAT = IERR)
               CLOSE (UNIT = NOUT)
               RETURN
            ENDIF
            IF (I.GT.1) THEN
               IF (X(I).LT.X(I - 1)) THEN
                  CALL X_PUTFAT (
     +'x-values not in nondecreasing order in call to X_ERRBAR')
                  DEALLOCATE(E, STAT = IERR)  
                  DEALLOCATE(X, STAT = IERR)
                  DEALLOCATE(Y, STAT = IERR)
                  CLOSE (UNIT = NOUT)
                  RETURN
                ENDIF
            ENDIF
         ENDDO
      ENDIF
      CLOSE (UNIT = NOUT)
C
C Calculate the means and error bars
C
      CALL X_NYYBAR (ISEND, N,
     +               X, Y, E)
C
C Overwrite the original data file supplied
C
      OPEN (UNIT = NOUT, FILE = FNAME)
      WRITE (NOUT,'(A)') TITLE
      I = 4
      WRITE (NOUT,'(2I6)') N, I
      DO I = 1, N
         WRITE (NOUT,'(1P,4E12.4)') X(I), Y(I) - E(I), Y(I), Y(I) + E(I)
      ENDDO
C
C Close the UNIT and deallocate workspaces
C      
      CLOSE (UNIT = NOUT)
      DEALLOCATE(E, STAT = IERR)  
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      END
C
C
