c
c
c
c
      character (len = 9) function x_form09 (x)
c
c action: write a double precision number to form09
c author: w.g.bardsley, university of manchester, u.k.
c           
c         12/05/2021 derived from x_form11 
c         11/06/2022 introduced x_nspace for small numbers  
c 
c  nwide = field width (9 in form09)
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c
       
      integer    i, ios, j, nstart, nstop
      integer    n0, nwide, nlast
      parameter (n0 = 0, nwide = 9, nlast = nwide - 4) 
      double precision absx
      double precision zero, one, ten1, ten2, ten3, ten4, ten5, ten6, 
     +                 ten7
      parameter (zero = 0.0d+00,
     +            one = 1.0d+00,
     +           ten1 = 1.0d+01,
     +           ten2 = 1.0d+02,
     +           ten3 = 1.0d+03,
     +           ten4 = 1.0d+04,
     +           ten5 = 1.0d+05,
     +           ten6 = 1.0d+06,
     +           ten7 = 1.0d+07)
      double precision xsmall, xvbig, xvsmall
      parameter ( xsmall = 0.001d+00, 
     +             xvbig = ten7, 
     +           xvsmall = 1.0d-250)
      character (len = 9) dfolt, word9, temp
      parameter (dfolt = '---------')
      character (len = 1) blank, dot, nought
      parameter (blank = ' ', dot = '.',  nought = '0')
      logical    abort
      external   x_nspace
      intrinsic  abs, adjustl, index
c
c initialise  
c      
      x_form09 = dfolt
      absx = abs(x)

      if (abs(x).le.xvsmall) then
c
c Case 1: deal with zero as a special case
c =======
c        
         x_form09 = '0.0'  
         write (word9,'(i17,a2)',iostat=ios) n0, '.0'
         return
      endif  
      if (absx.ge.1.0d-07 .and. absx.le.1.0d-02) then
         call x_nspace (x,
     +                  temp,
     +                  abort)
         if (.not.abort) then
            x_form09 = temp
            return         
         endif
      endif    
      if ((x.ge.zero .and. absx.ge.xsmall .and. absx.lt.xvbig) .or.
     +    (x.lt.zero .and. absx.ge.xsmall .and. absx.lt.ten6)) then
c
c Case 2: x is suitable for F formatting
c =======
c        
         if (x.gt.zero) then
            if (x.lt.one) then
               write (word9,'(f9.7)',iostat=ios) x
            elseif (x.lt.ten1) then
               write (word9,'(f9.7)',iostat=ios) x
            elseif (x.lt.ten2) then   
               write (word9,'(f9.6)',iostat=ios) x
             elseif (x.lt.ten3) then   
               write (word9,'(f9.5)',iostat=ios) x
            elseif (x.lt.ten4) then   
               write (word9,'(f9.4)',iostat=ios) x
            elseif (x.lt.ten5) then   
               write (word9,'(f9.3)',iostat=ios) x
            elseif (x.lt.ten6) then   
               write (word9,'(f9.2)',iostat=ios) x
             elseif (x.lt.ten7) then   
               write (word9,'(f9.1)',iostat=ios) x
            else   
               write (word9,'(f9.0)',iostat=ios) x
            endif      
         else
           if (absx.lt.one) then
               write (word9,'(f9.6)',iostat=ios) x
            elseif (absx.lt.ten1) then
               write (word9,'(f9.6)',iostat=ios) x
            elseif (absx.lt.ten2) then   
               write (word9,'(f9.5)',iostat=ios) x
             elseif (absx.lt.ten3) then   
               write (word9,'(f9.4)',iostat=ios) x
            elseif (absx.lt.ten4) then   
               write (word9,'(f9.3)',iostat=ios) x
            elseif (absx.lt.ten5) then   
               write (word9,'(f9.2)',iostat=ios) x
            elseif (absx.lt.ten6) then   
               write (word9,'(f9.1)',iostat=ios) x
            else   
               write (word9,'(f9.0)',iostat=ios) x
            endif   
         endif     
         if (ios.eq.0) then
c
c strip trailng zeros from F format then left justify
c           
            nstop = index(word9,dot) + 2  
            do i = nwide, nstop, -1
               if (word9(i:i).eq.nought) then
                  word9(i:i) = blank 
               else   
                  exit
               endif
            enddo
            x_form09 = adjustl(word9) 
            return
         endif   
      endif
c
c Case 3: use 1p,e9.4 or 1p,e19.3
c =======      
c
      if (x.gt.zero) then
         write (word9,'(1p,e9.3)',iostat=ios) x
      else   
         write (word9,'(1p,e9.2)',iostat=ios) x
      endif   
      if (ios.eq.0) then
         nstart = index(word9,dot) + 2
         nstop = nwide
         do i = nlast, nstart, -1
            if (word9(i:i).ne.nought) then
               exit
            else
               do j = i, nstop - 1
                  word9(j:j) = word9(j + 1:j + 1)
               enddo
               word9(nstop:nstop) = blank   
               nstop = nstop - 1
            endif     
         enddo 
         x_form09 = adjustl(word9)
      endif        
      end
c
c
      