c
c
      character (len = 11) function x_form11 (x)
c
c action: write a double precision number to form11
c author: w.g.bardsley, university of manchester, u.k.
c         28/03/2018 developed from x_form15
c         23/11/2019 used index and dot to find the decimal point  
c         11/05/2021 derived from x_form13 
c         11/06/2022 added x_nspace for small numbers depending on the number of significant figures   
c         23/07/2022 decreased xvsmall from 1.0d-300 to 1.0d-270     
c 
c  nwide = field width (11 in form11)
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c
       
      integer    i, ios, j, nstart, nstop
      integer    nwide, nlast
      parameter (nwide = 11, nlast = nwide - 4) 
      double precision absx
      double precision zero, one, ten1, ten2, ten3, ten4, ten5, ten6, 
     +                 ten7, ten8, ten9
      parameter (zero = 0.0d+00,
     +            one = 1.0d+00,
     +           ten1 = 1.0d+01,
     +           ten2 = 1.0d+02,
     +           ten3 = 1.0d+03,
     +           ten4 = 1.0d+04,
     +           ten5 = 1.0d+05,
     +           ten6 = 1.0d+06,
     +           ten7 = 1.0d+07,
     +           ten8 = 1.0d+08,
     +           ten9 = 1.0d+09)
      double precision xsmall, xvbig, xvsmall
      parameter ( xsmall = 0.0001d+00, 
     +             xvbig = ten9, 
     +           xvsmall = 1.0d-270)
      character (len = 11) dfolt, word11, temp
      parameter (dfolt = '-----------')
      character (len = 1) blank, dot, nought
      parameter (blank = ' ', dot = '.',  nought = '0')
      logical    abort
      external   x_nspace
      intrinsic  abs, adjustl, index
c
c initialise  
c      
      x_form11 = dfolt
      absx = abs(x)

      if (abs(x).le.xvsmall) then
c
c Case 1: deal with zero as a special case
c =======
c        
         x_form11 = '0.0'
         return
      endif  
      if (absx.ge.1.0d-07 .and. absx.le.1.0d-02) then
         call x_nspace (x,
     +                 temp,
     +                 abort)
         if (.not.abort) then
            x_form11 = temp
            return  
         endif
      endif   
      if ((x.ge.zero .and. absx.ge.xsmall .and. absx.lt.xvbig) .or.
     +    (x.lt.zero .and. absx.ge.xsmall .and. absx.lt.ten8)) then
c
c Case 2: x is suitable for F formatting
c =======
c        
         if (x.gt.zero) then
            if (x.lt.one) then
               write (word11,'(f11.9)',iostat=ios) x
            elseif (x.lt.ten1) then
               write (word11,'(f11.9)',iostat=ios) x
            elseif (x.lt.ten2) then   
               write (word11,'(f11.8)',iostat=ios) x
             elseif (x.lt.ten3) then   
               write (word11,'(f11.7)',iostat=ios) x
            elseif (x.lt.ten4) then   
               write (word11,'(f11.6)',iostat=ios) x
            elseif (x.lt.ten5) then   
               write (word11,'(f11.5)',iostat=ios) x
            elseif (x.lt.ten6) then   
               write (word11,'(f11.4)',iostat=ios) x
             elseif (x.lt.ten7) then   
               write (word11,'(f11.3)',iostat=ios) x
            elseif (x.lt.ten8) then   
               write (word11,'(f11.2)',iostat=ios) x
            else   
               write (word11,'(f11.1)',iostat=ios) x
            endif      
         else
           if (absx.lt.one) then
               write (word11,'(f11.8)',iostat=ios) x
            elseif (absx.lt.ten1) then
               write (word11,'(f11.8)',iostat=ios) x
            elseif (absx.lt.ten2) then   
               write (word11,'(f11.7)',iostat=ios) x
             elseif (absx.lt.ten3) then   
               write (word11,'(f11.6)',iostat=ios) x
            elseif (absx.lt.ten4) then   
               write (word11,'(f11.5)',iostat=ios) x
            elseif (absx.lt.ten5) then   
               write (word11,'(f11.4)',iostat=ios) x
            elseif (absx.lt.ten6) then   
               write (word11,'(f11.3)',iostat=ios) x
            elseif (absx.lt.ten7) then   
               write (word11,'(f11.2)',iostat=ios) x
            elseif (absx.lt.ten8) then   
               write (word11,'(f11.1)',iostat=ios) x
            else   
               write (word11,'(f11.0)',iostat=ios) x
            endif   
         endif     
         if (ios.eq.0) then
c
c strip trailng zeros from F format then left justify
c           
            nstop = index(word11,dot) + 2  
            do i = nwide, nstop, -1
               if (word11(i:i).eq.nought) then
                  word11(i:i) = blank 
               else   
                  exit
               endif
            enddo
            x_form11 = adjustl(word11) 
            return
         endif   
      endif
c
c Case 3: use 1p,e15.8 or 1p,e15.9
c =======      
c
      if (x.gt.zero) then
         write (word11,'(1p,e11.5)',iostat=ios) x
      else   
         write (word11,'(1p,e11.4)',iostat=ios) x
      endif   
      if (ios.eq.0) then
         nstart = index(word11,dot) + 2
         nstop = nwide
         do i = nlast, nstart, -1
            if (word11(i:i).ne.nought) then
               exit
            else
               do j = i, nstop - 1
                  word11(j:j) = word11(j + 1:j + 1)
               enddo
               word11(nstop:nstop) = blank   
               nstop = nstop - 1
            endif     
         enddo 
         x_form11 = adjustl(word11)
      endif        
      end
c
c