c   
c
      character (len = 15) function x_form15 (x)
c
c Note: x_show15 calculates right-justified character strings for double precision numbers (use in tables)
c       x_form15 calculates left-justified character strings for double precision numbers (use in control headers)
c action: write a double precision number to form15
c author: w.g.bardsley, university of manchester, u.k., 19/04/2008
c         30/07/2010 added code to strip trailng zeros from e15.7 format
c         28/09/2010 extensive re-write to preserve maximum number of digits
c         08/10/2010 deleted move and changed adjustr to adjustl
c         28/03/2018 extensively edited and now uses floating point notation for
c                    xsmall (0.00001) =< |x| < xvbig (10,000,000)
c                    but left in code for larger values for xvbig if required
c         22/11/2019 used dot and index to define nstop and nstart  
c         14/04/2021 introduced pnt001 = 0.001
c         11/06/2022 added x_nspace for small numbers depending on the number of significant figures  
c         22/06/2022 increased xvbig from 1.0d+07 to 1.0d+08  
c         23/07/2022 decreased xvsmall from 1.0d-300 to 1.0d-270  
c 
c  nwide = field width (15 in form15)
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c
       
      integer    i, ios, j, nstart, nstop
      integer    nwide, nlast
      parameter (nwide = 15, nlast = nwide - 4) 
      double precision absx
      double precision zero, one, ten1, ten2, ten3, ten4, ten5, ten6, 
     +                 ten7, ten8
      parameter (zero = 0.0d+00,
     +            one = 1.0d+00,
     +           ten1 = 1.0d+01,
     +           ten2 = 1.0d+02,
     +           ten3 = 1.0d+03,
     +           ten4 = 1.0d+04,
     +           ten5 = 1.0d+05,
     +           ten6 = 1.0d+06,
     +           ten7 = 1.0d+07,
     +           ten8 = 1.0d+08)
      double precision xsmall, xvbig, xvsmall
      parameter ( xsmall = 0.0001d+00, 
     +             xvbig = 1.0d+08, 
     +           xvsmall = 1.0d-270)
      double precision pnt001
      parameter (pnt001 = 0.001d+00)
      character (len = 15) dfolt, word15, temp
      parameter (dfolt = '***************')
      character (len = 1) blank, dot, nought
      parameter (blank = ' ', dot = '.', nought = '0')
      logical    abort
      external   x_nspace
      intrinsic  abs, adjustl, index
c
c initialise  
c      
      x_form15 = dfolt
      absx = abs(x)

      if (abs(x).le.xvsmall) then
c
c Case 1: deal with zero as a special case
c =======
c        
         x_form15 = '0.0'
         return
      endif  
      if (absx.ge.1.0d-07 .and. absx.le.1.0d-02) then
         call x_nspace (x,
     +                  temp,
     +                  abort)
         if (.not.abort) then
            x_form15 = temp
            return
         endif    
      endif             
      if (absx.ge.xsmall .and. absx.lt.xvbig) then
c
c Case 2: x is suitable for F formatting
c =======
c        
         if (x.gt.zero) then
            if (x.lt.pnt001) then
               write (word15,'(f15.13)',iostat=ios) x
            elseif (x.lt.one) then
               write (word15,'(f15.13)',iostat=ios) x
            elseif (x.lt.ten1) then
               write (word15,'(f15.13)',iostat=ios) x
            elseif (x.lt.ten2) then   
               write (word15,'(f15.12)',iostat=ios) x
             elseif (x.lt.ten3) then   
               write (word15,'(f15.11)',iostat=ios) x
            elseif (x.lt.ten4) then   
               write (word15,'(f15.10)',iostat=ios) x
            elseif (x.lt.ten5) then   
               write (word15,'(f15.9)',iostat=ios) x
            elseif (x.lt.ten6) then   
               write (word15,'(f15.8)',iostat=ios) x
             elseif (x.lt.ten7) then   
               write (word15,'(f15.7)',iostat=ios) x
            elseif (x.lt.ten8) then   
               write (word15,'(f15.6)',iostat=ios) x
            else   
               write (word15,'(f15.5)',iostat=ios) x
            endif      
         else
           if (absx.lt.pnt001) then
              write (word15,'(f15.12)',iostat=ios) x
           elseif (absx.lt.one) then
               write (word15,'(f15.12)',iostat=ios) x
            elseif (absx.lt.ten1) then
               write (word15,'(f15.12)',iostat=ios) x
            elseif (absx.lt.ten2) then   
               write (word15,'(f15.11)',iostat=ios) x
             elseif (absx.lt.ten3) then   
               write (word15,'(f15.10)',iostat=ios) x
            elseif (absx.lt.ten4) then   
               write (word15,'(f15.9)',iostat=ios) x
            elseif (absx.lt.ten5) then   
               write (word15,'(f15.8)',iostat=ios) x
            elseif (absx.lt.ten6) then   
               write (word15,'(f15.7)',iostat=ios) x
            elseif (absx.lt.ten7) then   
               write (word15,'(f15.6)',iostat=ios) x
            elseif (absx.lt.ten8) then   
               write (word15,'(f15.5)',iostat=ios) x
            else   
               write (word15,'(f15.4)',iostat=ios) x
            endif   
         endif     
         if (ios.eq.0) then
c
c strip trailng zeros from F format then left justify
c           
            nstop = index(word15,dot) + 2 
            do i = nwide, nstop, -1
               if (word15(i:i).eq.nought) then
                  word15(i:i) = blank 
               else   
                  exit
               endif
            enddo
            x_form15 = adjustl(word15) 
            return
         endif   
      endif
c
c Case 3: use 1p,e15.8 or 1p,e15.9
c =======      
c
      if (x.gt.zero) then
         write (word15,'(1p,e15.9)',iostat=ios) x
      else   
         write (word15,'(1p,e15.8)',iostat=ios) x
      endif  
      if (ios.eq.0) then
         nstart = index(word15,dot) + 2  
         nstop = nwide
         do i = nlast, nstart, -1
            if (word15(i:i).ne.nought) then
               exit
            else
               do j = i, nstop - 1
                  word15(j:j) = word15(j + 1:j + 1)
               enddo
               word15(nstop:nstop) = blank   
               nstop = nstop - 1
            endif     
         enddo 
         x_form15 = adjustl(word15)
      endif        
      end
c
c
