c
c
      character (len = 21) function x_form21 (x)
c
c Note: x_show21 calculates right-justified character strings for double precision numbers (use in results tables)
c       x_form21 calculates left-justified character strings for double precision numbers (use in numeric control headers)
c action: write a double precision number to x_form21
c author: w.g.bardsley, university of manchester, u.k.
c         18/11/2019 derived from x_form15
c         13/04/2021 decreased xsmall from 0.00001 to 0.0001 and introduced pnt001 = 0.001 so that this version
c                    fills out a field of width up to 21 characters rather than resticting to 12 significant figures
c         
c 
c  nwide = field width (21 in form21)
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c
       
      integer    i, ios, j, nstart, nstop
      integer    n0, nwide, nlast
      parameter (n0 = 0, nwide = 21, nlast = nwide - 4) 
      double precision absx
      double precision zero, one, ten1, ten2, ten3, ten4, ten5, ten6, 
     +                 ten7, ten8, ten9, ten10
      double precision pnt001
      parameter (pnt001 = 0.001d+00)
      parameter (zero = 0.0d+00,
     +            one = 1.0d+00,
     +           ten1 = 1.0d+01,
     +           ten2 = 1.0d+02,
     +           ten3 = 1.0d+03,
     +           ten4 = 1.0d+04,
     +           ten5 = 1.0d+05,
     +           ten6 = 1.0d+06,
     +           ten7 = 1.0d+07,
     +           ten8 = 1.0d+08,
     +           ten9 = 1.0d+09,
     +           ten10 = 1.0d+10)
      double precision xsmall, xvbig, xvsmall
      parameter ( xsmall = 0.0001d+00, 
     +             xvbig = 1.0d+10, 
     +           xvsmall = 1.0d-300)
      character (len = 21) dfolt, word21
      parameter (dfolt = '*********************')
      character (len = 1) blank, dot, nought
      parameter (blank = ' ', dot = '.', nought = '0')
      intrinsic  abs, adjustl
c
c initialise  
c      
      x_form21 = dfolt
      absx = abs(x)

      if (absx.le.xvsmall) then
c
c Case 1: deal with zero as a special case
c =======
c        
         write (word21,'(i19,a2)',iostat=ios) n0, '.0'
         if (ios.eq.0) then
            x_form21 = adjustl(word21)
            return
         endif   
      endif            
      if (absx.ge.xsmall .and. absx.lt.xvbig) then
c
c Case 2: x is suitable for F formatting
c =======
c        
         if (x.gt.zero) then
            if (x.lt.pnt001) then 
               write (word21,'(f21.15)',iostat=ios) x
            elseif (x.lt.one) then
               write (word21,'(f21.14)',iostat=ios) x
            elseif (x.lt.ten1) then
               write (word21,'(f21.14)',iostat=ios) x
            elseif (x.lt.ten2) then   
               write (word21,'(f21.13)',iostat=ios) x
             elseif (x.lt.ten3) then   
               write (word21,'(f21.12)',iostat=ios) x
            elseif (x.lt.ten4) then   
               write (word21,'(f21.11)',iostat=ios) x
            elseif (x.lt.ten5) then   
               write (word21,'(f21.10)',iostat=ios) x
            elseif (x.lt.ten6) then   
               write (word21,'(f21.9)',iostat=ios) x
             elseif (x.lt.ten7) then   
               write (word21,'(f21.8)',iostat=ios) x
            elseif (x.lt.ten8) then   
               write (word21,'(f21.7)',iostat=ios) x
            elseif (x.lt.ten9) then   
               write (word21,'(f21.6)',iostat=ios) x
            elseif (x.lt.ten10) then   
               write (word21,'(f21.5)',iostat=ios) x  
            else   
               write (word21,'(f21.4)',iostat=ios) x      
            endif      
         else
           if (absx.lt.pnt001) then
              write (word21,'(f21.15)',iostat=ios) x
           elseif (absx.lt.one) then
               write (word21,'(f21.14)',iostat=ios) x
            elseif (absx.lt.ten1) then
               write (word21,'(f21.14)',iostat=ios) x
            elseif (absx.lt.ten2) then   
               write (word21,'(f21.13)',iostat=ios) x
             elseif (absx.lt.ten3) then   
               write (word21,'(f21.12)',iostat=ios) x
            elseif (absx.lt.ten4) then   
               write (word21,'(f21.11)',iostat=ios) x
            elseif (absx.lt.ten5) then   
               write (word21,'(f21.10)',iostat=ios) x
            elseif (absx.lt.ten6) then   
               write (word21,'(f21.9)',iostat=ios) x
            elseif (absx.lt.ten7) then   
               write (word21,'(f21.8)',iostat=ios) x
            elseif (absx.lt.ten8) then   
               write (word21,'(f21.7)',iostat=ios) x
            elseif (absx.lt.ten9) then   
               write (word21,'(f21.6)',iostat=ios) x   
            elseif (absx.lt.ten10) then   
               write (word21,'(f21.5)',iostat=ios) x      
            else   
               write (word21,'(f21.4)',iostat=ios) x
            endif   
         endif     
         if (ios.eq.0) then
c
c strip trailng zeros from F format then left justify
c           
            nstop = index(word21,dot) + 2  
            do i = nwide, nstop, -1
               if (word21(i:i).eq.nought) then
                  word21(i:i) = blank 
               else   
                  exit
               endif
            enddo
            x_form21 = adjustl(word21) 
            return
         endif   
      endif
c
c Case 3: use 1p,d21.14
c =======      
c
      write (word21,'(1p,e21.14)',iostat=ios) x
      nstart = index(word21,dot) + 2
      if (ios.eq.0) then
         nstop = nwide
         do i = nlast, nstart, -1
            if (word21(i:i).ne.nought) then
               exit
            else
               do j = i, nstop - 1
                  word21(j:j) = word21(j + 1:j + 1)
               enddo
               word21(nstop:nstop) = blank   
               nstop = nstop - 1
            endif     
         enddo 
         x_form21 = adjustl(word21)
      endif        
      end
c
c