c
c
      character (len = 10) function x_formgr (x)
c
c action: return numbers suitable for including in plots (4 significant figures in 10 characters)
c author: w.g.bardsley, university of manchester, u.k., 16/09/2021       
c
c argument
c
      double precision, intent (in) :: x
c
c locals
c      
      integer    j, k, nsig
      parameter (nsig = 4)  
      double precision absx, xbot, xsmall, xtop 
      parameter (xbot = 1.0d-04, xsmall = 1.0d-250, xtop = 1.0d+05)
      character (len = 13) x_sigfig, word13
      character (len = 1 ) blank, letter, nought
      parameter (blank = ' ', nought = '0')
      intrinsic  abs, index, adjustl
      external   x_sigfig
      absx = abs(x)
      if (absx.le.xsmall) then
         word13 = '0.0'
      elseif (absx.lt.xbot .or. absx.gt.xtop) then
c
c use exponential notation if too small or too large
c           
          write (word13,'(1p,e13.3)') x
c
c check to replace 0Eabc by Eabc if required
c             
          j = index(word13,'E')
          letter = word13(j - 1:j - 1)
          if (letter.eq.nought) then
             do k = j - 1, 12
                word13(k:k) = word13(k + 1:k + 1)
             enddo
             word13(13:13) = blank 
          
c
c check if still need to replace 0Eabc by Eabc (i.e. 00E originally) 
c             
             j = j - 1
             letter = word13(j - 1:j - 1) 
             if (letter.eq.nought) then  
                do k = j - 1, 11
                   word13(k:k) = word13(k + 1:k + 1)
                enddo
                word13(12:12) = blank
            endif    
         endif      
      else   
c
c use value returned by x_sigfig
c            
         word13 = x_sigfig (nsig,
     +                      x)
      endif 
      word13 = adjustl(word13)
      x_formgr = word13(1:10)          
      end
c
c      