C
C
      SUBROUTINE X_FPRINT (LPTI,
     +                     FILE)
C
C ACTION : Print a file using redpr.exe, another driver, or DOS copy
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 24/3/98
C          03/12/1999 replaced start_process@ by winxec
C          05/12/1999 restored start_process@
C          14/02/2000 wrapped filename up in "..." and set REDPR as a
C                     parameter since start_process@ does not work when
C                     REDPR is called as c:\program files\simfit\redpr.exe
C          04/01/2001 added .WMF, .EMF, .PDF, .TEX to list of forbidden
C                     files and changed definition of L1 in a couple of places.
C                     Also trapped very long/short filenames.
C          08/02/2002 deleted /b from copy /b
C          14/11/2003 extensive editing to use any driver on cval(6)
C          02/05/2004 minor editing, added .XLS, .CHM, .BAT to forbidden list
C                     and intercepted calls to gsview using keyword GSVIEW
C          16/12/2004 changed STARTP for STARTP_PRINTER 
C          22/09/2006 corrected WORD6 to WORD60 in WRITE statement 
C          16/01/2007 edited for Linux PS printers 
C          08/02/2007 derived from FPRINT and edited for w_clearwin.dll
C          08/08/2010 added call to X_CHKEXT
C
C          LPTI should be 1 to 2 for LPT1 to LPT2 as read off
C          w_simfit.cfg o/w a default is assumed 
C          LPTI is not used in Linux which uses a PS-driver not REDPR
C          The use of REDPR or DOS copy is arbitrary and any method to
C          copy an ASCII text file to a printer will suffice. 
C          If the Windows printer fails then DOS copy is resorted to 
C
C--------------------------------------------------------------------------
C         LPTI: (input/unchanged) either 1 or 2 for LPT1: or LPT2:
C         FILE: (input/unchanged) name of file (ASCII text or PostScript)
C--------------------------------------------------------------------------
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: LPTI
      CHARACTER (LEN = *), INTENT (IN) :: FILE
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N12
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N12 = 12)
      INTEGER    MODE
      PARAMETER (MODE = -1)
      INTEGER    KVAL(N12)
      INTEGER    IOS, ISEND, L1, L2, L3, NOUT 
      INTEGER    X_LEN200
      CHARACTER  DRIVER*1024, TEMP*1024, TEMP_6*1024, TEMP_12*1024
      CHARACTER  COMAND*1024, COMDOS*1024, COMWIN*1024, CVAL(N12)*1024,
     +           FILE1*1024, LINE*1024, WORD4*4, WORD5*5,
     +           WORD6*6, WORD7*7
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    FIRST, THERE
      LOGICAL    LINUX_OS, X_LINUX3
      LOGICAL    NOISY, OK
      PARAMETER (NOISY = .TRUE.)
      EXTERNAL   X_UCASE1, X_LEN200, X_PUTFAT, X_TRIML1, W_PUTDOS,
     +           X_GETNOU, W_CONFIG, STARTP_PRINTER, RUN_GSVIEW, 
     +           X_LINUX2, X_LINUX3, X_CHKEXT, X_INFOFL
      INTRINSIC  MAX, INDEX
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
C
C Initialise ...........................................................
C ==========
C
      THERE = .FALSE.
      L2 = X_LEN200(FILE)
      IF (L2.LT.1 .OR. L2.GT.256) THEN
         WRITE (LINE,100)
         CALL X_PUTFAT (LINE)
         RETURN
      ENDIF
C
C Does the file exist ? ................................................
C =====================
C
      INQUIRE (FILE = FILE, EXIST = THERE, IOSTAT = IOS)
      IF (.NOT.THERE .OR. IOS.NE.N0) THEN
         ISEND = N1
         CALL X_INFOFL (ISEND,
     +                  FILE)           
         RETURN
      ENDIF
C
C Does it have an illegal file extension ? .............................
C ========================================
C
      IF (L2.GT.N4) THEN
         CALL X_CHKEXT (FILE,
     +                  NOISY, OK)
         IF (.NOT.OK) RETURN        
      ENDIF
C
C Is it an ASCII file ? ................................................
C =====================
C
      CALL X_GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILE, IOSTAT = IOS)
      IF (IOS.EQ.N0) READ (NOUT,'(A)',IOSTAT=IOS) LINE
      CLOSE (UNIT = NOUT)
      IF (IOS.NE.N0) THEN   
         ISEND = N4
         CALL X_INFOFL (ISEND,
     +                  FILE)          
         RETURN
      ENDIF
C
C Find the SIMFIT configuration arguments ..............................
C =======================================
C
      CALL W_CONFIG (MODE, KVAL, 
     +               CVAL)
      LINUX_OS = X_LINUX3 ('*')
      IF (LINUX_OS) THEN 
C
C Only check for printer existing in Linux as Windows can use DOS
C      
         INQUIRE (FILE = CVAL(6), EXIST = THERE, IOSTAT = IOS)
         IF (.NOT.THERE) THEN 
            ISEND = N1
            CALL X_INFOFL (ISEND,
     +                     CVAL(6))            
            RETURN
         ENDIF
      ENDIF    
      TEMP_6 = CVAL(6)
      TEMP_12 = CVAL(12)
      CALL X_TRIML1 (TEMP_6)
      CALL X_TRIML1 (TEMP_12)
      CALL X_UCASE1 (TEMP_6)
      CALL X_UCASE1 (TEMP_12)
      TEMP = TEMP_6
      IF (TEMP_6.EQ.TEMP_12) THEN
C
C Ignore arguments like -pLPT1:, etc. if gsview is required ............
C =========================================================
C
         CALL RUN_GSVIEW (FILE)
         RETURN
       ENDIF 
       IF (LINUX_OS) THEN
C
C Take special action in Linux
C       
          TEMP = FILE  
          CALL X_LINUX2 (CVAL(6), TEMP)
          CALL STARTP_PRINTER (CVAL(6), TEMP)
          RETURN
       ENDIF
C                                                           
C*****************************************************************
C NOTE: The rest of the code from now on will only work in Windows
C*****************************************************************
C 
C Define COMAND and copy it to COMDOS and COMWIN .......................
C COMDOS = command to DOS copy
C COMWIN = command to Windows driver
C ==================================
C
      IF (LPTI.GE.N1 .AND. LPTI.LE.N2) THEN
         COMAND = CVAL(LPTI + N3)
         IF (COMAND.EQ.BLANK) THEN
            COMDOS = BLANK
            COMWIN = BLANK
            L2 = N0
         ELSE
            CALL X_TRIML1 (COMAND)
            COMDOS = COMAND
            COMWIN = COMAND
C
C Do not change case for COMWIN ........................................
C =============================
C

            CALL X_UCASE1 (COMAND)
            L2 = X_LEN200 (COMAND)
         ENDIF
      ELSE
         COMAND = BLANK
         COMDOS = BLANK
         COMWIN = BLANK
         L2 = N0
      ENDIF
C
C See if the port is of the form lpt1, lpt1:, -pLPT1, -pLPT1: ..........
C ===========================================================
C
      IF (L2.GE.N4 .AND. L2.LE.N7 .AND.
     +    INDEX(COMAND, 'LPT').GT.N0) THEN
         IF (L2.EQ.N4) THEN
            WORD4 = COMAND(N1:N4)
            IF (WORD4.EQ.'LPT1') THEN
               COMDOS = 'LPT1:'
               COMWIN = '-pLPT1:'
            ELSEIF (WORD4.EQ.'LPT2') THEN
               COMDOS = 'LPT2:'
               COMWIN = '-pLPT2:'
            ENDIF
         ELSEIF (L2.EQ.N5) THEN
            WORD5 = COMAND(N1:N5)
            IF (WORD5.EQ.'LPT1:') THEN
               COMDOS = 'LPT1:'
               COMWIN = '-pLPT1:'
            ELSEIF (WORD5.EQ.'LPT2:') THEN
               COMDOS = 'LPT2:'
               COMWIN = '-pLPT2:'
            ENDIF
         ELSEIF (L2.EQ.N6) THEN
            WORD6 = COMAND(N1:N6)
            IF (WORD6.EQ.'-PLPT1') THEN
               COMDOS = 'LPT1:'
               COMWIN = '-pLPT1:'
            ELSEIF (WORD6.EQ.'-PLPT2') THEN
               COMDOS = 'LPT2:'
               COMWIN = '-pLPT2:'
            ENDIF
         ELSEIF (L2.EQ.N7) THEN
            WORD7 = COMAND(N1:N7)
            IF (WORD7.EQ.'-PLPT1:') THEN
               COMDOS = 'LPT1:'
               COMWIN = '-pLPT1:'
            ELSEIF (WORD7.EQ.'-PLPT2:') THEN
               COMDOS = 'LPT2:'
               COMWIN = '-pLPT2:'
            ENDIF
         ENDIF
      ENDIF
C
C Does DRIVER exist ? ...................................................
C ===================
C
      IF (INDEX(TEMP_6, 'REDPR.EXE').GT.N0) THEN
C
C Attempt a repair if redpr is required and port has not been specified
C =====================================================================
C
         DRIVER = 'redpr.exe'
         IF (INDEX(COMWIN, '-pLPT1:') .LE.N0 .AND.
     +       INDEX(COMWIN, '-pLPT2:') .LE.N0) COMWIN = '-pLPT1:'
      ELSE
C
C Otherwise just define driver as cval(6) ................................
C =======================================
C
         DRIVER = CVAL(N6)
      ENDIF
      INQUIRE (FILE = DRIVER, EXIST = THERE, IOSTAT = IOS)
C
C Define FILE1 as FILE wrapped up in ".." or otherwise depending on KVAL(4)
C =========================================================================
C
      L1 = N1
      L2 = X_LEN200 (FILE)
      IF (KVAL(N4).EQ.N1) THEN
         FILE1 = '"'//FILE(L1:L2)//'"'
         L2 = L2 + N2
      ELSE
         FILE1 = FILE
      ENDIF
      IF (.NOT.THERE .OR. IOS.NE.N0) THEN
C
C Not there ... so use copy .........................................
C =========================
C
         IF (FIRST) THEN
            WRITE (LINE,200)
            CALL X_PUTFAT (LINE)
            FIRST = .FALSE.
         ENDIF
         IF (COMDOS.EQ.BLANK) COMDOS = 'PRN'
         L3 = X_LEN200 (COMDOS)
         LINE = 'COPY'//BLANK//FILE1(L1:L2)//BLANK//COMDOS(L1:L3)
         CALL W_PUTDOS (IOS, LINE)
      ELSE
C
C Use the command line .................................................
C ====================
C
         L1 = N1
         L3 = X_LEN200 (COMWIN)
         IF (L3.GT.N0) THEN
            LINE = COMWIN(L1:L3)//BLANK//FILE1(L1:L2)
         ELSE
            LINE = FILE1
         ENDIF
         CALL STARTP_PRINTER (DRIVER, LINE)
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Illegal filename ... Too long or too short')
  200 FORMAT ('PS-driver is missing  ...  Will try copy')
      END
C
C

