c
c
      subroutine x_fserch (dir, fname, full_path,
     +                     there)
c
c action: search for a file
c author: w.g.bardsley, university of manchester, u.k.
c         26/12/2012 developed from w_pathto 
c                         
c       dir: (input/unchanged) directory to start searching
c     fname: (input/unchanged) file required
c full_path: (output)          full path to fname if there = .true.
c     there: (output)          if true then path exists o/w path was not found
c
c
c Note: pf = %PROGRAMFILES% is not used in this version
c
      implicit   none 
c
c arguments
c      
      character (len = *), intent (in)  :: dir, fname
      character (len = *), intent (out) :: full_path      
      logical,             intent (out) :: there
c
c locals
c      
      integer    i, k, l_pf
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart,
     +           ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1,
     +           numopt = 7, nstart = 14)  
      integer    isend
      parameter (isend = 9) 
      integer    numbld(30), numpos(numopt)
      integer    x_len200 
      character (len = 1024) dir_copy, full_path_copy
      character (len = 1024) pf, w_fpath2, svalue
      character (len = 100 ) line, text(30)
      character (len = 80  ) fname_copy, word80(3), query, x_trim80
      character (len = 12  ) undef
      parameter (undef = '***Undefined') 
      character (len = 2   ) root 
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\') 
      logical    repeet
      logical    fixed, full, high
      parameter (fixed = .false., full = .false., high = .false.)
      logical    first
      external   w_findfl, w_lbox01, x_putfat, x_infofl,
     +           x_trim80, w_patch1, x_len200,
     +           x_triml1, x_getstr, w_v7path, w_fpath2
      save       first, root
      data       first / .true. /
      data       numbld / 30*0 /
      data       numpos /numopt*1 /
      
      if (first) then
c
c first time round get the program files environment variable and root
c pf not used as possible 32-bit/64-bit confusion but may be restored
c        
         first = .false.
         full_path = blank
         call w_v7path (l_pf,
     +                  'p32', pf)         
         if (l_pf.gt.1) then
            if (pf(l_pf:l_pf).ne.bslash) then
               l_pf = l_pf + 1
               pf(l_pf:l_pf) = bslash
            endif
         else
            pf = 'C:\Program Files\'        
            l_pf = 17
         endif 
         root = pf(1:2)      
      endif
c
c check the data supplied 
c         
      there = .false.
      if (dir.eq.blank) then
         call x_putfat ('Cannot have a blank starting folder')
         return
      endif     
      if (fname.eq.blank) then
         call x_putfat ('Cannot have a blank file name')
         return
      endif 
c
c initialise
c
      dir_copy = dir
      fname_copy = fname
      full_path_copy = undef
c
c main loop
c
      numdec = 6           
      repeet = .true.
      do while (repeet)
         if (full_path_copy.eq.blank) full_path_copy = undef
         word80(1) = x_trim80(full_path_copy)
         word80(2) = x_trim80(fname_copy)   
         word80(3) = x_trim80(dir_copy)
         write (text,100) (word80(i), i = 1, 3), root
         numbld(1) = 1
         numbld(6) = 1
         numbld(9) = 1
         numbld(12) = 1
         ntext = nstart + numopt - 1
         call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                  numpos, nstart, ntext,
     +                  text,
     +                  fixed, full, high)
         numbld(1) = 0
         numbld(6) = 0
         numbld(9) = 0
         numbld(12) = 0
         if (numdec.eq.1) then
c
c try a full path/file_name
c                          
            query =
     +'Fully qualified path\filename for the program required'
            svalue = full_path_copy
            call x_getstr (query, svalue) 
            full_path_copy = svalue
            
            inquire (file = full_path_copy, exist = there)
            if (there) then  
               full_path = w_fpath2(full_path_copy)
               call x_infofl (isend,
     +                      full_path)               
               repeet = .false.
            else
               full_path_copy = undef
               write (line,200)
               call x_putfat (line)
            endif
            numdec = 4 
         elseif (numdec.eq.2) then
c
c try a new file name
c         
            query = 
     +'Full file name (with extension) for the program required' 
            svalue = fname_copy
            call x_getstr (query, svalue)
            fname_copy = svalue(1:80)
            if (fname_copy.eq.blank) fname_copy = undef
            numdec = 4
         elseif (numdec.eq.3) then 
c
c try a new search path
c         
            query =
     +'Full drive\path to search for the program required'
            svalue = dir_copy
            call x_getstr (query, svalue)
            dir_copy = svalue              
            call x_triml1 (dir_copy)
            k = x_len200(dir_copy)
            if (k.le.1) then
               write (line,300)
               call x_putfat (line)
            endif   
            numdec = 4
         elseif (numdec.eq.4) then 
c
c search for the missing file
c         
            call w_findfl (dir_copy, fname_copy, full_path_copy, 
     +                     there)
            if (there) then
               full_path = w_fpath2(full_path_copy)
               call x_infofl (isend,
     +                        full_path)              
               repeet = .false.
            else              
               write (line,200)
               call x_putfat (line)
               numdec = 5
            endif
         elseif (numdec.eq.5) then 
c
c search the root for the missing file
c         
            call w_findfl (root, fname_copy, full_path_copy, 
     +                     there)
            if (there) then
               full_path = w_fpath2(full_path_copy)
               call x_infofl (isend,
     +                      full_path)               
               repeet = .false.
            else              
               write (line,200)
               call x_putfat (line)
               numdec = 6
            endif   
         elseif (numdec.eq.numopt - 1) then
c
c help
c         
            write (text,400) root
            ntext = 22
            numbld(1) = 1
            numbld(5) = 1
            numbld(9) = 1
            numbld(13) = 1
            numbld(17) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                      text, fixed)
            numbld(1) = 0
            numbld(5) = 0
            numbld(9) = 0
            numbld(13) = 0
            numbld(17) = 0
            numdec = 5
         elseif (numdec.eq.numopt) then
c
c cancel search
c         
            repeet = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'The Simfit file finding procedure'
     +/
     +/'You can specify a full_path, file, or directory'
     +/
     +/'Current full-path'
     +/A  
     +/
     +/'Current file'
     +/A 
     +/
     +/'Current drive\path to search'
     +/A
     +/
     +/'Input a fully qualified drive\path\filename'
     +/'Input a new file to search for'
     +/'Input a new drive\path to search'
     +/'Search from current drive\path'
     +/'Search from the root ',a
     +/'Help'
     +/'Quit ... Exit the file searching procedure')
  200 format ('FAILURE ... file was not found')  
  300 format ('Path must have more than one character, e.g. D:')  
  400 format (
     + 'The Simfit file finding procedure'
     +/
     +/'The following definitions are observed for this procedure.'
     +/
     +/'Current full-path'
     +/'A supposed fullly qualified drive\path\filename. For example'
     +/'      C:\Program Files\Simdem\bin\simdem.exe'
     +/
     +/'Current file'
     +/'The unqualified name of a file. For example'
     +/'      simdem.exe'
     +/ 
     +/'Current drive\path to search'
     +/'The path where searching is to begin. For example'
     +/'      C:\Program Files'
     +/
     +/'The options available'
     +/'1)`Try  a fully qualified drive\path\filename'
     +/'2)`Choose a new filename'
     +/'3)`Choose a new search path'
     +/'4)`Search using the filename and search path'
     +/'5)`Search from the root ',a)
      end
c
c
