c
c
      subroutine x_fsizes (itype,
     +                     fsize,
     +                     store)
c
c action: store or retrieve font size correction factors
c author: w.g.bardsley, university of manchester, u.k., 13/10/2004
c         18/09/2006 added itype = 11
c         29/11/2010 added itype = 12 for extra title
c         20/01/2011 added options for further developments as follows:
c                    jtype = abs(itype) then
c                    store = .true. itype > 0: invokes a request to change font size jtype
c                                   itype < 0: store value supplied for font size jtype
c                    store = .false. just return the stored value for jtype
c         13/02/2011 added options 13, 14, and 15 and changed limits to (0.2,5.0)
c         28/05/2011 fsize is now returned if user changes the value
c         01/11/2011 now uses w_fsizes.cfg to store values
c         20/01/2013 sets smaller defaults and opens w_fsizes.cfg first time and then to
c                    store changes. Also now uses itype = 0 to restore defaults.  
c 
c         itype: (input/unchanged)
c                 itype = 0: restore all defaults then return    
c                o/w first set jtype = abs(itype) then
c         jtype: type of font required as follows:
c                jtype =  1: title (main)
c                jtype =  2: x-legend
c                jtype =  3: y-legend
c                jtype =  4: z-legend
c                jtype =  5: x-text-labels
c                jtype =  6: y-text-labels 
c                jtype =  7: z-text-labels
c                jtype =  8: bar chart labels
c                jtype =  9: pie chart labels
c                jtype = 10: panel labels
c                jtype = 11: data point labels
c                jtype = 12: title (extra)
c                jtype = 13: x_numbers
c                jtype = 14: y-numbers
c                itype = 15: z-numbers
c         fsize: (input/output) as follows:
c                store = .true. then change fsize and store a copy as follows
c                         itype > 0: interactive query
c                         itype < 0: store without a query       
c                store = .false. then just return the stored value
c         store: (input/unchanged) type of action required as above
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: itype
      double precision, intent (inout) :: fsize
      logical,          intent (in)    :: store
c
c locals
c
      integer    i, ios, jtype, l, nout, x_len200
      integer    numbld(30), numdec, numtxt
      integer    nmax, numopt, numsta
      parameter (nmax = 15, numopt = 5, numsta = 7)
      double precision fsize_1(nmax), fsize_2(nmax)
      double precision one, fmin, fmax, pnt75, pnt9
      parameter (one = 1.0d+00, fmin = 0.25d+00, fmax = 5.0d+00,
     +           pnt75 = 0.75d+00, pnt9 = 0.9d+00)
      character (len = 1024) full_path, x_sim256
      character (len = 100 ) line, text(30)
      character (len = 20  ) ftype(nmax), word20
      character (len = 15  ) word15(2), x_form15
      logical    first, repeet, there
      external   x_getdm1, x_len200, x_sim256, x_getnou, x_lstbox,
     +           x_putadv, x_patch2
      external   w_table1, x_form15
      intrinsic  abs
      save       first
      save       fsize_1
      data       numbld / 30*0 /
      data       first / .true. /
      data       fsize_1 / 4*one, 7*pnt9, 1*pnt75, 3*pnt9 /
      data       fsize_2 / 4*one, 7*pnt9, 1*pnt75, 3*pnt9 /
      data       ftype  / 'Title_1 (main)',
     +                    'X-legend',
     +                    'Y-legend',
     +                    'Z-legend',
     +                    'X-text-labels',
     +                    'Y-text-labels',
     +                    'Z-text-labels',
     +                    'Bar chart labels',
     +                    'Pie chart labels',
     +                    'Panel labels',
     +                    'Data point labels',
     +                    'Title_2 (subsidiary)',
     +                    'X-axis numbers',
     +                    'Y-axis numbers',
     +                    'Z-axis numbers' /


c--------------------------------------------------------------------------
      if (first) then
c
c first = .true. so open w_fsizes.cfg or create it and get fsize_1
c      
         first = .false.
         full_path = x_sim256('w_fsizes.cfg')
         inquire (file = full_path, exist = there)
         call x_getnou (nout)
         open (unit = nout, file = full_path, iostat = ios)
         if (ios.eq.0 .and. .not.there) then
            do i = 1, nmax
               if (ios.eq.0) write (nout,'(f8.4)',iostat=ios) fsize_1(i)
            enddo
            if (ios.eq.0) write (nout,100,iostat=ios)
            do i = 1, nmax
               if (ios.eq.0) write (nout,'(i3,2x,a)',iostat=ios)
     +                              i, ftype(i)
            enddo     
         else
            do i = 1, nmax
               if (ios.eq.0) read (nout,*,iostat=ios) fsize_1(i)
            enddo
         endif
         close (unit = nout)
      endif
c-------------------------------------------------------------------------
     
c
c restore defaults if itype = 0 then return
c    
      if (itype.eq.0) then
         fsize = one
         do i = 1, nmax
            fsize_1(i) = fsize_2(i)
         enddo  
         full_path = x_sim256('w_fsizes.cfg')
         call x_getnou (nout)
         open (unit = nout, file = full_path, iostat = ios)
         if (ios.eq.0) then
            do i = 1, nmax
               if (ios.eq.0) write (nout,'(f8.4)',iostat=ios) fsize_1(i)
            enddo
            if (ios.eq.0) write (nout,100,iostat=ios)
            do i = 1, nmax
               if (ios.eq.0) write (nout,'(i3,2x,a)',iostat=ios)
     +                              i, ftype(i)
            enddo     
         endif   
         close (unit = nout)
         return
      endif  
c
c check itype
c
      jtype = abs(itype)
      if (jtype.lt.1 .or. jtype.gt.nmax) then
         if (.not.store) fsize = one
         return
      endif
      
      if (store) then
c
c store = .true. ... change sizes
c        
         if (itype.gt.0) then
c
c get a value from the user interactively
c           
            numdec = 3
            repeet = .true.
            do while (repeet) 
               word15(1) = x_form15(fsize_1(jtype))
               word15(2) = x_form15(fsize_2(jtype))
               write (text,200) ftype(jtype), word15(1), word15(2), 
     +                          ftype(jtype)
               numtxt = numsta + numopt - 1
               numbld(1) = 4
               call x_lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                        text) 
               numbld(1) = 0 
               if (numdec.eq.1) then
c
c numdec = 1: view table
c                 
                  l = 15
                  call w_table1 (l, 'OPEN')
                  l = 4
                  line = 'Graphical Object        Size    Default'
                  call w_table1 (l, line)
                  l = 0
                  do i = 1, nmax
                     write (line,'(a20,2f8.2)') ftype(i), fsize_1(i),
     +                                                    fsize_2(i)
                     call w_table1 (l, line)
                  enddo
                  call w_table1 (l, 'CLOSE')  
               elseif (numdec.eq.2) then
c
c numdec = 2: restore defaults
c               
                  do i = 1, nmax
                     fsize_1(i) = fsize_2(i)
                  enddo
                  call x_putadv ('All sizes restored to default values')   
               elseif (numdec.eq.3) then               
c
c numdec = 3: change a value
c               
                  word20 = ftype(jtype)
                  l = x_len200(word20)
                  write (line,300) word20(1:l), fsize_2(jtype)
                  call x_getdm1 (fmin, fsize_1(jtype), fmax,
     +                           line)
               elseif (numdec.eq.4) then
c
c numdec = 4: help
c               
                  numtxt = 24
                  write (text,400)
                  numbld(1) = 1
                  numbld(5) = 1
                  numbld(12) = 1
                  numbld(21) = 1
                  call x_patch2 (numbld, numtxt,
     +                           text)  
                  numbld(1) = 0
                  numbld(5) = 0
                  numbld(12) = 0
                  numbld(21) = 0                
               else
c
c numdec = numopt: done ... proceed to update the configuration file
c                 
                  repeet = .false.
               endif      
            enddo
            fsize = fsize_1(jtype)
         else
c
c check then store the value supplied as an argument
c           
            if (fsize.lt.fmin) then
               fsize_1(jtype) = fmin
            elseif (fsize.gt.fmax) then
               fsize_1(jtype) = fmax
            else
               fsize_1(jtype) = fsize
            endif         
         endif
c
c write current values to w_fsizes.cfg
c         
         call x_getnou (nout)
         full_path = x_sim256('w_fsizes.cfg')
         open (unit = nout, file = full_path, iostat = ios)
         do i = 1, nmax
            if (ios.eq.0) write (nout,'(f8.4)',iostat=ios) fsize_1(i)
         enddo  
         if (ios.eq.0) write (nout,100,iostat=ios)
         do i = 1, nmax
            if (ios.eq.0) write (nout,'(i3,2x,a)',iostat=ios) i,
     +                                                        ftype(i)
         enddo
         close (unit = nout)
      else
c
c store = .false. ... retrieve the value required
c        
         fsize = fsize_1(jtype)          
      endif
c
c format statements
c      
  100 format ('%Meaning of the above font size parameters as follows:')
  200 format (
     + 'Changing relative font sizes'
     +/
     +/'Current font:',1x,a
     +/'Current size:',1x,a
     +/'Current default:',1x,a  
     +/
     +/'View all current values'
     +/'Set all to default values'
     +/'Change size for',1x,a
     +/'Help'
     +/'Quit ... Exit font size editing') 
  300 format (A,1X,'size required: Default value =',f6.4)
  400 format (
     + 'Techniques for altering font sizes in Simfit plots'
     +/     
     +/'There are two methods to change the character sizes.'
     +/
     +/'1) Global font size'
     +/
     +/'This is set using the [EPS] or [Win] options and results in'
     +/'a scaling factor being written to the file w_ps.cfg which then'
     +/'scales all the fonts in graphics display. It is probably best'
     +/'to leave this global font size at the default value of 1.'
     +/
     +/'2) Relative font size'
     +/
     +/'From the present control you can fine tune Simfit graphics by'
     +/'setting scaling factors to control relative character sizes.'
     +/'These scaling factors are written to the file w_fsizes.cfg and'
     +/'you should realise that results will depend on the font being'
     +/'used, and the degree of crowding if there too many tick marks,'
     +/'or longer text labels.' 
     +/
     +/'Advice'
     +/
     +/'In doubt use [EPS] or [Win] to set global factors = 1. Then'
     +/'experiment with individual relative scaling font sizes.')
 
      end
c
c
