c     
c Includes:
c module_ftable and functions
c x_ftable        
c e_formats
c x_sigfig
c i_call_x_ftable
C X_DOFDOT
c sigpdf ... significant figures
c conpdf ... contact
c sumpdf ... simfit summary
c
      module module_ftable
      implicit none
      integer ios, k, nunit
      integer ntype_sav
      character (len = 1024) fname, path
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical e_numbers
      save ntype_sav
      save fname, path
      save e_numbers
      data ntype_sav / 7 /!Note: this must be altered if the menu in x_ftable is altered 
      data fname, path / blank, blank /
      data e_numbers / .false. /
      end module  module_ftable
c
c      
      character (len = 13) function x_ftable(x,
     +                                       store)
      use module_ftable
      include <windows.ins>
c
c action: return string for x supplied formatted ready for a simfit table
c author: w.g.bardsley, university of manchester, u.k., 14/05/2021
c         15/06/2021 introduced x_nought and x_zero
c         01/08/2021 increased the number of options and added calls to x_sigfig
c         06/05/2022 added the case nsig = 7
c         08/10/2022 added call to usepdf
c
c if store = .true. the user defines ntype_sav and x is returned as an appropriate 13 character text string 
c if store = .false. x is just returned as an appropriate 13 character text string 
c 

c
c arguments
c
    
      double precision, intent (in) :: x
      logical,          intent (in) :: store
c
c locals
c      
      integer    i, jcolor, nsig, ntype 
      integer    numopt, numsta, numtxt
      parameter (numopt = 12, numsta = 8)
      integer    numdec, numbld(30)
      integer    sigpdf
      character (len = 100) text1(100), text2(100), text3(100)
      character (len = 80 ) mssage
      parameter (mssage =
     +'W_FTABLE.CFG must have read/write permission (use attrib -r)')
      character (len = 30 ) cipher(10)
      character (len = 13 ) word13, x_sigfig, x_show13
      character (len = 13 ) x_nought, x_zero
      parameter (x_zero = '      0.0E+00',
     +           x_nought = '          0.0')
      character (len = 12 ) word12, x_show12
      character (len = 11 ) word11, x_show11
      character (len = 10 ) word10, x_show10
      character (len = 3  ) blank3
      parameter (blank 3 = '   ')
      character (len = 2  ) blank2
      parameter (blank 2 = '  ')
      character (len = 1  ) blank1
      parameter (blank1 = ' ')
      logical    abort, first, repeet, there, use_sigpdf  
      external   sigpdf, x_getnou, w_v7path, x_show10, x_show11,
     +           x_show12, x_show13, x_sigfig
      external   w_lboxnx, w_table1, x_putadv
      save first
      data numbld / 30*0 /
      data first / .true. /
c
c intialise x_ftable and check ntype_sav first time called
c  
      use_sigpdf = .true.    
      x_ftable = blank
      if (first) then
c
c if first = .true. then set first = .false. and get the current default
c      
         first = .false.
         call w_v7path (k, 
     +                  'cfg', path)    
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash 
         endif   
         fname = path(1:k)//'w_ftable.cfg'
         call x_getnou (nunit)
         inquire (file = fname, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            open (unit = nunit, file = fname, iostat = ios)
            read (nunit,'(i3)',iostat=ios) ntype_sav
            close (unit = nunit)
         endif
         if (ios.ne.0) call x_putadv (mssage)
         if (ntype_sav.eq.6) then
            e_numbers = .true.
         else
            e_numbers = .false.
         endif
      endif

      if (store) then
c
c if store = .true. choose the format required
c
         numdec = ntype_sav 
         
         numtxt = numsta + numopt - 1 
         repeet = .true.
         do i = 1, 10
            cipher(i) = blank1
         enddo
         cipher(ntype_sav) = '[Current Option]'   
         do while (repeet)
            write (text1,100) (cipher(i), i = 1, 10)
            numbld(1) = 4
            call w_lboxnx (numbld, numdec, numopt, numsta, numtxt,
     +                     text1,       
     +                     abort)     
            numbld (1) = 0
            repeet = .true.
            if (numdec.ge.1 .and. numdec.le.10) then
               do i = 1, 10
                  cipher(i) = blank1
               enddo
               cipher(numdec) = '[Current Option]'   
               ntype_sav = numdec
               numdec = numopt
            elseif (numdec.eq.11) then
               if (use_sigpdf) then
                  i = sigpdf()
               else 
                  write (text1,200)
                  write (text2,300)
                  write (text3,400)
                  jcolor = 15
                  call w_table1 (jcolor, 'OPEN')
                  do i = 1, 24
                     if (i.eq.1) then
                        jcolor = 4
                     else
                        jcolor = 0
                     endif
                     call w_table1 (jcolor, text1(i))      
                  enddo      
                  do i = 1, 25
                     if (i.eq.1) then
                        jcolor = 4
                     else
                        jcolor = 0
                     endif      
                     call w_table1 (jcolor, text2(i))
                  enddo 
                  do i = 1, 18
                     call w_table1 (jcolor, text3(i))
                  enddo   
                  call w_table1 (jcolor, 'CLOSE')  
               endif   
               numdec = ntype_sav
            else
               repeet = .false.  
            endif
         enddo 
c
c save the altered value for ntype_sav then return
c  
         if (ntype_sav.ge.1 .and. ntype_sav.le.10) then 
            call x_getnou (nunit)
            open (unit = nunit, file = fname, iostat = ios)
            if (ios.eq.0) then
               write (nunit,'(i3)',iostat=ios) ntype_sav
               close (unit = nunit)
               if (ios.ne.0) call x_putadv (mssage)
            else
               call x_putadv (mssage)
            endif
            return
         else 
            ntype_sav = 7   
         endif    
      endif
c
c formatted output
c     
      ntype = ntype_sav
      if (ntype.eq.1) then
         word13 = x_show13(x)
         x_ftable = word13
      elseif (ntype.eq.2) then
         word12 = x_show12(x)
         x_ftable = blank//word12   
      elseif (ntype.eq.3) then
         word11 = x_show11(x)
         x_ftable = blank2//word11
      elseif (ntype.eq.4) then
         word10 = x_show10(x)
         x_ftable = blank3//word10
      elseif (ntype.eq.5) then
         nsig = 7
         x_ftable = x_sigfig (nsig,
     +              x)
      elseif (ntype.eq.6) then
         write (word13,'(1p,e13.5)') x
         x_ftable = word13
      elseif (ntype.eq.7) then   
         nsig = 6
         x_ftable = x_sigfig (nsig,
     +              x)
      elseif (ntype.eq.8) then  
         nsig = 5
         x_ftable = x_sigfig (nsig,
     +              x)
      elseif (ntype.eq.9) then 
         nsig = 4
         x_ftable = x_sigfig (nsig,
     +              x)
      elseif (ntype.eq.10) then
         nsig = 3
         x_ftable = x_sigfig (nsig,
     +              x)
      endif 
      if (x_ftable.eq.x_zero) x_ftable = x_nought 
      if (ntype_sav.eq.6) then
         e_numbers = .true.
      else
         e_numbers = .false.
      endif
c
c format statement
c     
c NOTE: the default value is set in module_ftable for initialisation so
c       format 100 MUST be consistent with ntype_sav defined in the module
c
c 
  100 format (
     + 'Configuring numbers displayed in Simfit results tales'
     +/
     +/'Select the number of significant digits in standard notation'
     +/'except for large (>10000000) or small (<0.0000001) values. The'
     +/'default is Option 7, or Option 6 using full scientific notation'
     +/'so that orders of magnitude can be seen at a glance.'
     +/
     +/'Option  1:  Up to 12 digits                         ',a              !1  ... x_show13
     +/'Option  2:  Up to 11 digits                         ',a              !2  ... x_show12                     
     +/'Option  3:  Up to 10 digits                         ',a              !3  ... x_show11
     +/'Option  4:  Up to  9 digits                         ',a              !4  ... x_show10    nsig = 7
     +/'Option  5:  Exactly 7 digits                        ',a              !5  ... x_sigfig    nsig = 6 
     +/'Option  6:  Exactly 6 digits (scientific format)    ',a              !6  ... exponential nsig = 6
     +/'Option  7:  Exactly 6 digits (recommended)          ',a              !7  ... x_sigfig    nsig = 6 (DEFAULT DEFINED IN MODULE_FTABLE)
     +/'Option  8:  Exactly 5 digits                        ',a              !8  ... x_sigfig    nsig = 5
     +/'Option  9:  Exactly 4 digits                        ',a              !9  ... x_sigfig    nsig = 4
     +/'Option 10:  Exactly 3 digits                        ',a              !10 ... x_sigfig    nsig = 3
     +/'Help'                                                                !11
     +/'Exit ... Accept the current option')                                 !12
  200 format ( 
     + 'The number of significant digits in results tables'
     +/    
     +/'Experimental data generally have variability or error of say'    
     +/'1 to 10% of the absolute value of the observations which only'   
     +/'requires about 4 to 7 significant digits. However, numbers'      
     +/'are calculated on computers up to 15 significant digits so'    
     +/'this means that results from calculations are best truncated'      
     +/'in tables for legibility.'    
     +/    
     +/'With large or small numbers scientific notation is useful, e.g.'
     +/
     +/'1.23456E+08 instead of 12345600.0, or'     
     +/'1.23456E-08 instead of 0.000000123456' 
     +/     
     +/'where powers of ten are shown as E_scale factors making it'
     +/'easier to read as, for example, when expressing weights in'
     +/'micrograms, milligrams, grams, or kilograms for convenience.'
     +/ 
     +/'The default format displays 6 significant digits but avoids'
     +/'exponential notation except for large or small values. This is'
     +/'true for all options except for 6 digits in scientific format'
     +/'where numbers line up at decimal points and orders of magnitude'
     +/'are clear from the powers of ten after the E_scale factor.'
     +/)
  300 format (
     + 'SIMFIT programs currently using these formatting options'
     +/
     +/'EXFIT    Fitting one or sums of exponentials'
     +/'GCFIT    Fitting growth and survival curves'       
     +/'HLFIT    Fitting High/Low affinity ligand binding models'       
     +/'MMFIT    Fitting one or sums of Michaelis-Menten functions '       
     +/'POLNOM   Using polynomials of degree 0 to 6 for calibration'
     +/'SIMSTAT  Section 1: Data exploration'
     +/'SIMSTAT  Section 2: Standard statistical tests'
     +/'SIMSTAT  Section 3: Analysis of variance'
     +/'SIMSTAT  Section 4: Analysis of proportions'
     +/'SIMSTAT  Section 5: Multivariate analysis'
     +/'SIMSTAT  Section 6: Linear regression and calibration'
     +/'SIMSTAT  Section 7: Generalised linear models'
     +/'SIMSTAT  Section 8: Smoothing/Time Series/Survival Analysis'
     +/'SIMSTAT  Section 9: Statistical calculations'
     +/'SIMSTAT  Section 10: Numerical analysis'
     +/'RFFIT    Fitting positive rational functions'
     +/'SFFIT    Fitting cooperative ligand binding models'
     +/'SPLINE   Fitting splines for analysis and calibration'
     +/'COMPARE  Fit splines to compare data sets for differences'
     +/'CALCURVE Fit splines for calibration curves'
     +/'INRATE   Estimate initial rate or horizontal asymptotes'
     +/'MAKDAT   Make plots and data files for selected models'
     +/'ADDERR   Add simulated experimental error to MAKDAT-files')
 400  format (
     + 'QNFIT    Fitting data by constrained nonlinear regression'
     +/'DEQSOL   Simulating and fitting differential equations'
     +/'AVERAGE  Areas and thresholds by the trapezoidal method'
     +/'RANNUM   Random numbers/permutations/check U(0,1) generator'
     +/'CSAFIT   Nonparametric comparison of two histograms'
     +/'MAKCSA   Generate random samples to test program CSAFIT'
     +/'MAKFIL   Makes files for plotting, fitting, and calibration'
     +/'EDITFL   Edits files for plotting, fitting, and calibration'
     +/'MAKMAT   Makes files for statistical and numerical analysis'
     +/'EDITMT   Edits files for statostical and numerical analysis'
     +/'NORMAL   Calculations using the Normal distribution'    
     +/'TTEST    Calculations using the t distribution'
     +/'CHISQD   Calculations using the chi-square distribution'    
     +/'FTEST    Calculations using the F distribution'
     +/'BINOMIAL Calculations using the binomial/Poisson distributions'
     +/'RSTEST   Nonparametric tests'
     +/'LINFIT   Linear and multilinear regression plus PLS and GLM'
     +/'USERMOD  Develop user-defined mathematical models'
     +/'MAKSIM   Convert text, csv, and html files into Simfit format')    
      end
c
c----------------------------------------------------------------------------
c
      recursive logical function e_formats()
      use module_ftable
c     
c action: define e_formats where e_numbers = e_formats() in the calling program
c author: w.g.bardsley, university of manchester, u.k., 15/06/2021
c
c if first = .true. then ntype_sav is read from w_table.cfg
c e_formats is returned as .true. only if ntype_sav = 6 i.e. exponential notation is requested
c      
      implicit none
      logical first, there
      save first
      data first / .true. /
      external x_getnou, w_v7path 
c
c if  first time round get the current default for ntype_sav and define e_numbers
c o/w just return the current value for e_numbers
c      
      if (first) then
         first = .false.
         call w_v7path (k, 
     +                  'cfg', path)    
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash 
         endif   
         fname = path(1:k)//'w_ftable.cfg'
         call x_getnou (nunit)
         inquire (file = fname, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            open (unit = nunit, file = fname, iostat = ios)
            read (nunit,'(i3)',iostat=ios) ntype_sav
            close (unit = nunit)
         else    
            open (unit = nunit, file = fname, iostat = ios)
            write (nunit, '(i3)',iostat=ios) ntype_sav!ntype_sav is defined in module_ftable as 7
            close (unit = nunit)
         endif
         if (ntype_sav.eq.6) then
            e_numbers = .true.
         else
            e_numbers = .false.
         endif
      endif  
      e_formats = e_numbers 
      end
c
c--------------------------------------------------       
c
c       
c
      character (len = 13) function x_sigfig (nsig,
     +                                        x)
c
c action: return x with nsig significant digits
c author: w.g.bardsley, university of manchester, u.k, 30/07/2021
c         15/02/2022 added nsig = 7 and solved a problem with continued sections such as ...9999 etc.  
c         05/05/2022 added nspace and factor to allow, e.g 0.0000001 instead of 1.0d-07 for epsi, etc. 
c         11/06/2022 added x_nspace for small numbers depending on the number of significant digits                           
c      
      implicit none
c
c arguments
c      
      integer,          intent(in) :: nsig
      double precision, intent(in) :: x 
c
c locals
c      
      integer i, j, k, l, msig, nspace
      double precision  factor, factmin, y
      parameter (factmin = 1.0d-04)
      double precision  absx, one, ten, x_new, xmax, xmin, xsmall
      parameter (one = 1.0d+00, ten = 10.0d+00, xmin = 1.0d-04, 
     +           xmax = 1.0d+08, xsmall = 1.0d-250)
      character (len = 20) line
      character (len = 13) word13, temp
      character (len = 1 ) blank, letter, nought, point
      parameter (blank = ' ', nought = '0', point = '.') 
      logical    abort
      external   x_nspace
      intrinsic  abs
      absx = abs(x)
c
c check for zero 
c      
      if (absx.le.xsmall) then
         x_sigfig = '0.0'
         return
      endif
c
c ensure msig is in range 
c            
      msig = nsig
      if (msig.gt.7) then
         msig = 7
      elseif (msig.lt.3) then
         msig = 3
      endif         
c
c write using exponential format to msig significant digits 
c      
      if (msig.eq.7) then
         write (word13,'(1p,e13.6)') x    
      elseif (msig.eq.6) then
         write (word13,'(1p,e13.5)') x
      elseif (msig.eq.5) then 
         write (word13,'(1p,e13.4)') x 
      elseif (msig.eq.4) then 
         write (word13,'(1p,e13.3)') x   
      elseif (msig.eq.3) then 
         write (word13,'(1p,e13.2)') x   
      endif
c      
c call x_nspace if 1.0d-08 < absx < 1.0d-02
c     
      if (absx.ge.1.0d-08 .and. absx.le.1.0d-02) then
         temp = word13
         read (temp,*) y
         call x_nspace (y,
     +                  temp,
     +                  abort)
         if (.not.abort) then
            x_sigfig = temp
            return
         endif      
      endif
c
c remove unrequired zeros in front of the exponential part
c      
      k = index(word13,point)
      l = 13
      do i = 9, k + 2, -1
         letter = word13(i:i)
         if (letter.eq.nought) then
            do j = i, l - 1
               word13(j:j) = word13(j + 1: j + 1)
            enddo
            word13(l:l) = blank
            l = l - 1
         else
            exit   
         endif  
      enddo
      word13 = adjustl(word13)
c
c use nspace, factor, and factmin to edit small numbers and allow, e.g.  0.0000001
c      
      l = len_trim(word13)
      nspace = 13 - l
      factor = one
      if (nspace.ge.1 .and. absx.lt.xmin) then
         factor = factor*(ten**(-nspace)) 
         if (factor.lt.factmin) factor = factmin
      endif   
      if (absx.gt.xmax .or. absx.lt.factor*xmin) then     
c
c out of range so just use the exponential notation and return
c        
         x_sigfig = word13
         return
      endif 
c
c read the value in default format to the correct number of significant digits
c      
      read (word13,*) x_new
      line = blank
      if (absx.lt.one) then
c
c numbers < 1.0
c        
         write (line,'(f20.10)') x_new
         
         line = adjustl(line)
         k = len_trim(line) 
         do i = k, 1, -1
            letter = line(i:i)
            if (letter.eq.nought) then
               line(i:i) = blank
            else
               exit   
            endif
         enddo
      else
c
c numbers >= 1.0
c        
         write (line,'(f20.6)') x_new
         
         line = adjustl(line)
         k = index(line,point)
         do i = 20, k + 2, -1
            letter = line(i:i)  
            if (letter.eq.blank) then
               continue
            elseif (letter.eq.nought) then
               line(i:i) = blank
            else    
               exit
            endif   
         enddo  
      endif
c
c adjust for things like 1. then define x_sigfig
c      
      k = index(line,point)
      if (line(k + 1:k + 1).eq.blank) line(k + 1:k + 1) = nought
      word13 = line(1:13)   
      x_sigfig = word13  
      end
c
c-------------------------------------------------------------------------------------------------   
c
      subroutine x_nspace (x,
     +                     wordx,  
     +                     abort)
c
c action: format small numbers with the maximum number of significant digits
c         case 1: maximum number possible for x_form09, x_form10, x_form11, x_form13, xform15
c         case 2: maximum number but after internal pre-processing with subroutine x_sigfig   
c         It replaces a lot of arbitrary code in x_sigfig, x_form09, x_form10, x_form11, x_form13 and x_form15 
c
c author: w.g.bardsley, university of manchester, u.k., 10/06/2022
c   
c         Note: abort is returned as .true when either
c               1) len(wordx) is not 9, 10, 11, 13, or 15 
c               2) xmax < abs(x) < xmin (original values were xmax = 1.0d-02 and xmin = 1.0d-08)
c            
      double precision,      intent (in)  :: x    
      character (len = *),   intent (out) :: wordx
      logical,               intent (out) :: abort
      integer i, k, l, legal
      double precision absx
      double precision  xmax, xmin, zero
      parameter (xmax = 1.0d-02, xmin = 1.0d-07, zero = 0.0d+00)
      character (len = 1) letter
      character (len = 1) blank, nought, point
      parameter (blank = ' ',  nought = '0', point = '.') 
      character (len = 20) line 
      intrinsic abs, len_trim
c
c set abort = .true.  and wodx to blank then return if either legal or x is out of range 
c    
      abort = .true. 
      wordx = blank
      legal = len(wordx)
      if (legal.lt.9 .or. legal.eq.12 .or. legal.eq.14
     +               .or. legal.gt.15) return
      absx = abs(x)
      if (absx.lt.xmin .or. absx.gt.xmax) return
c
c remove trailing blanks and noughts
c      
      if (x.le.zero) then
         write (line,'(f20.17)') x
      else
         write (line,'(f20.18)') x
      endif     
      line = adjustl(line)
      k = index(line,point)
      do i = 20, k + 2, -1
         letter = line(i:i)  
         if (letter.eq.blank) then
            continue 
         elseif (letter.eq.nought) then
            line(i:i) = blank
         else    
            exit! because a number or ., +, or - has been encountered
         endif   
      enddo
      l = len_trim(line)
      if (l.gt.legal) then
c
c there would be loss of significant digits in this case
c        
         return
      else   
c
c adjust for things like 1. then finally set abort = .false. and define wordx
c      
         abort = .false. 
         k = index(line,point)
         if (line(k + 1:k + 1).eq.blank) line(k + 1:k + 1) = nought
         wordx = line(1:legal)   
      endif   
      end
c
c
      SUBROUTINE X_DOFDOT (ISEND,
     +                     CIPHER, VALUEN)
c
c Action: replace 123.000 etc. in a string by 123 if ISEND = 0 or 123.0 if ISEND = 1
c Author: w.g.bardsley, university of manchester, u.k., 30/06/2022
c 19/08/2022 coirrected ltriml1, and trimt1 t0 x_triml1 and x_trimr1 
c  
c ISEND = 0: remove decimal point and return in integer format with no decimal point if possible
c ISEND = 1: leave  decimal point and return in double  format with at most 1 trailing '0'   
c      o/w : no action
c CIPHER = 'L' or CIPHER = 'l' then call X_triml1
c CIPHER = 'R' or CIPHER = 'r' then call X-trimr1
c      o/w no action 
c
c USAGE: isend = 0 transforms 123.000 into 123
c        isend = 1 transforms 123.000 into 123.0 
c        There is no action if there is no decimal point and no action
c        if anything except blanks or noughts follow the decimal point.
c        It is used to improve the situation where degrees of freedom are  
c        not integers as in programs TTEST, CHISQD, FTEST, etc.    
c
c    
      IMPLICIT NONE
c
c arguments
c      
      INTEGER,             INTENT (IN)    :: ISEND
      CHARACTER (LEN = *), INTENT (IN)    :: CIPHER
      CHARACTER (LEN = *), INTENT (INOUT) :: VALUEN
c
c locals
c      
      INTEGER    I, J, K, L
      CHARACTER (LEN = 1) BLANK, DOT, LETTER, NOUGHT, SYMBOL
      PARAMETER (BLANK = ' ', DOT = '.', NOUGHT = '0')
      EXTERNAL   X_TRIML1, X_TRIMR1, X_PUTADV
      INTRINSIC  LEN_TRIM, INDEX
c
c check ISEND
c      
      IF (ISEND.LT.0 .OR. ISEND.GT.1) THEN
         CALL X_PUTADV ('ISEND must be 0 or 1 in calls to DOFDOT') 
         RETURN
      ENDIF  
c
c trim depending on SYMBOL in case no other action is required
c      
      SYMBOL = CIPHER(1:1)  
      IF (SYMBOL.EQ.'L' .OR. SYMBOL.EQ.'l') THEN
         CALL X_TRIML1 (VALUEN) 
      ELSEIF (SYMBOL.EQ.'R' .OR. SYMBOL.EQ.'r') THEN
         CALL X_TRIMR1 (VALUEN)
      ENDIF  
c
c check
c      
      J = INDEX(VALUEN,'E')
      IF (J.GT.0) RETURN
      J = INDEX(VALUEN,'e')
      IF (J.GT.0) RETURN
      J = INDEX(VALUEN,'D')
      IF (J.GT.0) RETURN
      J = INDEX(VALUEN,'d')
      IF (J.GT.0) RETURN  
      J = INDEX(VALUEN,DOT)
      IF (J.LE.0) RETURN 
      K = LEN_TRIM(VALUEN)
c     
c strip trailing zeros etc.
c     
      IF (J.EQ.K) THEN
c
c the case where the decimal point is the last character
c
         IF (ISEND.EQ.0) THEN
            K = K - 1
            VALUEN(J:J) = BLANK
         ELSE
            K = K + 1
            VALUEN(K:K) = NOUGHT
         ENDIF      
      ELSEIF (ISEND.EQ.0 .AND. K.EQ.J + 1 .AND.
     +        VALUEN(K:K).EQ.NOUGHT) THEN
c
c the case with ISEND = 0 and only 1 nought after the decimal point
c        
         VALUEN(J:J) = BLANK
         VALUEN(K:K) = BLANK
         K = K - 2 
      ELSE 
c     
c strip trailing zeros 
c          
         L = K 
         DO I = K, J + 2, -1
            LETTER = VALUEN(I:I) 
            IF (LETTER.EQ.NOUGHT) THEN
               VALUEN(I:I) = BLANK
               L = L - 1 
            ELSE
               EXIT
            ENDIF      
         ENDDO 
         K = L    
         IF (ISEND.EQ.0 .AND. L.EQ.J + 1 .AND.
     +       VALUEN(L:L).EQ.NOUGHT) THEN 
c
c the case with ISEND = 0 and only 1 nought after the decimal point after stripping
c     
            VALUEN(J:J) = BLANK
            VALUEN(L:L) = BLANK  
            K = K - 2    
         ENDIF  
      ENDIF
c
c re-check in case re-trimming is required
c      
      SYMBOL = CIPHER(1:1)  
      IF (SYMBOL.EQ.'L' .OR. SYMBOL.EQ.'l') THEN
         CALL X_TRIML1 (VALUEN) 
      ELSEIF (SYMBOL.EQ.'R' .OR. SYMBOL.EQ.'r') THEN
         CALL X_TRIMR1 (VALUEN)
      ENDIF   
      END
c
c      
      recursive integer function sigpdf()
c
c action: display the significant digits pdf file
c author: w.g.bardsley, university of manchester u.k., 08/10/2022
c      
      integer    k
      character (len = 1024)  path, sig_file
      character (len =   33) stub
      parameter (stub = 'significant_digits_in_tables.pdf')
      logical    there
      external   run_acrobat, x_docdir, x_putadv
      call x_docdir (k,
     +               path)
      if (path(k:k).ne.'\') then
         k = k + 1
         path(k:k) = '\'
      endif   
      sig_file = path(1:k)//stub 
      inquire (file = sig_file, exist = there)
      if (there) then
         call run_acrobat (sig_file)
         sigpdf = 2
      else
         call x_putadv ('Cannot find significant_digits_in_tables.pdf')
         sigpdf = 0
      endif      
      end 
c
c      
      recursive integer function conpdf()
c
c action: display the contact pdf file
c author: w.g.bardsley, university of manchester u.k., 08/10/2022
c      
      integer    k
      character (len = 1024)  path, sig_file
      character (len =   33) stub
      parameter (stub = 'contact.pdf')
      logical    there
      external   run_acrobat, x_docdir, x_putadv
      call x_docdir (k,
     +               path)
      if (path(k:k).ne.'\') then
         k = k + 1
         path(k:k) = '\'
      endif   
      sig_file = path(1:k)//stub 
      inquire (file = sig_file, exist = there)
      if (there) then
         call run_acrobat (sig_file)
         conpdf = 2
      else
         call x_putadv ('Cannot find contact.pdf')
         conpdf = 0
      endif      
      end       
c
c
      
      recursive integer function sumpdf()
c
c action: display the contact pdf file
c author: w.g.bardsley, university of manchester u.k., 08/10/2022
c      
      integer    k
      character (len = 1024)  path, sum_file
      character (len =   33) stub
      parameter (stub = 'simfit_summary.pdf')
      logical    there
      external   run_acrobat, x_docdir, x_putadv
      call x_docdir (k,
     +               path)
      if (path(k:k).ne.'\') then
         k = k + 1
         path(k:k) = '\'
      endif   
      sum_file = path(1:k)//stub 
      inquire (file = sum_file, exist = there)
      if (there) then
         call run_acrobat (sum_file)
         sumpdf = 2
      else
         call x_putadv ('Cannot find simfit_summary.pdf')
         sumpdf = 0
      endif      
      end       
