c
c
      subroutine x_getany (isend, k, n, ntext,
     +                     x,
     +                     s, text)
c
c action: call w_get00n to get any values
c author: w.g.bardsley, university of manchester, u.k., 15/02/2007 
c         13/06/2010 adjusted numbld(1) as necessary     
c
c isend: (input/unchanged) as follows:
c         isend = 1: integers
c         isend = 2: double precisions
c         isend = 3: strings
c         isend = 4: logicals (returned as k = 0 or 1) 
c     k: (input/output) the integer values
c     n: (input/output) the number of values required
c ntext: (input/unchanged) the number of text lines
c     x: (input/output) the double precision values 
c     s: (input/output) the strings
c  text: (input/unchanged) the header text
c
      implicit none 
c
c arguments
c          
      integer, intent (in)                :: isend, n, ntext
      integer, intent (inout)             :: k(n)
      double precision, intent (inout)    :: x(n) 
      character (len = *), intent (in)    :: text(ntext)
      character (len = *), intent (inout) :: s(n)
c
c locals
c                                  
      integer    nmax
      parameter (nmax = 30)       
      integer    i, nstart, numbld(nmax), numpos(nmax)
      integer    icolor, ix, iy, lshade
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 0) 
      character  blank*1
      parameter (blank = ' ') 
      logical    fixed, full, high
      parameter (fixed = .false., full = .false., high = .true.)
      external   w_get00n
      if (isend.lt.1 .or. isend.gt.4 .or.
     +    n.lt.1     .or. n.gt.nmax  .or.
     +    ntext.lt.n .or. ntext.gt.nmax) return 
      do i = 1, ntext
         numbld(i) = 0
      enddo
      if (ntext.gt.n) then
         if (ntext.eq.n + 1) then
            numbld(1) = 4
         elseif (text(2).eq.blank) then
            numbld(1) = 4
         endif
      endif         
      do i = 1, n
         numpos(i) = isend
      enddo 
      nstart = ntext - n + 1        
      call w_get00n (icolor, ix, iy, k, lshade, numbld, n, numpos,
     +               nstart, ntext, 
     +               x,
     +               s, text,
     +               fixed, full, high)
      end
c
c 