c
c
      subroutine x_getcfg (mode, nval,
     +                     cval)
c
c action: get configuration parameters 
c author: w.g.bardsley, university of manchester, u.k.
c         30/08/2015 completely new version derived from x_switch 
c         15/05/2017 now outputs a full message for ERROR 1 
c         18/07/2017 added call to adjust_config_cval
c
c          mode: (input/unchanged)
c                mode = -2: as for mode = 0 but return nval = lval (advanced: wait times)
c                mode = -1: as for mode = 0 but return nval = kval (advanced: quotes etc.)
c                mode = 0 : just return arguments 
c                mode = 1 : refresh then as 0
c          nval: (output)
c          cval: (output)
c
c The next 48 items must be set properly to control the execution protocol
c used by w_simfit.exe and x64_simfit.exe, simdem.exe and x64_simdem.exe
c
c          nval(1) : 1 = show simfit logo then % ntype
c          nval(2) : 1 = delete f$??????.tmp files
c          nval(3) : 1 = create log file, 0 = default results file
c          nval(4) : 1 = show start up message
c          nval(5) : 1 = show errors if Simfit program file is missing
c          nval(6) : 1 = show w_ps.cfg configuration errors 
c          nval(7) : 1 = show missing main modules errors
c          nval(8) : 1 = show Ghostscript errors
c          nval(9) : 1 = show printer driver errors
c          nval(10): % plot area
c          nval(11): % font size
c          nval(12): # table lines
c
c The following default programs require subroutines w_pathto and w_findfl
c for checking and must be initialised in this subroutine and also in
c the function i_check_config
c
c          cval(1) : editor
c          cval(2) : explorer
c          cval(3) : simfit
c          cval(4) : results
c          cval(5) : user
c          cval(6) : config
c          cval(7) : clipboard viewer
c          cval(8) : ghostscript
c          cval(9) : temp
c          cval(10): gsview, i.e. PS-viewer
c          cval(11): acrobat, i.e. PDF-reader
c          cval(12): calculator
c
c Advanced options
c
c           kval(1) : quotes...editor
c           kval(2) : quotes...gsview, i.e. PS-viewer
c           kval(3) : quotes...ghostscript
c           kval(4) : quotes...ps printer
c           kval(5) : quotes...acrobat, i.e., PDF-reader
c           kval(6) : paint background window
c           kval(7) : always provide View/Open/cancel option
c           kval(8) : display Windows-specific messages (no for Linux)
c           kval(9) : display now input a file formatted like ... advice
c           kval(10): always provide type-in option
c           kval(11): display first time user messages
c           kval(12): display warning when quitting from advanced graphics
c
c           lval(1) : wait time for acrobat
c           lval(2) : wait time for calculator
c           lval(3) : wait time for clipboard
c           lval(4) : wait time for editor
c           lval(5) : wait time for explorer
c           lval(6) : wait time for gsview
c           lval(7) : wait time for simfit programs
c           lval(8) : wait time for arbitrary programs
c           lval(9) : wait time for PS printer driver
c           lval(10): reserved
c           lval(11): reserved
c           lval(12): reserved
c

      implicit   none
c
c argument
c      
      integer,             intent (in)  :: mode
      integer,             intent (out) :: nval(12)
      character (len = *), intent (out) :: cval(12)
c
c locals
c      
      integer    n_items, numtxt
      parameter (n_items = 12, numtxt = 18)
      integer    kval_sav(n_items), lval_sav(n_items),
     +           nval_sav(n_items)
      integer    i, iadd1, ios, k, nout
      integer    numbld(numtxt)
      character (len = 1024) cval_sav(n_items)
      character (len = 1024) path, full_path
      character (len = 100 ) line, text(numtxt) 
      character (len = 1   ) blank, pcent
      parameter (blank = ' ', pcent = '%')
      logical    first, op, read_only, there
      external   x_cfgdir, x_attrib, x_getnou, x_putfat, x_patch2 
      external   adjust_config_cval
      intrinsic  index
      save       nval_sav, kval_sav, lval_sav
      save       cval_sav 
      save       first
      data       first / .true. /
      data       nval_sav / n_items*1 / 
      data       kval_sav / n_items*1 / 
      data       lval_sav / n_items*1 / 
      data       cval_sav / n_items*blank /
      data       numbld / numtxt*0 /
c
c initialise then check the value of mode
c      
      do i = 1, n_items
         nval(i) = nval_sav(i)
         cval(i) = cval_sav(i)
      enddo   
      if (mode.lt.-2 .or. mode.gt.1) then
         call x_putfat ('Must have -2 =< MODE =< 1 in call to X_GETCFG')
         return
      endif    
c
c initialise then get configuration file details
c      
      ios = 0
      if (mode.eq.1 .or. first) then
         first = .false.
         call x_cfgdir (k,
     +                  path)      
         full_path = path(1:k)//'w_simfit.cfg'
         call x_attrib (full_path,
     +                  there, read_only)      
         if (.not.there) then  
c        
c check for error 1  ... missing configuration file          
c
            write (text,100) 
            numbld(1) = 1
            call x_patch2 (numbld, numtxt,
     +                     text)           
            return
         elseif (read_only) then
c        
c check for error 2            
c      
            write (line,200)
            call x_putfat (line)
            return
         else
c        
c check for error 3            
c        
            inquire (file = full_path, opened = op, iostat = ios) 
            if (ios.eq.0 .and. op) then
               write (line,300) 
               call x_putfat (line)
               return
            endif  
            call x_getnou (nout) 
            open (unit = nout, file = full_path, iostat = ios)  
         endif 
         if (ios.ne.0) then
c        
c check for error 4            
c        
            write (line,400) ios
            call x_putfat (line)
            close (unit = nout)
            return
         else
            iadd1 = 0
            do while (ios.eq.0 .and. iadd1.lt.48)
               iadd1 = iadd1 + 1
               if (iadd1.eq.1) then
                  read (nout,'(a)',iostat=ios) line
                  if (ios.ne.0) then
c        
c check for error 5            
c                 
                     write (line,500) ios
                     call x_putfat (line)
                     close (unit = nout)
                     return
                  endif   
                  k = index(line,pcent)
c        
c check for error 6            
c               
                  if (k.le.0) then
                     write (line, 600)
                     call x_putfat (line)
                     close (unit = nout)
                     return 
                  endif 
                  read (line(1:k - 1),*,iostat=ios) nval_sav(iadd1)
c        
c check for error 7            
c               
                  if (ios.ne.0) then
                     write (line,700) ios
                     call x_putfat (line)
                     close (unit = nout)
                     return
                  endif
               elseif (iadd1.le.12) then
                  read (nout,*, iostat = ios) nval_sav(iadd1)
               elseif (iadd1.le.24) then
                  read (nout,'(a)',iostat=ios) cval_sav(iadd1 - 12)
               elseif (iadd1.le.36) then
                  read (nout,*,iostat=ios) kval_sav(iadd1 - 24)  
               elseif (iadd1.le.48) then
                  read (nout,*,iostat=ios) lval_sav(iadd1 - 36)                                      
               endif
            enddo           
         endif
         close (unit = nout)
         if (iadd1.ne.48) then
c        
c check for error 8            
c        
            write (line,800) iadd1
            call x_putfat (line)
            return
         endif
      endif
c
c return the stored values
c      
      if (mode.eq.-2) then
         do i = 1, n_items
            nval(i) = lval_sav(i)
         enddo   
      elseif (mode.eq.-1) then
         do i = 1, n_items
            nval(i) = kval_sav(i)
         enddo 
      else 
         do i = 1, n_items
            nval(i) = nval_sav(i)
         enddo
      endif
      do i = 1, n_items
         cval(i) = cval_sav(i)
      enddo  
      call adjust_config_cval (cval) 
c
c format statements
c      
c  100 format ('X_GETCFG Error 1: cannot find w_simfit.cfg')
  100 format (
     + 'The Simfit configuration file w_simfit.cfg cannot be located'
     +/
     +/'Simfit and Simdem read configuration details from a text'
     +/'file (w_simfit.cfg) in ... ProgramData\Simfit\user\cfg.'
     +/'This will be missing with new installations, or if you have'
     +/'deleted this file, so an attempt will now be made to create'
     +/'a new version.' 
     +/
     +/'As you re-configure Simfit then use the [Apply] option, the'
     +/'changes required will be saved to w_simfit.cfg. This is'
     +/'described in the document configure.pdf.'
     +/
     +/'If, at any stage, this file gets corrupted you can safely'
     +/'delete it, which will simply cause a new one to be created.'
     +/
     +/'For group use where individuals have different requirements, an'
     +/'archive of personal copies can be made so one can be copied'
     +/'into ...ProgramData\Simfit\user\cfg before opening Simfit.')
  200 format ('X_GETCFG Error 2: w_simfit.cfg is read_only')
  300 format ('X_GETCFG Error 3: w_simfit.cfg is connected')
  400 format ('X_GETCFG Error 4: cannot open w_simfit.cfg, IOSTAT =',i6)
  500 format ('X_GETCFG Error 5: cannot read w_simfit.cfg, IOSTAT =',i6)
  600 format ('X_GETCFG Error 6: no % on w_simfit.cfg line 1')
  700 format ('X_GETCFG Error 7: cannot read NVAL(1), IOSTAT =',I6)
  800 format ('X_GETCFG Error 8: IADD1 =', i6) 
      end
c
c
     
