c
c
      subroutine x_getdg2 (x, y,
     +                     line)
c
c action: version of getdg2 for w_clearwin.dll
c author: w.g.bardsley, university of manchester, u.k., 14/09/2011
c
      implicit none
c
c arguments
c          
      double precision,    intent (inout) :: x, y
      character (len = *), intent (in)    :: line 
c
c locals
c      
      integer    icolor, ix, iy, nchar, numlin, numtxt
      parameter (icolor = 7, ix = 0, iy = 0, nchar = 25, numlin = 2,
     +           numtxt = 1)
      integer    icount, numbld(numtxt)
      character (len = 25) lines(numlin), x_form25
      character (len = 80) text(numtxt)
      double precision x1, y1 
      logical    abort
      logical    fixed, stack
      parameter (fixed = .false., stack = .true.)
      external   x_putfat, w_xlines, x_txt2r1, x_form25
c
c check
c      
      if (x.gt.y) then
         call x_putfat ('X > Y in call to X_GETDG2')
         return
      endif
c
c loop up to 5 times
c      
      text(1) = 'INPUT: '//line 
      numbld(1) = 0 
      icount = 0
      do while (icount.lt.5)
         icount = icount + 1
         x1 = x
         y1 = y
         lines(1) = x_form25(x1)
         lines(2) = x_form25(y1) 
         call w_xlines (icolor, ix, iy, nchar, numbld, numlin, numtxt,
     +                  lines, text,
     +                  fixed, stack)
         call x_txt2r1 (x1,
     +                  lines(1),
     +                  abort)
         if (.not.abort) then
            call x_txt2r1 (y1,
     +                     lines(2),
     +                     abort)   
         endif
         if (.not.abort) then
            if (y1.ge.x1) then
               x = x1
               y = y1
               return
            endif   
         endif      
         if (icount.lt.5) then
            call x_putfat ('Input rejected ... Try again')   
         else
            call x_putfat ('Input rejected ... Defaults accepted')
         endif      
      enddo
      end
c
c                        