c
c
      subroutine x_getdm1 (xbot, xmid, xtop, 
     +                     line)
c
c action: version of getdm1 for w_clearwin.dll
c author: w.g.bardsley, university of manchester, u.k., 20/09/2011
c
      implicit none
c
c arguments
c          
      double precision,    intent (in)    :: xbot, xtop
      double precision,    intent (inout) :: xmid
      character (len = *), intent (in)    :: line 
c
c locals
c      
      integer    icolor, ix, iy, nchar, numlin, numtxt
      parameter (icolor = 7, ix = 0, iy = 0, nchar = 25, numlin = 1,
     +           numtxt = 3)
      integer    icount, numbld(numtxt), nbot, ntop, x_len200
      character (len = 25) lines(numlin), x_form25, bot, top
      character (len = 80) text(numtxt)
      double precision x1 
      logical    abort
      logical    fixed, stack
      parameter (fixed = .false., stack = .true.)
      external   x_putfat, w_xlines, x_txt2r1, x_form25, x_len200
      data       numbld / numtxt*0 /
c
c check
c      
      if (xbot.gt.xtop) then
         call x_putfat ('xbot > xtop in call to x_getdm1')
         return
      endif   
      if (xmid.lt.xbot) then
         call x_putfat ('xmid < xbot in call to x_getdm1')
         return
      endif   
      if (xmid.gt.xtop) then
         call x_putfat ('xmid > xtop in call to x_getdm1')
         return
      endif   
c
c loop up to 5 times
c      
      text(1) = 'INPUT: '//line 
      text(2) = ' '
      bot = x_form25(xbot)
      top = x_form25(xtop)
      nbot = x_len200(bot)
      ntop = x_len200(top)
      write (text(3),100) bot(1:nbot), top(1:ntop) 
      icount = 0
      do while (icount.lt.5)
         icount = icount + 1
         x1 = xmid
         lines(1) = x_form25(x1)
         call w_xlines (icolor, ix, iy, nchar, numbld, numlin, numtxt,
     +                  lines, text,
     +                  fixed, stack)
         call x_txt2r1 (x1,
     +                  lines(1),
     +                  abort)
         if (.not.abort) then
            if (x1.ge.xbot .and. x1.le.xtop) then
               xmid = x1
               return
            endif 
         endif     
         if (icount.lt.5) then
            call x_putfat ('Input rejected ... Try again')   
         else
            call x_putfat ('Input rejected ... Default accepted')   
         endif   
      enddo
  100 format ('Minimum = ',a,',  Maximum = ',a)      
      end
c
c                              

     