c
c 
      subroutine x_getffs (fname, 
     +                     must_exist, ok)
c
c action: use w_getffs to find an existing arbitrary file or a possible filename 
c author: w.g.bardsley, university of manchester, u.k., 14/09/2011
c         30/12/2015 extensive editing and introduced use of w_pathto.cfg   
c         07/02/2019 changed filternames to (len = 45) and filterspecs to (len = 15)            
c
c must_exist = .false.: can return either a new or existing filename, i.e. Save As ...
c must_exist = .true. : only returns an existing filename, i.e. Open
c
      implicit none
c
c arguments
c     
      character (len = *), intent (out) :: fname
      logical,             intent (in)  :: must_exist
      logical,             intent (out) :: ok
c
c locals
c    
      integer    ios, l, m, nout
      integer    mustexist, nfilters
      parameter (nfilters = 15)
      character (len = 1024) path, path_open, path_save, pathto, 
     +                       x_sim256
      character (len = 1024) fname_open, fname_save
      character (len = 80  ) title
      character (len = 45  ) filternames(nfilters)
      character (len = 15  ) filterspecs(nfilters)
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical    abort, first, there
      logical    back
      parameter (back = .true.)
      external   w_getffs, x_getnou, w_chkfld, x_usrdir, x_sim256,
     +           w_getnou
      save       fname_open, fname_save 
      save       path_open, path_save, pathto 
      save       first
      data       first / .true. /
      data       fname_open, fname_save / 'my_file', 'untitled' /
      data       path_open, path_save, pathto / blank, blank, blank /
c
c initialise first time
c 
      if (first) then
         first = .false.
         call x_usrdir (l,
     +                  path_open)
         if (path_open(l:l).eq.bslash) path_open(l:l) = blank
         path_save = path_open
         pathto = x_sim256('w_pathto.cfg')
      endif   
c
c pick up path_open and path_save from w_pathto.cfg
c       
      inquire (file = pathto, exist = there, iostat = ios) 
      if (ios.eq.0 .and. there) then 
         call w_getnou (nout) 
         open (unit = nout, file = pathto, iostat = ios) 
         if (ios.eq.0) read (nout,'(a)',iostat= ios) path
         if (ios.eq.0) path_open = path 
         if (ios.eq.0) read (nout,'(a)',iostat= ios) path
         if (ios.eq.0) path_save = path 
         close (unit = nout)
      endif 
           
      ok = .false.
      if (must_exist) then
         mustexist = 1
         fname = fname_open
         path = path_open
      else
         mustexist = 0
         fname = fname_save
         path = path_save
      endif   
c
c Define the filters
c
      title = 'Select a file'
      filterspecs(1) = '*.*'
      filternames(1) = 'All files'
      filterspecs(2) = '*.txt'
      filternames(2) = 'Text files'
      filterspecs(3) = '*.dat'
      filternames(3) = 'Data files'
      filterspecs(4) = '*.res'
      filternames(4) = 'Results files'
      filterspecs(5) = '*.log'
      filternames(5) = 'Log files'
      filterspecs(6) = '*.tf?'
      filternames(6) = 'Test files'
      filterspecs(7) = '*.tmp'
      filternames(7) = 'Temporary files'
      filterspecs(8) = '*.old'
      filternames(8) = 'Old files'
      filterspecs(9) = '*.new'
      filternames(9) = 'New files'
      filterspecs(10) = '*.mod'
      filternames(10) = 'Model files'
      filterspecs(11) = '*.eps'
      filternames(11) = 'Encapsulated PostScript files'
      filterspecs(12) = '*.svg'
      filternames(12) = 'Scaleable vector graphics'
      filterspecs(13) = '*.png'
      filternames(13) = 'Portable network graphics'
      filterspecs(14) = '*.emf'
      filternames(14) = 'Windows enhanced metafiles'
      filterspecs(15) = '*.cfg'
      filternames(15) = 'Configuration files'
      call w_getffs (title, fname, path, filternames, filterspecs,
     +               nfilters,
     +               mustexist)
c
c if the file exists or is a viable filename then return ok = .true.
c     
      if (fname.eq.blank) return
      if (must_exist) then
         inquire (file = fname, exist = ok)
      else  
         call w_chkfld (fname,
     +                  abort)
         if (.not.abort) then        
            call x_getnou (nout)
            open (unit = nout, file = fname, iostat = ios)
            if (ios.eq.0) ok = .true.
            close (unit = nout)
         endif   
      endif  
      if (ok) then
         m = len_trim (fname)
         l = index(fname, bslash, back)
         if (l.gt.1 .and. m.gt.l) then
            if (must_exist) then
               path_open = fname(1:l - 1)
               fname_open = fname(l + 1:m)
            else   
               path_save = fname(1:l - 1)
               fname_save = fname(l + 1:m)
            endif   
            call w_getnou (nout)
            open (unit = nout, file = pathto, iostat = ios) 
            if (ios.eq.0) write (nout,'(a)',iostat = ios) path_open
            if (ios.eq.0) write (nout,'(a)',iostat = ios) path_save
            close (unit = nout) 
         endif
      endif  
      end
c
c
