c
c
      subroutine x_getlbl (itype, nlabel,
     +                     labels,
     +                     ffiles)
c
c action: view/edit/read-in/paste/overwrite current plotting labels
c author: w.g.bardsley, university of manchester, u.k., 30/01/2002
c         11/07/2005 edited and increased nwords from 500 to 2000
c         09/01/2007 made nwide a parameter for the call to edittx
c         07/04/2008 corrected dimension error in call to edittx
c         14/09/2011 developed from getlbl
c         31/12/2015 added call to x_savcfg 
c
c          itype: (input/unchanged) 1 for labels, 2 for templates
c         nlabel: (input/unchanged) number of labels
c         labels: (input/output)
c         ffiles: (input/unchanged) read in from files only if .TRUE.
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: itype, nlabel
      character (len = *), intent (inout) :: labels(nlabel)
      logical,             intent (in)    :: ffiles
c
c locals
c
      integer    i, ios, isend, n, nhigh, nlines, nout
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (ix = 4, iy = 4, lshade = 1, numopt = 7, numtxt = 22)
      integer    numbld(30)
      integer    nwide, nwords
      parameter (nwide = 40, nwords = 2000)
      character  fname*1024, line*100, temp*40, text(30)*100
      character  word4*4, word6*6, word40(2)*40, word80*80,
     +           words(nwords)*(nwide), type1*20, type2*20
      character  blank*1, path*1, pattern*1
      parameter (blank = ' ')
      logical    ok, repeet, there, yes
      logical    askif, border, must_exist
      parameter (askif = .false., border = .false., must_exist = .true.)
      external   x_listbx, w_patch1, w_edittx, x_getnou, w_viewer,
     +           x_yesno2, x_putfat, w_gettmp, w_deleet, x_triml1,
     +           x_getffs, x_savcfg
      intrinsic  min
      data       numbld / 30*0 /
c
c check
c
      if (nlabel.lt.1) return
      n = min(nlabel,nwords)
c
c intialise
c
      if (itype.eq.1) then
         type1 = 'Labels'
         type2 = 'Labels'
      else
         type1 = 'Templates'
         type2 = 'Templates (NA)'
      endif
      do i = 1, n
         words(i) = labels(i)
      enddo
      if (ffiles) then
         word4 = blank
      else
         word4 = '(NA)'
         if (itype.eq.1) type2 = 'Labels (NA)'
      endif
c
c main loop
c
      numdec = 5
      repeet = .true.
      do while (repeet)
         write (text,100) type1, word4, type1, type2
         call x_listbx (numdec, numopt,
     +                  text)
         if (numdec.eq.1) then
c
c View
c
            call w_gettmp (i,
     +                     fname)
            call x_getnou (nout)
            open (unit = nout, file = fname)
            word40(1) = 'Current'
            word40(2) = 'Replacement'
            word80 = word40(1)//word40(2)
            write (nout,'(a)') word80
            do i = 1, n
               word80 = labels(i)(1:40)//words(i)
               write (nout,'(a)') word80
            enddo
            close (unit = nout)
            isend = 1
            path = blank
            pattern = blank
            call w_viewer (isend,
     +                     fname, path, pattern)
            call w_deleet (fname,
     +                     askif, there)
         elseif (numdec.eq.2) then
c
c From file
c
            if (ffiles) then
               call x_getffs (fname,
     +                        must_exist, ok)              
               if (ok) then
                  isend = 1
                  path = blank
                  pattern = blank
                  call w_viewer (isend,
     +                           fname, path, pattern)
                  icolor = 1
                  yes = .false.
                  write (line,200) type1
                  call x_yesno2 (icolor, ix, iy,
     +                           line,
     +                           yes)
                  if (yes) then
                     call x_getnou (nout)
                     open (unit = nout, file = fname, iostat = ios)
                     if (ios.eq.0) then
                        do i = 1, n
                           if (ios.eq.0) read (nout,'(a)',iostat=ios)
     +                                         temp
                           if (ios.eq.0) words(i) = temp
                        enddo
                     endif
                     close (unit = nout)
                     isend = 2
                     call x_savcfg (isend,
     +                              fname)                   
                  endif
               endif
            else
               write (line,300)
               call x_putfat (line)
            endif
            numdec = 1
         elseif (numdec.eq.3) then
c
c From terminal ...  nhigh: (input/unchanged) no. lines supplied,
c                   nlines: (output) no. of lines returned after editing
c
            nhigh = n
            call w_edittx (nhigh, nlines, nwide,
     +                     words)
            numdec = 1
         elseif (numdec.eq.4) then
c
c Make integers
c
            if (itype.eq.1 .and. ffiles) then
               do i = 1, n
                  write (word6,'(i6)') i
                  call x_triml1 (word6)
                  words(i) = word6
               enddo
               numdec = 1
            else
               write (line,300)
               call x_putfat (line)
               numdec = 5
            endif
         elseif (numdec.eq.5) then
c
c Help
c
            write (text,400)
            icolor = 9
            numbld(1) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                     text,
     +                     border)
            numdec = 1
         elseif (numdec.eq.6) then
c
c Overwrite
c
            icolor = 4
            yes = .false.
            write (line,500) type1
            call x_yesno2 (icolor, ix, iy,
     +                     line,
     +                     yes)
            if (yes) then
               do i = 1, n
                  temp = labels(i)
                  labels(i) = words(i)
                  words(i) = temp
               enddo
               repeet = .false.
            else
               numdec = 1
            endif
         else
c
c Cancel
c
            icolor = 1
            yes = .false.
            write (line,600) type1
            call x_yesno2 (icolor, ix, iy,
     +                     line,
     +                     yes)
            if (yes) then
               repeet = .false.
            else
               numdec = 1
            endif
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'View current and replacement',1x,a
     +/'Input replacements from file',1x,a
     +/'Edit replacement',1x,a
     +/'Use integer replacement',1x,a
     +/'Help'
     +/'Apply'
     +/'Quit ... Exit label editing procedure')
  200 format ('Use this file to create replacement',1x,a)
  300 format ('Not available in this mode')
  400 format (
     + 'Installing vectors of text labels/templates for plotting'
     +/
     +/'Sometimes labels are required for plotting, e.g. in bar charts,'
     +/'pie charts, dendrogram, and principal component graphs. If the'
     +/'data files have row labels appended after the data (as with'
     +/'cluster.tf1) these will be used for plotting. If they do not,'
     +/'then the configuration defaults will be used, or else a set of'
     +/'consecutive integers will be substituted. The options are:'
     +/'1) View current and potential replacement text strings.'
     +/'2) Read in a set of replacement texts from a file.'
     +/'3) Paste in a set of pre-copied texts from the clipboard.'
     +/'4) Edit the replacement labels in the Simfit text editor.'
     +/'5) Generate a set of consecutive integer labels.'
     +/'At any stage you can view the current text and replacement'
     +/'strings, then decide to accept or discard the replacements.'
     +/'Labels files just have a sequence of labels, one per line, in'
     +/'ASCII text format, and the best way to make such files is to'
     +/'copy the labels from your spreadsheet to the clipboard, open'
     +/'an editor (Notepad), paste in the labels, then Save As ...'
     +/'Associated with every label is a template, where each template'
     +/'character indicates how the label character is to be plotted,'
     +/'e.g. 0=normal, 1=subscript, 2=superscript, 3=maths, etc.')
  500 format ('Apply editing and overwrite all current',1x,a)
  600 format ('Abandon editing and retain all original',1x,a)
      end
c
c
