C
C
      SUBROUTINE X_GETNOU (NOUT)
C
C ACTION: Find an unopened unit in range 12 to 100 or set NOUT = 0
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         28/01/2007 derived from GETNOU  
C
C Version for the X-compiler
C
      IMPLICIT   NONE 
C
C Argument
C      
      INTEGER, INTENT (OUT) :: NOUT
C
C Locals
C      
      INTEGER    N0, N12, N100
      PARAMETER (N0 = 0, N12 = 12, N100 = 100)
      INTEGER    I, IOS
      LOGICAL    OP
      EXTERNAL   X_PUTFAT
      DO I = N12, N100
         NOUT = I
         OP = .TRUE.
         INQUIRE (UNIT = NOUT, OPENED = OP, IOSTAT = IOS)
         IF (IOS.EQ.N0 .AND. .NOT.OP) RETURN
      ENDDO
      NOUT = N0
      CALL X_PUTFAT (
     +'X_GETNOU cannot find an unconnected unit: NOUT = 0')
      END
C
C
