C
C This version of GKSAX$ is EDITAX$ with the following disabled:
C KANGLE, WORDS, VECTOR, NUMBER, ROTATE
C
      SUBROUTINE X_GKSAXS (KTIC, MTIC, NWORDS,
     +                     ZCOORD, ZMAX, ZMIN, ZZBOT, ZZTOP,
     +                     LOGO,
     +                     PCENTX, PHIGHX, PLOTX, SHOW_XAXIS, TOINT)
C
C ACTION : Set up a GKS axis, KTIC = point in or out
C          NFONT = font no., MTIC = no. tick marks, SP = spacing,
C          XP = expansion factor, TOINT reals to integers
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 8/11/92
C          Derived from GKSAXS by adding ROTATE etc.
C          12/09/1996 added ZCOORD, ZZBOT, ZZTOP to slide axis along
C          18/09/1996 added PLOTX
C          23/09/1996 added VECTOR
C          14/07/1997 win32 version
C          18/02/2000 added PCENTX
C          23/02/2000 added PHIGHX
C          23/10/2000 added SELSTR
C          19/12/2000 added display/suppress all labels facility
C          20/07/2001 added SHOW_XAXIS and LVIEW2
C          18/10/2006 added call to CHKTIC$ 
C          13/04/2007 added INTENTS
C          21/07/2009 added GRFSIG$
C          26/08/2009 new version of GRFSIG$ and diabled PHIGHX but retained for future use
C          27/05/2011 improved calls to SELSTR 
C          14/09/2011 developed from GKSAXS$ for inclusion into W_CLEARWIN.DLL
C          08/02/2012 increased STRNG from 21 to 30 characters and defined INFO(6) properly
C
      IMPLICIT   NONE
C
C Arguments
C            
      INTEGER,             INTENT (IN)    :: NWORDS
      INTEGER,             INTENT (INOUT) :: KTIC, MTIC
      DOUBLE PRECISION,    INTENT (INOUT) :: ZCOORD, ZMAX, ZMIN, ZZBOT,
     +                                       ZZTOP
      CHARACTER (LEN = *), INTENT (IN)    :: LOGO 
      LOGICAL,             INTENT (INOUT) :: PCENTX, PHIGHX,
     +                                       PLOTX(NWORDS), SHOW_XAXIS,
     +                                       TOINT
C
C Locals
C      
      INTEGER    MWORDS, NMAX
      PARAMETER (MWORDS = 1, NMAX = 300)
      INTEGER    I, IADD1, ISEND, KANGLE, MTRANS, NDEC, NFIGX, NSIGX
      INTEGER    IBOT, IMID, ITOP, ITOP1, ITOP2
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 4, IXL = 4, IYL = 4)
      INTEGER    NUMOPT, NUMPOS(10)
      DOUBLE PRECISION XBIG, YBIG, ZBIG
      CHARACTER  WORDS(MWORDS)*1, VECTOR(MWORDS)*1
      CHARACTER  WORD5*5, WORD11(3)*11
      CHARACTER  INFO(13)*30, LINE*80, STRNG(NMAX)*30, TEXT(30)*100
      LOGICAL    AGAIN
      LOGICAL    NUMBER, ROTATE
      LOGICAL    STORE, TITLES
      PARAMETER (STORE = .FALSE., TITLES = .TRUE.)
      EXTERNAL   X_GETDG2, X_GETJM1, X_GETDM1, X_PUTADV, X_NEWSTR,
     +           X_CHKTIC, X_GRFSIG, SAVETR$
      EXTERNAL   X_LBOX02, X_SELSTR, X_TRIML1, X_LVIEW2
      INTRINSIC  MIN
      DATA       NUMPOS / 10*1 /
      CALL SAVETR$ (MTRANS,
     +              STORE)      
      ISEND = 3
      CALL X_GRFSIG (ISEND, MTRANS, NFIGX, NSIGX,
     +               LOGO)       
      KANGLE = 1
      NUMBER = .TRUE.
      ROTATE = .FALSE.
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (NUMBER .AND. TOINT) THEN
            CALL X_CHKTIC (MTIC,
     +                     ZMAX, ZMIN,
     +                     LOGO)
         ENDIF
C
C Integers or floating point numbers
C
         IF (TOINT) THEN
            INFO(1) = 'Integers'
         ELSE
            INFO(1) = 'Floating point'
         ENDIF
C
C Add a % character
C
         IF (PCENTX) THEN
            INFO(2) = 'add a % character'
         ELSE
            INFO(2) = 'no % character'
         ENDIF
C
C Significant figures
C
         IF (NSIGX.EQ.1) THEN
            PHIGHX = .FALSE.
            INFO(3) = 'Low precision' 
         ELSEIF (NSIGX.EQ.2) THEN
            PHIGHX = .TRUE.
            INFO(3) = 'Automatic precision'
         ELSE
            PHIGHX = .TRUE.
            INFO(3) = 'High precision'
         ENDIF
C
C Numbers or text strings
C
         IF (NUMBER) THEN
            INFO(4) = 'Numbers'
         ELSE
            INFO(4) = 'Text strings'
            INFO(1) = INFO(4)
            INFO(2) = INFO(4)
            INFO(3) = INFO(4)
         ENDIF
C
C Rotate labels
C
         IF (ROTATE) THEN
            IF (KANGLE.EQ.2) THEN
               INFO(5) = '- 45 degrees'
            ELSEIF (KANGLE.EQ.3) THEN
               INFO(5) = '- 60 degrees'
            ELSEIF (KANGLE.EQ.4) THEN
               INFO(5) = '- 75 degrees'
            ELSEIF (KANGLE.EQ.5) THEN
               INFO(5) = '- 90 degrees'
            ELSEIF (KANGLE.EQ.6) THEN
               INFO(5) = '+ 90 degrees'
            ELSEIF (KANGLE.EQ.7) THEN
               INFO(5) = '+ 75 degrees'
            ELSEIF (KANGLE.EQ.8) THEN
               INFO(5) = '+ 60 degrees'
            ELSEIF (KANGLE.EQ.9) THEN
               INFO(5) = '+ 45 degrees'
            ELSE
               INFO(5) = '**Error**'
            ENDIF
         ELSE
            INFO(5) = 'Horizontal'
         ENDIF
         
         ITOP = MIN(MTIC + 1, NMAX)
         IADD1 = 0
         DO I = 1, ITOP
            IF (PLOTX(I)) IADD1 = IADD1 + 1
         ENDDO
         WRITE (INFO(6),'(A,I3)') 'Number suppressed =', ITOP - IADD1
         
         INFO(7) = ' '
         WRITE (WORD5,'(I5)') MTIC + 1
         CALL X_TRIML1 (WORD5)
         INFO(8) = WORD5
C
C Tick marks
C
         IF (MTIC.LT.1) THEN
            INFO(9) = 'None'
         ELSEIF (KTIC.EQ. 1) THEN
            INFO(9) = 'Out'
         ELSEIF (KTIC.EQ.2) THEN
            INFO(9) = 'None'
         ELSE
            INFO(9) = 'In'
         ENDIF
C
C Range
C
         WRITE (WORD11(1),'(1P,E11.4)') ZMIN
         WRITE (WORD11(2),'(1P,E11.4)') ZMAX
C
C Translation
C
         WRITE (WORD11(3),'(1P,E11.4)') ZCOORD
         INFO(10) = WORD11(1)//','//WORD11(2)
         INFO(11) = WORD11(3)
C
C Suppress axis
C
         IF (SHOW_XAXIS) THEN
            INFO(12) = 'Display'
         ELSE
            INFO(12) = 'Suppress'
         ENDIF
         INFO(13) = ' '
         INFO(4) = 'Not available'
         INFO(5) = 'Not available'
         INFO(7) = 'Not available'
         WRITE (TEXT,100) LOGO, (INFO(I), I = 1, 13)
         NUMOPT = 13
         NDEC = NUMOPT
         CALL X_LVIEW2 (IXL, IYL, NDEC, NUMOPT, 
     +                  TEXT,
     +                  TITLES)
         IF (NDEC.EQ.4 .OR. NDEC.EQ.5 .OR. NDEC.EQ.7) THEN
             NDEC = 0
             CALL X_PUTADV ('Not available ... Get an upgrade')
         ENDIF
         IF (NDEC.EQ.1) THEN
            TOINT = .NOT.TOINT
         ELSEIF (NDEC.EQ.2) THEN
            PCENTX = .NOT.PCENTX
         ELSEIF (NDEC.EQ.3) THEN
            ISEND = 2
            CALL X_GRFSIG (ISEND, MTRANS, NFIGX, NSIGX,
     +                     LOGO)             
            IF (NSIGX.EQ.1) THEN
               PHIGHX = .FALSE.
            ELSE
               PHIGHX = .TRUE.
            ENDIF      
         ELSEIF (NDEC.EQ.4) THEN
C
C Not available in this version
C         
            NUMBER = .NOT.NUMBER
         ELSEIF (NDEC.EQ.5) THEN
C
C Not available in this version
C         
            WRITE (TEXT,200)
            NUMOPT = 9
            CALL X_LBOX02 (ICOLOR, IXL, IYL, KANGLE, NUMOPT, NUMPOS,
     +                     TEXT)
            IF (KANGLE.EQ.1) THEN
               ROTATE = .FALSE.
            ELSE
               ROTATE = .TRUE.
            ENDIF
         ELSEIF (NDEC.EQ.6) THEN
            IF (MTIC.LT.0) THEN
               CALL X_PUTADV ('There are no current labels to display')
            ELSE
               WRITE (TEXT,300)
               IBOT = 14
               ITOP = MIN(MTIC + 1, NMAX)
               ITOP1 = ITOP + 1
               ITOP2 = ITOP + 2
               
               IMID = 1
               DO WHILE (IMID.GT.0)
                  IADD1 = 0
                  DO I = 1, ITOP
                     IF (PLOTX(I)) THEN
                        IADD1 = IADD1 + 1
                        STRNG(I) = 'Display'
                     ELSE
                        STRNG(I) = 'Suppress'
                     ENDIF
                  ENDDO
                  IF (IADD1.EQ.ITOP) THEN
                     STRNG(ITOP1) = 'All labels suppressed [No]'
                     STRNG(ITOP2) = 'All labels displayed [Yes]'
                  ELSEIF (IADD1.EQ.0) THEN  
                     STRNG(ITOP1) = 'All labels suppressed [Yes]'
                     STRNG(ITOP2) = 'All labels displayed [No]' 
                  ELSE   
                     STRNG(ITOP1) = 'All labels suppressed [No]'
                     STRNG(ITOP2) = 'All labels displayed [No]' 
                  ENDIF   
                  CALL X_SELSTR (IMID, IBOT, ITOP2,
     +                           TEXT, STRNG)
                  IF (IMID.EQ.ITOP2) THEN
                     DO I = 1, ITOP
                        PLOTX(I) = .TRUE.
                     ENDDO
                  ELSEIF (IMID.EQ.ITOP1) THEN
                     DO I = 1, ITOP
                        PLOTX(I) = .FALSE.
                     ENDDO
                  ELSEIF (IMID.GT.0) THEN
                     PLOTX(IMID) = .NOT.PLOTX(IMID)
                  ENDIF
               ENDDO   
            ENDIF
         ELSEIF (NDEC.EQ.7) THEN
            IF (MTIC.LT.0) THEN
               CALL X_PUTADV ('There are no current labels to edit')
            ELSE
               WRITE (TEXT,400)
               IBOT = 14
               ITOP = MIN(MTIC + 1, NMAX)
               IMID = 1
               DO WHILE (IMID.GT.0)
                  CALL X_SELSTR (IMID, IBOT, ITOP,
     +                           TEXT, WORDS)
                  IF (IMID.GT.0) THEN
                     I = 0
                     CALL X_NEWSTR (I,
     +                              WORDS(IMID), VECTOR(IMID))
                  ENDIF
               ENDDO   
            ENDIF
         ELSEIF (NDEC.EQ.8) THEN
            IBOT = 0
            IMID = MTIC + 1
            ITOP = NWORDS
            CALL X_GETJM1 (IBOT, IMID, ITOP,
     +'Number of tick-marks/labels required')
            MTIC = IMID - 1
         ELSEIF (NDEC.EQ.9) THEN
            WRITE (TEXT,500)
            NUMOPT = 3
            IMID = NUMOPT
            CALL X_LBOX02 (ICOLOR, IXL, IYL, IMID, NUMOPT, NUMPOS,
     +                     TEXT)
            KTIC = IMID
         ELSEIF (NDEC.EQ.10) THEN
            WRITE (LINE,600) ZMIN, ZMAX
            XBIG = ZMIN
            YBIG = ZMAX
            CALL X_GETDG2 (XBIG, YBIG, LINE)
            ZMIN = XBIG
            ZMAX = YBIG
         ELSEIF (NDEC.EQ.11) THEN
            XBIG = ZZBOT
            ZBIG = ZZTOP
            WRITE (LINE,700) LOGO, ZCOORD
            YBIG = ZCOORD
            CALL X_GETDM1 (XBIG, YBIG, ZBIG, LINE)
            ZCOORD = YBIG
            CALL X_PUTADV (
     +'Translations are suppressed by boxes round data or plot offsets')
         ELSEIF (NDEC.EQ.12) THEN
            SHOW_XAXIS = .NOT.SHOW_XAXIS
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO 
C
C Format statements
C      
  100 FORMAT (
     + 'Display features of the ',A1,'-axis`Current settings'
     +/'Labels: integers or decimals  `',A
     +/'Labels: add % characters      `',A
     +/'Labels: significant figures   `',A
     +/'Labels: plot text or numbers  `',A
     +/'Labels: horizontal or rotated `',A
     +/'Labels: display or suppress   `',A
     +/'Labels: edit text strings     `',A
     +/'Tick marks: change number     `',A
     +/'Tick marks: change direction  `',A
     +/'Axis: change range plotted    `',A
     +/'Axis: move to new position    `',A
     +/'Axis: display or suppress     `',A
     +/'Apply                         `',A)
  200 FORMAT (
     + 'Horizontal'
     +/'45 degrees clockwise'
     +/'60 degrees clockwise'
     +/'75 degrees clockwise'
     +/'90 degrees clockwise'
     +/'90 degrees anticlockwise'
     +/'75 degrees anticlockwise'
     +/'60 degrees anticlockwise'
     +/'45 degrees anticlockwise')
  300 FORMAT (
     + 'Suppressing tick marks and plot labels'
     +/
     +/'Often tick marks and/or labels clash and it is useful to'
     +/'be able to suppress selected tick marks and associated'
     +/'labels. An example would be when the X or Y axis has been'
     +/'moved, and the X and Y labels overlap causing confusion.'
     +/
     +/'If you select a tick/label from this menu, it will toggle'
     +/'the display-suppress status, irrespective of whether a'
     +/'text label or number is being displayed. Normally this'
     +/'technique is only needed for occasional labels, but you'
     +/'may want to suppress all the labels then add your own'
     +/'labelling system. This is often useful with bar charts,'
     +/'when tick marks may not be required.')
  400 FORMAT (
     + 'Editing plot labels'
     +/
     +/'You can decide to display text labels instead of numbers'
     +/'at the tick mark positions. This is useful if you want to'
     +/'over-ride the default numerical labelling, or if labels'
     +/'are more appropriate. If you set a blank label, the tick'
     +/'mark will still be displayed. So, if you want neither a'
     +/'tick mark nor a label you should choose to suppress the'
     +/'particular label.'
     +/
     +/'Note that labels can be horizontal or rotated but, if you'
     +/'want arbitrary style, suppress or set blank labels then'
     +/'use the add-text facility to add labels manually at any'
     +/'size, colour, font or angle of inclination.')
  500 FORMAT (
     + 'Ticks pointing out'
     +/'Suppress ticks/labels'
     +/'Ticks pointing in')
  600 FORMAT (
     +'Start-value, Stop-value for axes (current =',
     +1P,E11.3,',',E11.3,')')
  700 FORMAT (
     +'Coordinate required for',1X,A,1X,'axis (current =',1P,E11.3,')')
      END
C
C
