c
c
      subroutine x_gkscol (isend, jcol, kcol, numj, numk)
c
c action: set colours for simple graphics
c author: w.g.bardsley, university of manchester, u.k., 21/07/2009
c         02/11/2011 now saves colors to w_colors.cfg
c
c isend = 1: set storage directly
c isend = 2: set storage from a menu
c jcol(1) = Plot title
c jcol(2) = Plot legends
c jcol(3) = Plot labels
c jcol(4) = Plot axes
c jcol(5) = Plot background
c jcol(6) = ***Unassigned
c jcol(7) = ***Unassigned
c jcol(8) = ***Unassigned
c
c kcol(i) = data(i) for i = 1, 12
c 
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend, numj, numk
      integer, intent (inout) :: jcol(numj), kcol(numk)
c
c locals
c
      integer    njmax, nkmax, ntotal
      parameter (njmax = 8, nkmax = 12, ntotal = njmax + nkmax)
      integer    isav(ntotal)
      integer    i, ios, itemp, j, k, nj, nk, nout
      integer    nback, nbot, ntop
      parameter (nback = 15, nbot = 0, ntop = 71)
      character  text(ntotal)*100, iwarnu*100
      character (len = 1024) full_path, x_sim256
      logical    loop, ok, there
      external   x_geti0n, x_putfat
      external   x_sim256, x_getnou
      intrinsic  min
      save       isav
      data       isav / 4*nbot, 1*nback, 15*nbot /
c
c check input arguments
c      
      nj = min(numj, njmax)
      nk = min(numk, nkmax)
      if (nj.lt.0 .or. nk.lt.0 .or. nj + nk.lt.1) return
c
c create or read from the configuration file 
c        
      full_path = x_sim256('w_colors.cfg')
      inquire (file = full_path, exist = there)
      call x_getnou (nout)
      open (unit = nout, file = full_path, iostat = ios)
      if (.not.there) then 
         if (ios.eq.0) write (nout,100,iostat=ios)      
         do i = 1, ntotal
            if (ios.eq.0) write (nout,*,iostat=ios) isav(i)
         enddo
      else
         if (ios.eq.0) read (nout,'(a)',iostat=ios) iwarnu
         do i = 1, ntotal
            if (ios.eq.0) read (nout,*,iostat=ios) itemp
            if (ios.eq.0) isav(i) = itemp  
         enddo
      endif             
      close (unit = nout)
      if (ios.ne.0) return
        
      if (isend.eq.1) then
c
c isend = 1: set storage values directly
c        
         do i = 1, nj
            j = jcol(i)
            if (j.ge.nbot .and. j.le.ntop) isav(i) = j 
         enddo 
         j = njmax
         do i = 1, nk
            j = j + 1
            k = kcol(i)
            if (k.ge.nbot .and. k.le.ntop) isav(j) = k 
         enddo   
      elseif (isend.eq.2) then
c
c isend = 2: set storage values 
c      
         do i = 1, ntotal
            if (isav(i).lt.nbot .or. isav(i).gt.ntop) then
              if (i.eq.5) then
                 isav(i) = nback
              else   
                 isav(i) = nbot
              endif   
            endif  
         enddo 
         write (text,200)
         loop = .true.
         do while (loop)
            call x_geti0n (ntotal, isav,
     +                     text)
            do i = 1, ntotal
               if (isav(i).lt.nbot .or. isav(i).gt.ntop) then
                  ok = .false.
                  if (i.eq.5) then
                     isav(i) = nback
                  else   
                    isav(i) = nbot
                  endif
               else
                  ok = .true.   
               endif  
               if (.not.ok) then
                  write (iwarnu,300) i
                  call x_putfat (iwarnu)
                  exit
               endif     
            enddo  
            if (ok) loop = .false.
         enddo 
         do i = 1, nj
            jcol(i) = isav(i)
         enddo
         j = njmax  
         do i = 1, nk
            j = j + 1
            kcol(i) = isav(j)
         enddo  
      elseif (isend.eq.3) then
c
c isend = 3: retrieve storage values
c        
         do i = 1, nj
            jcol(i) = isav(i)
         enddo
         j = njmax
         do i = 1, nk
            j = j + 1
            kcol(i) = isav(j)
         enddo    
      endif
c
c isedn < 3: refresh w_colors.cfg
c      
      if (isend.lt.3) then
         call x_getnou (nout)
         open (unit = nout, file = full_path, iostat = ios)
         if (ios.eq.0) write (nout,100,iostat=ios)      
         do i = 1, ntotal
            if (ios.eq.0) write (nout,'(i4)',iostat=ios) isav(i)
         enddo
         if (ios.eq.0) write (nout,200,iostat=ios) 
         close (unit = nout)  
       endif         
c
c format statement
c      
  100 format ('Configuration for simple graphics colours % 1')
  200 format (
     + 'Plot title'
     +/'Plot legends'
     +/'Plot labels'
     +/'Plot axes'
     +/'Plot background'
     +/'***Unassigned'
     +/'***Unassigned'
     +/'***Unassigned'
     +/'Data set 1'
     +/'Data set 2'
     +/'Data set 3'
     +/'Data set 4'
     +/'Data set 5'
     +/'Data set 6'
     +/'Data set 7'
     +/'Data set 8'
     +/'Data set 9'
     +/'Data set 10'
     +/'Data set 11'
     +/'Data set 12')
  300 format ('Must have  0 =< colour =< 71, corrected item no.',i3)  
      end       