c
c
      subroutine x_gkslgl (isend, nlgl,
     +                     varlgl)     
c
c action: set logical defaults for simple graphics
c author: w.g.bardsley, university of manchester, u.k., 21/07/2009
c         02/11/2011 now reads and writes to w_graphs.cfg         
c
c  isend: as follows ... isend = 1: install defaults
c                        isend = 2: set defaults from menu
c                        isend = 3: retrieve current defaults
c   nlgl: must be >= 7
c varlgl: logicals to control simple graphics
c Order of logical variables as follows:
c
c (1) Box round data plotted                 ... default = .true.
c (2) Frame round outside of figure          ... default = .false.
c (3) Offset X, Y axes                       ... default = .true.
c (4) Grid at X-tic marks parallel to Y axis ... default = .false.
c (5) Grid at Y-tic marks parallel to X axis ... default = .false.
c (6) Cross hairs at 0,0 if in range         ... default = .false. 
c (7) Tick marks pointing in                 ... default = .true.
c    
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend, nlgl
      logical, intent (inout) :: varlgl(nlgl)
c
c locals
c      
  
      integer    i, icount
      integer    nmax, numtxt
      parameter (nmax = 20, numtxt = 20) 
      character  text(numtxt)*100, title*100
      parameter (title = 'Logical defaults for simple graphics')
      logical    lglvar(nmax)
      logical    abort, la(nmax), ls(nmax)
      logical    store1, store2
      parameter (store1 = .false., store2 = .true.)
      external   w_chkbox, x_graphs
      save       lglvar
      data       lglvar / .true.,  .false., .true.,
     +                    .false., .false., .false.,
     +                    .true.,  .false., .false.,
     +                    .false., .false., .false.,
     +                    .false., .false., .false.,
     +                    .false., .false., .false.,
     +                    .false., .false. /
c
c check for array dimensions
c     
      if (nlgl.gt.nmax .or. nlgl.lt.1) return
c
c read current defaults from x_graphs.cfg
c        
      call x_graphs (icount, nlgl,
     +               abort, la, ls, store1)
      if (.not.abort .and. icount.gt.0) then
         do i = 1, icount
            lglvar(i) = ls(i)
         enddo
      endif   
                        
      if (isend.eq.1) then
c
c isend = 1: set storage values directly
c        
         do i = 1, nlgl
            lglvar(i) = varlgl(i)
         enddo
      elseif (isend.eq.2) then
c
c isend = 2: set storage values from check box
c      
         write (text,100)
         call w_chkbox (nlgl,
     +                  text, title,        
     +                  lglvar)
         do i = 1, nlgl
            varlgl(i) = lglvar(i)
         enddo             
      else
c
c isend = 3: retrieve storage values
c        
         do i = 1, nlgl
            varlgl(i) = lglvar(i)
         enddo   
      endif
c
c isend < 3: store edited values
c      
      if (isend.lt.3) then
         do i = 1, nlgl
            ls(i) = lglvar(i)
         enddo  
         call x_graphs (icount, nlgl,
     +                  abort, la, ls, store2) 
      endif  
c
c format statement
c      
  100 format (
     + 'Box round data plotted'
     +/'Frame round outside of figure'
     +/'Offset X, Y axes'    
     +/'Grid at X-tic marks (parallel to Y axis)'    
     +/'Grid at Y-tic marks (parallel to X axis)'
     +/'Cross hairs intersecting at (0,0) if in range'
     +/'Tick marks pointing in'
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved'     
     +/'Reserved')     
      end       