c
c
      subroutine x_gkssig (isend, nxfig, nxsig, nyfig, nysig)
c
c action: set graphics significance levels for simple graphics
c author: w.g.bardsley, university of manchester, u.k., 21/07/2009
c         27/08/2009 added nxfig and nyfig to arguments
c         26/06/2016 added call to x_patch2
c
c         This version only allows low(1), automatic (2) or high (3) precision
c
c         isend is intent (in) but other parameters are as follows: 
c         isend = 1: all other parameters are intent (in)
c         isend = 2: nxfig and nyfig are intent (out)
c                    nxsig and nysig are intent (inout) 
c         isend = 3: all other parameters are intent (out)
c
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend
      integer, intent (inout) :: nxfig, nxsig, nyfig, nysig
c
c locals
c
      integer    i, k         
      integer    nxfig_sav, nyfig_sav
      integer    nxsig_sav, nysig_sav
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta, numtxt
      parameter (icolor = 7, ix = 0, iy = 0, lshade = 0, numdec = 1,
     +           numopt = 7, numsta = 3, numtxt = numopt + numsta - 1)
      integer    numbld(30), numpos(numopt)
      character (len = 100) text(30)*100
      logical    repeet
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   w_rbox01, x_patch2
      save       nxfig_sav, nxsig_sav, nyfig_sav, nysig_sav
      data       nxfig_sav, nyfig_sav / 2, 2 /
      data       nxsig_sav, nysig_sav / 2, 2 /
      if (isend.eq.1) then
c
c isend = 1: set all storage values directly
c        
         if (nxfig.ge.1 .and. nxfig.le.8) nxfig_sav = nxfig
         if (nyfig.ge.1 .and. nyfig.le.8) nyfig_sav = nyfig
         if (nxsig.ge.1 .and. nxsig.le.3) nxsig_sav = nxsig
         if (nysig.ge.1 .and. nysig.le.3) nysig_sav = nysig
      elseif (isend.eq.2) then
c
c isend = 2: set nxsig and nysig from radio box, nxfig, nyfig from store
c      
         repeet = .true.
         do while (repeet)
            write (text,100)
            if (nxsig_sav.eq.1) then
               numpos(1) = 1
               numpos(2) = 0
               numpos(3) = 0
            elseif (nxsig_sav.eq.2) then
               numpos(1) = 0
               numpos(2) = 1   
               numpos(3) = 0   
            else
               numpos(1) = 0
               numpos(2) = 0
               numpos(3) = 1
            endif 
         
            if (nysig_sav.eq.1) then
               numpos(4) = 1
               numpos(5) = 0
               numpos(6) = 0
            elseif (nysig_sav.eq.2) then
               numpos(4) = 0
               numpos(5) = 1   
               numpos(6) = 0   
            else
               numpos(4) = 0
               numpos(5) = 0
               numpos(6) = 1
            endif   
            numpos(7) = 0   
            
            numbld(1) = 1
            numbld(2) = 0
            numbld(3) = 100
            numbld(4) = 100
            numbld(5) = 100
            numbld(6) = 200
            numbld(7) = 200
            numbld(8) = 200
            numbld(9) = 0
            call w_rbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text,
     +                     border, flash, high)
     
            if (numpos(1).eq.1) then
               nxsig_sav = 1
            elseif (numpos(2).eq.1) then
               nxsig_sav = 2   
            else
               nxsig_sav = 3
            endif 
            nxsig = nxsig_sav
         
            if (numpos(4).eq.1) then
               nysig_sav = 1
            elseif (numpos(5).eq.1) then
               nysig_sav = 2   
            else
               nysig_sav = 3
            endif
            nysig = nysig_sav
            nxfig = nxfig_sav
            nyfig = nyfig_sav   
            
            if (numpos(7).eq.1) then
c
c help
c              
               write (text,200)
               k = 22
               do i = 1, k
                  numbld(i) = 0
               enddo
               numbld(1) = 1
               numbld(8) = 1
               numbld(12) = 1
               numbld(19) = 1
               call x_patch2 (numbld, k,
     +                        text)               
            else
               repeet = .false.
            endif     
         enddo     
      else
c
c isend = 3: retrieve all storage values
c        
         nxfig = nxfig_sav
         nyfig = nyfig_sav
         nxsig = nxsig_sav
         nysig = nysig_sav
      endif
c
c format statements
c      
  100 format (
     + 'Select label plotting precision'
     +/'...'
     +/'X: low'
     +/'X: automatic'
     +/'X: high'    
     +/'Y: low'
     +/'Y: automatic'    
     +/'Y: high'
     +/'Help ... More information')  
  200 format (
     + 'The number of significant figures used for labelling axes'
     +/
     +/'Plotting integers is unambigous but with floating point numbers'
     +/'there may be be loss of precision if there are too many tick'
     +/'marks. So the trade off between tick marks, significant'
     +/'figures and decimal places can be altered as follows.'
     +/
     +/'Low precision'
     +/'With this option there will be just one place after a decimal'
     +/'point, so 1.25 will be plotted as 1.3 with loss of precision.'
     +/
     +/'Automatic precision (The default)'
     +/'With this option there will be sufficient integers before and'
     +/'after a decimal point so that the label will be accurate to'
     +/'at least 0.1% and 1.23456 will be displayed as 1.235. However' 
     +/'note that the labels plotted along an axis may not then all'
     +/'have the same number of significant figures or decimal places.'
     +/
     +/'High precision'
     +/'With this option there can be up to four places after a'
     +/'decimal point which could limit the number of labels'
     +/'that can be plotted in order to avoid overlapping.')
      end       
c
c
      