C
C
      SUBROUTINE X_GKSTYP (L, M, NTYPE,
     +                     SIZE1, WIDE, WIDE1, WIDE2, 
     +                     FNAME, TITLE,
     +                     BARCAP, LOWER, UPPER, VECTOR_FIELD)
C
C ACTION : Set up type of line, error bar, marker etc.
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,16/11/92
C          10/12/1997 win32 version corrected for Male/Female symbols
C          09/03/1998 Added VECTOR-FIELD
C          12/09/1999 added RBOX01
C          27/09/2000 added linetype = 9 (filled polygon)
C          16/12/2000 revised abd added QUITL and QUITM
C          08/11/2001 added TRIM60, CHOP60, FNAME1, FNAME2, TITLE1, TITLE2
C          07/01/2002 extensive revision
C          01/05/2003 extensive revision (introduced STARS, LTYPE, STYPE)
C          19/09/2006 minor revision
C          10/12/2007 corrected line type 5 from <<< to >>>
C          16/08/2008 added outline plotting symbols
C          18/06/2011 derived from GKSTYP$
C
      IMPLICIT   NONE 
C
C Arguments
C                                            
      INTEGER,             INTENT (IN)    :: NTYPE 
      INTEGER,             INTENT (INOUT) :: L, M
      DOUBLE PRECISION,    INTENT (INOUT) :: SIZE1, WIDE, WIDE1, WIDE2 
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME, TITLE
      LOGICAL,             INTENT (INOUT) :: BARCAP, LOWER, UPPER,
     +                                       VECTOR_FIELD
C
C Locals
C      
      INTEGER    NDEC
      INTEGER    I, IMID
      INTEGER    ICOLOR, IXL, IYL, LSHADE
      PARAMETER (ICOLOR = 1, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NUMOPT, NUMPOS(30), NSTART, NTEXT
      INTEGER    NSTARS
      PARAMETER (NSTARS = 29)
      INTEGER    M2N(0:37), N2M(29)
      DOUBLE PRECISION SIZBOT, SIZTOP
      PARAMETER (SIZBOT = 0.0D+00, SIZTOP = 100.0D+00)
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  FNAME1*1024, FNAME2*60, TITLE1*80, TITLE2*60
      CHARACTER  X_CHOP60*60, X_TRIM60*60
      CHARACTER  LTYPE*20, STARS(NSTARS)*2, STYPE*30
      CHARACTER  BLANK2*2, STAR2*2
      PARAMETER (BLANK2 = '  ', STAR2 = ' *')
      LOGICAL    BARW, LINES(2), SYMBOL(3), YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   X_GETDM1
      EXTERNAL   W_LBOX01, X_YESNO2, W_RBOX01, X_CHOP60, X_TRIM60,
     +           X_LBOX02
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 30*1 /
      DATA       N2M / 1,   !1  Dot
     +                 2,   !2  Plus
     +                17,   !3  Minus
     +                 3,   !4  Cross
     +                 4,   !5  Asterisk
     +                 5,   !6  Circle
     +                 6,   !7  Circle-half
     +                 7,   !8  Circle-full
     +                30,   !9  Circle-outline
     +                 8,   !10 Triangle
     +                 9,   !11 Triangle-half
     +                10,   !12 Triangle-full
     +                31,   !13 Triangle-outline
     +                11,   !14 Square
     +                12,   !15 Square-half
     +                13,   !16 Square-full
     +                32,   !17 Square-outline
     +                14,   !18 Diamond
     +                15,   !19 Diamond-half
     +                16,   !20 Diamond-full
     +                33,   !21 Diamond-outline
     +                34,   !22 Inverted-triangle
     +                35,   !23 Inverted-triangle-half
     +                36,   !24 Inverted-triangle-full
     +                37,   !25 Inverted-triangle-outline
     +                18,   !26 Male
     +                19,   !27 Female
     +                20,   !28 Bar
     +                 0 /  !29 Suppress
     
      DATA       M2N / 29,   !0  Suppress 
     +                  1,   !1  Dot
     +                  2,   !2  Plus
     +                  4,   !3  Cross
     +                  5,   !4  Asterisk
     +                  6,   !5  Circle
     +                  7,   !6  Circle-half
     +                  8,   !7  Circle-full
     +                 10,   !8  Triangle
     +                 11,   !9  Triangle-half
     +                 12,   !10 Triangle-full
     +                 14,   !11 Square
     +                 15,   !12 Square-half
     +                 16,   !13 Square-full
     +                 18,   !14 Diamond
     +                 19,   !15 Diamond-half
     +                 20,   !16 Square-full
     +                  3,   !17 Minus
     +                 26,   !18 Male
     +                 27,   !19 Female
     +                 28,   !20 Bar
     +                 28,   !21 Bar
     +                 28,   !22 Bar
     +                 28,   !23 Bar
     +                 28,   !24 Bar
     +                 28,   !25 Bar
     +                 28,   !26 Bar
     +                 28,   !27 Bar
     +                 28,   !28 Bar
     +                 28,   !29 Bar
     +                  9,   !30 Circle-outline
     +                 13,   !31 Triangle-outline
     +                 17,   !32 Square-outline
     +                 21,   !33 Diamond-outline
     +                 22,   !34 Inverted-triangle
     +                 23,   !35 Inverted-triangle-half
     +                 24,   !36 Inverted-triangle-full
     +                 25 /  !37 Inverted-triangle-outline

     
     
      IF (VECTOR_FIELD .AND. NTYPE.EQ.2) THEN
C              
C Note: this code may not be called from GRAF06$ .. it may be redundant
C Start of special action for VECTOR_FIELD............................
C
         WRITE (LINE,100) SIZE1
         YES = .FALSE.
         CALL X_YESNO2 (ICOLOR, IXL, IYL,
     +                  LINE,
     +                  YES)
         IF (YES) THEN
            WRITE (LINE,200) SIZE1
            CALL X_GETDM1 (SIZBOT, SIZE1, SIZTOP,
     +                     LINE)
         ENDIF
         RETURN
C
C End of special action for VECTOR_FIELD............................
C
      ENDIF
C
C Copy filename and title then chop and trim
C
      FNAME1 = FNAME
      FNAME2 = X_TRIM60(FNAME1)
      TITLE1 = TITLE
      TITLE2 = X_CHOP60(TITLE1)
C
C Record line and symbol type in LTYPE and STYPE
C
      IF (L.EQ.1) THEN
         LTYPE = 'Solid)'
      ELSEIF (L.EQ.2) THEN
         LTYPE = 'Dashed)'
      ELSEIF (L.EQ.3) THEN
         LTYPE = 'Dotted)'
      ELSEIF (L.EQ.4) THEN
         LTYPE = 'Dashed-Dotted)'
      ELSEIF (L.EQ.5) THEN
         LTYPE = 'Vector >>>)'
      ELSEIF (L.EQ.6) THEN
         LTYPE = 'Vector <<<)'
      ELSEIF (L.EQ.7) THEN
         LTYPE = 'Step-cdf)'
      ELSEIF (L.EQ.8) THEN
         LTYPE = 'Step-survival)'
      ELSEIF (L.EQ.9) THEN
         LTYPE = 'Filled polygon)'
      ELSE
         LTYPE = 'None)'
      ENDIF
      IF (M.EQ.1) THEN
         STYPE = 'Dot)'
      ELSEIF (M.EQ.2) THEN
         STYPE = 'Plus)'
      ELSEIF (M.EQ.3) THEN
         STYPE = 'Cross)'
      ELSEIF (M.EQ.4) THEN
         STYPE = 'Asterisk)'
      ELSEIF (M.EQ.5) THEN
         STYPE = 'Circle)'
      ELSEIF (M.EQ.6) THEN
         STYPE = 'Circle-half)'
      ELSEIF (M.EQ.7) THEN
         STYPE = 'Circle-full)'
      ELSEIF (M.EQ.8) THEN
         STYPE = 'Triangle)'
      ELSEIF (M.EQ.9) THEN
         STYPE = 'Triangle-half)'
      ELSEIF (M.EQ.10) THEN
         STYPE = 'Triangle-full)'
      ELSEIF (M.EQ.11) THEN
         STYPE = 'Square)'
      ELSEIF (M.EQ.12) THEN
         STYPE = 'Square-half)'
      ELSEIF (M.EQ.13) THEN
         STYPE = 'Square-full)'
      ELSEIF (M.EQ.14) THEN
         STYPE = 'Diamond)'
      ELSEIF (M.EQ.15) THEN
         STYPE = 'Diamond-half)'
      ELSEIF (M.EQ.16) THEN
         STYPE = 'Diamond-full)'
      ELSEIF (M.EQ.17) THEN
         STYPE = 'Minus)'
      ELSEIF (M.EQ.18) THEN
         STYPE = 'Male)'
      ELSEIF (M.EQ.19) THEN
         STYPE = 'Female)'
      ELSEIF (M.EQ.20) THEN
         STYPE = 'Bar-outline)'
      ELSEIF (M.EQ.21) THEN
         STYPE = 'Bar-filled)'
      ELSEIF (M.EQ.22) THEN
         STYPE = 'Bar-diagonal-up)'
      ELSEIF (M.EQ.23) THEN
         STYPE = 'Bar-diagonal-down)'
      ELSEIF (M.EQ.24) THEN
         STYPE = 'Bar-criss-cross)'
      ELSEIF (M.EQ.25) THEN
         STYPE = 'Bar-horizontal)'
      ELSEIF (M.EQ.26) THEN
         STYPE = 'Bar-vertical)'
      ELSEIF (M.EQ.27) THEN
         STYPE = 'Bar-dashed)'
      ELSEIF (M.EQ.28) THEN
         STYPE = 'Bar-dotted)'
      ELSEIF (M.EQ.29) THEN
         STYPE = 'Bar-dash-dotted)'
      ELSEIF (M.EQ.30) THEN
         STYPE = 'Circle-outline)'
      ELSEIF (M.EQ.31) THEN
         STYPE = 'Triangle-outline)'
      ELSEIF (M.EQ.32) THEN
         STYPE = 'Square-outline)'
      ELSEIF (M.EQ.33) THEN
         STYPE = 'Diamond-outline)' 
      ELSEIF (M.EQ.34) THEN
         STYPE = 'Inverted-triangle)'
      ELSEIF (M.EQ.35) THEN
         STYPE = 'Inverted-triangle-half)'
      ELSEIF (M.EQ.36) THEN
         STYPE = 'Inverted-triangle-full)'
      ELSEIF (M.EQ.37) THEN
         STYPE = 'Inverted-triangle-outline)'     
      ELSE
         STYPE = 'None)'
      ENDIF
C
C Choose editing required from a check box
C
      WRITE (TEXT,300) FNAME2, TITLE2, WIDE1, STYPE, SIZE1, WIDE2,
     +                 LTYPE, WIDE
      NSTART = 8
      NUMOPT = 9
      NTEXT = NSTART + NUMOPT - 1
      DO I = 1, NTEXT
         NUMBLD(I) = 0
      ENDDO
      DO I = 1, NUMOPT
         NUMPOS(I) = 0
      ENDDO
      NUMBLD(2) = 1
      NUMBLD(4) = 1
      IF (BARCAP) NUMPOS(1) = 1
      IF (LOWER) NUMPOS(2) = 1
      IF (UPPER) NUMPOS(3) = 1
      IMID = 1
      BORDER = .FALSE.
      CALL W_RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IMID,
     +               NUMOPT, NUMPOS, NSTART, NTEXT,
     +               TEXT,
     +               BORDER, FLASH, HIGH)
      IF (NUMPOS(1).EQ.0) THEN
         BARCAP = .FALSE.
      ELSE
         BARCAP = .TRUE.
      ENDIF
      IF (NUMPOS(2).EQ.0) THEN
         LOWER = .FALSE.
      ELSE
         LOWER = .TRUE.
      ENDIF
      IF (NUMPOS(3).EQ.0) THEN
         UPPER = .FALSE.
      ELSE
         UPPER = .TRUE.
      ENDIF
      IF (NUMPOS(4).EQ.0) THEN
         BARW = .FALSE.
      ELSE
         BARW = .TRUE.
      ENDIF
      IF (NUMPOS(5).EQ.0) THEN
         SYMBOL(1) = .FALSE.
      ELSE
         SYMBOL(1) = .TRUE.
      ENDIF
      IF (NUMPOS(6).EQ.0) THEN
         SYMBOL(2) = .FALSE.
      ELSE
         SYMBOL(2) = .TRUE.
      ENDIF
      IF (NUMPOS(7).EQ.0) THEN
         SYMBOL(3) = .FALSE.
      ELSE
         SYMBOL(3) = .TRUE.
      ENDIF
      IF (NUMPOS(8).EQ.0) THEN
         LINES(1) = .FALSE.
      ELSE
         LINES(1) = .TRUE.
      ENDIF
      IF (NUMPOS(9).EQ.0) THEN
         LINES(2) = .FALSE.
      ELSE
         LINES(2) = .TRUE.
      ENDIF
      
      IF (BARW) THEN
C
C Bar linewidth
C
         WRITE (LINE,500) WIDE1
         CALL X_GETDM1 (SIZBOT, WIDE1, SIZTOP,
     +                  LINE)
      ENDIF
      
      IF (SYMBOL(1)) THEN
C
C Use STARS to indicate the current marker type then choose new type
C
         NUMOPT = 30
         DO I = 1, NUMOPT - 1
            STARS(I) = BLANK2
         ENDDO
         IF (M.LT.0 .OR. M.GT.37) THEN
C
C The case where M is out of range
C           
            NDEC = 29
         ELSE
C
C Otherwise express NDEC as a function of M
C           
            NDEC = M2N(M)
         ENDIF
         STARS(NDEC) = STAR2
         WRITE (TEXT,400) (STARS(I), I = 1, NUMOPT - 1)
         BORDER = .FALSE.
         CALL X_LBOX02 (ICOLOR, IXL, IYL, NDEC, NUMOPT, NUMPOS,
     +                  TEXT)
         IF (NDEC.LT.28 .OR. NDEC.EQ.29) THEN
            M = N2M(NDEC)
         ELSEIF (NDEC.EQ.28) THEN
C
C Type of filling for bar type symbol
C
            NUMOPT = 12
            DO I = 1, NUMOPT - 1
               STARS(I) = BLANK2
            ENDDO
            IMID = M - 18
            IF (IMID.GE.1 .AND. IMID.LE.NUMOPT - 1) THEN
               STARS(IMID) = STAR2
            ELSE
               IMID = NUMOPT
            ENDIF
            WRITE (TEXT,600) FNAME2, TITLE2,
     +                      (STARS(I), I = 1, NUMOPT - 1)
            NSTART = 6
            NTEXT = 17
            BORDER = .FALSE.
            CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IMID,
     +                     NUMOPT, NUMPOS, NSTART, NTEXT,
     +                     TEXT,
     +                     BORDER, FLASH, HIGH)
            NDEC = IMID
            IF (NDEC.EQ.1) THEN
               M = 0
            ELSEIF (NDEC.GT.1 .AND. NDEC.LT.NUMOPT) THEN
               M = 18 + NDEC
            ENDIF
         ENDIF
      ENDIF
      
      IF (SYMBOL(2)) THEN
C
C Marker size
C
         WRITE (LINE,700) SIZE1
         CALL X_GETDM1 (SIZBOT, SIZE1, SIZTOP,
     +                  LINE)
      ENDIF
      
      IF (SYMBOL(3)) THEN
C
C Marker linewidth
C
         WRITE (LINE,800) WIDE2
         CALL X_GETDM1 (SIZBOT, WIDE2, SIZTOP, 
     +                  LINE)
      ENDIF
      
      IF (LINES(1)) THEN
C
C Choose line types
C
         NUMOPT = 11
         DO I = 1, NUMOPT - 1
            STARS(I) = BLANK2
         ENDDO
         IF (L.EQ.0) THEN
            IMID = 10
         ELSE
            IMID = L
         ENDIF
         IF (IMID.GE.1 .AND. IMID.LE.NUMOPT - 1) THEN
            STARS(IMID) = STAR2
         ELSE
            IMID = NUMOPT
         ENDIF
         WRITE (TEXT,900) FNAME2, TITLE2,
     +                   (STARS(I), I = 1, NUMOPT - 1)
         NSTART = 6
         NTEXT = NSTART + NUMOPT - 1
         BORDER = .FALSE.
         CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IMID,
     +                  NUMOPT, NUMPOS, NSTART, NTEXT, TEXT, BORDER,
     +                  FLASH, HIGH)
         NDEC = IMID
         IF (NDEC.LE.9) THEN
            L = NDEC
         ELSEIF (NDEC.EQ.10) THEN
            L = 0
         ENDIF
      ENDIF
      IF (LINES(2)) THEN
C
C Line thickness
C
         WRITE (LINE,1000) WIDE
         CALL X_GETDM1 (SIZBOT, WIDE, SIZTOP,
     +                  LINE)
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Change arrow size ? (Current size =',F5.2,')')
  200 FORMAT ('Arrow size required (current =',F5.2,')')
  300 FORMAT (
     + 'File:'
     +/A
     +/'Title:'
     +/A
     +/'...'
     +/'Tick to edit any display details for this data set'
     +/'...'
     +/'Error bars: display end caps'
     +/'Error bars: display lower bars'
     +/'Error bars: display upper bars'
     +/'Error bars: change linewidth (current =',F6.3,')'
     +/'Graph symbols: change type (current =',1X,A
     +/'Graph symbols: change size (current =',F6.3,')'
     +/'Graph symbols: change linewidth (current =',F6.3,')'
     +/'Lines: alter type (current =',1X,A
     +/'Lines: alter linewidth (current =',F6.3,')')
  400 FORMAT (
     + 'Dot',A
     +/'Plus sign',A
     +/'Minus sign',A
     +/'Cross',A
     +/'Asterisk',A
     +/'Circle: opaque',A
     +/'Circle: half-filled',A
     +/'Circle: filled',A
     +/'Circle: outline',A
     +/'Triangle: opaque',A
     +/'Triangle: half-filled',A
     +/'Triangle: filled',A
     +/'Triangle: outline',A
     +/'Square: opaque',A
     +/'Square: half-filled',A
     +/'Square: filled',A
     +/'Square: outline',A
     +/'Diamond: opaque',A
     +/'Diamond: half-filled',A
     +/'Diamond: filled',A
     +/'Diamond: outline',A
     +/'Inverted-triangle: opaque',A
     +/'Inverted-triangle: half-filled',A
     +/'Inverted-triangle: filled',A
     +/'Inverted-triangle: outline',A
     +/'Male symbol',A
     +/'Female symbol',A
     +/'Barchart type bar',A
     +/'Suppress marker',A
     +/'Cancel (* indicates current marker style)')
  500 FORMAT (
     +'Relative error bar line width required (current =',F5.2,')')
  600 FORMAT (
     + 'File:'
     +/A
     +/'Title:'
     +/A
     +/'...'
     +/'Suppressed',A
     +/'Outline type',A
     +/'Solid type',A
     +/'Diagonal up',A
     +/'Diagonal down',A
     +/'Criss-cross',A
     +/'Horizontal',A
     +/'Vertical',A
     +/'Dashed line',A
     +/'Dotted line',A
     +/'Dash/Dot',A
     +/'Cancel (* indicates current fill style)')
  700 FORMAT ('Symbol/Marker size required (current =',F5.2,')')
  800 FORMAT (
     +'Relative symbol/marker line width required (current =',F5.2,')')
  900 FORMAT (
     + 'File:'
     +/A
     +/'Title:'
     +/A
     +/'...'
     +/'Solid line',A
     +/'Dashed line',A
     +/'Dotted line',A
     +/'Dashed-dotted',A
     +/'Vector >>>',A
     +/'Vector <<<',A
     +/'Step (cdf)',A
     +/'Step (survival)',A
     +/'Filled polygon',A
     +/'Suppress line',A
     +/'Cancel (* indicates current line type)')
 1000 FORMAT ('Relative line width required (current =',F5.2,')')
       END
C
C
