c
c
      subroutine x_gksvf7 (ifill, ihue, nxtra,
     +                     factor,
     +                     fname)
c
c action: edit biplot and/or vector field arrows      
c author: w.g.bardsley, university of manchester, u.k., 19/09/2006 
c         29/12/2007 edited for script arrows  
c         19/09/2011 derived from gksvf7
c
c  ifill: (input/output) arrow type
c   ihue: (input/output) arrow colour
c  nxtra: (input/unchanged) dimension
c factor: (input/output) arrow head size
c  fname: (input/unchanged) name of a biplot or vector file type file
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: nxtra
      integer,             intent (inout) :: ifill(nxtra), ihue(nxtra)
      double precision,    intent (inout) :: factor(nxtra)
      character (len = *), intent (in)    :: fname
c
c local allocatable arrays
c
      integer,          allocatable :: ifill_1(:), ihue_1(:)          
      double precision, allocatable :: factor_1(:)
c                         
c locals
c       
      integer    i, ierr, ios, mode, ncol, nin, nrow, numdec, numopt,
     +           numtxt, numvec
      integer    numbld(30) 
      double precision a, b, c, d, e, f, g, h, z
      double precision blim, tlim
      parameter (blim = 0.0001d+00, tlim = 1.0d+00)       
      character  cipher*10, line*100, text(30)*100
      character  blank*1
      parameter (blank = ' ')
      logical    bi_plot, global, repeet, vector_field
      external   x_isitmf, x_listbx, w_palett, x_patch2, x_getnou   
      external   x_putfat, x_getjm1, x_getdm1, x_putadv 
      intrinsic  nint
      data       numbld / 30*0 /  
c
c first check the file provided
c      
      call x_isitmf (ncol, nrow,
     +               fname)
      if (nrow.lt.1) then
         write (line,100) 
         call x_putfat (line)
         return
      endif     
      if (ncol.eq.4) then     
         cipher = '(NA)'
         bi_plot = .false.
         vector_field = .true.
      elseif (ncol.eq.9) then
         cipher = blank
         bi_plot = .true.
         vector_field = .false.   
      else
         write (line,200)
         call x_putfat (line)
         return
      endif   
c
c allocate and store default parameters
c
      if (bi_plot) then
         ierr = 0
         if (allocated(ifill_1)) deallocate(ifill_1, stat = ierr)
         if (ierr.ne.0) return  
         if (allocated(ihue_1)) deallocate(ihue_1, stat = ierr)
         if (ierr.ne.0) return 
         if (allocated(factor_1)) deallocate(factor_1, stat = ierr)
         if (ierr.ne.0) return 
         allocate(ifill_1(nrow), stat = ierr)
         if (ierr.ne.0) return 
         allocate(ihue_1(nrow), stat = ierr)
         if (ierr.ne.0) return
         allocate(factor_1(nrow), stat = ierr)
         if (ierr.ne.0) return
         call x_getnou (nin)    
         close (unit = nin)
         open (unit = nin, file = fname, iostat = ios)
         if (ios.ne.0) then   
            close (unit = nin)
            deallocate(ifill_1, stat = ierr)
            deallocate(ihue_1, stat = ierr)
            deallocate(factor_1, stat = ierr)
            return
         endif
         read (nin,'(a)',iostat=ios) line
         if (ios.ne.0) then
            close (unit = nin)
            deallocate(ifill_1, stat = ierr)
            deallocate(ihue_1, stat = ierr)
            deallocate(factor_1, stat = ierr)
            return
         endif
         read (nin,*,iostat=ios) nrow, ncol
         if (ios.ne.0 .or. nrow.lt.1 .or. ncol.ne.9) then   
            close (unit = nin)
            deallocate(ifill_1, stat = ierr)
            deallocate(ihue_1, stat = ierr)
            deallocate(factor_1, stat = ierr)
            return
         endif
         do i = 1, nrow   
            read (nin,*,iostat = ios) a, b, c, d, e, f, g, h, z
            if (ios.eq.0) then
                ifill_1(i) = nint(g)
                factor_1(i) = h
                ihue_1(i) = nint(z)
            else
               close (unit = nin)
               deallocate(ifill_1, stat = ierr)
               deallocate(ihue_1, stat = ierr)
               deallocate(factor_1, stat = ierr)
               return
            endif        
         enddo
         close (unit = nin)
      endif
c
c the main loop
c      
      numvec = 1          
      repeet = .true.
      do while (repeet) 
         numopt = 11
         numdec = numopt - 1
         write (text,300) cipher, cipher, cipher  
         call x_listbx (numdec, numopt,
     +                  text)         
c
c make sure individual editing is allowed
c         
         if (vector_field) then
            if (numdec.eq.2 .or. numdec.eq.5 .or. numdec.eq.8) then
               numdec = 0
               write (line,400)
               call x_putfat (line)
            endif
         endif 
c
c define global
c          
         if (numdec.eq.1 .or. numdec.eq.4 .or. numdec.eq.7) then
            global = .true.
         else
            global = .false.
         endif   
         if (numdec.eq.3 .or. numdec.eq.6 .or. numdec.eq.9) then 
c
c numdec = 3, 6, or 9: restore defaults
c            
            if (bi_plot) then
               if (numdec.eq.3) then 
                  do i = 1, nrow
                     ifill(i) = ifill_1(i)
                  enddo
               elseif (numdec.eq.6) then 
                  do i = 1, nrow
                     ihue(i) = ihue_1(i)
                  enddo
               elseif (numdec.eq.9) then
                  do i = 1, nrow
                     factor(i) = factor_1(i)
                  enddo 
               endif       
            else  
               if (numdec.eq.3) then
                  ifill(1) = 1
               elseif (numdec.eq.6) then
                  ihue(1) = 0
               elseif (numdec.eq.9) then
                  factor(1) = 0.005d+00
               endif
            endif 
            write (line,500)
            call x_putadv (line)
         elseif (numdec.gt.0 .and. numdec.lt.numopt - 1) then
c
c numdec = 1, 2, 4, 5, 7, or 8: get numvec = no. of the vector required
c         
            if (global .or. vector_field) then
               numvec = 1
            else 
               write (line,600)
               if (numvec.le.0 .or. numvec.gt.nrow) numvec = 1
               i = 0
               call x_getjm1 (i, numvec, nrow,
     +                        line)               
            endif   
            if (numvec.gt.0 .and. numdec.le.2) then       
c
c numdec = 1 or 2: define ifill(numvec)
c            
               write (text,700) 
               numopt = 13
               if (ifill(numvec).eq.1) then
                  numdec = 1
               elseif (ifill(numvec).eq.16) then
                  numdec = 2  
               elseif (ifill(numvec).ge.17) then
                  numdec = ifill(numvec) - 8   
               else
                  numdec = ifill(numvec) - 1
               endif 
               if (numdec.lt.1 .or. numdec.gt.numopt) numdec = 1          
               call x_listbx (numdec, numopt,
     +                        text)
               if (numdec.eq.1) then
                  ifill(numvec) = 1
               elseif (numdec.eq.2) then
                  ifill(numvec) = 16        
               elseif (numdec.ge.9) then
                  ifill(numvec) = numdec + 8   
               else
                  ifill(numvec) = numdec - 1
               endif
               if (bi_plot .and. global) then
                  do i = 1, nrow 
                     ifill(i) = ifill(numvec)
                  enddo   
               endif
            elseif (numvec.gt.0 .and. numdec.le.5) then  
c
c numdec = 4 or 5: define ihue(numvec)
c            
               mode = 0
               call w_palett (ihue(numvec), mode)
               if (bi_plot .and. global) then
                  do i = 1, nrow
                     ihue(i) = ihue(numvec)
                  enddo   
               endif   
            elseif (numvec.gt.0 .and. numdec.le.8) then 
c
c numdec = 7 or 8: define factor(numvec)
c            
               if (factor(numvec).lt.blim .or. factor(numvec).gt.tlim)    
     +             factor(numvec) = blim               
               write (line,800) factor(numvec)
               call x_getdm1 (blim, factor(numvec), tlim,
     +                        line)  
               if (bi_plot .and. global) then
                  do i = 1, nrow
                     factor(i) = factor(numvec)
                  enddo
               endif              
            endif                           
         elseif (numdec.eq.numopt - 1) then 
c
c numdec = numopt - 1: help         
c
            write (text,900)
            numtxt = 21
            numbld(1) = 1
            numbld(10) = 1 
            call x_patch2 (numbld, numtxt,
     +                     text)
            numbld(1) = 0
            numbld(10) = 0            
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: apply
c         
            if (bi_plot) then
               deallocate(ifill_1, stat = ierr)
               deallocate(ihue_1, stat = ierr)
               deallocate(factor_1, stat = ierr)
            endif
            repeet = .false.
         endif   
      enddo                                
c
c format statements
c      
  100 format ('Insufficent data to define arrows')    
  200 format ('Not a biplot or vector field type file')
  300 format (
     + 'Arrow type: set globally' 
     +/'Arrow type: set individually',1x,a
     +/'Arrow type: restore defaults'
     +/'Arrow colour: set globally'
     +/'Arrow colour: set individually',1x,a 
     +/'Arrow colour: restore defaults'
     +/'Arrow size: set globally'
     +/'Arrow size: set individually',1x,a
     +/'Arrow size: restore defaults' 
     +/'Help'
     +/'Apply')                 
  400 format ('Only available for biplots')  
  500 format ('Defaults have been restored')
  600 format ('Number of the arrow required (0 for no action)')
  700 format (
     + 'Normal arrow'
     +/'Dashed arrow'
     +/'Outline arrow: hollow'
     +/'Outline arrow: filled'
     +/'Shaft only: solid'
     +/'Shaft only: dashed'
     +/'Shaft only: dotted'
     +/'Shaft only: dash-dotted'
     +/'Head only: plus'
     +/'Head only: multiply'
     +/'Head only: asterisk'
     +/'Script head: solid shaft'
     +/'Script head: dashed shaft') 
  800 format ('Arrow size required (current value =',f7.4,')')   
  900 format (
     + 'Vector field arrows (without arrow head labels)'
     +/  
     +/'With 4-column vector field type data sets (like vfield.tf1)'
     +/'the type of arrow, the colour, and the head size can only be'
     +/'set globally, and there are no labels. This is because it is'
     +/'likely that users may want to overlay other data sets on top'
     +/'of the vector field, such as orbits for systems of differential'
     +/'equations, etc.' 
     +/
     +/'Biplot arrows (with arrow head labels)'
     +/
     +/'With 9-column biplot type data sets (like vfield.tf2) it is'
     +/'usual to have one set of arrows for row vectors, and another'
     +/'set of arrows for column vectors, i.e. two sets of arrows which'
     +/'are distinguished by arrow type, colour, and/or size. This is'
     +/'the standard format from the Simfit biplot creation routines,'
     +/'and it is not anticipated that other data sets would be added'
     +/'as overlays very often. So, in this case, the arrow parameters'
     +/'can be set individually or globally. For example, if monochrome'
     +/'hardcopy is required you can use two different arrow types but' 
     +/'change over to black arrows.')
     
      end
c
c      