C
C GRAF02$: CALL MENU02$ from call backs i_press_2 and i_press_3
C MENU02$: Edit titles if NPRESS = 2 or legends if NPRESS = 3
C
      SUBROUTINE X_GRAF02 (NPRESS)
C
C ACTION: call MENU02$ from i_press_2, i_press_3
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 29/10/2000
C         19/10/2004 minor editing
C
C         NPRESS: (input/output)
C
      IMPLICIT   NONE
C
C Argument
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Locals
C
      INTEGER    ISEND
      INTEGER    NCT, NCX, NCY, NCZ
      PARAMETER (NCT = 80, NCX = 80, NCY = 80, NCZ = 80)
      DOUBLE PRECISION DRAGTI, DRAGXL, DRAGYL, DRAGZL
      CHARACTER  ARRAYQ*(NCT), ARRAYT(0:15)*(NCT), ARRAYX(0:15)*(NCX),
     +           ARRAYY(0:15)*(NCY), ARRAYZ(0:15)*(NCZ),
     +           PTITLE(0:15)*(NCT), QTITLE*(NCT), XTITLE(0:15)*(NCX),
     +           YTITLE(0:15)*(NCY), ZTITLE(0:15)*(NCZ)
      LOGICAL    PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS
      EXTERNAL   X_MENU02
      IF (NPRESS.EQ.2 .OR. NPRESS.EQ.3) THEN
C
C ISEND = 3: Retrieve
C
         ISEND = 3
         CALL X_MENU02 (ISEND, NPRESS,
     +                  DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                  ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                  PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                  PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
C
C ISEND = 2: Edit then store
C
         ISEND = 2
         CALL X_MENU02 (ISEND, NPRESS,
     +                  DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                  ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                  PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                  PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
      ELSE
         NPRESS = - NPRESS
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE X_MENU02 (ISEND, NPRESS,
     +                     DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                     ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                     PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                     PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)

      USE MODULE_CLEARWIN, ONLY : DRAGTI_1, DRAGXL_1, DRAGYL_1, 
     +                            DRAGZL_1,                                
     +                            ARRAYQ_1, ARRAYT_1,
     +                            ARRAYX_1, ARRAYY_1,
     +                            ARRAYZ_1, PTITLE_1,
     +                            QTITLE_1, XTITLE_1,
     +                            YTITLE_1, ZTITLE_1,  
     +                            PIE_1, PLOT_1, ROTATE_Z, SWAP_1,
     +                            TWO_1,
     +                            QUERY_EXIT                                          
C
C ACTION : Set up titles for GKSSTY ... MENU01 in v3.2
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 28/10/93
C          19/09/1996 Added STREDI$
C          14/07/1997 win32 version
C          26/11/1997 NPRESS = 2 (TITLE), NPRESS = 3 (LEGENDS)
C          21/02/2000 added DRAGTI, DRAGXL, DRAGYL, DRAGZL
C          18/10/2000 added ARRAYQ, QTITLE
C          29/10/2000 extensive re-editing
C          07/10/2002 added savegks.ins (PIE_1, TWO_1)
C          03/12/2003 new dimensions for local arrays and (*) for arguments
C          19/10/2004 added ITYPE, TSIZE, XSIZE, YSIZE, ZSIZE, STORE1 
C          18/10/2006 rearranged the menu systems
C          19/04/2007 added INTENTS and corrected NUMOPT = 12 to NUMOPT = 11
C          01/01/2008 uses MODULE_SAVEGKS instead of savegks.ins
C          18/01/2008 now all saved variables are in MODULE_SAVEGKS
C          23/10/2010 added ROTATE_Z and adjusted menus
C          29/11/2010 added TSIZE_2 
C          15/01/2014 introduced QUERY_EXIT and RE_DISPLAY
C          18/02/2014 removed RE_DISPLAY 
C
C          ISEND: (input/unchanged) as follows:
C                  ISEND = 1: just store
C                  ISEND = 2: edit then store
C                  ISEND = 3: retrieve
C         NPRESS: (input/unchanged) as follows:
C                  NPRESS = 2: titles
C                  NPRESS = 3: legends
C         Double precision and character arguments are (input/output)
C         but logical arguments are (input/output) 
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NPRESS
      DOUBLE PRECISION,    INTENT (INOUT) :: DRAGTI, DRAGXL, DRAGYL,
     +                                       DRAGZL
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAYQ, ARRAYT(0:15),
     +                                       ARRAYX(0:15), ARRAYY(0:15),
     +                                       ARRAYZ(0:15), PTITLE(0:15),
     +                                       QTITLE, XTITLE(0:15),
     +                                       YTITLE(0:15), ZTITLE(0:15) 
      LOGICAL,             INTENT (INOUT) :: PIE_CHART, PLOT_TITLE, 
     +                                       SWAP_YZ, TWO_PLOTS
C
C Locals
C
      INTEGER    ITYPE, MTRANS, NTHETA
      INTEGER    JSEND
      PARAMETER (JSEND = 3)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    I, NUMDEC, NUMBLD(30)
      DOUBLE PRECISION TSIZE_1, TSIZE_2, XSIZE, YSIZE, ZSIZE
      DOUBLE PRECISION DMAX, DMIN
      PARAMETER (DMAX = 1.0D+00, DMIN = - DMAX)
      CHARACTER  WORD*25
      CHARACTER  TEXT(30)*100  
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    AGAIN, STORE1
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   SAVETR$
      EXTERNAL   X_NEWSTR, X_PUTFAT, X_FSIZES
      EXTERNAL   X_GETDM1, W_PATCH1, X_LSTBOX
      DATA       NUMBLD / 30*0 /
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Store   
C ==========
C
         PLOT_1 = PLOT_TITLE
         PIE_1  = PIE_CHART
         SWAP_1 = SWAP_YZ
         TWO_1 = TWO_PLOTS
         DRAGTI_1 = DRAGTI
         DRAGXL_1 = DRAGXL
         DRAGYL_1 = DRAGYL
         DRAGZL_1 = DRAGZL
         ARRAYQ_1 = ARRAYQ
         QTITLE_1 = QTITLE
         DO I = 0, 15
            ARRAYT_1(I) = ARRAYT(I)
            ARRAYX_1(I) = ARRAYX(I)
            ARRAYY_1(I) = ARRAYY(I)
            ARRAYZ_1(I) = ARRAYZ(I)
            PTITLE_1(I) = PTITLE(I)
            XTITLE_1(I) = XTITLE(I)
            YTITLE_1(I) = YTITLE(I)
            ZTITLE_1(I) = ZTITLE(I)
          ENDDO
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Check NPRESS then edit and store
C ==========
C
         IF (NPRESS.LT.2 .OR. NPRESS.GT.3) RETURN
C
C Retrieve MTRANS
C
         CALL SAVETR$(MTRANS, STORE)
         IF (NPRESS.EQ.2) THEN
C
C NPRESS = 2: Choose required option for the plot title
C -----------
C
            ITYPE = 1
            STORE1 = .FALSE.
            CALL X_FSIZES (ITYPE,
     +                     TSIZE_1,
     +                     STORE1)
            ITYPE = 12
            CALL X_FSIZES (ITYPE,
     +                     TSIZE_2,
     +                     STORE1)
            AGAIN = .TRUE.
            DO WHILE (AGAIN)
               WRITE (TEXT,100) PTITLE(MTRANS), DRAGTI, TSIZE_1, TSIZE_2
C
C Adjust TEXT before displaying the main titles menu 
C                                                     
               NSTART = 9
               NUMOPT = 8
               NTEXT = NSTART + NUMOPT - 1  
               IF (QTITLE.NE.BLANK) TEXT(NSTART - 2) = QTITLE
               IF (PLOT_TITLE) THEN
                  TEXT(NSTART) = 'Suppress current titles'
               ELSE
                  TEXT(NSTART) = 'Display current titles'
               ENDIF      
               NUMDEC = NUMOPT - 1
               NUMBLD(1) = 4
               NUMBLD(4) = 1
               NUMBLD(7) = 1 
               CALL X_LSTBOX (NUMBLD, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                        TEXT)
               NUMBLD(1) = 0
               NUMBLD(4) = 0
               NUMBLD(7) = 0                
               AGAIN = .FALSE. 
               IF (NUMDEC.GE.1 .AND. NUMDEC.LE.6) QUERY_EXIT = .TRUE.
               IF (NUMDEC.EQ.1) THEN
                  PLOT_TITLE = .NOT.PLOT_TITLE
               ELSEIF (NUMDEC.EQ.2) THEN
                  CALL X_NEWSTR (JSEND,
     +                           PTITLE(MTRANS), ARRAYT(MTRANS))
               ELSEIF (NUMDEC.EQ.3) THEN
                  CALL X_NEWSTR (JSEND,
     +                           QTITLE, ARRAYQ)
               ELSEIF (NUMDEC.EQ.4) THEN
                  CALL X_GETDM1 (DMIN, DRAGTI, DMAX,
     +'Displacement to move title up(+)/down(-) (Fullscreen = 1)')
               ELSEIF (NUMDEC.EQ.5) THEN
                  ITYPE = 1
                  STORE1 = .TRUE.
                  CALL X_FSIZES (ITYPE,
     +                           TSIZE_1,
     +                           STORE1)
               ELSEIF (NUMDEC.EQ.6) THEN
                  ITYPE = 12
                  STORE1 = .TRUE.
                  CALL X_FSIZES (ITYPE, 
     +                           TSIZE_2,
     +                           STORE1)   
               ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
                  WRITE (TEXT,200)
                  NTEXT = 21
                  NUMBLD(1) = 1
                  CALL W_PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD,
     +                           NTEXT,
     +                           TEXT,
     +                           BORDER)
                  NUMBLD(1) = 0
                  AGAIN = .TRUE.
               ENDIF
            ENDDO
         ELSEIF (NPRESS.EQ.3) THEN
C
C NPRESS = 3: Choose required option for the legends
C ----------- 
C
            STORE1 = .FALSE.
            ITYPE = 2
            CALL X_FSIZES (ITYPE,
     +                     XSIZE, 
     +                     STORE1)
            ITYPE = 3
            CALL X_FSIZES (ITYPE,
     +                     YSIZE,
     +                     STORE1)
            ITYPE = 4
            CALL X_FSIZES (ITYPE,
     +                     ZSIZE,
     +                     STORE1)
            IF (PIE_CHART) THEN
               CALL X_PUTFAT ('Option not available for pie charts')
               AGAIN = .FALSE.
            ELSE
               AGAIN = .TRUE.
            ENDIF
            DO WHILE (AGAIN)
               IF (TWO_PLOTS) THEN    
C
C Just omit the option to swap Y-axis LHS/RHS
C                       
                  IF (ROTATE_Z) THEN
                     NTHETA = -90
                  ELSE
                     NTHETA = 90
                  ENDIF      
                  NSTART = 12
                  NUMOPT = 12   
                  WRITE (TEXT,300) XTITLE(MTRANS), YTITLE(MTRANS),
     +                             ZTITLE(MTRANS), 
     +                             DRAGXL, DRAGYL, DRAGZL, 
     +                             XSIZE, YSIZE, ZSIZE, NTHETA
               ELSE 
C
C Omit all options for the E-legends
C                        
                  NSTART = 9
                  NUMOPT = 9
                  IF (SWAP_YZ) THEN
                     WORD = 'right hand side'
                  ELSE
                     WORD = 'left hand side'
                  ENDIF 
                  WRITE (TEXT,400) XTITLE(MTRANS), YTITLE(MTRANS),
     +                             DRAGXL, DRAGYL, WORD,
     +                             XSIZE, YSIZE
               ENDIF
C
C Choose required option for legends
C
               NTEXT = NSTART + NUMOPT - 1
               NUMDEC = NUMOPT - 1
               NUMBLD(1) = 4
               NUMBLD(4) = 1
               NUMBLD(7) = 1 
               NUMBLD(10) = 1
               IF (TWO_PLOTS) NUMBLD(8) = 1  
               CALL X_LSTBOX (NUMBLD, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                        TEXT)
               NUMBLD(1) = 0
               NUMBLD(4) = 0
               NUMBLD(7) = 0
               NUMBLD(10) = 0
C
C Adjust the value of NUMDEC
C     
               IF (TWO_PLOTS) THEN
                  IF (NUMDEC.GT.6) NUMDEC = NUMDEC + 1
               ELSE 
                  IF (NUMDEC.GE.3 .AND. NUMDEC.LE.4) THEN
                     NUMDEC = NUMDEC + 1
                  ELSEIF (NUMDEC.GE.5 .AND. NUMDEC.LE.7) THEN
                     NUMDEC = NUMDEC + 2
                  ELSEIF (NUMDEC.GE.8 .AND. NUMDEC.LE.9) THEN
                     NUMDEC = NUMDEC + 4
                  ENDIF         
               ENDIF   
               AGAIN = .FALSE. 
               IF (NUMDEC.GE.1 .AND. NUMDEC.LE.11) QUERY_EXIT = .TRUE.
               IF (NUMDEC.EQ.1) THEN
                  CALL X_NEWSTR (JSEND,
     +                           XTITLE(MTRANS), ARRAYX(MTRANS))
               ELSEIF (NUMDEC.EQ.2) THEN
                  CALL X_NEWSTR (JSEND,
     +                           YTITLE(MTRANS), ARRAYY(MTRANS))
               ELSEIF (NUMDEC.EQ.3) THEN
                  CALL X_NEWSTR (JSEND,
     +                           ZTITLE(MTRANS), ARRAYZ(MTRANS))
               ELSEIF (NUMDEC.EQ.4) THEN
                  CALL X_GETDM1 (DMIN, DRAGXL, DMAX,
     +'Displacement to move X-legend up(-)/down(+) (Fullscreen = 1)')
               ELSEIF (NUMDEC.EQ.5) THEN
                  CALL X_GETDM1 (DMIN, DRAGYL, DMAX,
     +'Displacement to move Y-legend right(+)/left(-) (Fullscreen = 1)')
               ELSEIF (NUMDEC.EQ.6) THEN
                  CALL X_GETDM1 (DMIN, DRAGZL, DMAX,
     +'Displacement to move E-legend right(+)/left(-) (Fullscreen = 1)')
               ELSEIF (NUMDEC.EQ.7) THEN
                  SWAP_YZ = .NOT.SWAP_YZ
               ELSEIF (NUMDEC.EQ.8) THEN
                  STORE1 = .TRUE.
                  ITYPE = 2
                  CALL X_FSIZES (ITYPE,
     +                           XSIZE,
     +                           STORE1)
               ELSEIF (NUMDEC.EQ.9) THEN
                  STORE1 = .TRUE.
                  ITYPE = 3
                  CALL X_FSIZES (ITYPE,
     +                           YSIZE,
     +                           STORE1)
               ELSEIF (NUMDEC.EQ.10) THEN
                  STORE1 = .TRUE.
                  ITYPE = 4
                  CALL X_FSIZES (ITYPE,
     +                           ZSIZE,
     +                           STORE1)
               ELSEIF (NUMDEC.EQ.11) THEN
                  ROTATE_Z = .NOT.ROTATE_Z   
               ELSEIF (NUMDEC.EQ.12) THEN
                  WRITE (TEXT,200)
                  NTEXT = 21
                  NUMBLD(1) = 1
                  CALL W_PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD,
     +                           NTEXT, 
     +                           TEXT,
     +                           BORDER)
                  NUMBLD(1) = 0
                  AGAIN = .TRUE.
               ENDIF
            ENDDO
         ENDIF
C
C Store
C
         PLOT_1 = PLOT_TITLE
         PIE_1  = PIE_CHART
         SWAP_1 = SWAP_YZ
         TWO_1 = TWO_PLOTS
         DRAGTI_1 = DRAGTI
         DRAGXL_1 = DRAGXL
         DRAGYL_1 = DRAGYL
         DRAGZL_1 = DRAGZL
         ARRAYQ_1 = ARRAYQ
         QTITLE_1 = QTITLE
         DO I = 0, 15
            ARRAYT_1(I) = ARRAYT(I)
            ARRAYX_1(I) = ARRAYX(I)
            ARRAYY_1(I) = ARRAYY(I)
            ARRAYZ_1(I) = ARRAYZ(I)
            PTITLE_1(I) = PTITLE(I)
            XTITLE_1(I) = XTITLE(I)
            YTITLE_1(I) = YTITLE(I)
            ZTITLE_1(I) = ZTITLE(I)
          ENDDO
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Retrieve
C ==========
C
         PLOT_TITLE = PLOT_1
         PIE_CHART = PIE_1
         SWAP_YZ = SWAP_1
         TWO_PLOTS = TWO_1
         DRAGTI = DRAGTI_1
         DRAGXL = DRAGXL_1
         DRAGYL = DRAGYL_1
         DRAGZL = DRAGZL_1
         ARRAYQ = ARRAYQ_1
         QTITLE = QTITLE_1
         DO I = 0, 15
            ARRAYT(I) = ARRAYT_1(I)
            ARRAYX(I) = ARRAYX_1(I)
            ARRAYY(I) = ARRAYY_1(I)
            ARRAYZ(I) = ARRAYZ_1(I)
            PTITLE(I) = PTITLE_1(I)
            XTITLE(I) = XTITLE_1(I)
            YTITLE(I) = YTITLE_1(I)
            ZTITLE(I) = ZTITLE_1(I)
          ENDDO
      ENDIF 
C
C Format statements
C      
  100 FORMAT ( 
     + 'Editing the plot titles'
     +/
     +/'Current Title_1 (main title) is:'
     +/A
     +/
     +/'Current Title_2 (extra title) is:'
     +/'No subsidiary title ...'
     +/
     +/
     +/'Edit Title_1 (main title)'
     +/'Edit Title_2 (extra title)'
     +/'Move title(s): current up/down displacement =',F7.3
     +/'Re-size title_1: current size =',F7.3
     +/'Re-size title_2: current size =',F7.3
     +/'Help'
     +/'Quit ... Exit title editing procedure')
  200 FORMAT (
     + 'Editing titles and legends'
     +/
     +/'The plot can have no title, one title (Title_1), or two titles'
     +/'(Title_1 and Title_2). If you edit Title_2 so that it is not a'
     +/'blank string, then space will be created for this extra title.'
     +/'If you suppress the titles, then the graph will expand to use'
     +/'the maximum space. Titles can be centered over the data range,'
     +/'or centered in the plotting frame using the [Style] options. To'
     +/'edit text you select simple editing, but advanced editing is'
     +/'provided for maths, accents, degrees Centigrade, Greek, etc.'
     +/
     +/'There will always be a default X and Y legend but, in the case'
     +/'of a double plot, there will be an extra legend for the right'
     +/'hand axis. It you want multiple legends, just set the defaults'
     +/'to blank strings and use the extra text options to design your'
     +/'own legends.'
     +/
     +/'Font sizes can be set globally (permanently) using the [PS] or'
     +/'[Win] options, but temporary adjustments can be made from this'
     +/'control, which may require you to move the title and/or legends'
     +/'by adjustments to the default positions.')
  300 FORMAT (
     + 'Editing the X,Y,Z double plot legends'
     +/
     +/'Current X-legend (Horizontal) is:'
     +/A
     +/
     +/'Current Y-legend (LHS Vertical) is:'
     +/A
     +/ 
     +/'Current Z-legend (RHS Vertical) is:'
     +/A
     +/
     +/'Edit X-legend (Horizontal)'                             !1
     +/'Edit Y-legend (LHS Vertical)'                           !2
     +/'Edit Z-legend (RHS Vertical)'                           !3
     +/'Move X-legend: current up/down displacement =',F7.3     !4
     +/'Move Y-legend: current right/left displacement =',F7.3  !5
     +/'Move Z-legend: current right/left displacement =',F7.3  !6
     +/'Re-size X-legend: current size =',F7.3                  !8
     +/'Re-size Y-legend: current size =',F7.3                  !9
     +/'Re-size Z-legend: current size =',F7.3                  !10
     +/'Rotate Z-legend: current angle =',I4                    !11 
     +/'Help'                                                   !12
     +/'Quit ... Exit legend editing procedure')                                                !13
  400 FORMAT (  
     + 'Editing the X,Y plot legends'
     +/
     +/'Current X-legend is:'
     +/A
     +/
     +/'Current Y-legend is:'
     +/A
     +/
     +/'Edit X-legend'                                          !1
     +/'Edit Y-legend'                                          !2
     +/'Move X-legend: current up/down displacement =',F7.3     !4
     +/'Move Y-legend: current right/left displacement =',F7.3  !5
     +/'Swap Y-legend: current position =',1x,A                 !7
     +/'Re-size X-legend: current size =',F7.3                  !8
     +/'Re-size Y-legend: current size =',F7.3                  !9
     +/'Help'                                                   !11
     +/'Quit ... Exit legend editing procedure')                                                !12
      END
C
C
