C
C GRAF04$: call MENU04$ from i_press_4
C MENU04$: Notation for axes
C
C Subroutines for SIMPLOT
C
      SUBROUTINE X_GRAF04 (NPRESS)
C
C ACTION: call MENU04$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 30/10/2000
C         01/06/2001 increased NWORDS from 100 to 300
C         20/07/2001 added SHOW_XAXIS
C         15/08/2001 added MXDROP and YDROP and increased NWORDS to 1000
C         14/10/2004 added NPTS to argument list
C         14/07/2005 increased NWORDS from 1000 to 2000 and added PLOT_LABELS

C
C          NPRESS: (input/output) as follows:
C                  NPRESS .eq. 4 on entry: action then return unchanged
C                  NPRESS .ne. 4 on entry: no action the return as - NPRESS
C

      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Locals
C
      INTEGER    NWORDS
      PARAMETER (NWORDS = 2000)
      INTEGER    ISEND, KANGLE, KTIC, MXDROP, MXTIC, MYTIC, MZTIC,
     +           NGROUP, NPTS
      DOUBLE PRECISION XCOORD, XMAX, XMIN, YCOORD, YDROP, YMAX, YMIN,
     +                 ZCOORD, ZMAX, ZMIN
      CHARACTER   LABELS(NWORDS)*40, LABVEC(NWORDS)*40,
     +            WORDX(NWORDS)*40, WORDY(NWORDS)*40
      LOGICAL     BAR_CHART, NUMBRX, PCENTX, PCENTY,
     +            PCENTZ, PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +            PLOTX(NWORDS), PLOTY(NWORDS), PLOTZ(NWORDS),
     +            ROTATE, SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +            TWO_PLOTS, XTOINT, YTOINT, ZTOINT
      EXTERNAL X_MENU04
      IF (NPRESS.EQ.4) THEN
C
C ISEND = 3: Retrieve current arguments
C
         ISEND = 3
         CALL X_MENU04 (ISEND,
     +                  KANGLE, KTIC, MXDROP, MXTIC, MYTIC, MZTIC, 
     +                  NGROUP, NPTS, NWORDS,
     +                  XCOORD, XMAX, XMIN,
     +                  YCOORD, YDROP, YMAX, YMIN,
     +                  ZCOORD, ZMAX, ZMIN,
     +                  LABELS, LABVEC, WORDX, WORDY,
     +                  BAR_CHART, NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                  PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                  PLOTX, PLOTY, PLOTZ, ROTATE,
     +                  SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                  TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
C
C ISEND = 2: Edit then store current arguments
C
         ISEND = 2
         CALL X_MENU04 (ISEND,
     +                  KANGLE, KTIC, MXDROP, MXTIC, MYTIC, MZTIC,
     +                  NGROUP, NPTS, NWORDS,
     +                  XCOORD, XMAX, XMIN,
     +                  YCOORD, YDROP, YMAX, YMIN,
     +                  ZCOORD, ZMAX, ZMIN,
     +                  LABELS, LABVEC, WORDX, WORDY,
     +                  BAR_CHART, NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                  PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                  PLOTX, PLOTY, PLOTZ, ROTATE,
     +                  SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                  TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
      ELSE
C
C Error exit
C
         NPRESS = - NPRESS
      ENDIF
      END
C
C----------------------------------------------------------------------
C
       SUBROUTINE X_MENU04 (ISEND,
     +                      KANGLE, KTIC, MXDROP, MXTIC, MYTIC, MZTIC,
     +                      NGROUP, NPTS, NWORDS,
     +                      XCOORD, XMAX, XMIN,
     +                      YCOORD, YDROP, YMAX, YMIN,
     +                      ZCOORD, ZMAX, ZMIN,
     +                      LABELS, LABVEC, WORDX, WORDY,
     +                      BAR_CHART, NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                      PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                      PLOTX, PLOTY, PLOTZ, ROTATE,
     +                      SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                      TWO_PLOTS, XTOINT, YTOINT, ZTOINT)

      USE MODULE_CLEARWIN, ONLY : BAR_1, DFOLT_1, KTIC_1, LABELS_1,
     +                            LABVEC_1, NPTS_1, NWORD1,
     +                            PLOTX_1, PLOTY_1, PLOTZ_1,
     +                            TWO_1, WORDX_1, WORDY_1,
     +                            KANGLE_1, MXDROP_1, MXTIC_1, MYTIC_1,
     +                            MZTIC_1, NGROUP_1,
     +                            XCOORD_1, XMAX_1, XMIN_1, YCOORD_1,
     +                            YDROP_1, YMAX_1, YMIN_1, ZCOORD_1,
     +                            ZMAX_1, ZMIN_1,
     +                            NUMBRX_1, PCENTX_1, PCENTY_1,
     +                            PCENTZ_1,
     +                            PHIGHX_1, PHIGHY_1, PHIGHZ_1, PLOTL_1,
     +                            ROTATE_1, SHOW_X, SHOW_Y, SHOW_Z, 
     +                            XTOINT_1, YTOINT_1, ZTOINT_1,
     +                            QUERY_EXIT
C
C ACTION : Edit X, Y-axis notation etc. for GKSSTY ... MEN02 in v3.2
C AUTHOR : W. G. Bardsley, University of Manchester, 28/10/93
C          14/07/1997 win32 version
C          18/02/2000 added PCENTX, PCENTY, PCENTZ
C          23/02/2000 added PHIGHX, PHIGHY, PHIGHZ
C          30/10/2000 extensive re-editing
C          01/06/2001 increased NMAX from 100 to 300
C          20/07/2001 added DEND_G, SHOW_XAXIS
C          15/08/2001 added MXDROP and YDROP
C          07/10/2002 added savegks.ins (KTIC_1, LABELS_1, LABVEC_1, WORDX_1,
C                     WORDY_1, BAR_1, TWO_1, PLOTX_1, PLOTY_1, PLOTZ_1)
C          13/10/2004 added ITYPE, FSIZES$, XSIZE, and NPTS 
C          14/07/2005 added PLOT_LABELS to arguments
C          15/09/2006 revised and added BI_P and option to re-size label fonts 
C          18/10/2006 changed menu options to Exit after primary action 
C          25/12/2007 added ADJLAB$
C          01/01/2007 uses MODULE_SAVEGKS instead of savegks.ins
C          18/01/2008 transferred all saved variables to MODULE_SAVEGKS 
C          15/02/2011 added X_NUMBERS, Y_NUMBERS, Z_NUMBERS
C          27/05/2011 added call to SELSTR   
C          16/01/2014 added QUERY_EXIT and RE_DISPLAY 
C          18/02/2014 removed RE_DISPLAY     
C
C          ISEND = 1: store
C          ISEND = 2: edit then store
C          ISEND = 3: retrieve
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,              INTENT (IN)    :: ISEND, NWORDS
      INTEGER,              INTENT (INOUT) :: KANGLE, KTIC, MXDROP,
     +                                        MXTIC, MYTIC, MZTIC, 
     +                                        NGROUP, NPTS
      DOUBLE PRECISION,     INTENT (INOUT) :: XCOORD, XMAX, XMIN,
     +                                        YCOORD, YDROP, YMAX, YMIN,
     +                                        ZCOORD, ZMAX, ZMIN
      CHARACTER  (LEN = *), INTENT (INOUT) :: LABELS(NWORDS),
     +                                        LABVEC(NWORDS),
     +                                        WORDX(NWORDS), 
     +                                        WORDY(NWORDS)
      LOGICAL,              INTENT (INOUT) :: BAR_CHART, NUMBRX, PCENTX,
     +                                        PCENTY, PCENTZ, PHIGHX,
     +                                        PHIGHY, PHIGHZ,
     +                                        PLOT_LABELS,
     +                                        PLOTX(NWORDS),
     +                                        PLOTY(NWORDS),
     +                                        PLOTZ(NWORDS), ROTATE,
     +                                        SHOW_XAXIS, SHOW_YAXIS,
     +                                        SHOW_ZAXIS, TWO_PLOTS,
     +                                        XTOINT, YTOINT, ZTOINT
C
C Locals
C
      INTEGER    ITYPE, JSEND, JTYPE, NMAX, NUMHLP
      PARAMETER (ITYPE = 8, JSEND = 0, JTYPE = 11, NMAX = 300,
     +           NUMHLP = 15)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NUMTXT, N0, N1, N2, N3,
     +           N4, N5, N6, N7, N8, N9, N10, N11, N12
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, N0 = 0, N1 = 1,
     +           N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8, 
     +           N9 = 9, N10 = 10, N11 = 11, N12 = 12)
      INTEGER    NX, NY, NZ
      PARAMETER (NX = 13, NY = 14, NZ = 15)
      INTEGER    NUMBLD(30), NUMDEC, NUMPOS(NMAX + 1)
      INTEGER    I, IBOT, IMID, ITOP, NLOOP, NPT1, NSWAP
      DOUBLE PRECISION SAVMAX, SAVMIN
      DOUBLE PRECISION XBOT, XMID, XTOP
      DOUBLE PRECISION XSIZE, YSIZE
      DOUBLE PRECISION X_NUMBERS, Y_NUMBERS, Z_NUMBERS
      CHARACTER  HELP(NUMHLP)*100
      CHARACTER  LINE*100, TEXT(NMAX + 1)*100, TEXT12(12)*100
      CHARACTER  CIPHER*5, FLAG*5
      CHARACTER  MSSAGE(3:8)*25
      CHARACTER  BLANK*1, IWARNU*80
      PARAMETER (BLANK = ' ',
     +           IWARNU = 'NOT AVAILABLE with the current graph')
      LOGICAL    FORBID(3:8)
      LOGICAL    BORDER, INNER, OUTER
      LOGICAL    BAR_C, BI_P, DEND_G, PIE_C, STORE, TWO_P, VECTOR_F
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   SAVE11$
      EXTERNAL   X_GKSAXS, X_PUTFAT, X_NEWSTR, X_GETDM1, X_EDITLB,
     +           X_GETJM1, X_FSIZES, X_ADJLAB, X_EDITAX
      EXTERNAL   X_LBOX02, W_PATCH1, X_SELSTR
      INTRINSIC  MIN
      IF (NWORDS.GT.NWORD1) CALL X_PUTFAT (
     +                     'NWORDS > NWORD1 in call to MENU04$')
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Store
C ==========
C
         KANGLE_1 = KANGLE
         KTIC_1 = KTIC
         MXDROP_1 = MXDROP
         MXTIC_1 = MXTIC
         MYTIC_1 = MYTIC
         MZTIC_1 = MZTIC
         NGROUP_1 = NGROUP
         NPTS_1 = NPTS
         XCOORD_1 = XCOORD
         YCOORD_1 = YCOORD
         YDROP_1 = YDROP
         ZCOORD_1 = ZCOORD
         XMAX_1 = XMAX
         YMAX_1 = YMAX
         ZMAX_1 = ZMAX
         XMIN_1 = XMIN
         YMIN_1 = YMIN
         ZMIN_1 = ZMIN
         DO I = 1, MIN(NWORDS,NWORD1)
            LABELS_1(I) = LABELS(I)
            LABVEC_1(I) = LABVEC(I)
            WORDX_1(I) = WORDX(I)
            WORDY_1(I) = WORDY(I)
            PLOTX_1(I) = PLOTX(I)
            PLOTY_1(I) = PLOTY(I)
            PLOTZ_1(I) = PLOTZ(I)
         ENDDO
         IF (NWORD1.GT.NWORDS) THEN
            DO I = NWORDS + 1, NWORD1
               LABELS_1(I) = BLANK
               LABVEC_1(I) = BLANK
               WORDX_1(I) = BLANK
               WORDY_1(I) = BLANK
               PLOTX_1(I) = .TRUE.
               PLOTY_1(I) = .TRUE.
               PLOTZ_1(I) = .TRUE.
            ENDDO
         ENDIF
         BAR_1 = BAR_CHART
         NUMBRX_1 = NUMBRX
         PCENTX_1 = PCENTX
         PCENTY_1 = PCENTY
         PCENTZ_1 = PCENTZ
         PHIGHX_1 = PHIGHX
         PHIGHY_1 = PHIGHY
         PHIGHZ_1 = PHIGHZ
         PLOTL_1 = PLOT_LABELS
         ROTATE_1 = ROTATE
         SHOW_X = SHOW_XAXIS
         SHOW_Y = SHOW_YAXIS
         SHOW_Z = SHOW_ZAXIS
         TWO_1 = TWO_PLOTS
         XTOINT_1 = XTOINT
         YTOINT_1 = YTOINT
         ZTOINT_1 = ZTOINT
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Edit then store
C =========
C
         DO I = 1, NMAX + 1
            NUMPOS(I) = 1
         ENDDO
         STORE = .FALSE.
         CALL SAVE11$(BAR_C, BI_P, DEND_G, PIE_C, STORE, TWO_P,
     +                VECTOR_F)
C
C Return if it is a pie chart
C
         IF (PIE_C) RETURN
        
         DO I = N3, N8
            FORBID(I) = .TRUE.
            MSSAGE(I) = '[Not available]'
         ENDDO   
         IF (TWO_PLOTS) THEN
            FORBID(N3) = .FALSE.
            MSSAGE(N3) = BLANK
            FORBID(N8) = .FALSE.
            MSSAGE(N8) = BLANK
         ENDIF
         IF (PLOT_LABELS) THEN
            DO I = N4, N7
               FORBID(I) = .FALSE.
               MSSAGE(I) = BLANK
            ENDDO    
         ENDIF
         
         INNER = .TRUE.
         OUTER = .TRUE. 
         DO WHILE (OUTER)
            STORE = .FALSE.
            CALL X_FSIZES (JTYPE,
     +                     YSIZE,
     +                     STORE) 
            CALL X_FSIZES (NX,
     +                     X_NUMBERS,
     +                     STORE)
            CALL X_FSIZES (NY,
     +                     Y_NUMBERS,
     +                     STORE)   
            CALL X_FSIZES (NZ,
     +                     Z_NUMBERS,
     +                     STORE)   
C 
C----------------------------------------------
C Start of procedure to construct the main menu
C    
            IF (.NOT.FORBID(7)) THEN
               IF (DFOLT_1) THEN
                  MSSAGE(7) = '[Use defaults]'
               ELSE
                  MSSAGE(7) = '[Use line/symbol type]'
               ENDIF
            ENDIF         
            WRITE (TEXT12,100) MSSAGE(3), MSSAGE(4), YSIZE, MSSAGE(5),
     +                         MSSAGE(6), MSSAGE(7),
     +                         X_NUMBERS, Y_NUMBERS, Z_NUMBERS,
     +                         MSSAGE(8)  
            NUMOPT = N12  
C
C End of procedure to construct the main menu ... so now call the main menu
C--------------------------------------------
C            
            NUMDEC = NUMOPT - N1
            CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, 
     +                     TEXT12)
            IF (NUMDEC.GE.1 .AND. NUMDEC.LE.10) QUERY_EXIT = .TRUE.
            OUTER = .FALSE.  
C
C Check the selection
C--------------------
C                  
            IF (NUMDEC.GE.N3 .AND. NUMDEC.LE.N7) THEN  
               IF (FORBID(NUMDEC)) THEN
                  CALL X_PUTFAT (IWARNU)
                  NUMDEC = NUMOPT - N1
               ENDIF   
            ENDIF   
               
            IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: From main options ... Editing X-axis
C -----------
C            
               IF (BAR_CHART) THEN
C
C Editing X-axis for bar charts
C
                  QUERY_EXIT = .TRUE.
                  STORE = .FALSE.
                  CALL X_FSIZES (ITYPE,
     +                           XSIZE,
     +                           STORE)
                  INNER = .TRUE.
                  DO WHILE (INNER)
                     IF (SHOW_XAXIS) THEN
                        CIPHER = '(Yes)'
                     ELSE
                        CIPHER = '(No)'
                     ENDIF
                     IF (ROTATE) THEN
                        IF (KANGLE.EQ.2) THEN
                           FLAG = '(-45)'
                        ELSEIF (KANGLE.EQ.3) THEN
                           FLAG = '(-60)'
                        ELSEIF (KANGLE.EQ.4) THEN
                           FLAG = '(-75)'
                        ELSEIF (KANGLE.EQ.5) THEN
                           FLAG = '(-90)'
                        ELSEIF (KANGLE.EQ.6) THEN
                           FLAG = '(+90)'
                        ELSEIF (KANGLE.EQ.7) THEN
                           FLAG = '(+75)'
                        ELSEIF (KANGLE.EQ.8) THEN
                           FLAG = '(+60)'
                        ELSEIF (KANGLE.EQ.9) THEN
                           FLAG = '(+45)'
                        ELSE
                           FLAG = 'Error'
                        ENDIF
                     ELSE
                        FLAG = '(No)'
                     ENDIF
                     WRITE (TEXT,200) FLAG, XSIZE, CIPHER, NGROUP,
     +                                MXDROP, YDROP
                     NUMOPT = N9
                     NUMDEC = NUMOPT
                     CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT,
     +                              NUMPOS,
     +                              TEXT)
                     IF (NUMDEC.GE.1 .AND.
     +                   NUMDEC.LE.8) QUERY_EXIT = .TRUE. 
                     IF (NUMDEC.EQ.1) THEN
                        WRITE (TEXT,300)
                        NUMOPT = N9
                        CALL X_LBOX02 (ICOLOR, IX, IY, KANGLE, NUMOPT,
     +                                 NUMPOS,
     +                                 TEXT)
                        IF (KANGLE.EQ.1) THEN
                           ROTATE = .FALSE.
                        ELSE
                           ROTATE = .TRUE.
                        ENDIF
                     ELSEIF (NUMDEC.EQ.2) THEN
C
C Edit bar chart labels
C
                         NLOOP = NPTS/NGROUP
                         NUMOPT = MIN(NLOOP, NWORDS, NMAX)
                         NSWAP = 1
                         WRITE (HELP,700)
                         DO WHILE (NSWAP.GT.0)
                            CALL X_SELSTR (NSWAP, NUMHLP, NUMOPT,
     +                                     HELP, LABELS)
                            IF (NSWAP.GT.0) CALL X_NEWSTR (JSEND,
     +                                      LABELS(NSWAP),
     +                                      LABVEC(NSWAP))                            
                            
                         ENDDO  
                     ELSEIF (NUMDEC.EQ.3) THEN
                        STORE = .TRUE.
                        CALL X_FSIZES (ITYPE,
     +                                 XSIZE,
     +                                 STORE)
                     ELSEIF (NUMDEC.EQ.4) THEN
                        SHOW_XAXIS = .NOT.SHOW_XAXIS
                     ELSEIF (NUMDEC.EQ.5) THEN
                        XBOT = YMIN
                        XTOP = YMAX
                        XMID = YCOORD
                        CALL X_GETDM1 (XBOT, XMID, XTOP,
     +                 'Position (i.e. y-coordinate) for X-axis')
                        YCOORD = XMID
                      ELSEIF (NUMDEC.EQ.6) THEN
                        IBOT = 1
                        IMID = NGROUP
                        ITOP = NPTS
                        CALL X_GETJM1 (IBOT, IMID, ITOP,
     +'The number of bars per group (i.e. bars/labels)')
                        NLOOP = NPTS/IMID
                        IF (NLOOP*IMID.EQ.NPTS) THEN
                           NGROUP = IMID
                        ELSE
                           CALL X_PUTFAT (
     +'No. of bars per group must divide total no. of bars')
                        ENDIF
                        NLOOP = NPTS/NGROUP
                     ELSEIF (NUMDEC.EQ.7) THEN
                        IBOT = 10
                        ITOP = 200
                        WRITE (LINE,500) MXDROP
                        CALL X_GETJM1 (IBOT, MXDROP, ITOP,
     +                                 LINE)
                     ELSEIF (NUMDEC.EQ.8) THEN
                        XBOT = 0.02D+00
                        XTOP = 0.20D+00
                        WRITE (LINE,600) YDROP
                        CALL X_GETDM1 (XBOT, YDROP, XTOP, 
     +                                 LINE)
                     ELSE
                        INNER = .FALSE.
                     ENDIF
                  ENDDO
               ELSE
C
C Editing X-axis for standard graphs
C
                  SAVMAX = XMAX
                  SAVMIN = XMIN
                  CALL X_EDITAX (KANGLE, KTIC, MXDROP, MXTIC, NWORDS,
     +                           YCOORD, YDROP, XMAX, XMIN, YMIN, YMAX,
     +                           'X', WORDX, WORDY,
     +                           DEND_G, NUMBRX, PCENTX, PHIGHX, PLOTX,
     +                           ROTATE, SHOW_XAXIS, XTOINT)
                  IF (XMAX.GT.SAVMAX .OR. XMAX.LT.SAVMAX .OR.
     +                XMIN.GT.SAVMIN .OR. XMIN.LT.SAVMIN) THEN
                      XCOORD = XMIN
                      ZCOORD = XMAX
                  ENDIF
               ENDIF
            ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: From main menu ... Editing Y-axis for all graphs
C -----------
C
               SAVMAX = YMAX
               SAVMIN = YMIN
               CALL X_GKSAXS (KTIC, MYTIC, NWORDS,
     +                        XCOORD, YMAX, YMIN, XMIN, XMAX,
     +                        'Y', PCENTY, PHIGHY, PLOTY,
     +                        SHOW_YAXIS, YTOINT)
               IF (YMAX.GT.SAVMAX .OR. YMAX.LT.SAVMAX .OR.
     +             YMIN.GT.SAVMIN .OR. YMIN.LT.SAVMIN) THEN
                   YCOORD = YMIN
               ENDIF
            ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: From main menu ... Editing Z-axis for double graphs
C ----------- 
C
               IF (TWO_PLOTS) THEN
                  CALL X_GKSAXS (KTIC, MZTIC, NWORDS,
     +                           ZCOORD, ZMAX, ZMIN, XMIN, XMAX,
     +                           'E', PCENTZ, PHIGHZ, PLOTZ,
     +                            SHOW_ZAXIS, ZTOINT)
               ENDIF
            ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: From main  menu ... Edit plot labels
C -----------
C
               IF (PLOT_LABELS .AND. NPTS.GT.0) THEN
                  NPT1 = MIN(NPTS, NWORDS) 
                  CALL X_EDITLB (NPT1, NPT1,
     +                           LABELS, LABVEC,
     +                           DEND_G, PLOTZ)
               ENDIF
            ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: From main menu ... Re-size plot labels
C -----------
C
               IF (PLOT_LABELS) THEN
                  STORE = .TRUE.
                  CALL X_FSIZES (JTYPE,
     +                           YSIZE,
     +                           STORE)
               ENDIF
            ELSEIF (NUMDEC.EQ.N6) THEN
C
C NUMDEC = 6: From main menu ... Move/rotate
C            
               IF (PLOT_LABELS) THEN                  
                  I = NPTS
                  CALL X_ADJLAB (I,
     +                           LABELS)               
               ENDIF
C
C NUMDEC = 7: From main menu ... Use default colours
C               
            ELSEIF (NUMDEC.EQ.N7) THEN
               IF (PLOT_LABELS) THEN
                  DFOLT_1 = .NOT.DFOLT_1 
               ENDIF 
            ELSEIF (NUMDEC.EQ.N8) THEN
C
C NUMDEC = 8: From main menu ...Re-size X_NUMBERS
C            
               STORE = .TRUE.
               CALL X_FSIZES (NX,
     +                        X_NUMBERS,
     +                        STORE)  
            ELSEIF (NUMDEC.EQ.N9) THEN
C
C NUMDEC = 8: From main menu ...Re-size Y_NUMBERS
C            
               STORE = .TRUE.
               CALL X_FSIZES (NY,
     +                        Y_NUMBERS,
     +                        STORE)
            ELSEIF (NUMDEC.EQ.N10) THEN
C
C NUMDEC = 8: From main menu ...Re-size Z_NUMBERS
C            
               IF (FORBID(N8)) THEN
                  CALL X_PUTFAT (IWARNU)
               ELSE   
                  STORE = .TRUE.
                  CALL X_FSIZES (NZ,
     +                           Z_NUMBERS,
     +                           STORE)                               
               ENDIF
            ELSEIF (NUMDEC.EQ.N11) THEN
C
C NUMDEC = 11: From main menu ... Help
C -----------
C
               NUMTXT = 21
               DO I = N1, NUMTXT 
                  IF (I.EQ.1 .OR. I.EQ.18) THEN
                     NUMBLD(I) = N1
                  ELSE     
                     NUMBLD(I) = N0
                  ENDIF   
               ENDDO
               WRITE (TEXT,400)
               CALL W_PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                        TEXT,
     +                        BORDER)  
               OUTER = .TRUE.
            ENDIF
         ENDDO
C
C Store all edited variables
C
         KANGLE_1 = KANGLE
         KTIC_1 = KTIC
         MXDROP_1 = MXDROP
         MXTIC_1 = MXTIC
         MYTIC_1 = MYTIC
         MZTIC_1 = MZTIC
         NGROUP_1 = NGROUP
         NPTS_1 = NPTS
         XCOORD_1 = XCOORD
         YCOORD_1 = YCOORD
         YDROP_1 = YDROP
         ZCOORD_1 = ZCOORD
         XMAX_1 = XMAX
         YMAX_1 = YMAX
         ZMAX_1 = ZMAX
         XMIN_1 = XMIN
         YMIN_1 = YMIN
         ZMIN_1 = ZMIN
         DO I = 1, MIN(NWORDS,NWORD1)
            LABELS_1(I) = LABELS(I)
            LABVEC_1(I) = LABVEC(I)
            WORDX_1(I) = WORDX(I)
            WORDY_1(I) = WORDY(I)
            PLOTX_1(I) = PLOTX(I)
            PLOTY_1(I) = PLOTY(I)
            PLOTZ_1(I) = PLOTZ(I)
         ENDDO
         BAR_1 = BAR_CHART
         NUMBRX_1 = NUMBRX
         PCENTX_1 = PCENTX
         PCENTY_1 = PCENTY
         PCENTZ_1 = PCENTZ
         PHIGHX_1 = PHIGHX
         PHIGHY_1 = PHIGHY
         PHIGHZ_1 = PHIGHZ
         PLOTL_1 = PLOT_LABELS
         ROTATE_1 = ROTATE
         SHOW_X = SHOW_XAXIS
         SHOW_Y = SHOW_YAXIS
         SHOW_Z = SHOW_ZAXIS
         TWO_1 = TWO_PLOTS
         XTOINT_1 = XTOINT
         YTOINT_1 = YTOINT
         ZTOINT_1 = ZTOINT
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Retrieve
C ==========
C
         KANGLE = KANGLE_1
         KTIC = KTIC_1
         MXDROP = MXDROP_1
         MXTIC = MXTIC_1
         MYTIC = MYTIC_1
         MZTIC = MZTIC_1
         NGROUP = NGROUP_1
         NPTS = NPTS_1
         XCOORD = XCOORD_1
         YCOORD = YCOORD_1
         YDROP = YDROP_1
         ZCOORD = ZCOORD_1
         XMAX = XMAX_1
         YMAX = YMAX_1
         ZMAX = ZMAX_1
         XMIN = XMIN_1
         YMIN = YMIN_1
         ZMIN = ZMIN_1
         DO I = 1, MIN(NWORDS,NWORD1)
            LABELS(I) = LABELS_1(I)
            LABVEC(I) = LABVEC_1(I)
            WORDX(I) = WORDX_1(I)
            WORDY(I) = WORDY_1(I)
            PLOTX(I) = PLOTX_1(I)
            PLOTY(I) = PLOTY_1(I)
            PLOTZ(I) = PLOTZ_1(I)
         ENDDO
         BAR_CHART = BAR_1
         NUMBRX = NUMBRX_1
         PCENTX = PCENTX_1
         PCENTY = PCENTY_1
         PCENTZ = PCENTZ_1
         PHIGHX = PHIGHX_1
         PHIGHY = PHIGHY_1
         PHIGHZ = PHIGHZ_1
         PLOT_LABELS = PLOTL_1
         ROTATE = ROTATE_1
         SHOW_XAXIS = SHOW_X
         SHOW_YAXIS = SHOW_Y
         SHOW_ZAXIS = SHOW_Z
         TWO_PLOTS = TWO_1
         XTOINT = XTOINT_1
         YTOINT = YTOINT_1
         ZTOINT = ZTOINT_1
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'X-axis: edit labels/tick marks/range'
     +/'Y-axis: edit labels/tick marks/range'
     +/'Z-axis: edit labels/tick marks/range',1x,a
     +/'Labels: edit text',1x,a
     +/'Labels: re-size (current =',f6.2,')',1x,a
     +/'Labels: re-position/rotate',1x,a
     +/'Labels: colour scheme',1x,a
     +/'Numbers: re-size X-font (current =',f6.2,')'
     +/'Numbers: re-size Y-font (current =',f6.2,')'
     +/'Numbers: re-size Z-font (current =',f6.2,')',1x,a
     +/'Help'
     +/'Quit ... Exit label editing procedure')
  200 FORMAT (
     + 'X-labels: rotate',1X,A
     +/'X-labels: edit'
     +/'X-labels: re-size (current =',F6.2,')'
     +/'X-axis: display',1X,A
     +/'X-axis: translate'
     +/'Bars per group (current =',I3,')'
     +/'Double label: threshold (current =',I4,')'
     +/'Double label: translation (current =',F6.2,')'
     +/'Apply')
  300 FORMAT (
     + 'Horizontal'
     +/'45 degrees clockwise'
     +/'60 degrees clockwise'
     +/'75 degrees clockwise'
     +/'90 degrees clockwise'
     +/'90 degrees anticlockwise'
     +/'75 degrees anticlockwise'
     +/'60 degrees anticlockwise'
     +/'45 degrees anticlockwise')
  400 FORMAT (
     + 'Editing the axes'                            
     +/
     +/'The default X, Y, or E plot range (e.g. X_start to X_end)'
     +/'might be unsatisfactory: you could prefer integers instead'
     +/'of floating point notation, percentages may be appropriate,'
     +/'or text labels instead of numbers. Frequently you will want'
     +/'to adjust the numbers of tick marks so that they coincide'
     +/'with sensible subdivisions, and there will be times when it'
     +/'would be useful to move the axes from the default positions.'
     +/'You may prefer more significant figures for labels or, if there'
     +/'are many tick marks, fewer significant figures can be used to'
     +/'reduce crowding, but some choices are mutually inconsistent,'
     +/'e.g. you cannot have a frame round the plotted data and also'
     +/'move the axes from the default positions. Again, there are more'
     +/'possibilities with the X than the Y-axis, e.g. X-axis labels'
     +/'can be rotated, but obviously not the Y-axis labels.'
     +/
     +/'Editing labels'
     +/
     +/'These options are only available for plots with labels, e.g.,'
     +/'principal component scores, K-means clusters or biplots, etc.')
  500 FORMAT (
     +'No. of labels before swapping to double rows (current =',I3,')')
  600 FORMAT (
     +'Translation required for double labels (current =',1P,E11.3,')')
  700 FORMAT (
     + 'Editing bar chart text strings (x-axis labels)'
     +/   
     +/'Each label has two components: the text and the character key.'
     +/'You select a label from the list displayed and then choose the'
     +/'Simple editing option to revise the text. If you want extra'   
     +/'features like accents, maths, Greek alphabet, etc. you have to'   
     +/'choose the Advanced option to edit the character font keys, as'  
     +/'these are used to dictate the way the characters are displayed.'
     +/
     +/'Note that the simplest way to use non-standard characters is'
     +/'to select the required character from one of the character'
     +/'maps, as this automatically installs the character and key.'
     +/'For accented characters from the Isolatin1 character set you'
     +/'can just type in directly from the keyboard, as the Windows'
     +/'character set is almost identical to the IsoLatin1 set.')
      END
C
C
