C
C GRAF05$: Call MENU05$ from i_press_5
C MENU05$: Frames and sizes
C
C Subroutines for SIMPLOT
C
      SUBROUTINE X_GRAF05 (NPRESS)
C
C ACTION: call MENU05$ from i_press_5
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 30/10/2000
C         17/04/2001 added BORDER and GRATICULE
C         08/09/2001 added THREE_D
C         21/10/2004 added SHOW_BACKGROUND and SHOW_QUADRANTS
C         19/08/2005 added EXTEND_LINES
C
C         NPRESS: (input/output)
C
      IMPLICIT NONE
C
C Argument
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Locals
C
      INTEGER  ISEND, ISHAPE, KTIC
      DOUBLE PRECISION THICK, XCLIP(2), YCLIP(2), ZSCALE
      LOGICAL  BAR_CHART, BORDER, BOXIT, CENTRE, EXTEND_LINES,
     +         FRAME, GRATICULE, OFFSET, PIE_CHART, PLOT_TITLE,
     +         SHOW_BACKGROUND, SHOW_QUADRANTS, THREE_D, TWO_PLOTS,
     +         XGRID, YGRID
      EXTERNAL X_MENU05
      IF (NPRESS.EQ.5) THEN
C
C ISEND = 3: retrieve
C
         ISEND = 3
         CALL X_MENU05 (ISEND, ISHAPE, KTIC,
     +                  THICK, XCLIP, YCLIP, ZSCALE,
     +                  BAR_CHART, BORDER, BOXIT, CENTRE, EXTEND_LINES,
     +                  FRAME, GRATICULE, OFFSET, PIE_CHART, PLOT_TITLE,
     +                  SHOW_BACKGROUND, SHOW_QUADRANTS, THREE_D,
     +                  TWO_PLOTS, XGRID, YGRID)
C
C ISEND = 3: edit then store
C
         ISEND = 2
         CALL X_MENU05 (ISEND, ISHAPE, KTIC,
     +                  THICK, XCLIP, YCLIP, ZSCALE,
     +                  BAR_CHART, BORDER, BOXIT, CENTRE, EXTEND_LINES,
     +                  FRAME, GRATICULE, OFFSET, PIE_CHART, PLOT_TITLE,
     +                  SHOW_BACKGROUND, SHOW_QUADRANTS, THREE_D,
     +                  TWO_PLOTS, XGRID, YGRID)
      ELSE
         NPRESS = - NPRESS
      ENDIF
      END
C
C--------------------------------------------------------------------------------
C
      SUBROUTINE X_MENU05 (ISEND, ISHAPE, KTIC,
     +                     THICK, XCLIP, YCLIP, ZSCALE,
     +                     BAR_CHART, BORDER, BOXIT, CENTRE,
     +                     EXTEND_LINES,
     +                     FRAME, GRATICULE, OFFSET, PIE_CHART,
     +                     PLOT_TITLE, SHOW_BACKGROUND, SHOW_QUADRANTS,
     +                     THREE_D, TWO_PLOTS, XGRID, YGRID)

      USE MODULE_CLEARWIN, ONLY : BAR_1, EXTEND_1, KTIC_1, ISHAPE_1,
     +                            PIE_1, TWO_1,
     +                            THICK_1, XCLIP_1, YCLIP_1,
     +                            ZSCALE_1,
     +                            BORDER_1, BOXIT_1, CENTRE_1, FRAME_1,
     +                            GRATICULE_1, OFFSET_1, PLOT_1, 
     +                            THREE_1, SHOW_B, SHOW_Q, XGRID_1,
     +                            YGRID_1, QUERY_EXIT
C
C ACTION : Edit frames and sizes for GKSSTY ... MENU03 in v3.2
C AUTHOR : W. G. Bardsley, University of Manchester, 28/10/93
C          30/07/1997 Added ISHAPE
C          03/10/1996 Redesigned to include toggling
C          04/11/1996 Added XCLIP, YCLIP
C          14/07/1997 win32 version
C          06/06/2000 improved logic and added warning about clipping
C          18/10/2000 added ISHAPE = 4, aspect ration 1:2
C          30/10/2000 extensive re-editing
C          17/04/2001 added BORDER and GRATICULE
C          08/09/2001 added THREE_D
C          07/10/2002 added SAVEGKS.INS (ISHAPE_1, KTIC_1, PIE_1, TWO_1)
C          21/10/2004 revised and added SHOW_BACKGROUND and SHOW_QUADRANTS
C          19/08/2005 added EXTEND_LINES 
C          20/04/2007 added INTENTS
C          01/01/2006 uses MODULE_SAVEGKS instead of savegks.ins 
C          10/01/2008 transferred all saved variables to MODULE_SAVEGKS  
C          04/11/2008 added calls to SAVGRD$
C          15/06/2010 added kval_11 and call to NKLCFG
C          01/12/2010 allowed horizontal grid in two plot mode
C          16/01/2014 added QUERY_EXIT
C
C          ISEND: (input/unchanged) as follows:
C                 ISEND = 1: store
C                 ISEND = 2: edit then store
C                 ISEND = 3: retrieve
C          All other arguments (input/output) 
C
C
      IMPLICIT   NONE
C
C Arguments
C            
      INTEGER,          INTENT (IN)    :: ISEND
      INTEGER,          INTENT (INOUT) :: ISHAPE, KTIC
      DOUBLE PRECISION, INTENT (INOUT) :: THICK, XCLIP(2), YCLIP(2),
     +                                    ZSCALE
      LOGICAL,          INTENT (INOUT) :: BAR_CHART, PIE_CHART,
     +                                    TWO_PLOTS
      LOGICAL,          INTENT (INOUT) :: BORDER, BOXIT, CENTRE,
     +                                    EXTEND_LINES, FRAME,
     +                                    GRATICULE, OFFSET,
     +                                    PLOT_TITLE, SHOW_BACKGROUND,
     +                                    SHOW_QUADRANTS, THREE_D, 
     +                                    XGRID, YGRID
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(30), NDEC, NUMPOS(30)
      INTEGER    I_COLR, I_LINE, I_WIDE
      INTEGER    I, ISAV
      INTEGER    X_LEN200
      INTEGER    KVAL_11, X_NKLCFG  
      INTEGER    N1, N23
      PARAMETER (N1 = 1, N23 = 23)
      DOUBLE PRECISION RMIN, RMID, RMAX
      PARAMETER (RMIN = 0.1D+00, RMAX = 0.9D+00)
      DOUBLE PRECISION ZERO, ONE, EIGHT, XSQ1, XSQ2, XVERT1, XVERT2
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EIGHT = 8.0D+00,
     +           XSQ1 = 0.06D+00, XSQ2 = 0.86D+00, XVERT1 = 0.12D+00,
     +           XVERT2 = 0.78D+00)
      DOUBLE PRECISION XBOT, XMID, XTOP, XBOT1, XTOP1
      PARAMETER (XBOT = 0.01D+00, XTOP = 10.0D+00)
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-06)
      CHARACTER  LINE*100, SYMBOL*12, TEXT(30)*100
      CHARACTER  CLIPIT*12
      LOGICAL    DONE, FIRST
      LOGICAL    DOUGH_NUT, STORE_DN
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      LOGICAL    BORDOR, FLASH, HIGH
      PARAMETER (BORDOR = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      EXTERNAL   X_PUTFAT, X_GETDM1, X_SAVGRD
      EXTERNAL   W_RBOX01, X_TRIML1, X_LVIEW1, X_LEN200, X_PUTMES,
     +           X_NKLCFG
      EXTERNAL   SAVEDN$
      INTRINSIC  ABS
      SAVE       I_COLR, I_LINE, I_WIDE
      SAVE       ISAV, CLIPIT, FIRST
      DATA       ISAV, CLIPIT, FIRST / 1, '[Horizontal]', .TRUE. /
      DATA       I_COLR, I_LINE, I_WIDE / -1, 2, 2 /
      IF (ISEND.EQ.1) THEN
C
C Store
C
         ISHAPE_1 = ISHAPE
         KTIC_1 = KTIC
         THICK_1 = THICK
         DO I = 1, 2
            XCLIP_1(I) = XCLIP(I)
            YCLIP_1(I) = YCLIP(I)
         ENDDO
         ZSCALE_1 = ZSCALE
         BAR_1 = BAR_CHART
         BORDER_1 = BORDER
         BOXIT_1 = BOXIT
         EXTEND_1 = EXTEND_LINES
         CENTRE_1 = CENTRE
         FRAME_1 = FRAME
         GRATICULE_1 = GRATICULE
         OFFSET_1 = OFFSET
         PIE_1 = PIE_CHART
         PLOT_1 = PLOT_TITLE
         SHOW_B = SHOW_BACKGROUND
         SHOW_Q = SHOW_QUADRANTS
         THREE_1 = THREE_D
         TWO_1 = TWO_PLOTS
         XGRID_1 = XGRID
         YGRID_1 = YGRID
      ELSEIF (ISEND.EQ.2) THEN
C
C First set all counters to zero then edit and store
C
        QUERY_EXIT = .TRUE.
        DONE = .FALSE.
        DO I = 1, 30
            NUMBLD(I) = 0
            NUMPOS(I) = 0
         ENDDO
         IF (PIE_CHART) THEN
C
C Special action for pie charts
C
            IF (FRAME) THEN
               NUMPOS(1) = 1
            ELSE
               NUMPOS(1) = 0
            ENDIF
            IF (GRATICULE) THEN
               NUMPOS(2) = 1
            ELSE
               NUMPOS(2) = 0
            ENDIF
            IF (SHOW_BACKGROUND) THEN
               NUMPOS(3) = 1
            ELSE
               NUMPOS(3) = 0
            ENDIF
            IF (THREE_D) THEN
               NUMPOS(4) = 1
            ELSE
               NUMPOS(4) = 0
            ENDIF
            STORE_DN = .FALSE.
            CALL SAVEDN$(RMID, 
     +                   DOUGH_NUT, STORE_DN)
            IF (DOUGH_NUT) THEN
               NUMPOS(5) = 1
            ELSE
               NUMPOS(5) = 0
            ENDIF   
            NUMPOS(6) = 0   
            WRITE (TEXT,100) RMID
            NUMOPT = 6
            NTEXT = 7
            NDEC = NUMOPT
            NSTART = 2
            NUMBLD(1) = 1
            CALL W_RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC,
     +                     NUMOPT, NUMPOS, NSTART, NTEXT,
     +                     TEXT,
     +                     BORDOR, FLASH, HIGH)
            IF (NUMPOS(1).EQ.1) THEN
               FRAME = .TRUE.
            ELSE
               FRAME = .FALSE.
            ENDIF
            IF (NUMPOS(2).EQ.1) THEN
               GRATICULE = .TRUE.
            ELSE
               GRATICULE = .FALSE.
            ENDIF
            IF (NUMPOS(3).EQ.1) THEN
               SHOW_BACKGROUND = .TRUE.
            ELSE
               SHOW_BACKGROUND = .FALSE.
            ENDIF
            IF (NUMPOS(4).EQ.1) THEN
               THREE_D = .TRUE.
            ELSE
               THREE_D = .FALSE.
            ENDIF
            IF (NUMPOS(5).EQ.1) THEN
               DOUGH_NUT = .TRUE.
            ELSE
               DOUGH_NUT = .FALSE.
            ENDIF 
            IF (NUMPOS(6).EQ.1) THEN
               CALL X_GETDM1 (RMIN, RMID, RMAX,
     +'Fraction of radius to use for central disc')
            ENDIF              
            STORE_DN = .TRUE.
            CALL SAVEDN$(RMID,
     +                   DOUGH_NUT, STORE_DN)      
            FRAME_1 = FRAME
            GRATICULE_1 = GRATICULE
            SHOW_B = SHOW_BACKGROUND
            THREE_1 = THREE_D
            RETURN
         ENDIF
C
C All other plot types
C
         IF (ISHAPE.EQ.1) THEN
            IF (ABS(XCLIP(1) - ZERO).LE.EPSI .AND.
     +          ABS(XCLIP(2) - ONE) .LE.EPSI .AND.
     +          ABS(YCLIP(1) - ZERO).LE.EPSI .AND.
     +          ABS(YCLIP(2) - ONE) .LE.EPSI) THEN
               CLIPIT = '[Horizontal]'
            ENDIF
         ENDIF
C
C Define ganging groups adding 1 for the title line
C
         NUMBLD(2) = 100
         NUMBLD(3) = 100
         NUMBLD(4) = 100

         NUMBLD(5) = 200
         NUMBLD(6) = 200
         NUMBLD(7) = 200
         NUMBLD(8) = 200

         NUMBLD(10) = 300
         NUMBLD(11) = 300
         NUMBLD(12) = 300

         IF (PLOT_TITLE) THEN
            IF (CENTRE) THEN
               NUMPOS(1) = 1
            ELSE
               NUMPOS(2) = 1
            ENDIF
         ELSE
            NUMPOS(3) = 1
         ENDIF
         IF (ISHAPE.EQ.1) THEN
            NUMPOS(4) = 1
         ELSEIF (ISHAPE.EQ.2) THEN
            NUMPOS(5) = 1
         ELSEIF (ISHAPE.EQ.3) THEN
            NUMPOS(6) = 1
         ELSE
            NUMPOS(7) = 1
         ENDIF
         IF (KTIC.EQ. 1) THEN
            NUMPOS(9) = 1
         ELSEIF (KTIC.EQ.2) THEN
            NUMPOS(10) = 1
         ELSE
            NUMPOS(11) = 1
         ENDIF
         IF (OFFSET) NUMPOS(13) = 1
         IF (BOXIT) NUMPOS(14) = 1
         IF (FRAME) NUMPOS(15) = 1
C         IF (TWO_PLOTS) YGRID = .FALSE.
         IF (YGRID) NUMPOS(16) = 1
         IF (BAR_CHART) XGRID = .FALSE.
         IF (XGRID) NUMPOS(17) = 1
         IF (SHOW_QUADRANTS) NUMPOS(18) = 1
         IF (GRATICULE) NUMPOS(19) = 1
         IF (BORDER) NUMPOS(20) = 1
         IF (EXTEND_LINES) NUMPOS(21) = 1
         IF (SHOW_BACKGROUND) NUMPOS(22) = 1
         WRITE (SYMBOL,'(F12.3)') THICK
         CALL X_TRIML1 (SYMBOL)
         WRITE (TEXT,200) CLIPIT, SYMBOL(1:X_LEN200(SYMBOL))
         NUMOPT = 22
         NTEXT = NUMOPT + 1
         IF (BAR_CHART) THEN
            NTEXT = NTEXT + 1
            NUMOPT = NUMOPT + 1
            IF (THREE_D) NUMPOS(NUMOPT) = 1
         ENDIF
         NDEC = NUMOPT
         NSTART = 2
         NUMBLD(1) = 1
         CALL W_RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC,
     +                  NUMOPT, NUMPOS, NSTART, NTEXT, 
     +                  TEXT,
     +                  BORDOR, FLASH, HIGH)
         IF (NUMPOS(1).EQ.1) THEN
            PLOT_TITLE = .TRUE.
            CENTRE = .TRUE.
         ELSEIF (NUMPOS(2).EQ.1) THEN
            PLOT_TITLE = .TRUE.
            CENTRE = .FALSE.
         ELSEIF (NUMPOS(3).EQ.1) THEN
            PLOT_TITLE = .FALSE.
         ENDIF
         IF (NUMPOS(4).EQ.1) THEN
            ISHAPE = 1
         ELSEIF (NUMPOS(5).EQ.1) THEN
            ISHAPE = 2
         ELSEIF (NUMPOS(6).EQ.1) THEN
            ISHAPE = 3
         ELSEIF (NUMPOS(7).EQ.1) THEN
            ISHAPE = 4
         ENDIF
         IF (ISAV.NE.ISHAPE) THEN
            IF (FIRST) THEN
               KVAL_11 = X_NKLCFG(N23)
               IF (KVAL_11.EQ.N1) THEN
                  FIRST = .FALSE.
                  WRITE (TEXT,400)
                  I = 17
                  CALL X_PUTMES (I,
     +                           TEXT)
               ENDIF   
            ENDIF
            NUMPOS(8) = 1
         ENDIF
         ISAV = ISHAPE
         IF (NUMPOS(8).EQ.1) THEN
            WRITE (TEXT,500) CLIPIT, XCLIP(1), XCLIP(2), YCLIP(1),
     +                       YCLIP(2)
            NDEC = 1
            NUMOPT = 5
            NTEXT = 14
            NSTART = 6
            CALL X_LVIEW1 (IXL, IYL, NDEC, NUMOPT, NSTART, NTEXT,
     +                     TEXT,
     +                     TITLES)
            IF (NDEC.EQ.1) THEN
               XCLIP(1) = ZERO
               XCLIP(2) = ONE
               YCLIP(1) = ZERO
               YCLIP(2) = ONE
               CLIPIT = '[Horizontal]'
            ELSEIF (NDEC.EQ.2) THEN
               XCLIP(1) = XSQ1
               XCLIP(2) = XSQ2
               YCLIP(1) = ZERO
               YCLIP(2) = ONE
               CLIPIT = '[Square]'
            ELSEIF (NDEC.EQ.3) THEN
               XCLIP(1) = XVERT1
               XCLIP(2) = XVERT2
               YCLIP(1) = ZERO
               YCLIP(2) = ONE
               CLIPIT = '[Vertical]'
            ELSEIF (NDEC.EQ.4) THEN
               XCLIP(1) = ZERO
               XCLIP(2) = ONE
               YCLIP(1) = ZERO + ONE/EIGHT
               YCLIP(2) = ONE - ONE/EIGHT
               CLIPIT = '[Flat]'
            ELSEIF (NDEC.EQ.5) THEN
               XBOT1 = ZERO
               XTOP1 = ONE
               WRITE (LINE,600) 'X_start_clipping value', XCLIP(1)
               XMID = XCLIP(1)
               CALL X_GETDM1 (XBOT1, XMID, XTOP1,
     +                        LINE)
               XCLIP(1) = XMID
               XBOT1 = XMID
               WRITE (LINE,600) 'X_stop_clipping value', XCLIP(2)
               XMID = XCLIP(2)
               CALL X_GETDM1 (XBOT1, XMID, XTOP1,
     +                       LINE)
               XCLIP(2) = XMID
               XBOT1 = ZERO
               WRITE (LINE,600) 'Y_start_clipping value', YCLIP(1)
               XMID = YCLIP(1)
               CALL X_GETDM1 (XBOT1, XMID, XTOP1,
     +                        LINE)
               YCLIP(1) = XMID
               XBOT1 = XMID
               WRITE (LINE,600) 'Y_stop_clipping value', YCLIP(2)
               XMID = YCLIP(2)
               CALL X_GETDM1 (XBOT1, XMID, XTOP1,
     +                        LINE)
               YCLIP(2) = XMID
               CLIPIT = '[Selected]'
            ENDIF
         ENDIF
         IF (NUMPOS(9).EQ.1) THEN
            KTIC = 1
         ELSEIF (NUMPOS(10).EQ.1) THEN
            KTIC = 2
         ELSEIF (NUMPOS(11).EQ.1) THEN
            KTIC = 3
         ENDIF
         IF (NUMPOS(12).EQ.1) THEN
            WRITE (LINE,300)
     +'Line width required for plot axes', THICK
            XMID = THICK
            IF (XMID.LT.XBOT) THEN
               XMID = XBOT
            ELSEIF (XMID.GT.XTOP) THEN
               XMID = XTOP
            ENDIF      
            CALL X_GETDM1 (XBOT, XMID, XTOP,
     +                    LINE)
            THICK = XMID
         ENDIF
         IF (NUMPOS(13).EQ.1) THEN
            OFFSET = .TRUE.
         ELSE
            OFFSET = .FALSE.
         ENDIF
         IF (NUMPOS(14).EQ.1) THEN
            BOXIT = .TRUE.
         ELSE
            BOXIT = .FALSE.
         ENDIF
         IF (NUMPOS(15).EQ.1) THEN
            FRAME = .TRUE.
         ELSE
            FRAME = .FALSE.
         ENDIF
         IF (NUMPOS(16).EQ.1) THEN
C
C Un-comment the next lines and susequent ENDIF to retore trap for
C horizontal grid in two-plot mode 
C           
C            IF (TWO_PLOTS) THEN
C               CALL PUTFAT$(
C     +'Grid parallel to X-axis not available in two-plot mode')
C               YGRID = .FALSE.
C            ELSE
               IF (.NOT.YGRID .AND. .NOT.DONE) THEN
                  DONE = .TRUE.
                  CALL X_SAVGRD (I_COLR, I_LINE, I_WIDE,
     +                           STORE)                
               ENDIF 
               YGRID = .TRUE.
C            ENDIF
         ELSE
            YGRID = .FALSE.
         ENDIF
         IF (NUMPOS(17).EQ.1) THEN
            IF (BAR_CHART) THEN
               CALL X_PUTFAT (
     +'Grid parallel to Y-axis not available in bar-chart mode')
               XGRID = .FALSE.
            ELSE
               IF (.NOT.XGRID .AND. .NOT.DONE) THEN
                  DONE = .TRUE.
                  CALL X_SAVGRD (I_COLR, I_LINE, I_WIDE,
     +                           STORE)                
               ENDIF 
               XGRID = .TRUE.
            ENDIF
         ELSE
            XGRID = .FALSE.
         ENDIF
         IF (NUMPOS(18).EQ.1) THEN
            IF (BAR_CHART) THEN
               CALL X_PUTFAT (
     +'Lines intersecting at (0,0) not available in bar chart mode')
               SHOW_QUADRANTS = .FALSE.
            ELSE
               SHOW_QUADRANTS = .TRUE.
            ENDIF
         ELSE
            SHOW_QUADRANTS = .FALSE.
         ENDIF
         IF (NUMPOS(19).EQ.1) THEN
            GRATICULE = .TRUE.
         ELSE
            GRATICULE = .FALSE.
         ENDIF
         IF (NUMPOS(20).EQ.1) THEN
            BORDER = .TRUE.
         ELSE
            BORDER = .FALSE.
         ENDIF
         IF (NUMPOS(21).EQ.1) THEN
            EXTEND_LINES = .TRUE.
         ELSE
            EXTEND_LINES = .FALSE.
         ENDIF
         IF (NUMPOS(22).EQ.1) THEN
            SHOW_BACKGROUND = .TRUE.
         ELSE
            SHOW_BACKGROUND = .FALSE.
         ENDIF
         IF (BAR_CHART) THEN
            IF (NUMPOS(23).EQ.1) THEN
               THREE_D = .TRUE.
            ELSE
               THREE_D = .FALSE.
            ENDIF
         ENDIF
C
C Adjust ZSCALE to keep plotting symbols appropriately sized
C
         IF (PLOT_TITLE) THEN
            ZSCALE = 1.0D+00
         ELSE
            ZSCALE = 0.9D+00
         ENDIF
         IF (ISHAPE.EQ.2) THEN
            ZSCALE = 1.3333D+00*ZSCALE
         ELSEIF (ISHAPE.EQ.3) THEN
            ZSCALE = 2.0D+00*ZSCALE
         ELSEIF (ISHAPE.EQ.4) THEN
            ZSCALE = 1.0D+00*ZSCALE
         ENDIF
C
C Store
C
         ISHAPE_1 = ISHAPE
         KTIC_1 = KTIC
         THICK_1 = THICK
         DO I = 1, 2
            XCLIP_1(I) = XCLIP(I)
            YCLIP_1(I) = YCLIP(I)
         ENDDO
         ZSCALE_1 = ZSCALE
         BAR_1 = BAR_CHART
         BORDER_1 = BORDER
         BOXIT_1 = BOXIT
         CENTRE_1 = CENTRE
         EXTEND_1 = EXTEND_LINES
         FRAME_1 = FRAME
         GRATICULE_1 = GRATICULE
         OFFSET_1 = OFFSET
         PIE_1 = PIE_CHART
         PLOT_1 = PLOT_TITLE
         SHOW_B = SHOW_BACKGROUND
         SHOW_Q = SHOW_QUADRANTS
         THREE_1 = THREE_D
         TWO_1 = TWO_PLOTS
         XGRID_1 = XGRID
         YGRID_1 = YGRID
      ELSEIF (ISEND.EQ.3) THEN
C
C Retrieve
C
         ISHAPE = ISHAPE_1
         KTIC = KTIC_1
         THICK = THICK_1
         DO I = 1, 2
            XCLIP(I) = XCLIP_1(I)
            YCLIP(I) = YCLIP_1(I)
         ENDDO
         ZSCALE = ZSCALE_1
         BAR_CHART = BAR_1
         BORDER = BORDER_1
         BOXIT = BOXIT_1
         CENTRE = CENTRE_1
         EXTEND_LINES = EXTEND_1
         FRAME = FRAME_1
         GRATICULE = GRATICULE_1
         OFFSET = OFFSET_1
         PIE_CHART = PIE_1
         PLOT_TITLE = PLOT_1
         SHOW_BACKGROUND = SHOW_B
         SHOW_QUADRANTS = SHOW_Q
         THREE_D = THREE_1
         TWO_PLOTS = TWO_1
         XGRID = XGRID_1
         YGRID = YGRID_1
      ENDIF 
C
C Format statements
C      
  100 FORMAT (
     + 'Use these options to define the plot type'
     +/'Add a frame around plot border'
     +/'Add a graticule to position text'
     +/'Display background even if white'
     +/'Display segments in 3-D perspective'
     +/'Display segments in doughnut form'
     +/'Change doughnut radius: current =',f6.2)
  200 FORMAT (
     + 'Use these options to define the plot type'
     +/'Title(s) ... centered in display'
     +/'Title(s) ... centered over data'
     +/'Title(s) ... suppressed'
     +/'Shape ... horizontal'
     +/'Shape ... square'
     +/'Shape ... vertical'
     +/'Shape ... flat'
     +/'Shape ... change clipping coordinates ',A
     +/'Tick marks ... pointing out'
     +/'Tick marks ... suppressed'
     +/'Tick marks ... pointing in'
     +/'Axes ... change line thickness [',A,']'
     +/'Axes ... offset'
     +/'Add ... box around data plotted'
     +/'Add ... frame around plot border'
     +/'Add ... grid parallel to X-direction'
     +/'Add ... grid parallel to Y-direction'
     +/'Add ... lines intersecting at (0,0)'
     +/'Add ... graticule to position text'
     +/'Add ... border region round plot'
     +/'Extend ... lines to boundaries'
     +/'Display ... opaque background even if white'
     +/'Display ... bars in 3-D perspective')
  300 FORMAT (A33,' (current =',F6.3,')')
  400 FORMAT (
     + 'First time message: y:x aspect ratios and clipping'
     +/
     +/'Square, vertical or flat formats change the aspect ratio of'
     +/'the plot and create empty borders. This can be convenient if'
     +/'you want to use the additional space for a panel or extra'
     +/'text at the sides of the plot, as it does not change the'
     +/'overall rectangular shape of the final hardcopy. However,'
     +/'if you want square, vertical or flat *.eps files to include'
     +/'in documents or collages, but you do not want an overall'
     +/'rectangular format with surplus margins, you must clip to'
     +/'the desired shape to delete the unwanted margins.'
     +/
     +/'Important Notes:'
     +/'1) Set clipping to 3:4 default to make all graph space useable.'
     +/'2) The title (line 2) will display when nonblank after editing.'
     +/'3) Any clipped space is shown greyed out on the bitmap display.'
     +/'4) If you save clipped bitmaps/metafiles you may have to crop.'
     +/'5) Check the BoundingBox in GSview before making *.eps files.')
  500 FORMAT (
     + 'Clipping PS plots to chosen aspect ratios'
     +/'Current PS clipping coordinates are:-'
     +/A
     +/F5.3,' < x < ',F5.3,', ',F5.3,' < y < ',F5.3
     +/'Clipping shape  `y:x Ratio'
     +/'Horizontal  `3:4'
     +/'Square      `1:1'
     +/'Vertical    `4:3'
     +/'Flat        `1:2'
     +/'You select  `n:m'
     +/'*.eps files set BoundingBoxes to clipping'
     +/'coordinates, but bitmaps may be full-frame.'
     +/'Space outside the clipping frame will be'
     +/'greyed out on the screen bitmap display.')
  600 FORMAT (A,': Current value =',F6.3)
      END
C
C
