C
C X_GRAF06: calls X_MENU06 from i_press_6
C X_MENU06: Lines, symbols, error-bar types
C
C subroutines for simplot
C
      SUBROUTINE X_GRAF06 (NPRESS)

      USE MODULE_CLEARWIN, ONLY : NXTRA1
C
C ACTION: call MENU06$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 30/10/2000
C         01/06/2001 increased NWORDS from 100 to 300
C         29/09/2002 increased NWORDS from 300 to 500
C         07/10/2002 set NGRAFS = 300, NWORDS = 1000
C         07/01/2003 redimensioned WIDE(5*NGRAFS)
C         25/10/2004 minor editing
C         11/07/2005 increased NWORDS from 1000 to 2000
C         10/12/2007 corrected line type 5 from <<< to >>>
C         01/01/2008 added MODULE_SAVGKS then used NXTRA
C
C         NPRESS: (input/output)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C
      INTEGER,          ALLOCATABLE :: IFILL(:), IHUE(:)
      DOUBLE PRECISION, ALLOCATABLE :: FACTOR(:)     
C
C Locals
C
      INTEGER    NGRAFS, NWORDS
      PARAMETER (NGRAFS = 300, NWORDS = 2000)
      INTEGER    IERR, ISEND, L(NGRAFS), LPREV, M(NGRAFS), NFILES,
     +           NGROUP, NPTS, NSAV(NGRAFS), NXTRA
      DOUBLE PRECISION SIZES(NGRAFS), WIDE(5*NGRAFS)
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABELS(NWORDS)*40,
     +           LABVEC(NWORDS)*40, TSAV(NGRAFS)*80
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, PIE_CHART,
     +           LOWER(NGRAFS), UPPER(NGRAFS), VECTOR_FIELD
      EXTERNAL   X_MENU06
      IF (NPRESS.EQ.6) THEN
         IERR = 0
         IF (ALLOCATED(IFILL)) DEALLOCATE(IFILL, STAT = IERR)
         IF (IERR.NE.0) RETURN  
         IF (ALLOCATED(IHUE)) DEALLOCATE(IHUE, STAT = IERR)
         IF (IERR.NE.0) RETURN
         IF (ALLOCATED(FACTOR)) DEALLOCATE(FACTOR, STAT = IERR)
         IF (IERR.NE.0) RETURN            
         NXTRA = NXTRA1
         ALLOCATE(IFILL(NXTRA), STAT = IERR)
         IF (IERR.NE.0) RETURN 
         ALLOCATE(IHUE(NXTRA), STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(FACTOR(NXTRA), STAT = IERR)
         IF (IERR.NE.0) RETURN              
C
C ISEND = 3: retrieve
C
         ISEND = 3
         CALL X_MENU06 (ISEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                  NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                  FACTOR, SIZES, WIDE,
     +                  FSAV, FSAV1, LABELS, LABVEC, TSAV, BARCAP,
     +                  BARCAP_1, BAR_CHART, PIE_CHART, LOWER, UPPER,
     +                  VECTOR_FIELD)
C
C ISEND = 2: edit then store
C
         ISEND = 2
         CALL X_MENU06 (ISEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                  NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                  FACTOR, SIZES, WIDE,
     +                  FSAV, FSAV1, LABELS, LABVEC, TSAV, BARCAP,
     +                  BARCAP_1, BAR_CHART, PIE_CHART, LOWER, UPPER,
     +                  VECTOR_FIELD)
         DEALLOCATE(IFILL, STAT = IERR) 
         DEALLOCATE(IHUE, STAT = IERR)
         DEALLOCATE(FACTOR, STAT = IERR)          
      ELSE
         NPRESS = - NPRESS
      ENDIF
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE X_MENU06 (ISEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                     NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                     FACTOR, SIZES, WIDE,
     +                     FSAV, FSAV1, LABELS, LABVEC, TSAV,
     +                     BARCAP, BARCAP_1, BAR_CHART, PIE_CHART,
     +                     LOWER, UPPER, VECTOR_FIELD)

      USE MODULE_CLEARWIN, ONLY : BAR_1, BARCAP_2, FACTOR_1, FSAV_1,
     +                            FSAV1_1, IHUE_1, IFILL_1, L_1,
     +                            LABELS_1, LABVEC_1, LOWER_1, M_1, 
     +                            NFILES_1, 
     +                            NGRAF1, NPTS_1, NSAV_1, PIE_1, TSAV_1,
     +                            UPPER_1, NWORD1, NXTRA1, WIDE_1,
     +                            SIZE_1,
     +                            LPREV_1, NGROUP_1,
     +                            BARCAP_3, VECTOR_1,
     +                            JCOLOR_1, QUERY_EXIT 
C
C ACTION : Edit error bars etc. for GKSSTY ... MENU04 in v3.2
C AUTHOR : W. G. Bardsley, University of Manchester, U.K, 28/10/93
C
C          20/02/1997 added BARCAP_1 and SYMBOLS to MENU05 arg list
C          14/07/1997 win32 version
C          09/03/1998 added VECTOR_FIELD
C          10/09/1998 added numeric editing, restore and save, and calls
C                     BCCOPY to update the bar chart file
C          30/10/2000 extensive re-editing
C          01/06/2001 increased KMAX from 100 to 300
C          07/10/2002 added savegks.ins (L_1, M_1, NFILES_1, NPTS_1,
C                     NSAV_1, IFILL_1, IHUE_1, WIDE_1, FSAV_1, FSAV1_1,
C                     LABELS_1, SYMBOLS_1, TSAV_1, BARCAP_2, LOWER_1,
C                     UPPER_1, BAR_1, PIE_1)
C          07/01/2003 redimensioned WIDE(5*NGRAFS)
C          09/05/2004 redimensioned NMAX to 302 and added PLOTYN$
C          25/10/2004 added call to PATCH1 and NGROUP to argument list
C          19/09/2006 added call to GKSVF7  
C          20/04/2007 added INTENTS and removed calls to SYMBOLS and SYMLAB$
C          01/02/2008 uses MODULE_SAVEGKS instead of savegks.ins 
C          30/01/2008 added call to GKSSAV$ if array size must be increased
C          01/02/2008 introduced JCOLOR_1 to menu
C          16/08/2008 added code for outline symbols (30 =< M =< 33)
C          02/01/2011 added NSTEPS
C          16/01/2014 added QUERY_EXIT and RE_DISPLAY
C          18/02/2014 removed RE_DISPLAY 
C          31/12/2015 added call to X_SAVCFG
C
C          ISEND = 1: store
C          ISEND = 2: edit then store
C          ISEND = 3: retrieve
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NGRAFS, NWORDS,
     +                                       NXTRA
      INTEGER,             INTENT (INOUT) :: IFILL(NXTRA),
     +                                       IHUE(NXTRA), NFILES,
     +                                       NGROUP, L(NGRAFS), LPREV,
     +                                       M(NGRAFS), NPTS,
     +                                       NSAV(NGRAFS)
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NXTRA),
     +                                       SIZES(NGRAFS), 
     +                                       WIDE(5*NGRAFS)
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NGRAFS), 
     +                                       FSAV1(NGRAFS),
     +                                       LABELS(NWORDS), 
     +                                       LABVEC(NWORDS),
     +                                       TSAV(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: BARCAP(NGRAFS), BARCAP_1,
     +                                       BAR_CHART, PIE_CHART,
     +                                       LOWER(NGRAFS),
     +                                       UPPER(NGRAFS), VECTOR_FIELD
C
C Locals
C
      INTEGER    I, IADD1, K, NDEC, NOUT
      INTEGER    NMAX, N0, N1, N5
      PARAMETER (NMAX = 302, N0 = 0, N1 = 1, N5 = 5)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(NMAX), NUMPOS(NMAX)
      INTEGER    L_TEMP(NMAX), M_TEMP(NMAX)
      INTEGER    KSEND, MODE1, MODE5
      PARAMETER (KSEND = 2, MODE1 = 1, MODE5 = 5)
      INTEGER    NROWS, NCOLS
      INTEGER    NGRAF2, NGRAF3, NGRAF4, NGRAF5
      INTEGER    NMAX1
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  LINE*100, TEXT(NMAX)*129, X_TRIM40*40, WORD6*6,
     +           WORD40*40
      CHARACTER  LTYPE*20, STYPE*30
      CHARACTER  DUMMY*1024
      CHARACTER  BLANK*1, GRAVE*1
      PARAMETER (BLANK = ' ', GRAVE = '`')
      LOGICAL    REPEET
      LOGICAL    BARKEY, PIEKEY, TITLES
      PARAMETER (BARKEY = .FALSE., PIEKEY = .FALSE., TITLES = .TRUE.)
      LOGICAL    FIXED, FULL, HIGH
      PARAMETER (FIXED = .FALSE., FULL = .TRUE., HIGH = .FALSE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE., LABEL = .TRUE.,
     +           ORDER = .FALSE., WEIGHT = .FALSE.)
      LOGICAL    BORDER, STORE
      PARAMETER (BORDER = .FALSE., STORE = .FALSE.)
      LOGICAL    MUST_EXIST, SAVE_NX
      PARAMETER (MUST_EXIST = .FALSE., SAVE_NX = .TRUE.)
      LOGICAL    ABORT, FILE, EDIT, ERRORS, OK, RESTORE
      EXTERNAL   X_ERRBAR
      EXTERNAL   X_GKSTYP, X_EDITPC, X_BCCOPY, X_GETFFS, X_EDITBC,
     +           X_NUPLOT, X_COPYFL, X_COPYFG, W_LBOX01,  
     +           X_GETNOU, X_NUDATA, X_PUTFAT, X_TRIM40, X_LVIEW1,
     +           X_PLOTYN, W_PATCH1, X_PUTADV, X_NSTEPS,
     +           X_GKSVF7, X_ISITMF, X_TRIML1, X_SAVCFG
      EXTERNAL   SAVINT$
      INTRINSIC  MIN
      DATA       NUMBLD / NMAX*0 /
      DATA       NUMPOS / NMAX*1 / 
C
C Check NGRAFS, NWORDS then define NGRAF2, NGRAF3, NGRAF4
C
      IF (NGRAFS.GT.NGRAF1) CALL X_PUTFAT (
     +                     'NGRAFS > NGRAF1 in call to X_MENU06')
      IF (NWORDS.GT.NWORD1) CALL X_PUTFAT (
     +                     'NWORDS > NWORD1 in call to X_MENU06')
      IF (NXTRA.GT.NXTRA1) CALL X_PUTFAT (
     +                     'NXTRA > NXTRA1 in call to X_MENU06')     
      NGRAF2 = 2*NGRAFS
      NGRAF3 = 3*NGRAFS
      NGRAF4 = 4*NGRAFS
      NGRAF5 = 5*NGRAF1
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Store
C ==========
C
         LPREV_1 = LPREV
         NFILES_1 = NFILES
         NGROUP_1 = NGROUP
         NPTS_1 = NPTS
         BARCAP_3 = BARCAP_1
         BAR_1 = BAR_CHART
         PIE_1 = PIE_CHART
         VECTOR_1 = VECTOR_FIELD
         DO I = N1, MIN(NXTRA, NXTRA1)
            IFILL_1(I) = IFILL(I)
            IHUE_1(I) = IHUE(I)
            FACTOR_1(I) = FACTOR(I)
         ENDDO  
         DO I = N1, MIN(NWORDS, NWORD1)
            LABELS_1(I) = LABELS(I)
            LABVEC_1(I) = LABVEC(I)
         ENDDO
         IF (NXTRA1.GT.NXTRA) THEN
            DO I = NXTRA + N1, NXTRA1
               IFILL_1(I) = N1
               IHUE_1(I) = N0
               FACTOR_1(I) = ONE              
            ENDDO
         ENDIF     
         IF (NWORD1.GT.NWORDS) THEN
            DO I = NWORDS + N1, NWORD1
               LABELS_1(I) = BLANK
               LABVEC_1(I) = BLANK
            ENDDO
         ENDIF
         DO I = N1, NGRAF5
            WIDE_1(I) = ONE
         ENDDO
         DO I = N1, MIN(NGRAFS, NGRAF1)
            L_1(I) = L(I)
            M_1(I) = M(I)
            NSAV_1(I) = NSAV(I)
            SIZE_1(I) = SIZES(I)
            WIDE_1(I) = WIDE(I)
            K = NGRAFS + I
            IF (K.LE.NGRAF5) WIDE_1(K) = WIDE(K)
            K = NGRAF2 + I
            IF (K.LE.NGRAF5) WIDE_1(K) = WIDE(K)
            K = NGRAF3 + I
            IF (K.LE.NGRAF5) WIDE_1(K) = WIDE(K)
            K = NGRAF4 + I
            IF (K.LE.NGRAF5) WIDE_1(K) = WIDE(K)
            FSAV_1(I) = FSAV(I)
            FSAV1_1(I) = FSAV1(I)
            TSAV_1(I) = TSAV(I)
            BARCAP_2(I) = BARCAP(I)
            LOWER_1(I) = LOWER(I)
            UPPER_1(I) = UPPER(I)
         ENDDO
         IF (NGRAF1.GT.NGRAFS) THEN
            DO I = NGRAFS + N1, NGRAF1
               L_1(I) = N1
               M_1(I) = N1
               NSAV_1(I) = N0
               SIZE_1(I) = ONE
               FSAV_1(I) = BLANK
               FSAV1_1(I) = BLANK
               TSAV_1(I) = BLANK
               BARCAP_2(I) = .TRUE.
               LOWER_1(I) = .TRUE.
               UPPER_1(I) = .TRUE.
            ENDDO
         ENDIF
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Edit then store
C ==========
C
         IF (PIE_CHART) THEN
C
C------------------------------
C Special action for pie charts
C------------------------------
C
            QUERY_EXIT = .TRUE. 
            CALL X_EDITPC (IFILL, IHUE, NPTS,
     +                     FACTOR, WIDE(1),
     +                     FSAV1(1), LABELS, LABVEC, 
     +                     PIEKEY)
            NPTS_1 = NPTS
            DO I = N1, NPTS_1
               IFILL_1(I) = IFILL(I)
               IHUE_1(I) = IHUE(I)
               FACTOR_1(I) = FACTOR(I)
               LABELS_1(I) = LABELS(I)
               LABVEC_1(I) = LABVEC(I)
            ENDDO
            FSAV1_1(1) = FSAV1(1)
            WIDE_1(1) = WIDE(1)
            RETURN
         ENDIF
C
C------------------
C Other graph types
C------------------
C
         REPEET = .TRUE.
         DO WHILE (REPEET)
            WRITE (TEXT,100) NFILES, LPREV
            NUMBLD(1) = 4
            NUMBLD(9) = 1
            NUMBLD(10) = 1
            NSTART = 12
            NUMOPT = 11
            NTEXT = NSTART + NUMOPT - 1
            NUMDEC = NUMOPT - 1
            CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                     NUMOPT, NUMPOS, NSTART, NTEXT,
     +                     TEXT,
     +                     FIXED, FULL, HIGH)
            IF (NUMDEC.GE.1 .AND. NUMDEC.LE.9) QUERY_EXIT = .TRUE. 
            NUMBLD(1) = 0
            NUMBLD(9) = 0
            NUMBLD(10) = 0
            EDIT = .FALSE.
            ERRORS = .FALSE.
            FILE = .FALSE.
            RESTORE = .FALSE.
            IF (NUMDEC.EQ.1) THEN
C
C Edit line types and symbols
C
               OK = .TRUE.
               WRITE (TEXT,200) 'to edit symbols and/or line-types'
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Edit the data
C
               OK = .TRUE.
               EDIT = .TRUE.
               WRITE (TEXT,200) 'to edit data values'
            ELSEIF (NUMDEC.EQ.3) THEN
C
C Restore the data
C
               OK = .TRUE.
               RESTORE = .TRUE.
               WRITE (TEXT,200) 'to use for restoring'
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Save As ...
C
               OK = .TRUE.
               FILE = .TRUE.
               WRITE (TEXT,200) 'to use for saving'
            ELSEIF (NUMDEC.EQ.5) THEN
C
C Create error bars
C
               OK = .TRUE.
               ERRORS = .TRUE.
               WRITE (TEXT,200) 'for creating error bars'
            ELSEIF (NUMDEC.EQ.6) THEN
C
C New data from a new file
C
               OK = .FALSE.
               CALL X_NUPLOT (NFILES, NSAV(NFILES + 1),
     +                        FSAV(NFILES + 1),
     +                        FSAV1(NFILES + 1))
               IF (NFILES.GT.NFILES_1) THEN
                  NFILES_1 = NFILES
C
C Define new parameters
C
                  CALL X_ISITMF (NCOLS, NROWS,
     +                           FSAV(NFILES))
                  CALL SAVINT$(N5, N5, NMAX1,
     +                         STORE)                  
                  IF (NROWS.GT.NMAX1) THEN
                     NMAX1 = NROWS
                     CALL SAVINT$(N5, N5, NMAX1,
     +                            SAVE_NX)                     
                  ENDIF 
                  L(NFILES) = 1
                  M(NFILES) = 1
                  SIZES(NFILES) = ONE
                  K = NFILES
                  WIDE(K) = ONE
                  K = NGRAFS + NFILES
                  WIDE(K) = ONE
                  K = NGRAF2 + NFILES
                  WIDE(K) = ONE
                  TSAV(NFILES) = 'Extra data from file'
                  BARCAP(NFILES) = .FALSE.
                  LOWER(NFILES) = .FALSE.
                  UPPER(NFILES) = .FALSE.
C
C Make copies
C
                  NSAV_1(NFILES) = NSAV(NFILES)
                  M_1(NFILES) = M(NFILES)
                  SIZE_1(NFILES) = SIZES(NFILES)
                  K = NFILES
                  WIDE_1(K) = WIDE(K)
                  K = NGRAFS + NFILES
                  WIDE_1(K) = WIDE(K)
                  K = NGRAF2 + NFILES
                  WIDE_1(K) = WIDE(K)
                  TSAV_1(NFILES) = TSAV(NFILES)
                  BARCAP_2(NFILES) = BARCAP(NFILES)
                  LOWER_1(NFILES) = LOWER(NFILES)
                  UPPER_1(NFILES) = UPPER(NFILES)

                  FSAV_1(NFILES) = FSAV(NFILES)
                  FSAV1_1(NFILES) = FSAV1(NFILES)
                  TSAV_1(NFILES) = TSAV(NFILES)
               ENDIF
            ELSEIF (NUMDEC.EQ.7) THEN
C
C New data interactively
C
               OK = .FALSE.
               CALL X_NUDATA (NFILES, NSAV(NFILES + 1),
     +                        FSAV(NFILES + 1),
     +                        FSAV1(NFILES + 1))
               IF (NFILES.GT.NFILES_1) THEN
                  NFILES_1 = NFILES
C
C Define new parameters
C
                  CALL X_ISITMF (NCOLS, NROWS,
     +                           FSAV(NFILES))
                  CALL SAVINT$(N5, N5, NMAX1,
     +                         STORE)                  
                  IF (NROWS.GT.NMAX1) THEN
                     NMAX1 = NROWS
                     CALL SAVINT$(N5, N5, NMAX1,
     +                            SAVE_NX)                     
                  ENDIF  
                  L(NFILES) = 1
                  M(NFILES) = 1
                  SIZES(NFILES) = ONE
                  K = NFILES
                  WIDE(K) = ONE
                  K = NGRAFS + NFILES
                  WIDE(K) = ONE
                  K = NGRAF2 + NFILES
                  WIDE(K) = ONE
                  TSAV(NFILES) = 'Extra data interactively'
                  BARCAP(NFILES) = .FALSE.
                  LOWER(NFILES) = .FALSE.
                  UPPER(NFILES) = .FALSE.
C
C Make copies
C
                  NSAV_1(NFILES) = NSAV(NFILES)
                  M_1(NFILES) = M(NFILES)
                  SIZE_1(NFILES) = SIZES(NFILES)
                  K = NFILES
                  WIDE_1(K) = WIDE(K)
                  K = NGRAFS + NFILES
                  WIDE_1(K) = WIDE(K)
                  K = NGRAF2 + NFILES
                  WIDE_1(K) = WIDE(K)
                  TSAV_1(NFILES) = TSAV(NFILES)
                  BARCAP_2(NFILES) = BARCAP(NFILES)
                  LOWER_1(NFILES) = LOWER(NFILES)
                  UPPER_1(NFILES) = UPPER(NFILES)

                  FSAV_1(NFILES) = FSAV(NFILES)
                  FSAV1_1(NFILES) = FSAV1(NFILES)
                  TSAV_1(NFILES) = TSAV(NFILES)
               ENDIF
            ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot/suppress selected files
C
               OK = .FALSE.
               IF (BAR_CHART) THEN
                  L(1) = 1
                  M(1) = 1
               ENDIF
               CALL X_PLOTYN (ISEND, L, M, NFILES,
     +                        FSAV,
     +                        BARCAP, LOWER, UPPER)
               IF (BAR_CHART) THEN
                  IF (L(1).EQ.N0 .AND. M(1).EQ.N0)
     +            CALL X_PUTADV ('Cannot suppress a bar chart')
                  L(1) = 0
                  M(1) = 0
               ENDIF
               DO I = N1, NFILES
                  L_1(I) = L(I)
                  M_1(I) = M(I)
                  BARCAP_2(I) = BARCAP(I)
                  LOWER_1(I) = LOWER(I)
                  UPPER_1(I) = UPPER(I)
               ENDDO
            ELSEIF (NUMDEC.EQ.9) THEN   
C
C Omit intermediate points
C
               OK = .FALSE.
               IF (BAR_CHART .OR. PIE_CHART .OR. VECTOR_FIELD) THEN
                  CALL X_PUTADV ('Only for standard plotting functions')             
               ELSE   
                  CALL X_NSTEPS (KSEND, L_TEMP, M_TEMP, NFILES) 
               ENDIF  
            ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
               OK = .FALSE.
               REPEET = .TRUE.
               WRITE (TEXT,300)
               NTEXT = 21
               NUMBLD(1) = 1
               CALL W_PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +                        TEXT,
     +                        BORDER)
                NUMBLD(1) = 0
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Apply
C
               OK = .FALSE.
               REPEET = .FALSE.
            ENDIF
            IF (OK .AND. NFILES.EQ.1) THEN
C
C Only 1 file
C
               NDEC = 1
               LPREV = 1
            ELSEIF (OK) THEN
C
C Select a file
C
               IADD1 = 2
               DO I = N1, MIN(NFILES,NMAX - 1)
C
C Record line and symbol type in LTYPE and STYPE
C
                  IF (L(I).EQ.1) THEN
                     LTYPE = 'Solid'
                  ELSEIF (L(I).EQ.2) THEN
                     LTYPE = 'Dashed'
                  ELSEIF (L(I).EQ.3) THEN
                    LTYPE = 'Dotted'
                  ELSEIF (L(I).EQ.4) THEN
                     LTYPE = 'Dash-Dot'
                  ELSEIF (L(I).EQ.5) THEN
                     LTYPE = 'Vector >>>'
                  ELSEIF (L(I).EQ.6) THEN
                     LTYPE = 'Vector <<<'
                  ELSEIF (L(I).EQ.7) THEN
                     LTYPE = 'cdf'
                  ELSEIF (L(I).EQ.8) THEN
                     LTYPE = 'survival'
                  ELSEIF (L(I).EQ.9) THEN
                     LTYPE = 'Polygon'
                  ELSE
                     LTYPE = 'None'
                  ENDIF
                  IF (M(I).EQ.1) THEN
                     STYPE = 'Dot'
                  ELSEIF (M(I).EQ.2) THEN
                     STYPE = 'Plus'
                  ELSEIF (M(I).EQ.3) THEN
                     STYPE = 'Cross'
                  ELSEIF (M(I).EQ.4) THEN
                     STYPE = 'Asterisk'
                  ELSEIF (M(I).EQ.5) THEN
                     STYPE = 'Circle'
                  ELSEIF (M(I).EQ.6) THEN
                     STYPE = 'Circle-half'
                  ELSEIF (M(I).EQ.7) THEN
                     STYPE = 'Circle-full'
                  ELSEIF (M(I).EQ.8) THEN
                     STYPE = 'Triangle'
                  ELSEIF (M(I).EQ.9) THEN
                     STYPE = 'Triangle-half'
                  ELSEIF (M(I).EQ.10) THEN
                     STYPE = 'Triangle-full'
                  ELSEIF (M(I).EQ.11) THEN
                     STYPE = 'Square'
                  ELSEIF (M(I).EQ.12) THEN
                  STYPE = 'Square-half'
                  ELSEIF (M(I).EQ.13) THEN
                     STYPE = 'Square-full'
                  ELSEIF (M(I).EQ.14) THEN
                     STYPE = 'Diamond'
                  ELSEIF (M(I).EQ.15) THEN
                     STYPE = 'Diamond-half'
                  ELSEIF (M(I).EQ.16) THEN
                     STYPE = 'Diamond-full'
                  ELSEIF (M(I).EQ.17) THEN
                     STYPE = 'Minus'
                  ELSEIF (M(I).EQ.18) THEN
                     STYPE = 'Male'
                  ELSEIF (M(I).EQ.19) THEN
                     STYPE = 'Female'
                  ELSEIF (M(I).EQ.20) THEN
                     STYPE = 'Bar-hollow'
                  ELSEIF (M(I).EQ.21) THEN
                     STYPE = 'Bar-filled'
                  ELSEIF (M(I).EQ.22) THEN
                     STYPE = 'Bar-diag-up'
                  ELSEIF (M(I).EQ.23) THEN
                     STYPE = 'Bar-diag-down'
                  ELSEIF (M(I).EQ.24) THEN
                     STYPE = 'Bar-crossed'
                  ELSEIF (M(I).EQ.25) THEN
                     STYPE = 'Bar-horizontal'
                  ELSEIF (M(I).EQ.26) THEN
                     STYPE = 'Bar-vertical'
                  ELSEIF (M(I).EQ.27) THEN
                     STYPE = 'Bar-dash'
                  ELSEIF (M(I).EQ.28) THEN
                     STYPE = 'Bar-dot'
                  ELSEIF (M(I).EQ.29) THEN
                     STYPE = 'Bar-dash-dot'
                  ELSEIF (M(I).EQ.30) THEN
                     STYPE = 'Circle-outline'
                  ELSEIF (M(I).EQ.31) THEN
                     STYPE = 'Triangle-outline'
                  ELSEIF (M(I).EQ.32) THEN
                     STYPE = 'Square-outline'
                  ELSEIF (M(I).EQ.33) THEN
                     STYPE = 'Diamond-outline'  
                  ELSEIF (M(I).EQ.34) THEN
                     STYPE = 'Inverted-triangle'
                  ELSEIF (M(I).EQ.35) THEN
                     STYPE = 'Inverted-triangle-half'
                  ELSEIF (M(I).EQ.36) THEN
                     STYPE = 'Inverted-triangle-full'
                  ELSEIF (M(I).EQ.37) THEN
                     STYPE = 'Inverted-triangle-outline'     
                  ELSE
                     STYPE = 'None'
                  ENDIF
                  IADD1 = IADD1 + 1
                  WORD40 = X_TRIM40(FSAV(I))
                  WRITE (WORD6,'(I6)') JCOLOR_1(I)
                  CALL X_TRIML1 (WORD6)
                  TEXT(IADD1) = 
     +            WORD40//GRAVE//STYPE//GRAVE//LTYPE//GRAVE//WORD6
               ENDDO
               NDEC = LPREV
               NSTART = 3
               NTEXT = IADD1
               NUMOPT = IADD1 - 2
               CALL X_LVIEW1 (IXL, IYL, NDEC, NUMOPT, NSTART, NTEXT,
     +                        TEXT,
     +                        TITLES)
               LPREV = NDEC
            ELSE
               NDEC = 0
            ENDIF
            IF (OK .AND. NDEC.NE.0) THEN
               IF (EDIT) THEN
C
C Edit the file
C
                  CALL X_GETNOU (NOUT)
                  OPEN (UNIT = NOUT, FILE = FSAV1(NDEC))
                  READ (NOUT,'(A)') LINE
                  READ (NOUT,*) NROWS, NCOLS
                  CLOSE (UNIT = NOUT)
                  IF (NCOLS.EQ.2) THEN
                     CURVE = .TRUE.
                     LINE = ' Column 1 = x, Column 2 = y'
                  ELSEIF (NCOLS.EQ.3) THEN
                     CURVE = .TRUE.
                     LINE = ' 1 = x, 2 = y, ignore s values in column 3'
                  ELSEIF (NCOLS.EQ.4) THEN
                     CURVE = .FALSE.
                  IF (PIE_CHART) THEN
                     LINE =
     +'1=x, 2=fillstyle(0-10), 3=displacement(0-1), 4=colour(0-71)'
                  ELSE
                     LINE =
     +'1 = x, 2 = low-errorbar, 3 = mean-y, 4 = high-errorbar'
                  ENDIF
                  ELSEIF (NCOLS.EQ.6) THEN
                     CURVE = .FALSE.
                     LINE =
     +'1=x-low, 2=x-mean, 3=x-high, 4=y-low, 5=y-mean, 6 = y-high'
                  ELSEIF (NCOLS.EQ.9) THEN
                     CURVE = .FALSE.  
                     IF (BAR_CHART) THEN
                        LINE =
     +'1=x,2=le,3=bb,4=mb,5=tb,6=he,7=fs(0-10),8=w(0-1),9=c(0-71)'
                     ELSE
                       LINE =
     +'x1:x3,y1:y3(head,tail,label),type(0-7,16),size(0-1),colour(0-71)'
     
                     ENDIF
                  ENDIF
                  CALL X_COPYFG (MODE5,
     +                           FSAV1(NDEC), DUMMY, LINE,
     +                           ABORT, CURVE, FIXCOL, FIXROW, LABEL,
     +                           ORDER, WEIGHT)
               ELSEIF (RESTORE) THEN
C
C Restore the original data
C 
                  CALL X_COPYFL (MODE1, 
     +                           FSAV(NDEC), FSAV1(NDEC),
     +                           ABORT)
                  CALL X_PUTADV ('Data set has been restored')
               ELSEIF (FILE) THEN
C
C Save edited data to file
C
                  CALL X_GETFFS (DUMMY,
     +                           MUST_EXIST, OK)                  
                  IF (.NOT.OK) RETURN
                  CALL X_COPYFL (MODE1,
     +                           FSAV1(NDEC), DUMMY,
     +                           ABORT)
                  I = 1
                  IF (.NOT.ABORT) CALL X_SAVCFG (I,
     +                                           DUMMY)                    
               ELSEIF (ERRORS) THEN
C
C Calculate error bars
C
                  IF (BAR_CHART .AND. NDEC.EQ.1) THEN
                     CALL X_PUTADV (
     +                   'Not available for a bar-chart file')
                  ELSE
                     CALL X_ERRBAR (FSAV1(NDEC))
                     LOWER(NDEC) = .TRUE.
                     UPPER(NDEC) = .TRUE.
                     BARCAP(NDEC) = .TRUE.
                     NSAV(NDEC) = 2
                  ENDIF
               ELSE
C
C Edit line and symbol types
C
                  IF (BAR_CHART .AND. NDEC.EQ.1) THEN
                     CALL X_EDITBC (IFILL, IHUE, NGROUP, NPTS,
     +                              FACTOR, WIDE(1), WIDE(NGRAFS + 1),
     +                              LABELS, LABVEC,
     +                              BARCAP_1, BARKEY)
                     CALL X_BCCOPY (NPTS, IFILL, IHUE, 
     +                              FACTOR, 
     +                              FSAV1(1),
     +                              ABORT)
                  ELSE
                     IF (NDEC.EQ.1 .AND. VECTOR_FIELD) THEN
                        CALL X_GKSVF7 (IFILL, IHUE, NXTRA,
     +                                 FACTOR,
     +                                 FSAV(1))                         
                     ELSE
                        CALL X_GKSTYP (L(NDEC), M(NDEC), NSAV(NDEC),
     +                                 SIZES(NDEC),
     +                                 WIDE(NDEC),
     +                                 WIDE(NDEC + NGRAFS),
     +                                 WIDE(NDEC + NGRAF2),
     +                                 FSAV(NDEC), TSAV(NDEC),
     +                                 BARCAP(NDEC), LOWER(NDEC),
     +                                 UPPER(NDEC), VECTOR_FIELD)
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
         ENDDO
C
C Store
C
         LPREV_1 = LPREV
         NFILES_1 = NFILES
         NGROUP_1 = NGROUP
         NPTS_1 = NPTS
         BARCAP_3 = BARCAP_1
         BAR_1 = BAR_CHART
         PIE_1 = PIE_CHART
         VECTOR_1 = VECTOR_FIELD
         DO I = N1, MIN(NXTRA, NXTRA1)
            IFILL_1(I) = IFILL(I)
            IHUE_1(I) = IHUE(I)
            FACTOR_1(I) = FACTOR(I)
         ENDDO  
         DO I = N1, MIN(NWORDS, NWORD1)
            LABELS_1(I) = LABELS(I)
            LABVEC_1(I) = LABVEC(I)
         ENDDO
         DO I = N1, MIN(NFILES, NGRAF1)
            L_1(I) = L(I)
            M_1(I) = M(I)
            NSAV_1(I) = NSAV(I)
            SIZE_1(I) = SIZES(I)
            WIDE_1(I) = WIDE(I)
            WIDE_1(I + NGRAFS) = WIDE(I + NGRAFS)
            WIDE_1(I + NGRAF2) = WIDE(I + NGRAF2)
            FSAV_1(I) = FSAV(I)
            FSAV1_1(I) = FSAV1(I)
            TSAV_1(I) = TSAV(I)
            BARCAP_2(I) = BARCAP(I)
            LOWER_1(I) = LOWER(I)
            UPPER_1(I) = UPPER(I)
         ENDDO
      ELSEIF (ISEND.EQ.3) THEN
C
C Retrieve
C
         LPREV = LPREV_1
         NFILES = NFILES_1
         NGROUP = NGROUP_1
         NPTS = NPTS_1
         BARCAP_1 = BARCAP_3
         BAR_CHART = BAR_1
         PIE_CHART = PIE_1
         VECTOR_FIELD = VECTOR_1
         DO I = N1, MIN(NXTRA, NXTRA1)
            IFILL(I) = IFILL_1(I)
            IHUE(I) = IHUE_1(I)
            FACTOR(I) = FACTOR_1(I)
         ENDDO  
         DO I = N1, MIN(NWORDS, NWORD1)
            LABELS(I) = LABELS_1(I)
            LABVEC(I) = LABVEC_1(I)
         ENDDO
         DO I = N1, MIN(NGRAFS, NGRAF1)
            L(I) = L_1(I)
            M(I) = M_1(I)
            NSAV(I) = NSAV_1(I)
            SIZES(I) = SIZE_1(I)
            WIDE(I) = WIDE_1(I)
            WIDE(I + NGRAFS) = WIDE_1(I + NGRAFS)
            WIDE(I + NGRAF2) = WIDE_1(I + NGRAF2)
            FSAV(I) = FSAV_1(I)
            FSAV1(I) = FSAV1_1(I)
            TSAV(I) = TSAV_1(I)
            BARCAP(I) = BARCAP_2(I)
            LOWER(I) = LOWER_1(I)
            UPPER(I) = UPPER_1(I)
         ENDDO
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Editing symbols/line-types/data/error-bars'
     +/
     +/'You can edit symbols/line-types or data values for'
     +/'a chosen file, and you can save edited data to a'
     +/'new file or restore original data. Replicates can'
     +/'be replaced by means and error bars, if x-values are'
     +/'in increasing order. Original data are unchanged.'
     +/
     +/'Number of current files =',I3
     +/'Number of the last file edited =',I3
     +/
     +/'Edit: symbols and/or line-types'
     +/'Edit: data values'
     +/'Data: restore edited values'
     +/'Data: Save As ...'
     +/'Data: calculate means/error-bars'
     +/'New data: input from a file'
     +/'New data: input interactively'
     +/'Files: change plot/suppress status'
     +/'Files: change step-over parameters'
     +/'Help'
     +/'Apply')
  200 FORMAT (
     + 'Select the file ',A
     +/'Data files that are currently available for plotting',
     +'`Plot symbol type','`Plot line type','`Colour')
  300 FORMAT (
     + 'Plotting, editing, and saving data'
     +/
     +/'Every set of data supplied to this program must be as ASCII'
     +/'coordinates contained in a stored file, or in a temporary file'
     +/'created by Simfit (which will have a name like f$123456.tmp).'
     +/'Associated with every such file is the line type, thickness,'
     +/'and colour, error bar type, and symbol type, size and colour.'
     +/'From this control you first select the file of interest (if'
     +/'there are several files) then proceed to the chosen action.'
     +/'There are two ways you can edit files: you can interactively'
     +/'change values, or (with replicates in increasing order) you'
     +/'can calculate means and (symmetrical) error bars.'
     +/'Note that such action can always be reversed, as a copy of the'
     +/'original data set is saved, and can be recalled to overwrite'
     +/'the edited data.'
     +/'Another option is to save any current data set to file. This'
     +/'is particularly useful in the case of pie charts plotted from'
     +/'vectors, bar charts plotted from an arbitrary matrix, or error'
     +/'bars plotted from a file with replicates in increasing order,'
     +/'as the saved file will be in the corect format of an advanced'
     +/'pie, or bar chart, or error bar file.')
      END
C
C
