C
C GRAF07$: edit panel from call back function i_press_7
C MENU07$: edit panel from PLTPAN$ or SIMPLOT directly
C
C Subroutines for SIMPLOT
C
      SUBROUTINE X_GRAF07 (NPRESS)

      USE MODULE_CLEARWIN, ONLY : NXTRA1
C
C ACTION: Edit Panel from call back function i_press_7
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 29/10/2000
C         01/06/2001 increased NWORDS from 100 to 300
C         28/09/2002 increased NWORDS from 300 to 500
C         07/10/2002 increased NWORDS from 500 to 1000
C         19/10/2004 minor editing
c         11/07/2005 increased NWORDS from 1000 to 2000
C
C         NPRESS: (input/output)
C
      IMPLICIT   NONE
C
C Argument
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Allocatables
C      
      INTEGER, ALLOCATABLE :: IFILL(:), IHUE(:)
C
C Locals
C
      INTEGER    KPANEL, NXTRA
      PARAMETER (KPANEL = 300)
      INTEGER    IERR, ISEND, ISHAPE, NFILES, NPTS
      CHARACTER  FSAV1*1024, PLINE(KPANEL)*40, PSYMB(KPANEL)*40
      LOGICAL    BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS
      EXTERNAL   X_MENU07
      IF (NPRESS.EQ.7) THEN
         IERR = 0
         IF (ALLOCATED(IFILL)) DEALLOCATE(IFILL, STAT = IERR)
         IF (IERR.NE.0) RETURN  
         IF (ALLOCATED(IHUE)) DEALLOCATE(IHUE, STAT = IERR)
         IF (IERR.NE.0) RETURN 
         NXTRA = NXTRA1
         ALLOCATE(IFILL(NXTRA), STAT = IERR)
         IF (IERR.NE.0) RETURN 
         ALLOCATE(IHUE(NXTRA), STAT = IERR)
         IF (IERR.NE.0) RETURN                           
C
C ISEND = 3: retrieve
C
         ISEND = 3
         CALL X_MENU07 (IFILL, IHUE, ISEND, ISHAPE, KPANEL, NFILES,
     +                  NPTS, NXTRA,
     +                  FSAV1, PLINE, PSYMB,
     +                  BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
C
C ISEND = 2: edit then store
C
         ISEND = 2
         CALL X_MENU07 (IFILL, IHUE, ISEND, ISHAPE, KPANEL, NFILES,
     +                  NPTS, NXTRA,
     +                  FSAV1, PLINE, PSYMB,
     +                  BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
         DEALLOCATE(IFILL, STAT = IERR)
         DEALLOCATE(IHUE, STAT = IERR) 
      ELSE
         NPRESS = - NPRESS
      ENDIF
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE X_MENU07 (IFILL, IHUE, ISEND, ISHAPE, KPANEL, NFILES,
     +                     NPTS, NXTRA,
     +                     FSAV1, PLINE, PSYMB,
     +                     BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)

      USE MODULE_CLEARWIN, ONLY : BAR_1, IFILL_1, IHUE_1, ISHAPE_1,
     +                            NBAR_1, NFILES_1, NGRAF1, NGROUP_1, 
     +                            NPTS_1, NXTRA1, PIE_1, PLINE_1, 
     +                            FACTOR_1,
     +                            PSYMB_1, TWO_1,
     +                            PANEL_1, PANEL_LINES, PANEL_SYMBOLS,
     +                            SIDE_1, WIDE_PANEL,
     +                            QUERY_EXIT
C
C ACTION : Edit information panel details
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 28/10/93
C          01/06/2001 increased NMAX from 100 to 300
C          07/10/2002 added savegks.ins (ISHAPE_1, IFILL_1, IHUE_1,
C                     NFILES_1, NPTS_1, FSAV1_1, BAR_1, PIE_1, TWO_1)
C          08/01/2003 added WIDE1
C          19/10/2004 added ITYPE, XSIZE, STORE, FSIZES$, CIPHER
C          20/04/2007 added INTENTS
C          01/01/2008 uses MODULE_SAVEGKS instead of savegks.ins 
C          18/01/2008 transferred all saved variables to MODULE_SAVEGKS
C          30/11/2010 allowed a side panel with double plots, introduced WIDE_PANEL,
C                     and provided font size alteration 
C          04/12/2010 added PLINE in call to PCKEYS$
C          11/02/2011 added PANEL_LINES and PANEL_SYMBOLS
C          13/05/2011 improved code for editing panel labels
C          24/09/2011 rationalised the menu for pie_chart panels
C          16/01/2014 added QUERY_EXIT and RE_DISPLAY
C          18/02/2014 removed RE_DISPLAY 
C
C          ISEND: (input/unchanged) as follows:
C                  ISEND = 1: just store
C                  ISEND = 2: edit then store
C                  ISEND = 3: just retrieve
C         KPANEL: (input/unchanged) dimension
C         NWORDS: (input/unchanged) dimension
C
C         Theoretically all the other parameters can be (input/output)
C         but, if this routine is called correctly, then NFILES, NPTS,
C         FSAV1, BAR_CHART, PIE_CHART, and TWO_PLOTS should really be
C         like constant parameters to the calling programs after the
C         first call with ISEND = 1 to initialise.
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND,  KPANEL, NXTRA
      INTEGER,             INTENT (INOUT) :: ISHAPE, IFILL(NXTRA),
     +                                       IHUE(NXTRA), NFILES, NPTS
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV1, PLINE(KPANEL),
     +                                       PSYMB(KPANEL)
      LOGICAL,             INTENT (INOUT) :: BAR_CHART, PANEL,
     +                                       PIE_CHART, SIDE, TWO_PLOTS
C
C Locals
C
      INTEGER    ITYPE, N0, N1, N20
      PARAMETER (ITYPE = 10, N0 = 0, N1 = 1, N20 = 20)
      INTEGER    NDEC, NGROUP
      INTEGER    I, IMID, ITOP
      INTEGER    JCOLOR, JX, JY, JSHADE, NUMOPT, NUMTXT
      PARAMETER (JCOLOR = 9, JX = 4, JY = 4, JSHADE = 1, NUMTXT = 24)
      INTEGER    NUMBLD(30), NUMPOS(15)
      DOUBLE PRECISION X
      DOUBLE PRECISION XSIZE
      CHARACTER  FTEMP*1024
      CHARACTER  CIPHER(7)*30, TEXT(30)*100
      CHARACTER  BLANK*1, YES*30
      PARAMETER (BLANK = ' ', YES = '[Current option]')
      LOGICAL    AGAIN, STORE
      LOGICAL    BORDER, PIEKEY
      PARAMETER (BORDER = .FALSE., PIEKEY = .TRUE.)
      EXTERNAL   X_NEWSTR, X_PUTFAT, X_BCPANL, X_EDITPC, X_FSIZES,
     +           X_PUTADV
      EXTERNAL   X_LBOX02, X_SELSTR, W_PATCH1
      INTRINSIC  MIN
      SAVE       FTEMP
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 15*1 /
      IF (NXTRA.GT.NXTRA1) CALL X_PUTFAT (
     +                     'NXTRA > NXTRA1 in call to MENU07$')
      IF (ISEND.EQ.1) THEN
C
C Store
C
         ISHAPE_1 = ISHAPE
         NFILES_1 = NFILES
         NPTS_1 = NPTS
         DO I = N1, MIN(NXTRA, NXTRA1)
            IFILL_1(I) = IFILL(I)
            IHUE_1(I) = IHUE(I)
         ENDDO
         IF (NXTRA1.GT.NXTRA) THEN
            DO I = NXTRA + N1, NXTRA1
               IFILL_1(I) = N0
               IHUE_1(I) = N0
            ENDDO
         ENDIF
         FTEMP = FSAV1
         DO I = N1, MIN(KPANEL, NGRAF1)
            PLINE_1(I) = PLINE(I)
            PSYMB_1(I) = PSYMB(I)
         ENDDO
         IF (NGRAF1.GT.KPANEL) THEN
            DO I = KPANEL + N1, NGRAF1
               PLINE_1(I) = BLANK
               PSYMB_1(I) = BLANK
            ENDDO
         ENDIF
         BAR_1 = BAR_CHART
         PANEL_1 = PANEL
         PIE_1 = PIE_CHART
         SIDE_1 = SIDE
         TWO_1 = TWO_PLOTS
      ELSEIF (ISEND.EQ.2) THEN
C
C Edit the information panel
C
         STORE = .FALSE.
         CALL X_FSIZES (ITYPE,
     +                  XSIZE,
     +                  STORE)
         AGAIN = .TRUE.
         DO WHILE (AGAIN)
            DO I = 1, 4
               CIPHER(I) = BLANK
            ENDDO
            IF (BAR_CHART .OR. PIE_CHART) THEN
               CIPHER(5) = 'Not available'
               CIPHER(6) = 'Not available'
               CIPHER(7) = 'Not available'
            ELSE   
               IF (WIDE_PANEL) THEN
                  CIPHER(5) = 'Wide' 
               ELSE
                  CIPHER(5) = 'Narrow'    
               ENDIF 
               IF (PANEL_LINES) THEN
                  CIPHER(6) = 'Display'
               ELSE
                  CIPHER(6) = 'Suppress'
               ENDIF  
               IF (PANEL_SYMBOLS) THEN
                 CIPHER(7) = 'Display'
               ELSE
                 CIPHER(7) = 'Suppress'
               ENDIF          
            ENDIF     
            IF (PIE_CHART) THEN
               NUMOPT = 7
               IF (PANEL) THEN
                  IF (SIDE) THEN
                     CIPHER(2) = YES
                  ELSE
                     CIPHER(3) = YES
                   ENDIF
               ELSE
                  CIPHER(1) = YES
               ENDIF
               WRITE (TEXT,100) (CIPHER(I), I = 1, 3), XSIZE
            ELSE
               NUMOPT = 11
               IF (PANEL) THEN
                  IF (SIDE) THEN
                     IF (ISHAPE.EQ.2) THEN
                        CIPHER(2) = YES
                     ELSE
                        CIPHER(3) = YES
                     ENDIF
                  ELSE
                     CIPHER(4) = YES
                   ENDIF
               ELSE
                  CIPHER(1) = YES
               ENDIF
               WRITE (TEXT,200) (CIPHER(I), I = 1, 4), XSIZE, 
     +                          (CIPHER(I), I = 5, 7)
            ENDIF
            IMID = NUMOPT - 1
            CALL X_LBOX02 (JCOLOR, JX, JY, IMID, NUMOPT, NUMPOS,
     +                     TEXT)
            AGAIN = .FALSE.
            IF (PIE_CHART) THEN
               IF (IMID.GE.1 .AND. IMID.LE.4) QUERY_EXIT = .TRUE.	
               IF (IMID.GT.1 .AND. IMID.LE.5) THEN
                  IMID = IMID + 1
               ELSEIF (IMID.GT.5) THEN
                  IMID = IMID + 4
               ENDIF
            ELSE
               IF (IMID.GE.1 .AND. IMID.LE.9) QUERY_EXIT = .TRUE.   
            ENDIF         
C
C Primary decisions
C
            IF (IMID.EQ.1) THEN
               PANEL = .FALSE.
               SIDE = .FALSE.
               ISHAPE = 1
            ELSEIF (IMID.EQ.2) THEN
               ISHAPE = 2
               PANEL = .TRUE.
               SIDE = .TRUE.
            ELSEIF (IMID.EQ.3) THEN
               ISHAPE = 1
               PANEL = .TRUE.
               SIDE = .TRUE.
            ELSEIF (IMID.EQ.4) THEN
               ISHAPE = 1
               PANEL = .TRUE.
               SIDE = .FALSE.
            ELSEIF (IMID.EQ.5) THEN
               IF (PANEL) THEN
                  AGAIN = .TRUE.
                  DO WHILE (AGAIN)
C
C Edit an information panel key
C
                     AGAIN = .FALSE.
                     IF (BAR_CHART) THEN
                        IF (NGROUP_1.EQ.N1) THEN
                           NGROUP = MIN(NBAR_1, N20)
                        ELSE
                           NGROUP = MIN(NGROUP_1, N20)
                        ENDIF    
                        CALL X_BCPANL (NGROUP,
     +                                 PLINE, PSYMB)                       
                     ELSEIF (PIE_CHART) THEN
                        NGROUP = MIN(NPTS,N20)
                        CALL X_EDITPC (IFILL, IHUE, NGROUP,
     +                                 FACTOR_1, X,
     +                                 FSAV1, PLINE, PSYMB,
     +                                 PIEKEY)                 
                     ELSE
                        WRITE (TEXT,300)
                        IMID = NUMTXT
                        ITOP = NFILES
                        CALL X_SELSTR (NDEC, IMID, ITOP,
     +                                 TEXT, PLINE)
                        IF (NDEC.NE.0) THEN
                           AGAIN = .TRUE.  
                           CALL X_NEWSTR (N0,
     +                                    PLINE(NDEC), PSYMB(NDEC))
                        ENDIF 
                     ENDIF
                  ENDDO                   
               ELSE
                  CALL X_PUTFAT (
     +           'Panel is not currently being displayed')
               ENDIF
            ELSEIF (IMID.EQ.6) THEN
               STORE = .TRUE.
               CALL X_FSIZES (ITYPE,
     +                        XSIZE,
     +                        STORE)
            ELSEIF (IMID.EQ.7) THEN
               IF (BAR_CHART .OR. PIE_CHART) THEN
                  CALL X_PUTADV ('Not available in bar and pie charts')
               ELSE    
                  WIDE_PANEL = .NOT.WIDE_PANEL
               ENDIF 
             ELSEIF (IMID.EQ.8) THEN
               IF (BAR_CHART .OR. PIE_CHART) THEN
                  CALL X_PUTADV ('Not available in bar and pie charts')
               ELSE    
                  PANEL_LINES = .NOT.PANEL_LINES
               ENDIF
             ELSEIF (IMID.EQ.9) THEN
               IF (BAR_CHART .OR. PIE_CHART) THEN
                  CALL X_PUTADV ('Not available in bar and pie charts')
               ELSE    
                  PANEL_SYMBOLS = .NOT.PANEL_SYMBOLS
               ENDIF      
            ELSEIF (IMID.EQ.10) THEN
               AGAIN = .TRUE.
               WRITE (TEXT,300)
               NUMBLD(1) = 1
               CALL W_PATCH1 (JCOLOR, JX, JY, JSHADE, NUMBLD, NUMTXT,
     +                        TEXT,
     +                        BORDER)
            ELSEIF (IMID.EQ.11) THEN
               AGAIN = .FALSE.
            ENDIF
C
C Check decisions and take further actions if required
C ----------------------------------------------------------------
C Un-comment the next lines to inhibit a side panel in 2-plot mode
C            IF (TWO_PLOTS .AND. (IMID.EQ.2.OR.IMID.EQ.3)) THEN
C               CALL PUTFAT$('Not allowed in two plot mode')
C               ISHAPE = 1
C               PANEL = .FALSE.
C               SIDE = .FALSE.
C            ENDIF
C ----------------------------------------------------------------
         ENDDO
C
C Store after editing
C
         ISHAPE_1 = ISHAPE
         NFILES_1 = NFILES
         NPTS_1 = NPTS
         DO I = N1, MIN(NXTRA, NXTRA1)
            IFILL_1(I) = IFILL(I)
            IHUE_1(I) = IHUE(I)
         ENDDO
         FTEMP = FSAV1
         DO I = N1, MIN(KPANEL, NGRAF1)
            PLINE_1(I) = PLINE(I)
            PSYMB_1(I) = PSYMB(I)
         ENDDO
         BAR_1 = BAR_CHART
         PANEL_1 = PANEL
         PIE_1 = PIE_CHART
         SIDE_1 = SIDE
         TWO_1 = TWO_PLOTS
      ELSEIF (ISEND.EQ.3) THEN
C
C Retrieve
C
         ISHAPE = ISHAPE_1
         NFILES = NFILES_1
         NPTS = NPTS_1
         DO I = N1, MIN(NXTRA, NXTRA1)
            IFILL(I) = IFILL_1(I)
            IHUE(I) = IHUE_1(I)
         ENDDO
         DO I = N1, MIN(KPANEL, NGRAF1)
            PLINE(I) = PLINE_1(I)
            PSYMB(I) = PSYMB_1(I)
         ENDDO
         FSAV1 = FTEMP
         BAR_CHART = BAR_1
         PANEL = PANEL_1
         PIE_CHART = PIE_1
         SIDE = SIDE_1
         TWO_PLOTS = TWO_1
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Panel: suppressed', 1X,A
     +/'Panel: side-moveable (=< 20 items)',1X,A
     +/'Panel: bottom-fixed (=< 12 items)',1X,A
     +/'Panel: edit labels'
     +/'Panel: re-size label font, Current size:',F6.2
     +/'Help'
     +/'Quit ... Exit panel display options')
  200 FORMAT (
     + 'Panel: suppressed',1X,A
     +/'Panel: side-moveable (=< 20 items, y:x aspect ratio = 1:1)',1X,A
     +/'Panel: side-moveable (=< 20 items, y:x aspect ratio = 3:4)',1X,A
     +/'Panel: bottom-fixed (=< 10 items)',1X,A
     +/'Labels: edit'
     +/'Labels: re-size font, Current size:',F6.2
     +/'Items: change line-display width, Current mode:',1X,A
     +/'Items: change line-display type, Current mode:',1X,A
     +/'Items: change symbol-display type, Current mode:',1X,A
     +/'Help'
     +/'Quit ... Exit panel display options')
  300 FORMAT (
     + 'Activating and moving the information panel'
     +/
     +/'The [Panel] button allows panel activation/supression/editing'
     +/'The [=>Panel] button moves the panel to the red arrow'
     +/
     +/'An information panel is a set of keys (i.e. labels), lines,'
     +/'and/or symbols, intended to identify plotted data. First you'
     +/'select the numbered key text string you want to edit, then'
     +/'you create a new text string, or edit the existing one.'
     +/
     +/'Here is how to edit information panel text strings'
     +/
     +/'Start with simple editing to create a string or over-ride'
     +/'the default string, reserving the advanced editing option'
     +/'for subtle details, like introducing degrees centigrade,'
     +/'displaying maths, or adding accents to letters. To suppress'
     +/'a key, just input a blank string.'
     +/'Panels can be fixed at the bottom of the plot or allowed to'
     +/'float in 3:4 or, usually, 1:1 aspect ratio, then you can re-'
     +/'set positions, aspect ratios and clipping frames, by using the'
     +/'plot style options. Ambitious users can make customised panels'
     +/'using linked graphical objects, positioned using a graticule.'
     +/'To plot a frame round the panel after editing, drag the head'
     +/'and tail of a transparent horizontal box to opposing corners.')
      END
C
C
